package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 活动审核表
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_ActivityApproval")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert
@DynamicUpdate
public class ActivityApproval extends BaseBean {

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;
	
	private String name;

	private String approvalName;//审批人

	private String approvalStatus;//审批状态(字典)

	private String approvalDate;

	private String comment;//审批回复

}
