package com.bcxin.risk.activity;

import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.org.domain.Org;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

/**
 * 活动信息表
 * @author 罗鹏
 */
@Entity
@Table(name = "RISK_Activity")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert
@DynamicUpdate
public class Activity extends BaseBean {

	private static final long serialVersionUID = 1L;

    /**
     * 活动创建时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    private Date activityDate;


    /**
     * 下单时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    private Date orderDate;

    /**
     * 活动logo
     */
    private String logo;
    /**
     * 活动编号
     */
    private String activityNo;
    /**
     * 活动名称
     */
	private String name;

    /**
     * 活动状态（字典）
     */
	private String activityStatus;

    /**
     * 初级审批状态（字典）
     */
	private String primaryStatus;

    /**
     *
     */
	@ManyToOne(targetEntity = User.class, fetch = FetchType.EAGER, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "user_id")
	private User user;

    /**
     *
     */
	@ManyToOne(targetEntity = Org.class, fetch = FetchType.LAZY, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "org_id")
	private Org org;

    /**
     * 公安审核状态（字典）
     */
	private String approvalStatus;

    /**
     * 申报系统的审批状态（仅供客服人员查看，不参与业务逻辑处理）
     */
    private String sbApprovalStatus;

    /**
     * 公安审批意见
     */
    private String approvalContent;

    /**
     * 活动人数
     */
    private String number;

    /**
     * 活动天数
     */
    private String days;

    /**
     * 活动类型
     */
    private String activityType;

    /**
     * 活动地点（室内和室外） 字典
     */
    private String addressType;

    /**
     * 室外地点（字典）
     */
    private String outDoorType;

    /**
     * 展会类型
     */
    private String exhibitionType;

    /**
     * 预计当日高峰人数
     */
    private String peakNum;

    /**
     * 是否盈利性演出（1代表是，0代表不是）
     */
    private String profitableShow;

    /**
     * 主办单位
     */
    private String sponsor;


    /**
     * 审批单位
     */
    private String approveOrg;

    /**
     * 许可单位
     */
    @ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "unit_id")
    private Region unit;

    /**
     * 省份
     */
    @ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "province_id")
    private Region province;

    /**
     * 市
     */
    @ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "city_id")
    private Region city;

    /**
     * 区
     */
    @ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "area_id")
    private Region area;

    /**
     * 活动地址，xxxx#xxxx
     */
    private String address;

    /**
     * 开始时间
     */
    private String startDate;

    /**
     * 结束时间
     */
    private String endDate;

    /**
     * 是否开通临建权限（0,代表否，1代表是）
     */
    private String isInstallAuth;

    /**
     * 临建开始时间
     */
    private String installStartDate;

    /**
     * 临建结束时间
     */
    private String installEndDate;

    /**
     * 是否已经开始上传材料（0,代表无，1代表有）
     */
    private String postMaterial;

    /**
     * 是否是政府类项目（0,代表否，1代表是）
     */
    private String gov;

    /**
     * 是否是报备活动（0,代表否，1代表是）
     */
    private String isBackup;

    /**
     * 是否选择了评估机构（0,代表否，1代表是）
     */
    private String chooseAssess;

    /**
     * 活动申请的渠道（sb_sn.dh.pss360.cn,代表申报子系统陕西环境）
     */
    private String channel;

    /**
     * 历史项目标识（0,代表否，1代表是）
     */
    private String history;

    /**
     * 活动来源（字典 activitySource）
     */
    private String activitySource;

    /**
     * 是否为申报活动
     * 1 申报活动
     */
    private String isShenBao;

    /**
     * 是否需要推送到申报系统
     */
    private String isPushToSB;

    /**
     * 推送结果
     */
    private String pushResult;

    /**
     * 需要风评报告
     */
    private String needReport;

}
