/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.policy.domain;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.policy.domain.InsuranceProduct;
import com.bcxin.risk.policy.domain.PolicyExtra;
import com.bcxin.risk.policy.enums.InsuranceCompany;
import com.bcxin.risk.policy.enums.Policy_ActivityFireFight;
import com.bcxin.risk.policy.enums.Policy_ActivityLocal;
import com.bcxin.risk.policy.enums.Policy_ActivityPeriod;
import com.bcxin.risk.policy.enums.Policy_ActivityQuota;
import com.bcxin.risk.policy.enums.Policy_ActivityScale;
import com.bcxin.risk.policy.enums.Policy_ActivityType;
import com.bcxin.risk.policy.enums.Whether;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class PremiumCalc {
    private BigDecimal standard = new BigDecimal("2000");
    Map<Policy_ActivityQuota, String> cpic_quotaMap = new HashMap<Policy_ActivityQuota, String>();
    Map<Policy_ActivityType, String> cpic_typeMap = new HashMap<Policy_ActivityType, String>();
    Map<Policy_ActivityScale, String> cpic_scaleMap = new HashMap<Policy_ActivityScale, String>();
    Map<Policy_ActivityPeriod, String> cpic_periodMap = new HashMap<Policy_ActivityPeriod, String>();
    Map<Policy_ActivityFireFight, String> cpic_fireMap = new HashMap<Policy_ActivityFireFight, String>();
    Map<Policy_ActivityLocal, String> cpic_localMap = new HashMap<Policy_ActivityLocal, String>();
    Map<Whether, String> cpic_guestMap = new HashMap<Whether, String>();
    Map<Whether, String> cpic_dangerMap = new HashMap<Whether, String>();
    private BigDecimal even = new BigDecimal("250");
    Map<Policy_ActivityType, String> ht_typeMap = new HashMap<Policy_ActivityType, String>();
    Map<Policy_ActivityQuota, String> ht_quotaMap = new HashMap<Policy_ActivityQuota, String>();
    Map<Policy_ActivityLocal, String> ht_localMap = new HashMap<Policy_ActivityLocal, String>();
    Map<Policy_ActivityFireFight, String> ht_fireMap = new HashMap<Policy_ActivityFireFight, String>();
    Map<Policy_ActivityScale, String> ht_scaleMap = new HashMap<Policy_ActivityScale, String>();
    Map<Whether, String> ht_dangerMap = new HashMap<Whether, String>();

    private void load_cpic_data() {
        this.cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_ONE, "1.1");
        this.cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_TWO, "1.2");
        this.cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_THREE, "1.3");
        this.cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_FOUR, "1.4");
        this.cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_FIVE, "1.5");
        this.cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_SIX, "1.6");
        this.cpic_typeMap.put(Policy_ActivityType.EXHIBITION, "1");
        this.cpic_typeMap.put(Policy_ActivityType.LITERATURE, "1.2");
        this.cpic_typeMap.put(Policy_ActivityType.SPORTS, "1.3");
        this.cpic_typeMap.put(Policy_ActivityType.GARDENLANTERN, "1.4");
        this.cpic_typeMap.put(Policy_ActivityType.OTHER, "1.2");
        this.cpic_scaleMap.put(Policy_ActivityScale.CPIC_BELOW, "1");
        this.cpic_scaleMap.put(Policy_ActivityScale.CPIC_MIDDLE, "1.2");
        this.cpic_scaleMap.put(Policy_ActivityScale.CPIC_UP, "1.4");
        this.cpic_periodMap.put(Policy_ActivityPeriod.BELOW, "1");
        this.cpic_periodMap.put(Policy_ActivityPeriod.MIDDLE, "1.2");
        this.cpic_periodMap.put(Policy_ActivityPeriod.UP, "1.3");
        this.cpic_fireMap.put(Policy_ActivityFireFight.ACCEPTANCE, "1");
        this.cpic_fireMap.put(Policy_ActivityFireFight.EXTINGUISHER, "1.1");
        this.cpic_fireMap.put(Policy_ActivityFireFight.NO_EXTINGUISHER, "1.3");
        this.cpic_localMap.put(Policy_ActivityLocal.INDOOR, "1");
        this.cpic_localMap.put(Policy_ActivityLocal.OPEN, "1.1");
        this.cpic_localMap.put(Policy_ActivityLocal.OUTDOOR, "1.2");
        this.cpic_guestMap.put(Whether.HAVE, "1");
        this.cpic_guestMap.put(Whether.WITHOUT, "1.1");
        this.cpic_dangerMap.put(Whether.HAVE, "1");
        this.cpic_dangerMap.put(Whether.WITHOUT, "1.2");
    }

    private void load_ht_data() {
        this.ht_typeMap.put(Policy_ActivityType.EXHIBITION, "2000");
        this.ht_typeMap.put(Policy_ActivityType.LITERATURE, "2500");
        this.ht_typeMap.put(Policy_ActivityType.SPORTS, "3500");
        this.ht_typeMap.put(Policy_ActivityType.GARDENLANTERN, "4000");
        this.ht_typeMap.put(Policy_ActivityType.OTHER, "4000");
        this.ht_quotaMap.put(Policy_ActivityQuota.HT_LEVEL_ONE, "1.1");
        this.ht_quotaMap.put(Policy_ActivityQuota.HT_LEVEL_TWO, "1.4");
        this.ht_quotaMap.put(Policy_ActivityQuota.HT_LEVEL_THREE, "1.5");
        this.ht_quotaMap.put(Policy_ActivityQuota.HT_LEVEL_FOUR, "1.6");
        this.ht_localMap.put(Policy_ActivityLocal.INDOOR, "1");
        this.ht_localMap.put(Policy_ActivityLocal.OPEN, "1.1");
        this.ht_localMap.put(Policy_ActivityLocal.OUTDOOR, "1.2");
        this.ht_fireMap.put(Policy_ActivityFireFight.ACCEPTANCE, "1");
        this.ht_fireMap.put(Policy_ActivityFireFight.EXTINGUISHER, "1.1");
        this.ht_scaleMap.put(Policy_ActivityScale.HT_BELOW, "1");
        this.ht_scaleMap.put(Policy_ActivityScale.HT_MIDDLE, "1.2");
        this.ht_scaleMap.put(Policy_ActivityScale.HT_SE_MIDDLE, "1.5");
        this.ht_scaleMap.put(Policy_ActivityScale.HT_UP, "2");
        this.ht_dangerMap.put(Whether.WITHOUT, "1");
        this.ht_dangerMap.put(Whether.HAVE, "1.3");
    }

    public BigDecimal calc(InsuranceProduct product, PolicyExtra extra) {
        if (product.getInsuranceCompany().equals((Object)InsuranceCompany.CPIC_PROPERTY)) {
            this.load_cpic_data();
            BigDecimal premium = this.standard;
            String quota = this.cpic_quotaMap.get((Object)extra.getActivityQuota());
            String type = this.cpic_typeMap.get((Object)extra.getActivityType());
            String scale = this.cpic_scaleMap.get((Object)extra.getActivityScale());
            String period = this.cpic_periodMap.get((Object)extra.getActivityPeriod());
            String fire = this.cpic_fireMap.get((Object)extra.getActivityFireFight());
            String local = this.cpic_localMap.get((Object)extra.getActivityLocal());
            String guest = this.cpic_guestMap.get((Object)extra.getGuest());
            String danger = this.cpic_dangerMap.get((Object)extra.getDanger());
            if (StringUtil.isEmpty(quota)) {
                quota = "1.1";
            }
            if (StringUtil.isEmpty(type)) {
                type = "1";
            }
            if (StringUtil.isEmpty(scale)) {
                scale = "1";
            }
            if (StringUtil.isEmpty(period)) {
                period = "1";
            }
            if (StringUtil.isEmpty(fire)) {
                fire = "1";
            }
            if (StringUtil.isEmpty(local)) {
                local = "1";
            }
            if (StringUtil.isEmpty(guest)) {
                guest = "1";
            }
            if (StringUtil.isEmpty(danger)) {
                danger = "1";
            }
            premium = premium.multiply(new BigDecimal(quota)).multiply(new BigDecimal(type)).multiply(new BigDecimal(scale)).multiply(new BigDecimal(period)).multiply(new BigDecimal(fire)).multiply(new BigDecimal(local)).multiply(new BigDecimal(guest)).multiply(new BigDecimal(danger));
            return premium.setScale(2, 4);
        }
        if (product.getInsuranceCompany().equals((Object)InsuranceCompany.HT)) {
            this.load_ht_data();
            BigDecimal premium = this.even;
            Policy_ActivityQuota xiane = extra.getActivityQuota();
            if (extra.getAmount() != null && !"".equals(extra.getAmount())) {
                xiane = Policy_ActivityQuota.getLevel(extra.getAmount());
            }
            String quota = this.ht_quotaMap.get((Object)xiane);
            String type = this.ht_typeMap.get((Object)extra.getActivityType());
            String scale = this.ht_scaleMap.get((Object)extra.getActivityScale());
            String fire = this.ht_fireMap.get((Object)extra.getActivityFireFight());
            String local = this.ht_localMap.get((Object)extra.getActivityLocal());
            String danger = this.ht_dangerMap.get((Object)extra.getDanger());
            String days = extra.getInsureDays();
            if (StringUtil.isEmpty(quota)) {
                quota = "1";
            }
            if (StringUtil.isEmpty(type)) {
                type = "2000";
            }
            if (StringUtil.isEmpty(scale)) {
                scale = "1";
            }
            if (StringUtil.isEmpty(fire)) {
                fire = "1";
            }
            if (StringUtil.isEmpty(local)) {
                local = "1";
            }
            if (StringUtil.isEmpty(danger)) {
                danger = "1";
            }
            if (StringUtil.isEmpty(days)) {
                days = "1";
            }
            BigDecimal dayprice = premium.multiply(new BigDecimal(days));
            premium = new BigDecimal(quota).multiply(new BigDecimal(type)).multiply(new BigDecimal(scale)).multiply(new BigDecimal(danger)).multiply(new BigDecimal(fire)).multiply(new BigDecimal(local));
            premium = premium.add(dayprice);
            return premium.setScale(2, 4);
        }
        return BigDecimal.ZERO;
    }
}

