/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.activity.dto.data;

import com.bcxin.risk.activity.Quotation;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(value={"hibernateLazyInitializer"})
public class QuotationDTO
implements Serializable {
    private String oid;
    private String name;
    private String maxQuote;
    private String minQuote;
    private String quotationType;
    private String active;
    private Page page;

    public QuotationDTO() {
    }

    public QuotationDTO(Map<String, Object> map) {
        this.oid = this.safeTransfor(map.get("oid"));
        this.name = this.safeTransfor(map.get("name"));
        if (this.name != null && this.name.length() > 20) {
            this.name = this.name.substring(0, 20) + "..";
        }
        this.maxQuote = this.safeTransfor(map.get("maxQuote"));
        this.minQuote = this.safeTransfor(map.get("minQuote"));
        this.quotationType = this.safeTransfor(map.get("quotationType"));
        this.active = this.safeTransfor(map.get("actie"));
    }

    public QuotationDTO(Quotation quotation) {
        this.oid = quotation.getOid() + "";
        this.name = quotation.getName();
        if (this.name != null && this.name.length() > 20) {
            this.name = this.name.substring(0, 20) + "..";
        }
        this.maxQuote = quotation.getMaxQuote().toString();
        this.minQuote = quotation.getMinQuote().toString();
        this.quotationType = quotation.getQuotationType();
        this.active = quotation.getActive();
    }

    private String safeTransfor(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    @Generated
    public String getOid() {
        return this.oid;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMaxQuote() {
        return this.maxQuote;
    }

    @Generated
    public String getMinQuote() {
        return this.minQuote;
    }

    @Generated
    public String getQuotationType() {
        return this.quotationType;
    }

    @Generated
    public String getActive() {
        return this.active;
    }

    @Generated
    public Page getPage() {
        return this.page;
    }

    @Generated
    public void setOid(String oid) {
        this.oid = oid;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMaxQuote(String maxQuote) {
        this.maxQuote = maxQuote;
    }

    @Generated
    public void setMinQuote(String minQuote) {
        this.minQuote = minQuote;
    }

    @Generated
    public void setQuotationType(String quotationType) {
        this.quotationType = quotationType;
    }

    @Generated
    public void setActive(String active) {
        this.active = active;
    }

    @Generated
    public void setPage(Page page) {
        this.page = page;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuotationDTO)) {
            return false;
        }
        QuotationDTO other = (QuotationDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$oid = this.getOid();
        String other$oid = other.getOid();
        if (this$oid == null ? other$oid != null : !this$oid.equals(other$oid)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$maxQuote = this.getMaxQuote();
        String other$maxQuote = other.getMaxQuote();
        if (this$maxQuote == null ? other$maxQuote != null : !this$maxQuote.equals(other$maxQuote)) {
            return false;
        }
        String this$minQuote = this.getMinQuote();
        String other$minQuote = other.getMinQuote();
        if (this$minQuote == null ? other$minQuote != null : !this$minQuote.equals(other$minQuote)) {
            return false;
        }
        String this$quotationType = this.getQuotationType();
        String other$quotationType = other.getQuotationType();
        if (this$quotationType == null ? other$quotationType != null : !this$quotationType.equals(other$quotationType)) {
            return false;
        }
        String this$active = this.getActive();
        String other$active = other.getActive();
        if (this$active == null ? other$active != null : !this$active.equals(other$active)) {
            return false;
        }
        Page this$page = this.getPage();
        Page other$page = other.getPage();
        return !(this$page == null ? other$page != null : !this$page.equals(other$page));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QuotationDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oid = this.getOid();
        result = result * 59 + ($oid == null ? 43 : $oid.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $maxQuote = this.getMaxQuote();
        result = result * 59 + ($maxQuote == null ? 43 : $maxQuote.hashCode());
        String $minQuote = this.getMinQuote();
        result = result * 59 + ($minQuote == null ? 43 : $minQuote.hashCode());
        String $quotationType = this.getQuotationType();
        result = result * 59 + ($quotationType == null ? 43 : $quotationType.hashCode());
        String $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : $active.hashCode());
        Page $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QuotationDTO(oid=" + this.getOid() + ", name=" + this.getName() + ", maxQuote=" + this.getMaxQuote() + ", minQuote=" + this.getMinQuote() + ", quotationType=" + this.getQuotationType() + ", active=" + this.getActive() + ", page=" + this.getPage() + ")";
    }
}

