/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.cdc.kafka.source.task.compnents;

import com.bcxin.flink.cdc.kafka.source.task.cdcs.CdcSourceMeta;
import com.bcxin.flink.cdc.kafka.source.task.compnents.dtos.OrgInfoDTO;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JdbcDbReaderComponent
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(JdbcDbReaderComponent.class);
    private static Map<String, OrgInfoDTO> orgRegionCodeMaps = new HashMap<String, OrgInfoDTO>();
    private String url;
    private String userName;
    private String password;

    private JdbcDbReaderComponent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OrgInfoDTO getRegionCode(String orgId, CdcSourceMeta meta) {
        ResultSet resultSet;
        OrgInfoDTO orgInfo;
        block25: {
            OrgInfoDTO orgInfoDTO;
            orgInfo = orgRegionCodeMaps.get(orgId);
            if (orgInfo != null) return orgInfo;
            String sql = String.format("SELECT a.supervise_region_code,a.institutional_code FROM obpm2.tenant_organizations a where a.id='%s'", orgId);
            StringBuilder track = new StringBuilder();
            try {
                block28: {
                    Connection connection;
                    block27: {
                        PreparedStatement statement;
                        block26: {
                            connection = DriverManager.getConnection(this.url, this.userName, this.password);
                            track.append("\u83b7\u53d6connection\u94fe\u63a5\u4fe1\u606f;");
                            statement = connection.prepareStatement(sql);
                            track.append("\u83b7\u53d6statement\u94fe\u63a5\u4fe1\u606f;");
                            resultSet = statement.executeQuery();
                            try {
                                track.append("\u83b7\u53d6resultSet\u94fe\u63a5\u4fe1\u606f;");
                                if (!resultSet.next()) break block25;
                                String regionCode = resultSet.getString("supervise_region_code");
                                if (!StringUtils.hasLength((String)regionCode)) {
                                    regionCode = "none";
                                }
                                String institutionalCode = resultSet.getString("institutional_code");
                                orgInfo = OrgInfoDTO.create(regionCode, institutionalCode);
                                orgRegionCodeMaps.put(orgId, orgInfo);
                                orgInfoDTO = orgInfo;
                                if (resultSet == null) break block26;
                            }
                            catch (Throwable throwable) {
                                if (resultSet == null) throw throwable;
                                try {
                                    resultSet.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            resultSet.close();
                        }
                        if (statement == null) break block27;
                        statement.close();
                    }
                    if (connection == null) break block28;
                    connection.close();
                }
                if (orgInfo != null) return orgInfoDTO;
            }
            catch (Exception ex) {
                logger.error("v3.\u83b7\u53d6\u4f01\u4e1a({})\u6240\u5c5e\u7684\u76d1\u7ba1\u533a\u57df\u4fe1\u606f\u53d1\u751f(\u8ddf\u8e2a\u4fe1\u606f={})\u5f02\u5e38(sql={})", new Object[]{orgId, track, sql, ex});
                return orgInfo;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            logger.error("v3.\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f({})", (Object)orgId);
            return orgInfoDTO;
        }
        if (resultSet == null) return orgInfo;
        resultSet.close();
        return orgInfo;
    }

    public static JdbcDbReaderComponent build(Properties properties) {
        JdbcDbReaderComponent component = new JdbcDbReaderComponent();
        component.url = properties.getProperty("datasource.url");
        component.userName = properties.getProperty("datasource.username");
        component.password = properties.getProperty("datasource.password");
        return component;
    }
}

