/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.cdc.kafka.source.task.cdcs.dynamic;

import com.bcxin.flink.cdc.kafka.source.task.cdcs.dynamic.DynamicDbCollectionMongoSinkBuilder;
import com.bcxin.flink.cdc.kafka.source.task.cdcs.dynamic.DynamicDbCollectionMongoWriter;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.mongodb.common.config.MongoConnectionOptions;
import org.apache.flink.connector.mongodb.sink.config.MongoWriteOptions;
import org.apache.flink.connector.mongodb.sink.writer.serializer.MongoSerializationSchema;
import org.apache.flink.util.Preconditions;

public class DynamicDbCollectionMongoSink<IN>
implements Sink<IN> {
    private static final long serialVersionUID = 1L;
    private final MongoConnectionOptions connectionOptions;
    private final MongoWriteOptions writeOptions;
    private final MongoSerializationSchema<IN> serializationSchema;

    DynamicDbCollectionMongoSink(MongoConnectionOptions connectionOptions, MongoWriteOptions writeOptions, MongoSerializationSchema<IN> serializationSchema) {
        this.connectionOptions = (MongoConnectionOptions)Preconditions.checkNotNull((Object)connectionOptions);
        this.writeOptions = (MongoWriteOptions)Preconditions.checkNotNull((Object)writeOptions);
        this.serializationSchema = (MongoSerializationSchema)Preconditions.checkNotNull(serializationSchema);
        ClosureCleaner.clean(serializationSchema, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
    }

    public static <IN> DynamicDbCollectionMongoSinkBuilder<IN> builder() {
        return new DynamicDbCollectionMongoSinkBuilder();
    }

    public SinkWriter<IN> createWriter(Sink.InitContext context) {
        return new DynamicDbCollectionMongoWriter<IN>(this.connectionOptions, this.writeOptions, this.writeOptions.getDeliveryGuarantee() == DeliveryGuarantee.AT_LEAST_ONCE, context, this.serializationSchema);
    }
}

