/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.cdc.kafka.source.task.cdcs;

import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.flink.cdc.kafka.source.task.cdcs.BinlogOffsetValue;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class BinlogCdcValue
implements Serializable {
    private String id;
    private String db;
    private String table;
    private String value;
    private Date lastSyncTime;
    private Map<String, ?> sourceMeta;
    private BinlogOffsetValue binlogOffsetValue;

    public static BinlogCdcValue create(String id, String db, String table, String value, Date lastSyncTime) {
        BinlogCdcValue cdcValue = new BinlogCdcValue();
        cdcValue.setId(id);
        cdcValue.setValue(value);
        cdcValue.setDb(db);
        cdcValue.setTable(table);
        cdcValue.setLastSyncTime(lastSyncTime);
        return cdcValue;
    }

    public void changeBinlog(Map<String, ?> sourceMeta) {
        if (CollectionUtils.isEmpty(sourceMeta)) {
            throw new BadEventException("\u65e0\u6548\u7684binlog\u5143\u6570\u636e\u4fe1\u606f");
        }
        this.setSourceMeta(sourceMeta);
        Object file = sourceMeta.get("file");
        if (file == null) {
            throw new BadEventException("\u627e\u4e0d\u5230binlog\u6587\u4ef6\u7684file\u4fe1\u606f:" + sourceMeta.keySet().stream().map(ix -> String.format("%s=%s", ix, sourceMeta.get(ix))).collect(Collectors.joining(";")));
        }
        Object pos = sourceMeta.get("pos");
        if (pos == null) {
            throw new BadEventException("\u627e\u4e0d\u5230binlog\u6587\u4ef6\u7684pos\u4fe1\u606f:" + sourceMeta.keySet().stream().map(ix -> String.format("%s=%s", ix, sourceMeta.get(ix))).collect(Collectors.joining(";")));
        }
        Object gtIds = sourceMeta.get("gtids");
        BinlogOffsetValue offsetValue = BinlogOffsetValue.create(String.valueOf(file), (Long)pos, gtIds == null ? null : String.valueOf(gtIds));
        offsetValue.changeNote(String.format("%s.%s=%s", this.getDb(), this.getTable(), this.getId()));
        this.setBinlogOffsetValue(offsetValue);
    }

    public String getBinlogFile() {
        if (this.getBinlogOffsetValue() == null) {
            throw new BadEventException("\u627e\u4e0d\u5230binlog\u7684\u914d\u7f6e\u4fe1\u606f");
        }
        return this.getBinlogOffsetValue().getFile();
    }

    public String getFullTable() {
        return String.format("%s.%s", this.getDb(), this.getTable());
    }

    public String getId() {
        return this.id;
    }

    public String getDb() {
        return this.db;
    }

    public String getTable() {
        return this.table;
    }

    public String getValue() {
        return this.value;
    }

    public Date getLastSyncTime() {
        return this.lastSyncTime;
    }

    public Map<String, ?> getSourceMeta() {
        return this.sourceMeta;
    }

    public BinlogOffsetValue getBinlogOffsetValue() {
        return this.binlogOffsetValue;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setLastSyncTime(Date lastSyncTime) {
        this.lastSyncTime = lastSyncTime;
    }

    public void setSourceMeta(Map<String, ?> sourceMeta) {
        this.sourceMeta = sourceMeta;
    }

    public void setBinlogOffsetValue(BinlogOffsetValue binlogOffsetValue) {
        this.binlogOffsetValue = binlogOffsetValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinlogCdcValue)) {
            return false;
        }
        BinlogCdcValue other = (BinlogCdcValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$db = this.getDb();
        String other$db = other.getDb();
        if (this$db == null ? other$db != null : !this$db.equals(other$db)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Date this$lastSyncTime = this.getLastSyncTime();
        Date other$lastSyncTime = other.getLastSyncTime();
        if (this$lastSyncTime == null ? other$lastSyncTime != null : !((Object)this$lastSyncTime).equals(other$lastSyncTime)) {
            return false;
        }
        Map<String, ?> this$sourceMeta = this.getSourceMeta();
        Map<String, ?> other$sourceMeta = other.getSourceMeta();
        if (this$sourceMeta == null ? other$sourceMeta != null : !((Object)this$sourceMeta).equals(other$sourceMeta)) {
            return false;
        }
        BinlogOffsetValue this$binlogOffsetValue = this.getBinlogOffsetValue();
        BinlogOffsetValue other$binlogOffsetValue = other.getBinlogOffsetValue();
        return !(this$binlogOffsetValue == null ? other$binlogOffsetValue != null : !((Object)this$binlogOffsetValue).equals(other$binlogOffsetValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BinlogCdcValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $db = this.getDb();
        result = result * 59 + ($db == null ? 43 : $db.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Date $lastSyncTime = this.getLastSyncTime();
        result = result * 59 + ($lastSyncTime == null ? 43 : ((Object)$lastSyncTime).hashCode());
        Map<String, ?> $sourceMeta = this.getSourceMeta();
        result = result * 59 + ($sourceMeta == null ? 43 : ((Object)$sourceMeta).hashCode());
        BinlogOffsetValue $binlogOffsetValue = this.getBinlogOffsetValue();
        result = result * 59 + ($binlogOffsetValue == null ? 43 : ((Object)$binlogOffsetValue).hashCode());
        return result;
    }

    public String toString() {
        return "BinlogCdcValue(id=" + this.getId() + ", db=" + this.getDb() + ", table=" + this.getTable() + ", value=" + this.getValue() + ", lastSyncTime=" + this.getLastSyncTime() + ", sourceMeta=" + this.getSourceMeta() + ", binlogOffsetValue=" + this.getBinlogOffsetValue() + ")";
    }
}

