/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.cdc.kafka.source.task;

import com.bcxin.event.core.JobParameterDTO;
import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.JsonProviderImpl;
import com.bcxin.event.core.enums.JobType;
import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.event.core.exceptions.IllegalArgumentEventException;
import com.bcxin.event.core.exceptions.NoFoundEventException;
import com.bcxin.flink.cdc.kafka.source.task.JobContext;
import com.bcxin.flink.cdc.kafka.source.task.compnents.JdbcDbReaderComponent;
import com.bcxin.flink.cdc.kafka.source.task.jobs.DbStreamCdcHttpSinkJob;
import com.bcxin.flink.cdc.kafka.source.task.jobs.DbStreamCdcJobAbstract;
import com.bcxin.flink.cdc.kafka.source.task.jobs.DbStreamCdcKafkaJob;
import com.bcxin.flink.cdc.kafka.source.task.proerpties.CdcDatabaseSourceProperty;
import com.bcxin.flink.cdc.kafka.source.task.proerpties.CheckpointConfigPropertyBuilder;
import com.bcxin.flink.cdc.kafka.source.task.proerpties.HttpRegionSinkProperty;
import com.bcxin.flink.cdc.kafka.source.task.proerpties.KafkaConfigProperty;
import com.bcxin.flink.streaming.cores.JdbcJobExecutorUtil;
import com.bcxin.flink.streaming.cores.SystemPropertyUtil;
import com.bcxin.flink.streaming.cores.properties.CheckpointConfigProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.flink.api.java.utils.ParameterTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class JdbcBinLogCaptureApp {
    private static final Logger logger = LoggerFactory.getLogger(JdbcBinLogCaptureApp.class);
    private static final JsonProvider jsonProvider = new JsonProviderImpl();
    private static JdbcDbReaderComponent dbReaderComponent = null;

    public static void main(String[] args) throws Exception {
        logger.info("\u63a5\u6536\u53c2\u6570\u51c6\u5907\u6267\u884cCDC\u7684BINLOG\u8bfb\u53d6:{}", (Object)Arrays.stream(args).collect(Collectors.joining(";")));
        ParameterTool parameterTool = ParameterTool.fromArgs((String[])args);
        JdbcBinLogCaptureApp.buildJobEnvironment(parameterTool);
        DbStreamCdcJobAbstract job = null;
        job = JdbcBinLogCaptureApp.isHttpSink(args) ? new DbStreamCdcHttpSinkJob() : new DbStreamCdcKafkaJob(dbReaderComponent);
        job.execute();
    }

    private static void buildJobEnvironment(ParameterTool parameterTool) throws IOException {
        String[] args = new String[]{parameterTool.get("env"), parameterTool.get("jobId"), parameterTool.get("mode")};
        Properties properties = JdbcBinLogCaptureApp.loadProperties(args);
        CheckpointConfigProperty configProperty = CheckpointConfigPropertyBuilder.build(properties, parameterTool);
        dbReaderComponent = JdbcDbReaderComponent.build(properties);
        if (JdbcBinLogCaptureApp.isHttpSink(args)) {
            ArrayList<HttpRegionSinkProperty> regionSinkProperties = new ArrayList<HttpRegionSinkProperty>();
            Enumeration<Object> regionKeys = properties.keys();
            while (regionKeys.hasMoreElements()) {
                String value;
                String name = (String)regionKeys.nextElement();
                HttpRegionSinkProperty sinkProperty = HttpRegionSinkProperty.getRegionConfigProperty(name, value = properties.getProperty(name));
                if (sinkProperty == null) continue;
                regionSinkProperties.add(sinkProperty);
            }
            if (CollectionUtils.isEmpty(regionSinkProperties)) {
                throw new BadEventException("\u65e0\u6548Http Region\u914d\u7f6e\u4fe1\u606f");
            }
            JobContext.initHttpSink(properties.getProperty("job.name"), regionSinkProperties, CdcDatabaseSourceProperty.create(properties), configProperty);
        } else {
            KafkaConfigProperty kafkaConfigProperty = KafkaConfigProperty.create(properties.getProperty("kafka.bootstrap.server"), properties.getProperty("kafka.cdc.topic.prefix"), properties.getProperty("kafka.consumer.group.id"));
            JobContext.initKafkaSink(properties.getProperty("job.name"), CdcDatabaseSourceProperty.create(properties), configProperty, kafkaConfigProperty);
        }
    }

    private static Properties loadProperties(String[] args) throws IOException {
        if (args == null || args.length < 2) {
            throw new BadEventException("\u65e0\u63d0\u4f9b\u6709\u6548\u914d\u7f6e\u53c2\u6570(\u73af\u5883\u4ee5\u53cajobId), \u7cfb\u7edf\u65e0\u6cd5\u542f\u52a8");
        }
        String env = args[0];
        Properties properties = SystemPropertyUtil.loadEnvConf((String)env);
        int jobId = Integer.parseInt(args[1]);
        JobParameterDTO jobParameterDTO = JdbcJobExecutorUtil.getJobParameter((int)jobId);
        if (jobParameterDTO == null) {
            throw new NoFoundEventException("\u53c2\u6570\u65e0\u6548; \u65e0\u6cd5\u52a0\u8f7d\u5bf9\u5e94\u7684job\u53c2\u6570");
        }
        if (jobParameterDTO.getJobType() != JobType.CDC_BINLOG) {
            throw new IllegalArgumentEventException(String.format("\u8be5jobType(%s)\u4e0d\u652f\u6301BINLOG CDC\u5904\u7406", jobParameterDTO.getJobType()));
        }
        String corePropertyConf = jobParameterDTO.getParam1(jsonProvider);
        String databasePropertyConf = jobParameterDTO.getParam2(jsonProvider);
        Map corePropertyConfMap = null;
        try {
            corePropertyConfMap = (Map)jsonProvider.toObject(Map.class, corePropertyConf);
        }
        catch (Exception ex) {
            throw new BadEventException(String.format("\u8f6c\u5316\u5f02\u5e38:%s", corePropertyConf), ex);
        }
        Map databasePropertyConfMap = null;
        try {
            databasePropertyConfMap = (Map)jsonProvider.toObject(Map.class, databasePropertyConf);
        }
        catch (Exception ex) {
            throw new BadEventException(String.format("\u8f6c\u5316\u5f02\u5e38:%s", databasePropertyConf), ex);
        }
        properties.setProperty("PARAM_JOB_ID_NAME", String.valueOf(jobId));
        if (corePropertyConfMap != null) {
            for (String key : corePropertyConfMap.keySet()) {
                properties.setProperty(key, (String)corePropertyConfMap.get(key));
            }
        }
        if (databasePropertyConfMap != null) {
            for (String key : databasePropertyConfMap.keySet()) {
                properties.setProperty(key, (String)databasePropertyConfMap.get(key));
            }
        }
        properties.setProperty("PARAM_JOB_ID", String.valueOf(jobId));
        if (!JdbcBinLogCaptureApp.isHttpSink(args) && args.length > 2 && args[2] != null) {
            properties.setProperty("PARAM_BINLOG_SKIP_REDIS_CALCULATE", args[2]);
            if (!"skip-redis".equalsIgnoreCase(args[2])) {
                properties.setProperty("PARAM_BINLOG_STARTUP_OPTION", args[2]);
            }
        }
        return properties;
    }

    private static boolean isHttpSink(String[] args) {
        return args.length > 2 && "http-sink".equalsIgnoreCase(args[2]);
    }
}

