package com.bcxin.flink.cdc.kafka.source.task.proerpties;

import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;

@Data
public class HttpRegionSinkProperty implements Serializable {
    private String regionIdPrefix;
    private String api;

    public static HttpRegionSinkProperty create(String regionIdPrefix,String api) {
        HttpRegionSinkProperty sinkProperty = new HttpRegionSinkProperty();
        sinkProperty.setApi(api);
        sinkProperty.setRegionIdPrefix(regionIdPrefix);

        return sinkProperty;
    }

    public static HttpRegionSinkProperty getRegionConfigProperty(String name,String value) {
        if (!StringUtils.hasLength(name)) {
            return null;
        }

        if (!name.startsWith("dispatch.region") || !name.contains("_")) {
            return null;
        }

        String regionPrefix = name.split("_")[1];

        return HttpRegionSinkProperty.create(regionPrefix, value);
    }



    public boolean IsMatchedApi(String regionId) {
        if (!StringUtils.hasLength(this.getRegionIdPrefix()) || !StringUtils.hasLength(regionId)) {
            return false;
        }

        return regionId.startsWith(this.getRegionIdPrefix());
    }
}
