package com.bcxin.flink.streaming.table.tasks.jobs;

import com.bcxin.event.core.FlinkJobAbstract;
import com.bcxin.flink.streaming.cores.StreamingCoreEnvironments;
import com.bcxin.flink.streaming.table.tasks.StreamingJobContext;
import com.bcxin.flink.streaming.table.tasks.definitions.JobDataDefinition;
import com.bcxin.flink.streaming.table.tasks.definitions.KafkaMetaDefinition;
import com.bcxin.flink.streaming.table.tasks.functions.Convert2PointFunction;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.*;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ScriptDispatchJob extends FlinkJobAbstract {
    private static final Logger logger = LoggerFactory.getLogger(ScriptDispatchJob.class);

    private final JobDataDefinition definition;

    public ScriptDispatchJob(JobDataDefinition definition) {
        this.definition = definition;
    }

    @Override
    protected void coreExecute() throws Exception {
        StreamingJobContext jobContext = StreamingJobContext.getInstance();
        Map<String, String> flinkConfig = new HashMap<>();
        Configuration configuration = new Configuration();


        if (definition.getName().contains("实时归集人员信息")) {
            flinkConfig.put(TaskManagerOptions.NETWORK_MEMORY_MIN.key(), "2048m");
            flinkConfig.put(TaskManagerOptions.NETWORK_MEMORY_MAX.key(), "2048m");
            configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, MemorySize.parse("2048m"));
            configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, MemorySize.parse("2048m"));
        } else {
            flinkConfig.put(TaskManagerOptions.NETWORK_MEMORY_MIN.key(), "512m");
            flinkConfig.put(TaskManagerOptions.NETWORK_MEMORY_MAX.key(), "512m");
            configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, MemorySize.parse("512m"));
            configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, MemorySize.parse("512m"));
        }

        jobContext.assign(flinkConfig);
        /**
         * 谨记: 必须不能启用checkPoint, 否则join会问题!!!!!!!!!!!
         */

        /**
         * todo: 临时重置
         */
        configuration = new Configuration();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment(configuration);

        /**
         * 重启一万次，每个5秒钟一次
         */
        env.setRestartStrategy(
                RestartStrategies.fixedDelayRestart(10_000,
                        Time.of(5, TimeUnit.SECONDS))
        );

        CheckpointConfig checkpointConfig = env.getCheckpointConfig();
        /**
         * https://cloud.tencent.com/developer/article/1886629
         */
        checkpointConfig.setCheckpointTimeout(30000);
        checkpointConfig.setMinPauseBetweenCheckpoints(500);
        checkpointConfig.setTolerableCheckpointFailureNumber(10);
        jobContext.getConfigProperty().getCheckpointPath();
        checkpointConfig.setCheckpointStorage(jobContext.getConfigProperty().getCheckpointPath());
        checkpointConfig.setMaxConcurrentCheckpoints(1);

        checkpointConfig.setCheckpointingMode(CheckpointingMode.EXACTLY_ONCE);

        configuration = new Configuration();
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX,MemorySize.parse("2048m"));
        EnvironmentSettings settings = EnvironmentSettings.newInstance()
                .inStreamingMode()
                .withConfiguration(configuration)
                .build();
        TableEnvironment tableEnvironment = TableEnvironment.create(settings);
        /**
         * 状态保留5分钟
         */
        tableEnvironment.getConfig().setIdleStateRetention(Duration.ofMinutes(5));
        logger.error("当前执行的配置信息为V3:name={} and TaskManagerOptions.NETWORK_MEMORY_MAX={};checkpointMode={}",
                definition.getName(),
                flinkConfig.get(TaskManagerOptions.NETWORK_MEMORY_MAX.key()),
                env.getCheckpointConfig().getCheckpointingMode()
        );
        tableEnvironment.createTemporaryFunction("convert2Point", new Convert2PointFunction());

        //TableConfig tableConfig = tableEnvironment.getConfig();
// set low-level key-value options
        /*
        tableConfig.set("table.exec.mini-batch.enabled", "true");
        tableConfig.set("table.exec.mini-batch.allow-latency", "2 s");
        tableConfig.set("table.exec.mini-batch.size", "500");
         */
        //tableConfig.set("parallelism.default", "10");
        //tableConfig.set("table.exec.state.ttl", "60 s");
        /**
         * https://nightlies.apache.org/flink/flink-docs-release-1.14/docs/dev/table/config/#table-exec-state-ttl
         */
        //tableConfig.set("parallelism.default", "10");
        /**
         * https://nightlies.apache.org/flink/flink-docs-release-1.17/docs/dev/table/config/
         */

        KafkaMetaDefinition kafkaMetaDefinition = definition.getKafkaMeta();
        if (kafkaMetaDefinition != null && !CollectionUtils.isEmpty(kafkaMetaDefinition.getTopicDefinitions())) {
            kafkaMetaDefinition.getTopicDefinitions()
                    .forEach(td -> {
                        tableEnvironment.executeSql(td.getFullDefinitionSql(kafkaMetaDefinition));
                    });
        }

        if (definition.getJdbcMeta() != null && !CollectionUtils.isEmpty(definition.getJdbcMeta().getSqlMetaDefinitions())) {
            definition.getJdbcMeta().getSqlMetaDefinitions().forEach(sl -> {
                String fullSql = sl.getFullSql(definition.getJdbcMeta());
                tableEnvironment.executeSql(fullSql);
            });
        }

        StatementSet statementSet = tableEnvironment.createStatementSet();
        definition.getExecuteSql().forEach(ix -> {
            statementSet.addInsertSql(ix);
        });

  /*
        definition.getExecuteSql().forEach(ix -> {
            statementSet.addInsertSql("select o.id,o.name,(case when ITEM_companyStatus='注销' then 2 when ITEM_companyStatus='撤销' then 1 else 0 end) as ITEM_companyStatus,ci.ITEM_legalPerson,ci.ITEM_legalPersonPhone,ifnull(o.institutional_code,''),o.place_of_register_address,o.place_of_business_address,ci.ITEM_businessScope,o.id,'#','#supervise_depart_id',TO_TIMESTAMP(FROM_UNIXTIME(ci.LASTMODIFIED/1000, 'yyyy-MM-dd HH:mm:ss')),TO_TIMESTAMP(FROM_UNIXTIME(ci.LASTMODIFIED/1000, 'yyyy-MM-dd HH:mm:ss')),'042302', convert2Point(o.longitude,o.latitude) as lonlat from kafka_tenant_organizations o left join kafka_tlk_companyinformation ci on o.id=ci.DOMAINID limit 100");
        });*/

        TableResult result = statementSet.execute();
        result.print();
    }
}
