package com.bcxin.flink.streaming.table.tasks.definitions;

import com.bcxin.event.core.definitions.FlinkDefinitionAbstract;
import lombok.Data;
import org.apache.kafka.common.protocol.types.Field;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.UUID;

@Data
public class KafkaMetaDefinition extends FlinkDefinitionAbstract {
    private String autoOffsetRest = "earliest";
    private String scanStartupMode = "earliest-offset";//""group-offsets";
    private String enableAutoCommit = "true";
    private String bootstrapServer;
    private Collection<KafkaMetaTopicDefinition> topicDefinitions;

    @Data
    public static class KafkaMetaTopicDefinition extends FlinkDefinitionAbstract {
        private String topic;
        private String sql;

        public String getFullDefinitionSql(KafkaMetaDefinition definition) {
            return String.format("%s WITH ('connector'='kafka','scan.startup.mode'='%s','properties.group.id'='%s-consumer-jdbc-v2-" +
                            (UUID.randomUUID()) + "','topic' = '%s'," +
                            "'properties.bootstrap.servers' = '%s','properties.auto.offset.reset' = 'earliest','properties.enable.auto.commit' = 'true','format'='debezium-json')",
                    this.getSql(),
                    //definition.getScanStartupMode(),
                    "group-offsets",
                    this.getTopic(),
                    this.getTopic(),
                    definition.getBootstrapServer());
        }
    }
}