package com.bcxin.flink.streaming.table.tasks.components;

import com.bcxin.flink.streaming.table.tasks.jobs.StreamingJobContext_DispatchJob;
import org.apache.flink.table.api.TableEnvironment;

public class KafkaSourceDefinitionUtils {
    public static void doDefinition(TableEnvironment tEnv) {
        String bootstrapServer = "117.78.39.204:9092";
        tEnv.executeSql("create table kafka_tenant_organizations(id STRING,name STRING,industry_code STRING,institutional_code STRING,place_of_business_address STRING," +
                "place_of_register_address STRING,latitude STRING,longitude STRING,PRIMARY KEY (id) NOT ENFORCED) " +
                getKafkaConnectorDebeziumDefinition(bootstrapServer, getObpm2Topic(".tenant_organizations"))
        );

        tEnv.executeSql("create table kafka_tlk_companyinformation(ID STRING,ITEM_companyStatus STRING, DOMAINID STRING, ITEM_legalPerson STRING,ITEM_legalPersonPhone STRING,ITEM_businessScope STRING,LASTMODIFIED BIGINT," +
                "PRIMARY KEY (ID) NOT ENFORCED) " +
                getKafkaConnectorDebeziumDefinition(bootstrapServer, getBaibaodunflowTopic(".tlk_companyinformation"))
        );


        tEnv.executeSql("create table kafka_tenant_user_credentials(id STRING,created_time BIGINT,address STRING,credential_type INT,front_photo STRING," +
                "head_photo STRING,name STRING,number STRING,reverse_photo STRING,selected INT,valid_date_from BIGINT,valid_date_to BIGINT,tenant_user_id STRING," +
                "mark STRING,district_code STRING,city_code STRING,province_code STRING" +
                ", PRIMARY KEY (id) NOT ENFORCED) " + getKafkaConnectorDebeziumDefinition(bootstrapServer, getObpm2Topic(".tenant_user_credentials")));

        tEnv.executeSql("create table kafka_tenant_users(id STRING,authenticated_status INT,authenticated_result STRING,authenticated_time BIGINT," +
                "checked_status INT,third_party_loginNo STRING,created_time BIGINT ,email STRING,habit_setting STRING,head_photo STRING,im_identity STRING,lon_lat_json STRING," +
                "name STRING,sex INT,stature STRING,telephone STRING,user_type INT,selected_credential_id STRING,household_type STRING,one_inch_color_white_photo STRING,two_inch_color_blue_photo STRING," +
                "education STRING,marital_status STRING,military_status STRING,nation STRING,native_place STRING,politics_status STRING,cid STRING,wechat STRING,wechat_nicky STRING,last_updated_time BIGINT," +
                "background_screening_status INT,last_background_screening_time BIGINT,emergency_contact STRING,emergency_phone STRING,license_level STRING,place_of_now_address STRING,place_of_now_city_code STRING," +
                "place_of_now_city_name STRING,place_of_now_district_code STRING,place_of_now_district_name STRING,place_of_now_province_code STRING,place_of_now_province_name STRING,third_party_login_no STRING,last_sync_time BIGINT" +
                ", PRIMARY KEY (id) NOT ENFORCED) " + getKafkaConnectorDebeziumDefinition(bootstrapServer, getObpm2Topic(".tenant_users")));

        tEnv.executeSql("create table kafka_tenant_employees(id STRING,created_time BIGINT,email STRING,hired_date BIGINT,job_number STRING,last_updated_time BIGINT," +
                "leave_note STRING,leave_operator_created_time BIGINT,leave_operator_id STRING,leave_operator_name STRING,leave_time BIGINT,master_slave_type INT," +
                "occupation_type INT,`position` STRING,positive_date BIGINT,salary STRING,salary_bank_number STRING,status INT,work_place STRING,organization_id STRING," +
                "superior_id STRING,tenant_user_id STRING,unique_offset STRING,insure INT,is_domain_admin INT,identification STRING,interview STRING,person_status INT," +
                "plan_positive_date BIGINT,probation STRING,hired_operator_created_time BIGINT,hired_operator_id STRING,hired_operator_name STRING,last_sync_time BIGINT" +
                ", PRIMARY KEY (id) NOT ENFORCED) " + getKafkaConnectorDebeziumDefinition(bootstrapServer, getObpm2Topic(".tenant_employees")));

        tEnv.executeSql("create table kafka_tlk_SetSupervise(ID STRING,ITEM_REGISTERADDRESS STRING,ITEM_REGISTERADDRESSID STRING,ITEM_REGISTERPOLICEADDRESS STRING,ITEM_OFFICEPOLICEADDRESSID STRING," +
                "ITEM_OFFICEPOLICEIDINDEX STRING,ITEM_REGISTERPOLICEADDRESSID STRING,ITEM_REGISTERPOLICEIDINDEX STRING,ITEM_DOMAIN_ID STRING,ITEM_B STRING,ITEM_FLAG INT" +
                ", PRIMARY KEY (ID) NOT ENFORCED) " + getKafkaConnectorDebeziumDefinition(bootstrapServer, getBaibaodunflowTopic(".tlk_SetSupervise")));

        tEnv.executeSql("create table kafka_tlk_attendance_site_base_info(ID STRING,ITEM_OFFICEPOLICEADDRESSID STRING,ITEM_ATTENDANCESITENAME STRING,ITEM_ATTENDANCESITETYPE STRING,DOMAINID STRING,ITEM_PRINCIPAL STRING," +
                "ITEM_PRINCIPALNAME STRING,ITEM_PRINCIPALPHONENO STRING,ITEM_SERVEOBJECTNAME STRING,ITEM_ATTENDANCESITEADDRESS STRING,ITEM_ATTENDANCESITEFULLADDRESS STRING, " +
                "ITEM_ATTENDANCESITELONGITUDE STRING,ITEM_ATTENDANCESITELATITUDE STRING,ITEM_ATTENDANCESTARTDATE BIGINT,ITEM_ATTENDANCEENDDATE BIGINT,ITEM_ATTENDANCESITESTATE STRING, LASTMODIFIED BIGINT, " +
                " PRIMARY KEY (ID) NOT ENFORCED) " +
                getKafkaConnectorDebeziumDefinition(bootstrapServer, getBaibaodunflowTopic(".tlk_attendance_site_base_info"))
        );

        tEnv.executeSql("create table kafka_tlk_attendance_site_person_info(ID STRING, ITEM_ATTENDANCESITEID STRING,ITEM_SECURITYID STRING,ITEM_SECURITYNAME STRING,PRIMARY KEY (ID) NOT ENFORCED) " +
                getKafkaConnectorDebeziumDefinition(bootstrapServer, getBaibaodunflowTopic(".tlk_attendance_site_person_info"))
        );
    }

    private static String getBaibaodunflowTopic(String tableName) {
        return "baibaodunflow.binlog-cdc.topic" + tableName;
    }

    private static String getKafkaConnectorDebeziumDefinition(String bootstrapServer, String topic) {
        String withKafkaPropertyFormat = "WITH ('connector'='kafka'," +
                "'scan.startup.mode'='earliest-offset','properties.group.id'='%s','topic' = '%s'," +
                "'properties.bootstrap.servers' = '%s'," +
                "'format'='debezium-json')";

        return String.format(withKafkaPropertyFormat,
                topic.concat(".v2.consumer").concat(StreamingJobContext_DispatchJob.getKafkaConsumerGroupIdSuffix()),
                topic, bootstrapServer);
    }

    private static String getObpm2Topic(String tableName) {
        return "obpm2.binlog-cdc.topic" + tableName;
    }
}
