package com.bcxin.flink.streaming.table.tasks.components;

import org.apache.flink.table.api.TableEnvironment;

public class JdbcSourceDefinitionUtils {
    public static void doDefinition(TableEnvironment tEnv)
    {
        String withJdbcPropertyFormat =
                "WITH ('connector'='jdbc','url'='jdbc:mysql://49.4.21.141:45611/dispatch?characterEncoding=UTF-8&connectionTimeZone=GMT%2B8&allowMultiQueries=true&autoReconnect=true'," +
                        "'table-name'='#{tableName}','username'='bcx','password'='Wstestv5qy#2022','sink.parallelism'='1')";
        //todo lon_lat STRING 临时这样定义
        String tableName = "rd_company_summary";
        tEnv.executeSql("create table " + getJdbcDefinitionTable(tableName) + "(id STRING,status INT, NAME STRING,legal STRING,legal_telephone STRING,institutional STRING,register_address STRING,business_address STRING," +
                "service_scope STRING,lon_lat STRING,organization_id STRING,supervise_domain_id STRING,supervise_depart_id STRING, last_sync_time TIMESTAMP(3),last_updated_time TIMESTAMP(3),supervise_region_code STRING," +
                "PRIMARY KEY (id) NOT ENFORCED) " + withJdbcPropertyFormat.replace("#{tableName}", tableName));
        //todo lon_lat STRING 临时这样定义
        tableName = "rd_security_station_summary";
        tEnv.executeSql("create table " + getJdbcDefinitionTable(tableName) + "(id STRING,NAME STRING,station_type STRING,company_name STRING,principal_id STRING,principal_name STRING,principal_contact STRING," +
                "service_scope STRING,address STRING,lon_lat STRING,organization_id STRING,supervise_domain_id STRING,supervise_depart_id STRING, last_sync_time TIMESTAMP(3),last_updated_time TIMESTAMP(3),site_state STRING," +
                "begin_date TIMESTAMP(3),end_date TIMESTAMP(3),supervise_region_code STRING, " +
                "PRIMARY KEY (id) NOT ENFORCED) " + withJdbcPropertyFormat.replace("#{tableName}", tableName));

        tableName = "rd_employee_summary";
        tEnv.executeSql("create table " + getJdbcDefinitionTable(tableName) + " (id STRING,company_id STRING,name STRING,head_photo STRING,contact STRING, company_name STRING,status INT,checked_status INT," +
                "authenticated_status INT,military_status STRING,security_certificate_no STRING,occupation_type INT,hired_date TIMESTAMP(3),leave_time TIMESTAMP(3)," +
                "insure INT,organization_id STRING,tenant_user_id STRING,tenant_employee_id STRING," +
                "last_sync_time TIMESTAMP(3),last_updated_time TIMESTAMP(3),device_number STRING," +
                "tenant_im_user_id STRING,idCard_no STRING,cid STRING" +
                ", PRIMARY KEY (id) NOT ENFORCED) " + withJdbcPropertyFormat.replace("#{tableName}", tableName));

        tableName = "rd_security_station_person_summary";
        tEnv.executeSql("create table " + getJdbcDefinitionTable(tableName) + "(id STRING,employee_id STRING,security_station_id STRING, " +
                "PRIMARY KEY (id) NOT ENFORCED) " + withJdbcPropertyFormat.replace("#{tableName}", tableName));
    }

    private static String getJdbcDefinitionTable(String tableName) {
        return "jdbc_insert_" + tableName;
    }
}
