package com.bcxin.flink.streaming.computing.task.dtos;

import com.bcxin.event.core.definitions.KafkaTableDefinition;
import lombok.Data;
import lombok.Getter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

@Data
public class JobKafka2KafkaDataDto implements Serializable {
    private String id;
    private String name;
    private String description;

    private Collection<KafkaTableDefinition> kafkaDefinitions;

    private String batchSql;

    public Collection<String> getDefinitionSqls() {
        Collection<String> dSqls = new ArrayList<>();

        if (!CollectionUtils.isEmpty(this.getKafkaDefinitions())) {
            dSqls.addAll(
                    this.getKafkaDefinitions().stream()
                            .filter(ii -> !StringUtils.isEmpty(ii.getSql()))
                            .map(ii -> ii.getSql()).collect(Collectors.toList())
            );
        }

        return dSqls.stream().filter(ix -> !StringUtils.isEmpty(ix))
                .collect(Collectors.toList());
    }
}
