package com.bcxin.flink.streaming.computing.task.dtos;

import com.bcxin.event.core.enums.OperatorType;
import com.bcxin.event.core.exceptions.IllegalArgumentEventException;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.*;

@Getter
@Setter(AccessLevel.PRIVATE)
public class DebeziumJsonNodeDto implements Serializable {
    private String op;
    private Long ts_ms;
    private JsonNode before;
    private JsonNode after;
    private JsonNode source;
    private String key;

    public OperatorType getOperatorType() {
        if (StringUtils.isEmpty(this.getOp())) {
            throw new IllegalArgumentEventException("无效操作类型");
        }

        switch (op) {
            case "d":
                return OperatorType.DELETE;
            case "u":
                return OperatorType.UPDATE;
            default:
                return OperatorType.INSERT;
        }
    }

    public static DebeziumJsonNodeDto create(String key,String op,Long ts_ms,
                                             JsonNode before,
                                             JsonNode after,
                                             JsonNode source) {
        DebeziumJsonNodeDto debeziumJsonNode = new DebeziumJsonNodeDto();
        debeziumJsonNode.setKey(key);
        debeziumJsonNode.setOp(op);
        debeziumJsonNode.setBefore(before);
        debeziumJsonNode.setAfter(after);
        debeziumJsonNode.setSource(source);

        return debeziumJsonNode;
    }

    private Map<String,Object> _parameters;
    public Map<String,Object> getParameters(String primaryKeyName) {
        if (_parameters == null) {
            _parameters = new HashMap<>();
            _parameters = buildParameters(_parameters, "before", this.getBefore());
            _parameters = buildParameters(_parameters, "after", this.getAfter());
            _parameters = buildParameters(_parameters, "source", this.getSource());
            _parameters.put("op", this.getOp());
            _parameters.put("key", this.getKey());
            _parameters.put("ts_ms", this.getTs_ms());
            _parameters.put(primaryKeyName, this.getKey());
        }

        return _parameters;
    }

    private Map<String,Object> buildParameters(
            Map<String,Object> map,
            String prefix, JsonNode node) {
        Iterator<String> iterator = node.fieldNames();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String nodeKey = iterator.next();
                String key = nodeKey;
                if (!StringUtils.isEmpty(prefix)) {
                    key = String.format("%s.%s", prefix, nodeKey);
                }

                JsonNode nodeValue = node.get(nodeKey);
                switch (nodeValue.getNodeType()) {
                    case NULL:
                        map.put(key, null);
                        break;
                    case NUMBER:
                        if (nodeKey.toLowerCase().contains("time")) {
                            map.put(key, "2023-02-01 11:00:00");
                        } else if (nodeKey.toLowerCase().contains("date")) {
                            Date stamp = new Date(nodeValue.asLong());
                            map.put(key, new Date());
                        } else {
                            map.put(key, nodeValue.asDouble());
                        }
                        break;
                    case BOOLEAN:
                        map.put(key, nodeValue.asBoolean());
                        break;
                    case STRING:
                    case MISSING:
                    case OBJECT:
                    case ARRAY:
                    case BINARY:
                    case POJO:
                        if (nodeKey.toLowerCase().contains("time")) {
                            Date stamp = new Date(nodeValue.asLong());
                            map.put(key, "2023-02-01 11:00:00");
                        } else if (nodeKey.toLowerCase().contains("date")) {
                            Date stamp = new Date(nodeValue.asLong());
                            map.put(key, new Date());
                        } else {
                            map.put(key, nodeValue.asText());
                        }
                        break;
                }
            }
        }

        return map;
    }
}
