package com.bcxin.flink.cdc.dispatch.task.proerpties;

import com.bcxin.flink.streaming.cores.TableConstant;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Properties;

@Getter
public class CdcDatabaseSourceProperty implements Serializable {
    private final String name;
    private final String hostName;
    private final int port;
    private final String userName;
    private final String password;

    private final String connectionTimeZone;
    private final String serverId;
    private final int connectTimeout;

    private final String dbList;
    private final String tableList;

    @Getter
    @Setter(AccessLevel.PRIVATE)
    private String jobId;

    private CdcDatabaseSourceProperty(String name, String hostName, int port, String userName, String password,
                                      String connectionTimeZone,
                                      String serverId, int connectTimeout, String dbList, String tableList) {
        this.name = name;
        this.hostName = hostName;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.connectionTimeZone = connectionTimeZone;
        this.serverId = serverId;
        this.connectTimeout = connectTimeout;
        this.dbList = dbList;
        this.tableList = tableList;
    }

    public void assignJobId(String jobId) {
        this.setJobId(jobId);
    }

    public static CdcDatabaseSourceProperty create(Properties properties) {

        CdcDatabaseSourceProperty property = new CdcDatabaseSourceProperty(
                properties.getProperty("source.name"),
                properties.getProperty("source.database.host"),
                Integer.parseInt(properties.getProperty("source.database.port")),
                properties.getProperty("source.database.username"),
                properties.getProperty("source.database.password"),
                properties.getProperty("source.database.connectionTimeZone"),
                properties.getProperty("source.database.serverId"),
                Integer.parseInt(properties.getProperty("source.database.connectTimeout")),
                properties.getProperty("source.database.db.list"),
                properties.getProperty("source.database.table.list"));
        property.setJobId(properties.getProperty(TableConstant.PARAM_JOB_ID));

        return property;
    }
}
