package com.bcxin.flink.cdc.dispatch.task.components;

import com.bcxin.flink.cdc.dispatch.task.cdcs.CdcSourceMeta;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class MultiThreadConsumerClient implements Runnable{
    private static final Logger logger = LoggerFactory.getLogger(MultiThreadConsumerClient.class);

    private final LinkedBlockingQueue<CdcSourceMeta> bufferQueue;
    private final CyclicBarrier barrier;

    public MultiThreadConsumerClient(LinkedBlockingQueue<CdcSourceMeta> bufferQueue,
                                     CyclicBarrier barrier) {
        this.bufferQueue = bufferQueue;
        this.barrier = barrier;
    }

    @Override
    public void run() {
        CdcSourceMeta entity;
        int MAX_BATCH_SIZE = 800;
        Collection<CdcSourceMeta> willSend=new ArrayList<>(MAX_BATCH_SIZE);
        while (true) {
            try {
                //entity = bufferQueue.poll(50, TimeUnit.MILLISECONDS);
                entity = bufferQueue.take();
                willSend.add(entity);
                int i = 0;
                while (++i < MAX_BATCH_SIZE &&
                        (entity = bufferQueue.poll(5, TimeUnit.SECONDS)) != null) { // poll是一个等待的操作，当等
                    willSend.add(entity);                                                     // 待 MAX_WAIT_TIME 后未能获
                }

                if (!CollectionUtils.isEmpty(willSend)) {
                    //doExecute(willSend);
                    CdcBinlog2DispatchComponent.doExecute(willSend);

                } else {
                    if (barrier.getNumberWaiting() > 0) {
                        logger.error("MultiThreadConsumerClient 执行flush, 当前线程数:" + barrier.getNumberWaiting());
                        flush();
                    }
                }

            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * client执行flush操作, 防止丢数据
     */
    private void flush()
    {

    }
}
