package com.bcxin.flink.cdc.dispatch.task.cdcs;

import com.alibaba.fastjson.annotation.JSONField;
import com.bcxin.event.core.KafkaConstants;
import com.bcxin.event.core.exceptions.BadEventException;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;

@Data
public class CdcSourceMeta implements Serializable {
    private final static Logger logger  = LoggerFactory.getLogger(CdcSourceMeta.class);

    private String op;

    /**
     * 变更前
     */
    private CoreData before;
    /**
     * 变更后
     */
    private CoreData after;

    private SourceData source;

    private String originalValue;

    public String getServerId() {
        if (this.getSource() == null) {
            return null;
        }

        return this.getSource().getServerId();
    }

    public String getTopicKey1() {
        if (this.getSource() == null) {
            return null;
        }

        return String.format(
                "streaming.topic.data.%s.%s",
                this.getDbName(),
                this.getTableName()
        );
    }

    public String getId() {
        String dataId = null;
        if (this.getBefore() != null) {
            dataId = this.getBefore().getId();
        }

        if (StringUtils.isEmpty(dataId) && this.getAfter() != null) {
            dataId = this.getAfter().getId();
        }

        return dataId;
    }

    public String getPartitionKey() {
        String dataId = null;
        if (this.getBefore() != null) {
            dataId = this.getBefore().getPartitionKey();
        }

        if (StringUtils.isEmpty(dataId) && this.getAfter() != null) {
            dataId = this.getAfter().getPartitionKey();
        }

        if(StringUtils.isEmpty(dataId)) {
            logger.error("无效的dataId=null;{}.{}.{}", this.getDbName(), this.getTableName(), this.getOp());
            return "fixed";
        }

        return dataId;
    }

    public String getDomainId() {
        String dataId = null;
        if (this.getBefore() != null) {
            dataId = this.getBefore().getDomainId();
        }

        if (StringUtils.isEmpty(dataId) && this.getAfter() != null) {
            dataId = this.getAfter().getDomainId();
        }

        /**
         *  来自智能人事的数据
         */
        if (this.getBefore() != null) {
            dataId = this.getBefore().getOrganizationId();
        }

        if (StringUtils.isEmpty(dataId) && this.getAfter() != null) {
            dataId = this.getAfter().getOrganizationId();
        }

        return dataId;
    }

    public boolean isEmployeeStatusChanged() {
        if (this.getBefore() == null) {
            return true;
        }

        if (this.getAfter() == null) {
            return true;
        }

        return this.getBefore().getStatus() != this.getAfter().getStatus();
    }


    public String getSecurityId() {
        String securityId = null;
        if (this.getBefore()!=null && !StringUtils.isEmpty(this.getBefore().getSecurityId())) {
            securityId = this.getBefore().getSecurityIdFromStationPerson();
        }

        if (!StringUtils.isEmpty(this.getAfter().getSecurityIdFromStationPerson2())) {
            securityId = this.getAfter().getSecurityIdFromStationPerson();
        }

        return securityId;
    }

    public String getDbName() {
        if (this.getSource() == null) {
            return null;
        }

        return this.getSource().getDbName();
    }

    public String getTableName() {
        if (this.getSource() == null) {
            return null;
        }

        return this.getSource().getTableName();
    }


    public String getFile() {
        if (this.getSource() == null) {
            return null;
        }

        return this.getSource().getFile();
    }

    public int getPos() {
        if (this.getSource() == null) {
            return 0;
        }

        return this.getSource().getPos();
    }

    /**
     * 默认设置10个分区进行消费
     *
     * @return
     */
    public int getPartition() {
        if (this.getId() == null) {
            return 0;
        }

        int partition =
                Math.abs(this.getPartitionKey().hashCode()) % KafkaConstants.DEFAULT_PARTITION_COUNT;

        if (partition >= KafkaConstants.DEFAULT_PARTITION_COUNT) {
            throw new BadEventException(String.format("无效分区数据:%s", partition));
        }

        return partition;
    }

    @Data
    public static class CoreData implements Serializable {
        private String id;
        @JSONField(name = "organization_id")
        private String organizationId;
        @JSONField(name = "DOMAINID")
        private String domainId;
        /**
         * 针对职员数据
         */
        @JSONField(name = "tenant_user_id")
        private String tenantUserId;

        @JSONField(name = "ITEM_securityId")
        private String securityIdFromStationPerson;

        @JSONField(name = "ITEM_SECURITYID")
        private String securityIdFromStationPerson2;

        @JSONField(name = "status")
        private String status;

        public String getPartitionKey() {
            if (!StringUtils.isEmpty(this.getOrganizationId()) &&
                    this.getOrganizationId().trim().length() > 1) {
                return this.getOrganizationId();
            }
            if (!StringUtils.isEmpty(this.getDomainId()) &&
                    this.getDomainId().trim().length() > 1) {
                return this.getDomainId();
            }

            if (!StringUtils.isEmpty(this.getTenantUserId()) &&
                    this.getTenantUserId().trim().length() > 1) {
                return this.getTenantUserId();
            }

            return this.getId();
        }

        public String getSecurityId() {
            if (!StringUtils.isEmpty(this.getSecurityIdFromStationPerson())) {
                return this.getSecurityIdFromStationPerson();
            }

            if (!StringUtils.isEmpty(this.getSecurityIdFromStationPerson2())) {
                return this.getSecurityIdFromStationPerson2();
            }

            return null;
        }
    }

    @Data
    public static class SourceData implements Serializable{
        @JSONField(name = "db")
        private String dbName;
        private String connector;
        private String name;
        @JSONField(name = "table")
        private String tableName;
        @JSONField(name = "server_id")
        private String serverId;

        @JSONField(name = "file")
        private String file;
        @JSONField(name = "pos")
        private int pos;
    }
}
