package com.bcxin.flink.cdc.dispatch.task;

import com.bcxin.flink.cdc.dispatch.task.proerpties.CdcDatabaseSourceProperty;
import com.bcxin.flink.streaming.cores.CoreJobContext;
import com.bcxin.flink.streaming.cores.TableConstant;
import com.bcxin.flink.streaming.cores.properties.CheckpointConfigProperty;
import lombok.Getter;
import org.apache.commons.collections.MapUtils;

import java.util.HashMap;
import java.util.Map;

@Getter
public class JobContext implements CoreJobContext {
    private final String name;
    private final Map<String,String> flinkConfig;
    private JobContext(
            String name,
            CdcDatabaseSourceProperty databaseProperty,
            CheckpointConfigProperty configProperty) {
        this.name = name;
        this.flinkConfig = new HashMap<>();
        this.configProperty = configProperty;
        this.databaseProperty = databaseProperty;
    }

    private final CheckpointConfigProperty configProperty;

    private final CdcDatabaseSourceProperty databaseProperty;

    public void assign(HashMap<String,String> optionConfig) {
        if (MapUtils.isEmpty(optionConfig)) {
            return;
        }

        for (String key : optionConfig.keySet()) {
            this.getFlinkConfig().put(key, optionConfig.get(key));
        }
    }

    private static JobContext _instance;
    public static void init(
            String name,
            CdcDatabaseSourceProperty databaseProperty,
            CheckpointConfigProperty configProperty) {
        if (_instance == null) {
            synchronized (JobContext.class) {
                if (_instance == null) {
                    _instance = new JobContext(name, databaseProperty,
                            configProperty);
                }
            }
        }
    }

    public static JobContext getInstance() {

        if (_instance == null) {
            throw new IllegalArgumentException("未对JobContext进行初始化操作");
        }

        return _instance;
    }

    public String getJobId()
    {
        return System.getProperty(TableConstant.PARAM_JOB_ID);
    }
}
