/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.model.product.ProductRelation;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.CancelCollectRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.UserCollectRequest;
import com.zbkj.common.response.UserProductRelationResponse;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.service.dao.ProductRelationDao;
import com.zbkj.service.service.ProductRelationService;
import com.zbkj.service.service.UserService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ProductRelationServiceImpl
extends ServiceImpl<ProductRelationDao, ProductRelation>
implements ProductRelationService {
    @Resource
    private ProductRelationDao dao;
    @Autowired
    private UserService userService;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public Boolean delete(CancelCollectRequest request) {
        Integer userId = this.userService.getUserIdException();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(ProductRelation::getProductId, (Collection)CrmebUtil.stringToArray((String)request.getIds()));
        lqw.eq(ProductRelation::getUid, (Object)userId);
        return this.dao.delete((Wrapper)lqw) > 0;
    }

    @Override
    public PageInfo<UserProductRelationResponse> getUserList(PageParamRequest pageParamRequest) {
        Integer userId = this.userService.getUserIdException();
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List<UserProductRelationResponse> list = this.dao.getUserList(userId);
        return CommonPage.copyPageInfo((Page)page, list);
    }

    @Override
    public Integer getCollectCountByUid(Integer uid) {
        LambdaQueryWrapper lqr = Wrappers.lambdaQuery();
        lqr.eq(ProductRelation::getUid, (Object)uid);
        lqr.eq(ProductRelation::getType, (Object)"collect");
        return this.dao.selectCount((Wrapper)lqr);
    }

    @Override
    public Boolean deleteByProId(Integer proId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(ProductRelation::getProductId, new Object[]{proId});
        int delete = this.dao.delete((Wrapper)lqw);
        return delete > 0;
    }

    @Override
    public Integer getCountByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{ProductRelation::getId});
        lqw.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Integer getCountByDateAndProId(String date, Integer proId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{ProductRelation::getId});
        lqw.eq(ProductRelation::getProductId, (Object)proId);
        lqw.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Boolean add(UserCollectRequest request) {
        ProductRelation productRelation = new ProductRelation();
        productRelation.setProductId(request.getProductId());
        productRelation.setUid(this.userService.getUserIdException());
        productRelation.setType("collect");
        productRelation.setCategory(request.getCategory());
        return this.save(productRelation);
    }

    @Override
    public Integer getCollectCountByProductId(Integer productId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{ProductRelation::getId});
        lqw.eq(ProductRelation::getProductId, (Object)productId);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Boolean existCollectByUser(Integer uid, Integer proId) {
        if (uid.equals(0) || proId.equals(0)) {
            return false;
        }
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{ProductRelation::getId});
        lqw.eq(ProductRelation::getProductId, (Object)proId);
        lqw.eq(ProductRelation::getUid, (Object)uid);
        lqw.eq(ProductRelation::getType, (Object)"collect");
        lqw.last(" limit 1");
        ProductRelation relation = (ProductRelation)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)relation);
    }

    @Override
    public Boolean deleteByUidAndProIdList(Integer uid, List<Integer> proIdList) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.in(ProductRelation::getProductId, proIdList);
        wrapper.eq(ProductRelation::getCategory, (Object)ProductConstants.PRODUCT_RELATION_CATEGORY_NORMAL);
        wrapper.eq(ProductRelation::getUid, (Object)uid);
        wrapper.eq(ProductRelation::getType, (Object)"collect");
        return this.dao.delete((Wrapper)wrapper) > 0;
    }

    @Override
    public Boolean batchAdd(Integer uid, List<Integer> proIdList) {
        if (CollUtil.isEmpty(proIdList)) {
            return true;
        }
        List relationList = proIdList.stream().map(pid -> {
            ProductRelation productRelation = new ProductRelation();
            productRelation.setUid(uid);
            productRelation.setType("collect");
            productRelation.setCategory(ProductConstants.PRODUCT_RELATION_CATEGORY_NORMAL);
            productRelation.setProductId(pid);
            return productRelation;
        }).collect(Collectors.toList());
        return this.saveBatch(relationList);
    }

    @Override
    public Boolean deleteByUid(Integer uid) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(ProductRelation::getUid, (Object)uid);
        return this.remove((Wrapper)wrapper);
    }
}

