/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxFapiaoApply;
import com.zbkj.common.model.bcx.BcxFapiaoSource;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxFapiaoApplyCreateRequest;
import com.zbkj.common.request.bcx.BcxFapiaoApplyRejectRequest;
import com.zbkj.common.request.bcx.BcxFapiaoApplyRequest;
import com.zbkj.common.request.bcx.BcxFapiaoTitleRequest;
import com.zbkj.common.request.bcx.BcxWriteFapiaoRequest;
import com.zbkj.common.response.bcx.BcxFapiaoApplyDetailResponse;
import com.zbkj.common.response.bcx.BcxFapiaoApplyResponse;
import com.zbkj.common.response.bcx.BcxFapiaoLastSendToResponse;
import com.zbkj.common.response.bcx.BcxSummaryInfo;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.DateUtils;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.bcx.BcxFapiaoApplyDao;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.bcx.BcxFapiaoApplyService;
import com.zbkj.service.service.bcx.BcxFapiaoSourceService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Validator;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class BcxFapiaoApplyServiceImpl
extends ServiceImpl<BcxFapiaoApplyDao, BcxFapiaoApply>
implements BcxFapiaoApplyService {
    @Resource
    private BcxFapiaoApplyDao dao;
    @Resource
    private UserService userService;
    @Resource
    private BcxFapiaoSourceService bcxFapiaoSourceService;
    @Resource
    private Validator validator;
    @Resource
    private TransactionTemplate transactionTemplate;

    @Override
    public BcxFapiaoApplyResponse queryById(Integer id) {
        BcxFapiaoApply source = (BcxFapiaoApply)this.dao.selectById(id);
        BcxFapiaoApplyResponse target = this.transform(source);
        return target;
    }

    @Override
    public PageInfo<BcxFapiaoApplyResponse> queryWriterPagedList(BcxFapiaoApplyRequest request, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        Integer userId = this.userService.getUserIdException();
        lqw.eq(BcxFapiaoApply::getWriterId, (Object)userId);
        return this.queryPagedList(request, pageParamRequest, (LambdaQueryWrapper<BcxFapiaoApply>)lqw);
    }

    @Override
    public PageInfo<BcxFapiaoApplyResponse> queryReceiverPagedList(BcxFapiaoApplyRequest request, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        Integer userId = this.userService.getUserIdException();
        lqw.eq(BcxFapiaoApply::getReceiverId, (Object)userId);
        return this.queryPagedList(request, pageParamRequest, (LambdaQueryWrapper<BcxFapiaoApply>)lqw);
    }

    private PageInfo<BcxFapiaoApplyResponse> queryPagedList(BcxFapiaoApplyRequest request, PageParamRequest pageParamRequest, LambdaQueryWrapper<BcxFapiaoApply> lqw) {
        this.concatQueryParam(lqw, request);
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List sources = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)sources)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new BcxFapiaoApplyResponse[0]));
        }
        List<BcxFapiaoApplyResponse> result = this.transform(sources);
        return CommonPage.copyPageInfo((Page)page, result);
    }

    private LambdaQueryWrapper<BcxFapiaoApply> concatQueryParam(LambdaQueryWrapper<BcxFapiaoApply> lqw, BcxFapiaoApplyRequest request) {
        lqw.orderByDesc(BcxFapiaoApply::getId);
        if (StrUtil.isNotEmpty((CharSequence)request.getFapiaoNo())) {
            lqw.like(BcxFapiaoApply::getFapiaoNo, (Object)request.getFapiaoNo());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getApplyNo())) {
            lqw.like(BcxFapiaoApply::getApplyNo, (Object)request.getApplyNo());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getReceiver())) {
            lqw.like(BcxFapiaoApply::getReceiver, (Object)request.getReceiver());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getWriter())) {
            lqw.like(BcxFapiaoApply::getWriter, (Object)request.getWriter());
        }
        if (ObjectUtil.isNotNull((Object)request.getFapiaoStatus())) {
            lqw.eq(BcxFapiaoApply::getFapiaoStatus, (Object)request.getFapiaoStatus());
        }
        if (ObjectUtil.isNotNull((Object)request.getSourceType())) {
            lqw.eq(BcxFapiaoApply::getSourceType, (Object)request.getSourceType());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getFapiaoTime())) {
            DateLimitUtilVo fapiaoTime = CrmebDateUtil.getDateLimit((String)request.getFapiaoTime());
            lqw.ge(BcxFapiaoApply::getWriteTime, (Object)fapiaoTime.getStartTime());
            lqw.le(BcxFapiaoApply::getWriteTime, (Object)fapiaoTime.getEndTime());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getApplyTime())) {
            DateLimitUtilVo applyTime = CrmebDateUtil.getDateLimit((String)request.getApplyTime());
            lqw.ge(BcxFapiaoApply::getApplyTime, (Object)applyTime.getStartTime());
            lqw.le(BcxFapiaoApply::getApplyTime, (Object)applyTime.getEndTime());
        }
        return lqw;
    }

    @Override
    public BcxFapiaoApply create(BcxFapiaoApplyCreateRequest request) {
        Integer userId = this.userService.getUserIdException();
        this.validateTitle(request);
        if (request.getApplyId() != null) {
            BcxFapiaoApply apply = (BcxFapiaoApply)this.getById(request.getApplyId());
            if (apply == null || !userId.equals(apply.getReceiverId())) {
                throw new CrmebException("\u627e\u4e0d\u5230\u7533\u8bf7\u5355\uff1a" + request.getApplyId());
            }
            BeanUtils.copyProperties((Object)request, (Object)apply);
            apply.setFapiaoStatus(Integer.valueOf(2));
            this.updateById(apply);
            return apply;
        }
        String sourceIds = request.getSourceIds();
        if (StrUtil.isBlank((CharSequence)sourceIds)) {
            throw new CrmebException("\u6e90\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> ids = Arrays.asList(sourceIds.split(","));
        List<Integer> idList = ids.stream().map(Integer::parseInt).collect(Collectors.toList());
        Map<Integer, BcxFapiaoSource> sourceMap = this.bcxFapiaoSourceService.getMapBySourceIdList(idList);
        if (sourceMap.size() != ids.size()) {
            throw new CrmebException("\u6e90\u5355\u4e0d\u5b58\u5728" + sourceIds);
        }
        Collection<BcxFapiaoSource> sources = sourceMap.values();
        List writers = sources.stream().map(BcxFapiaoSource::getWriterId).distinct().collect(Collectors.toList());
        if (writers.size() > 1) {
            throw new CrmebException("\u5f00\u7968\u65b9\u4e0d\u540c\uff0c\u4e0d\u80fd\u5408\u5e76");
        }
        List receiverIds = sources.stream().map(BcxFapiaoSource::getReceiverId).distinct().collect(Collectors.toList());
        if (receiverIds.size() > 1) {
            throw new CrmebException("\u6536\u7968\u65b9\u4e0d\u540c\uff0c\u4e0d\u80fd\u5408\u5e76");
        }
        if (!userId.equals(receiverIds.get(0))) {
            throw new CrmebException("\u975e\u6cd5\u8bf7\u6c42");
        }
        List bizTypes = sources.stream().map(BcxFapiaoSource::getCategoryId).distinct().collect(Collectors.toList());
        if (bizTypes.size() > 1) {
            throw new CrmebException("\u5546\u54c1\u5206\u7c7b\u4e0d\u540c\uff0c\u4e0d\u80fd\u5408\u5e76");
        }
        List sourceTypes = sources.stream().map(BcxFapiaoSource::getSourceType).distinct().collect(Collectors.toList());
        if (sourceTypes.size() > 1) {
            throw new CrmebException("\u8d39\u7528\u7c7b\u578b\u4e0d\u540c\uff0c\u4e0d\u80fd\u5408\u5e76");
        }
        if (sources.stream().anyMatch(s -> StrUtil.isNotBlank((CharSequence)s.getApplyNo()))) {
            throw new CrmebException("\u6709\u5355\u636e\u5df2\u7533\u8bf7\uff0c\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7\u5f00\u7968");
        }
        BcxFapiaoApply apply = new BcxFapiaoApply();
        BeanUtils.copyProperties((Object)request, (Object)apply);
        apply.setApplyNo(CrmebUtil.getOrderNo((String)"FP"));
        apply.setApplyTime(new Date());
        apply.setFapiaoAmount(sources.stream().map(BcxFapiaoSource::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        apply.setFapiaoStatus(Integer.valueOf(2));
        apply.setWriterId((Integer)writers.get(0));
        apply.setWriter(sources.stream().findFirst().get().getWriter());
        apply.setReceiverId((Integer)receiverIds.get(0));
        apply.setReceiver(sources.stream().findFirst().get().getReceiver());
        apply.setSourceType((Integer)sourceTypes.get(0));
        sources.forEach(s -> s.setApplyNo(apply.getApplyNo()));
        if (((Boolean)this.transactionTemplate.execute(transactionStatus -> {
            this.bcxFapiaoSourceService.updateBatchById(sources);
            return this.save(apply);
        })).booleanValue()) {
            return apply;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean writeFapiao(BcxWriteFapiaoRequest request) {
        Integer userId = this.userService.getUserIdException();
        String applyNo = request.getApplyNo();
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxFapiaoApply::getApplyNo, (Object)applyNo);
        List fapiaoList = this.dao.selectList((Wrapper)lqw);
        if (fapiaoList.size() < 1) {
            throw new CrmebException("\u4e0d\u662f\u6709\u6548\u7684\u5f00\u7968\u7533\u8bf7\u5355" + applyNo);
        }
        if (fapiaoList.stream().anyMatch(f -> f.getFapiaoStatus() == 1 || !Objects.equals(f.getWriterId(), userId))) {
            throw new CrmebException("\u5fc5\u987b\u662f\u90fd\u672a\u5f00\u7968\u7684\u672c\u5f00\u7968\u65b9\u7684\u7533\u8bf7\u5355\u624d\u80fd\u5f00\u7968");
        }
        fapiaoList.forEach(f -> {
            f.setFapiaoNo(request.getFapiaoNo());
            f.setFapiaoStatus(Integer.valueOf(1));
            f.setWriteTime(DateUtils.parseDate((Object)request.getWriteTime()));
            f.setVendorId(request.getVendorId());
            f.setVendorName(request.getVendorName());
            f.setFapiaoOrg(request.getFapiaoOrg());
            if (StrUtil.isNotEmpty((CharSequence)request.getRejectReason())) {
                f.setRejectReason(request.getRejectReason());
            }
        });
        this.updateBatchById(fapiaoList);
        return true;
    }

    @Override
    public BcxFapiaoApplyDetailResponse queryByApplyNo(String applyNo) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxFapiaoApply::getApplyNo, (Object)applyNo);
        List fapiaoList = this.dao.selectList((Wrapper)lqw);
        if (fapiaoList.size() < 1) {
            throw new CrmebException("\u4e0d\u662f\u6709\u6548\u7684\u5f00\u7968\u7533\u8bf7\u5355" + applyNo);
        }
        BcxFapiaoApplyDetailResponse response = new BcxFapiaoApplyDetailResponse();
        BeanUtils.copyProperties(fapiaoList.get(0), (Object)response);
        List<BcxFapiaoSource> sources = this.bcxFapiaoSourceService.queryByApplyNo(applyNo);
        response.setSources(sources);
        return response;
    }

    @Override
    public boolean rejectById(BcxFapiaoApplyRejectRequest request) {
        LambdaUpdateWrapper lqw = new LambdaUpdateWrapper();
        lqw.set(BcxFapiaoApply::getFapiaoStatus, (Object)3);
        lqw.set(BcxFapiaoApply::getRejectReason, (Object)request.getRejectReason());
        lqw.eq(BcxFapiaoApply::getId, (Object)request.getId());
        return this.update((Wrapper)lqw);
    }

    @Override
    public BcxSummaryInfo getWriterSummaryInfo(BcxFapiaoApplyRequest request) {
        QueryWrapper qw = new QueryWrapper();
        qw.select(new String[]{"count(1) as totalCount, sum(fapiao_amount) as totalPrice"});
        LambdaQueryWrapper<BcxFapiaoApply> lqw = this.concatQueryParam((LambdaQueryWrapper<BcxFapiaoApply>)qw.lambda(), request);
        Integer userId = this.userService.getUserIdException();
        lqw.eq(BcxFapiaoApply::getWriterId, (Object)userId);
        List maps = this.dao.selectMaps((Wrapper)lqw);
        Map map = (Map)maps.get(0);
        if (map == null) {
            return new BcxSummaryInfo(Integer.valueOf(0), BigDecimal.ZERO);
        }
        Object totalCount = map.get("totalCount");
        Object totalPrice = map.get("totalPrice");
        return new BcxSummaryInfo(Integer.valueOf(totalCount == null ? 0 : Integer.valueOf(totalCount.toString())), new BigDecimal(totalPrice == null ? "0" : totalPrice.toString()));
    }

    @Override
    public BcxSummaryInfo getReceiverSummaryInfo(BcxFapiaoApplyRequest request) {
        QueryWrapper qw = new QueryWrapper();
        qw.select(new String[]{"count(1) as totalCount, sum(fapiao_amount) as totalPrice"});
        LambdaQueryWrapper<BcxFapiaoApply> lqw = this.concatQueryParam((LambdaQueryWrapper<BcxFapiaoApply>)qw.lambda(), request);
        Integer userId = this.userService.getUserIdException();
        lqw.eq(BcxFapiaoApply::getReceiverId, (Object)userId);
        List maps = this.dao.selectMaps((Wrapper)lqw);
        Map map = (Map)maps.get(0);
        if (map == null) {
            return new BcxSummaryInfo(Integer.valueOf(0), BigDecimal.ZERO);
        }
        Object totalCount = map.get("totalCount");
        Object totalPrice = map.get("totalPrice");
        return new BcxSummaryInfo(Integer.valueOf(totalCount == null ? 0 : Integer.valueOf(totalCount.toString())), new BigDecimal(totalPrice == null ? "0" : totalPrice.toString()));
    }

    @Override
    public BcxFapiaoLastSendToResponse lastSendTo() {
        Integer userId = this.userService.getUserIdException();
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxFapiaoApply::getReceiverId, (Object)userId);
        lqw.orderByDesc(BcxFapiaoApply::getUpdateTime);
        lqw.last("limit 1");
        BcxFapiaoApply last = (BcxFapiaoApply)this.dao.selectOne((Wrapper)lqw);
        BcxFapiaoLastSendToResponse response = new BcxFapiaoLastSendToResponse();
        if (last != null) {
            BeanUtils.copyProperties((Object)last, (Object)response);
        }
        return response;
    }

    public void validateTitle(BcxFapiaoApplyCreateRequest request) {
        if (request.getTitleType() == 0 && request.getFapiaoType() == 1) {
            throw new CrmebException("\u4e2a\u4eba\u53ea\u80fd\u5f00\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968");
        }
        if (request.getTitleType() == 1) {
            if (request.getFapiaoType() == 0) {
                this.validator.validate((Object)request, new Class[]{BcxFapiaoTitleRequest.CompanyPlainGroup.class});
            } else {
                this.validator.validate((Object)request, new Class[]{BcxFapiaoTitleRequest.CompanyDedicatedGroup.class});
            }
        }
    }

    private List<BcxFapiaoApplyResponse> transform(List<BcxFapiaoApply> sources) {
        ArrayList<BcxFapiaoApplyResponse> result = new ArrayList<BcxFapiaoApplyResponse>();
        for (BcxFapiaoApply source : sources) {
            BcxFapiaoApplyResponse target = this.transform(source);
            result.add(target);
        }
        return result;
    }

    private BcxFapiaoApplyResponse transform(BcxFapiaoApply source) {
        BcxFapiaoApplyResponse target = new BcxFapiaoApplyResponse();
        BeanUtils.copyProperties((Object)source, (Object)target);
        return target;
    }
}

