/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.wangshang.notify.service.impl;

import cn.hutool.core.date.DateUtil;
import com.github.pagehelper.util.StringUtil;
import com.zbkj.common.model.huifu.HuifuWalletTrade;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.HuifuWalletAccountDetailDao;
import com.zbkj.service.dao.HuifuWalletTradeDao;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.BkcloudfundsMerchantAccountUnfreezeNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.BkcloudfundsMerchantAccountUnfreezeNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="accountUnfreezeNotifyService")
public class BkcloudfundsMerchantAccountUnfreezeNotifyImpl
implements MybankNotifyService {
    private static final Logger logger = LoggerFactory.getLogger(BkcloudfundsMerchantAccountUnfreezeNotifyImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Resource
    private HuifuWalletTradeDao huifuWalletTradeDao;
    @Resource
    private HuifuWalletAccountDetailDao huifuWalletAccountDetailDao;
    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String xmlContext, String function) throws Exception {
        BkcloudfundsMerchantAccountUnfreezeNotifyRequest merchantAccountUnfreezeNotifyRequest = XmlConverter.getInstance().toResponse(xmlContext, BkcloudfundsMerchantAccountUnfreezeNotifyRequest.class);
        RequestHead head = merchantAccountUnfreezeNotifyRequest.getBkcloudfundsMerchantAccountUnfreezeNotify().getRequestHead();
        boolean flag = false;
        try {
            flag = this.saveNotify(merchantAccountUnfreezeNotifyRequest.getBkcloudfundsMerchantAccountUnfreezeNotify().getBkcloudfundsMerchantAccountUnfreezeNotifyModel());
        }
        catch (Exception e) {
            logger.error("========= > \u5546\u6237\u4f59\u989d\u89e3\u51bb\u7ed3\u679c\u901a\u77e5\u63a5\u53e3:ant.mybank.bkcloudfunds.merchant.account.unfreeze.notify:" + e.getMessage());
        }
        String response = this.commomRequstHandle.getSignResult(flag, head);
        this.transactionLogService.save("\u5546\u6237\u4f59\u989d\u89e3\u51bb\u7ed3\u679c\u901a\u77e5\u63a5\u53e3:ant.mybank.bkcloudfunds.merchant.account.unfreeze.notify", "1", xmlContext, response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(BkcloudfundsMerchantAccountUnfreezeNotifyModel model) {
        HuifuWalletTrade trade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(model.getOperateNo());
        if (!"P".equals(trade.getTradeStatus())) {
            return true;
        }
        if ("SUCCESS".equals(model.getStatus())) {
            trade.setUpdateTime(new Date());
            if (StringUtil.isNotEmpty((String)model.getFinishTime())) {
                trade.setTransFinishTime(DateUtil.formatDateTime((Date)DateUtil.parse((String)model.getFinishTime(), (String)"yyyy-MM-dd HH:mm:ss")));
            }
            trade.setTradeStatus("S");
        } else {
            trade.setErrorMsg(model.getErrorDesc());
            trade.setUpdateTime(new Date());
            trade.setTradeStatus("F");
        }
        this.huifuWalletTradeDao.updateById(trade);
        return true;
    }
}

