/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.WeChatConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.utils.UploadUtil;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.WechatMediaService;
import com.zbkj.service.service.WechatService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@Service
public class WechatMediaServiceImpl
implements WechatMediaService {
    private static final Logger logger = LoggerFactory.getLogger(WechatMediaService.class);
    @Autowired
    private WxMaService wxMaService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private WechatService wechatService;

    @Override
    public WxMediaUploadResult uploadMedia(String type, MultipartFile multipart) {
        WxMediaUploadResult wxMediaUploadResult;
        String rootPath = this.crmebConfig.getImagePath().trim();
        String modelPath = "public/wechat/";
        String newFileName = UploadUtil.fileName((String)FilenameUtils.getExtension((String)multipart.getOriginalFilename()).toLowerCase());
        String webPath = modelPath + CrmebDateUtil.nowDate((String)"yyyy/MM/dd") + "/";
        String destPath = FilenameUtils.separatorsToSystem((String)(rootPath + webPath)) + newFileName;
        try {
            File file = UploadUtil.createFile((String)destPath);
            multipart.transferTo(file);
            wxMediaUploadResult = this.wxMaService.getMediaService().uploadMedia(type, file);
            logger.info("\u4e0a\u4f20\u5fae\u4fe1\u7d20\u6750\u6210\u529f:{}", (Object)JSON.toJSONString((Object)wxMediaUploadResult));
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5fae\u4fe1\u7d20\u6750\u51fa\u9519:{}", (Object)e.getMessage());
            throw new CrmebException(StrUtil.format((CharSequence)"\u4e0a\u4f20\u5fae\u4fe1\u7d20\u6750\u51fa\u9519:{}", (Object[])new Object[]{e.getMessage()}));
        }
        return wxMediaUploadResult;
    }

    @Override
    public WxMediaUploadResult uploadMediaByLocal(String type, String imagePath) {
        logger.info("type:{}", (Object)type);
        logger.info("imagePath:{}", (Object)imagePath);
        String rootPath = this.crmebConfig.getImagePath().trim();
        String modelPath = "public/wechat/";
        String newFileName = UploadUtil.fileName((String)FilenameUtils.getExtension((String)imagePath).toLowerCase());
        String webPath = modelPath + CrmebDateUtil.nowDate((String)"yyyy/MM/dd") + "/";
        String destPath = FilenameUtils.separatorsToSystem((String)(rootPath + webPath)) + newFileName;
        File file = new File(destPath);
        HttpUtil.downloadFile((String)imagePath, (File)file);
        try {
            WxMediaUploadResult wxMediaUploadResult = this.wxMaService.getMediaService().uploadMedia(type, file);
            logger.info("\u4e0a\u4f20\u5fae\u4fe1\u7d20\u6750\u6210\u529f:{}", (Object)JSON.toJSONString((Object)wxMediaUploadResult));
            return wxMediaUploadResult;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5fae\u4fe1\u7d20\u6750\u51fa\u9519:{}", (Object)e.getMessage());
            throw new CrmebException(StrUtil.format((CharSequence)"\u4e0a\u4f20\u5fae\u4fe1\u7d20\u6750\u51fa\u9519:{}", (Object[])new Object[]{e.getMessage()}));
        }
    }

    @Override
    public File getFileByMediaId(String mediaId) throws WxErrorException {
        return this.wxMaService.getMediaService().getMedia(mediaId);
    }

    @Override
    public String preserveUploadImgNotMediaId(MultipartFile multipart) {
        String rootPath = this.crmebConfig.getImagePath().trim();
        String modelPath = "public/wechat/";
        String newFileName = UploadUtil.fileName((String)FilenameUtils.getExtension((String)multipart.getOriginalFilename()).toLowerCase());
        String webPath = modelPath + CrmebDateUtil.nowDate((String)"yyyy/MM/dd") + "/";
        String destPath = FilenameUtils.separatorsToSystem((String)(rootPath + webPath)) + newFileName;
        File file = null;
        try {
            file = UploadUtil.createFile((String)destPath);
            multipart.transferTo(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_MEDIA_UPLOADIMG, (Object[])new Object[]{miniAccessToken});
        FileSystemResource fileSystemResource = new FileSystemResource(destPath);
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"media", (Object)fileSystemResource);
        String uploadResult = this.restTemplateUtil.postFormData(url, params);
        JSONObject jsonObject = JSONObject.parseObject((String)uploadResult);
        return jsonObject.getString("url");
    }

    @Override
    public JSONObject preserveUploadImgHasMediaId(String imgUrl) {
        Assert.notNull((Object)imgUrl, (String)"\u56fe\u7247\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        String rootPath = this.crmebConfig.getImagePath().trim();
        String modelPath = "public/wechat/";
        String newFileName = UploadUtil.fileName((String)FilenameUtils.getExtension((String)imgUrl).toLowerCase());
        String webPath = modelPath + CrmebDateUtil.nowDate((String)"yyyy/MM/dd") + "/";
        String destPath = FilenameUtils.separatorsToSystem((String)(rootPath + webPath)) + newFileName;
        File file = new File(destPath);
        HttpUtil.downloadFile((String)imgUrl, (File)file);
        String miniAccessToken = this.wechatService.getPublicAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_MEDIA_UPLOADIMG_HASMEDIAID, (Object[])new Object[]{miniAccessToken});
        FileSystemResource fileSystemResource = new FileSystemResource(destPath);
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"media", (Object)fileSystemResource);
        params.add((Object)"type", (Object)"image");
        String uploadResult = this.restTemplateUtil.postFormData(url, params);
        return JSONObject.parseObject((String)uploadResult);
    }

    @Override
    public File preserveImgGet(String mediaId) {
        String miniAccessToken = this.wechatService.getPublicAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_MEDIA_GET, (Object[])new Object[]{miniAccessToken});
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("media_id", (Object)mediaId);
        String uploadResult = this.restTemplateUtil.postJsonData(url, jsonObject);
        File file = new File("Tempalte", "xx");
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])uploadResult.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6c38\u4e45\u7d20\u6750\u51fa\u9519:{}", (Object)e.getMessage());
            throw new CrmebException("\u83b7\u53d6\u6c38\u4e45\u7d20\u6750\u51fa\u9519:" + e.getMessage());
        }
        return new File(uploadResult);
    }
}

