/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.express.ShippingTemplatesFree;
import com.zbkj.common.request.ShippingTemplatesFreeRequest;
import com.zbkj.common.response.ShippingTemplatesFreeResponse;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.service.dao.ShippingTemplatesFreeDao;
import com.zbkj.service.service.ShippingTemplatesFreeService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Service;

@Service
public class ShippingTemplatesFreeServiceImpl
extends ServiceImpl<ShippingTemplatesFreeDao, ShippingTemplatesFree>
implements ShippingTemplatesFreeService {
    @Resource
    private ShippingTemplatesFreeDao dao;

    @Override
    public Boolean saveAll(List<ShippingTemplatesFreeRequest> shippingTemplatesFreeRequestList, Integer type, Integer tempId) {
        ArrayList<ShippingTemplatesFree> shippingTemplatesFreesList = new ArrayList<ShippingTemplatesFree>();
        for (ShippingTemplatesFreeRequest shippingTemplatesFreeRequest : shippingTemplatesFreeRequestList) {
            String uniqueKey = DigestUtils.md5Hex((String)shippingTemplatesFreeRequest.toString());
            List titleArray = JSONArray.parseArray((String)shippingTemplatesFreeRequest.getTitle(), String.class);
            if (shippingTemplatesFreeRequest.getCityId().equals("all") || shippingTemplatesFreeRequest.getCityId().equals("0")) {
                ShippingTemplatesFree shippingTemplatesFree = new ShippingTemplatesFree();
                shippingTemplatesFree.setCityId(Integer.valueOf(0));
                shippingTemplatesFree.setTitle((String)titleArray.get(0));
                shippingTemplatesFree.setUniqid(uniqueKey);
                shippingTemplatesFree.setTempId(tempId);
                shippingTemplatesFree.setType(type);
                shippingTemplatesFree.setNumber(shippingTemplatesFreeRequest.getNumber());
                shippingTemplatesFree.setPrice(shippingTemplatesFreeRequest.getPrice());
                shippingTemplatesFreesList.add(shippingTemplatesFree);
                continue;
            }
            List cityIdList = CrmebUtil.stringToArray((String)shippingTemplatesFreeRequest.getCityId());
            HashMap cityMap = new HashMap();
            titleArray.forEach(e -> {
                JSONArray parseArray = JSONArray.parseArray((String)e);
                Integer cityId = parseArray.getInteger(2);
                cityMap.put(cityId, e);
            });
            for (Integer cityId : cityIdList) {
                ShippingTemplatesFree shippingTemplatesFree = new ShippingTemplatesFree();
                shippingTemplatesFree.setCityId(cityId);
                shippingTemplatesFree.setTitle((String)cityMap.get(cityId));
                shippingTemplatesFree.setUniqid(uniqueKey);
                shippingTemplatesFree.setTempId(tempId);
                shippingTemplatesFree.setType(type);
                shippingTemplatesFree.setNumber(shippingTemplatesFreeRequest.getNumber());
                shippingTemplatesFree.setPrice(shippingTemplatesFreeRequest.getPrice());
                shippingTemplatesFreesList.add(shippingTemplatesFree);
            }
        }
        return this.saveBatch(shippingTemplatesFreesList);
    }

    @Override
    public Boolean deleteByTempId(Integer tempId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(ShippingTemplatesFree::getTempId, (Object)tempId);
        return this.dao.delete((Wrapper)wrapper) > 0;
    }

    @Override
    public ShippingTemplatesFree getByTempIdAndCityId(Integer tempId, Integer cityId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(ShippingTemplatesFree::getTempId, (Object)tempId);
        lqw.eq(ShippingTemplatesFree::getCityId, (Object)cityId);
        lqw.last(" limit 1");
        return (ShippingTemplatesFree)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean existCityId(Integer regionId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{ShippingTemplatesFree::getId});
        lqw.eq(ShippingTemplatesFree::getCityId, (Object)regionId);
        lqw.last(" limit 1");
        ShippingTemplatesFree shippingTemplatesRegion = (ShippingTemplatesFree)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)shippingTemplatesRegion);
    }

    @Override
    public List<ShippingTemplatesFreeResponse> getListGroup(Integer tempId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{ShippingTemplatesFree::getTitle, ShippingTemplatesFree::getNumber, ShippingTemplatesFree::getPrice, ShippingTemplatesFree::getUniqid});
        lqw.eq(ShippingTemplatesFree::getTempId, (Object)tempId);
        List list = this.dao.selectList((Wrapper)lqw);
        ArrayList responseList = CollUtil.newArrayList((Object[])new ShippingTemplatesFreeResponse[0]);
        if (CollUtil.isEmpty((Collection)list)) {
            return responseList;
        }
        Map<String, List<ShippingTemplatesFree>> listMap = list.stream().collect(Collectors.groupingBy(ShippingTemplatesFree::getUniqid));
        Set<Map.Entry<String, List<ShippingTemplatesFree>>> entrySet = listMap.entrySet();
        for (Map.Entry<String, List<ShippingTemplatesFree>> entry : entrySet) {
            String uniqid = entry.getKey();
            String title = entry.getValue().stream().map(ShippingTemplatesFree::getTitle).collect(Collectors.joining(","));
            ShippingTemplatesFree free = entry.getValue().get(0);
            ShippingTemplatesFreeResponse response = new ShippingTemplatesFreeResponse();
            response.setTitle(title);
            response.setUniqid(uniqid);
            response.setNumber(free.getNumber());
            response.setPrice(free.getPrice());
            responseList.add(response);
        }
        return responseList;
    }
}

