/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.CouponConstants;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.coupon.Coupon;
import com.zbkj.common.model.coupon.CouponProduct;
import com.zbkj.common.model.coupon.CouponUser;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.merchant.MerchantInfo;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttr;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.model.product.ProductCategory;
import com.zbkj.common.model.product.ProductCoupon;
import com.zbkj.common.model.product.ProductDescription;
import com.zbkj.common.model.seckill.SeckillActivity;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.CouponProductSearchRequest;
import com.zbkj.common.request.MerchantProductSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.ProductActivitySearchRequest;
import com.zbkj.common.request.ProductAddRequest;
import com.zbkj.common.request.ProductAddStockRequest;
import com.zbkj.common.request.ProductAttrValueAddRequest;
import com.zbkj.common.request.ProductAttrValueAddStockRequest;
import com.zbkj.common.request.ProductAttrValueReviewFreeEditRequest;
import com.zbkj.common.request.ProductAuditRequest;
import com.zbkj.common.request.ProductDeleteRequest;
import com.zbkj.common.request.ProductForceDownRequest;
import com.zbkj.common.request.ProductFrontSearchRequest;
import com.zbkj.common.request.ProductPlatUpdateRequest;
import com.zbkj.common.request.ProductRequest;
import com.zbkj.common.request.ProductReviewFreeEditRequest;
import com.zbkj.common.request.ProductSearchRequest;
import com.zbkj.common.request.SystemCouponProductSearchRequest;
import com.zbkj.common.response.AdminProductListResponse;
import com.zbkj.common.response.AttrValueResponse;
import com.zbkj.common.response.BcxProductInfoResponse;
import com.zbkj.common.response.PlatformProductListResponse;
import com.zbkj.common.response.ProMerchantProductResponse;
import com.zbkj.common.response.ProductActivityResponse;
import com.zbkj.common.response.ProductFrontResponse;
import com.zbkj.common.response.ProductInfoResponse;
import com.zbkj.common.response.ProductResponseForCopyProduct;
import com.zbkj.common.response.ProductTabsHeaderResponse;
import com.zbkj.common.response.bcx.BcxProductRiskResponse;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.LoginUserVo;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.OnePassUserInfoVo;
import com.zbkj.common.vo.ProCategoryCacheVo;
import com.zbkj.common.vo.SimpleProductVo;
import com.zbkj.service.dao.ProductDao;
import com.zbkj.service.service.ActivityStyleService;
import com.zbkj.service.service.CartService;
import com.zbkj.service.service.CouponProductService;
import com.zbkj.service.service.CouponService;
import com.zbkj.service.service.CouponUserService;
import com.zbkj.service.service.MerchantInfoService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OnePassService;
import com.zbkj.service.service.ProductAttrService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductCategoryService;
import com.zbkj.service.service.ProductCouponService;
import com.zbkj.service.service.ProductDescriptionService;
import com.zbkj.service.service.ProductRelationService;
import com.zbkj.service.service.ProductReplyService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.SeckillActivityService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.util.ProductUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ProductServiceImpl
extends ServiceImpl<ProductDao, Product>
implements ProductService {
    private final Logger LOGGER = LoggerFactory.getLogger(ProductServiceImpl.class);
    @Resource
    private ProductDao dao;
    @Autowired
    private ProductAttrService attrService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Autowired
    private ProductDescriptionService productDescriptionService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private CouponProductService couponProductService;
    @Autowired
    private ProductCouponService productCouponService;
    @Autowired
    private CouponUserService couponUserService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private ProductCategoryService productCategoryService;
    @Autowired
    private MerchantInfoService merchantInfoService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private CouponService couponService;
    @Autowired
    private ProductUtils productUtils;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private OnePassService onePassService;
    @Autowired
    private ProductRelationService productRelationService;
    @Autowired
    private CartService cartService;
    @Autowired
    private ProductReplyService productReplyService;
    @Autowired
    private SeckillActivityService seckillActivityService;
    @Autowired
    private ActivityStyleService activityStyleService;

    @Override
    public PageInfo<AdminProductListResponse> getAdminList(ProductSearchRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(Product::getMerId, (Object)admin.getMerId());
        this.setAdminListWrapperByType((LambdaQueryWrapper<Product>)lqw, request.getType(), admin.getMerId());
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(Product::getName, (Object)keywords)).or()).apply(StrUtil.format((CharSequence)" find_in_set('{}', keyword)", (Object[])new Object[]{keywords}), new Object[0]);
            });
        }
        if (ObjectUtil.isNotNull((Object)request.getIsShow())) {
            lqw.eq(Product::getIsShow, (Object)request.getIsShow());
        }
        lqw.apply(StrUtil.isNotBlank((CharSequence)request.getCateId()), "FIND_IN_SET ('" + request.getCateId() + "', cate_id)", new Object[0]);
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            lqw.eq(Product::getCategoryId, (Object)request.getCategoryId());
        }
        ((LambdaQueryWrapper)lqw.orderByDesc(Product::getSort)).orderByDesc(Product::getId);
        Page productPage = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List products = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)products)) {
            return CommonPage.copyPageInfo((Page)productPage, (List)CollUtil.newArrayList((Object[])new AdminProductListResponse[0]));
        }
        ArrayList<AdminProductListResponse> productResponses = new ArrayList<AdminProductListResponse>();
        List<ProductCategory> categoryCache = this.productCategoryService.getCache();
        Map<Integer, ProductCategory> cateMap = categoryCache.stream().collect(Collectors.toMap(ProductCategory::getId, c -> c));
        for (Product product : products) {
            AdminProductListResponse productResponse = new AdminProductListResponse();
            BeanUtils.copyProperties((Object)product, (Object)productResponse);
            productResponse.setCollectCount(this.productRelationService.getCollectCountByProductId(product.getId()));
            if (cateMap.get(product.getCategoryId()) != null) {
                productResponse.setCategoryName(cateMap.get(product.getCategoryId()).getName());
            }
            productResponses.add(productResponse);
        }
        return CommonPage.copyPageInfo((Page)productPage, productResponses);
    }

    @Override
    public List<SimpleProductVo> getSimpleListInIds(List<Integer> productIds) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{Product::getId, Product::getName, Product::getImage, Product::getPrice, Product::getStock});
        lqw.in(Product::getId, productIds);
        lqw.eq(Product::getIsDel, (Object)false);
        List selectList = this.dao.selectList((Wrapper)lqw);
        return selectList.stream().map(e -> {
            SimpleProductVo vo = new SimpleProductVo();
            BeanUtils.copyProperties((Object)e, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
    }

    @Override
    public Boolean save(ProductAddRequest request) {
        ProductCategory productCategory;
        if (!request.getSpecType().booleanValue() && request.getAttrValue().size() > 1) {
            throw new CrmebException("\u5355\u89c4\u683c\u5546\u54c1\u5c5e\u6027\u503c\u4e0d\u80fd\u5927\u4e8e1");
        }
        if (request.getIsSub().booleanValue()) {
            request.getAttrValue().forEach(av -> {
                int brokerageRatio = av.getBrokerage() + av.getBrokerageTwo();
                if (brokerageRatio > this.crmebConfig.getRetailStoreBrokerageRatio()) {
                    throw new CrmebException(StrUtil.format((CharSequence)"\u4e00\u4e8c\u7ea7\u8fd4\u4f63\u6bd4\u4f8b\u4e4b\u548c\u8303\u56f4\u4e3a 0~{}", (Object[])new Object[]{this.crmebConfig.getRetailStoreBrokerageRatio()}));
                }
            });
        }
        if (ObjectUtil.isNull((Object)(productCategory = (ProductCategory)this.productCategoryService.getById(request.getCategoryId()))) || productCategory.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u5e73\u53f0\u5206\u7c7b\u4e0d\u5b58\u5728\u6216\u4ee5\u5220\u9664");
        }
        if (productCategory.getLevel() < 3) {
            throw new CrmebException("\u5fc5\u987b\u9009\u62e9\u5546\u54c1\u5e73\u53f0\u7b2c\u4e09\u7ea7\u5206\u7c7b");
        }
        LoginUserVo loginUserVo = SecurityUtil.getLoginUserVo();
        Merchant merchant = this.merchantService.getByIdException(loginUserVo.getUser().getMerId());
        Product product = new Product();
        BeanUtils.copyProperties((Object)request, (Object)product);
        product.setId(null);
        product.setMerId(loginUserVo.getUser().getMerId());
        product.setBizType(request.getBizType());
        String cdnUrl = this.systemAttachmentService.getCdnUrl();
        product.setImage(this.systemAttachmentService.clearPrefix(product.getImage(), cdnUrl));
        product.setSliderImage(this.systemAttachmentService.clearPrefix(product.getSliderImage(), cdnUrl));
        if (StrUtil.isNotBlank((CharSequence)product.getFlatPattern())) {
            product.setFlatPattern(this.systemAttachmentService.clearPrefix(product.getFlatPattern(), cdnUrl));
        }
        List attrValueAddRequestList = request.getAttrValue();
        ProductAttrValueAddRequest minAttrValue = attrValueAddRequestList.stream().min(Comparator.comparing(ProductAttrValueAddRequest::getPrice)).get();
        product.setPrice(minAttrValue.getPrice());
        product.setOtPrice(minAttrValue.getOtPrice());
        product.setCost(minAttrValue.getCost());
        product.setStock(Integer.valueOf(attrValueAddRequestList.stream().mapToInt(ProductAttrValueAddRequest::getStock).sum()));
        product.setAuditStatus(ProductConstants.AUDIT_STATUS_EXEMPTION);
        product.setIsAudit(Boolean.valueOf(false));
        product.setIsShow(Boolean.valueOf(false));
        List addRequestList = request.getAttr();
        List attrList = addRequestList.stream().map(e -> {
            ProductAttr attr = new ProductAttr();
            BeanUtils.copyProperties((Object)e, (Object)attr);
            attr.setId(null);
            attr.setType(ProductConstants.PRODUCT_TYPE_NORMAL);
            return attr;
        }).collect(Collectors.toList());
        List attrValueList = attrValueAddRequestList.stream().map(e -> {
            ProductAttrValue attrValue = new ProductAttrValue();
            BeanUtils.copyProperties((Object)e, (Object)attrValue);
            attrValue.setId(null);
            attrValue.setSku(this.getSku(e.getAttrValue()));
            attrValue.setQuota(Integer.valueOf(0));
            attrValue.setQuotaShow(Integer.valueOf(0));
            attrValue.setType(ProductConstants.PRODUCT_TYPE_NORMAL);
            attrValue.setImage(this.systemAttachmentService.clearPrefix(e.getImage(), cdnUrl));
            return attrValue;
        }).collect(Collectors.toList());
        if (product.getBizType().equals(ProductConstants.BIZ_TYPE_INSURANCE) || product.getBizType().equals(ProductConstants.BIZ_TYPE_RISK)) {
            List<String> barCodes = attrValueList.stream().map(ProductAttrValue::getBarCode).filter(StrUtil::isNotBlank).collect(Collectors.toList());
            if (barCodes.size() != attrValueList.size()) {
                throw new CrmebException("\u4fdd\u9669/\u98ce\u8bc4\u5546\u54c1\u89c4\u683c\u4e2d\u7684\u5546\u54c1\u6761\u7801\u4e3a\u7279\u5b9a\u503c\uff0c\u8bf7\u8054\u7cfb\u96ea\u5cf0\u63d0\u4f9b");
            }
            List<ProductAttrValue> existBarCodes = this.productAttrValueService.getByBarCodes(barCodes);
            if (!existBarCodes.isEmpty()) {
                String existBarCodesStr = existBarCodes.stream().map(ProductAttrValue::getBarCode).collect(Collectors.joining(","));
                throw new CrmebException("\u89c4\u683c\u4e2d\u7684\u5546\u54c1\u6761\u7801\u5df2\u5b58\u5728\uff1a" + existBarCodesStr);
            }
            if (product.getBizType().equals(ProductConstants.BIZ_TYPE_RISK) && attrValueList.stream().anyMatch(v -> !v.getBarCode().toUpperCase().startsWith("ESTAND-BG-") && !v.getBarCode().toUpperCase().startsWith("ESTAND-TK-") && !v.getBarCode().toUpperCase().startsWith("ESTAND-ZJ-"))) {
                throw new CrmebException("\u98ce\u8bc4\u5546\u54c1\u7684\u89c4\u683c\u5546\u54c1\u7f16\u7801\u5fc5\u987b\u4ee5 ESTAND-BG/TK/ZJ- \u5f00\u5934\uff0c\u5982\u62a5\u544a\uff1aESTAND-BG-10101 \u8e0f\u52d8 ESTAND-TK-10301 \u4e13\u5bb6 ESTAND-ZJ-10201");
            }
        }
        if (ObjectUtil.isNotNull((Object)product.getMasterId()) && ObjectUtil.isNull((Object)this.getById(product.getMasterId()))) {
            throw new CrmebException("\u627e\u4e0d\u5230\u4e3b\u5546\u54c1\uff1a" + product.getMasterId());
        }
        ArrayList descList = request.getContents();
        if (CollUtil.isEmpty((Collection)descList)) {
            descList = new ArrayList();
        }
        List finalDescList = descList.stream().map(spd -> {
            ProductDescription productDescription = new ProductDescription();
            BeanUtils.copyProperties((Object)spd, (Object)productDescription);
            productDescription.setId(null);
            productDescription.setDescription(StrUtil.isNotBlank((CharSequence)spd.getDescription()) ? this.systemAttachmentService.clearPrefix(spd.getDescription(), cdnUrl) : "");
            productDescription.setType(ProductConstants.PRODUCT_TYPE_NORMAL);
            return productDescription;
        }).collect(Collectors.toList());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            if (merchant.getProductSwitch().booleanValue()) {
                product.setAuditStatus(ProductConstants.AUDIT_STATUS_WAIT);
            }
            this.save(product);
            attrList.forEach(attr -> attr.setProductId(product.getId()));
            attrValueList.forEach(value -> value.setProductId(product.getId()));
            this.attrService.saveBatch(attrList);
            this.productAttrValueService.saveBatch(attrValueList, 100);
            finalDescList.forEach(d -> d.setProductId(product.getId()));
            this.productDescriptionService.deleteByProductId(product.getId(), ProductConstants.PRODUCT_TYPE_NORMAL);
            this.productDescriptionService.saveBatch(finalDescList);
            if (CollUtil.isNotEmpty((Collection)request.getCouponIds())) {
                ArrayList<ProductCoupon> couponList = new ArrayList<ProductCoupon>();
                for (Integer couponId : request.getCouponIds()) {
                    ProductCoupon spc = new ProductCoupon();
                    spc.setProductId(product.getId());
                    spc.setCouponId(couponId);
                    spc.setAddTime(CrmebDateUtil.getNowTime());
                    couponList.add(spc);
                }
                this.productCouponService.saveBatch(couponList);
            }
            return Boolean.TRUE;
        });
        return execute;
    }

    private String getSku(String attrValue) {
        LinkedHashMap linkedHashMap = (LinkedHashMap)JSONObject.parseObject((String)attrValue, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
        Iterator iterator = linkedHashMap.entrySet().iterator();
        ArrayList strings = CollUtil.newArrayList((Object[])new String[0]);
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            strings.add(next.getValue());
        }
        return String.join((CharSequence)",", strings);
    }

    @Override
    public Boolean update(ProductAddRequest productRequest) {
        Product tempProduct;
        if (ObjectUtil.isNull((Object)productRequest.getId())) {
            throw new CrmebException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!productRequest.getSpecType().booleanValue() && productRequest.getAttrValue().size() > 1) {
            throw new CrmebException("\u5355\u89c4\u683c\u5546\u54c1\u5c5e\u6027\u503c\u4e0d\u80fd\u5927\u4e8e1");
        }
        if (productRequest.getIsSub().booleanValue()) {
            productRequest.getAttrValue().forEach(av -> {
                int brokerageRatio = av.getBrokerage() + av.getBrokerageTwo();
                if (brokerageRatio > this.crmebConfig.getRetailStoreBrokerageRatio()) {
                    throw new CrmebException(StrUtil.format((CharSequence)"\u4e00\u4e8c\u7ea7\u8fd4\u4f63\u6bd4\u4f8b\u4e4b\u548c\u8303\u56f4\u4e3a 0~{}", (Object[])new Object[]{this.crmebConfig.getRetailStoreBrokerageRatio()}));
                }
            });
        }
        if (ObjectUtil.isNull((Object)(tempProduct = (Product)this.getById(productRequest.getId())))) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (tempProduct.getIsRecycle().booleanValue() || tempProduct.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u5df2\u5220\u9664");
        }
        if (tempProduct.getIsShow().booleanValue()) {
            throw new CrmebException("\u8bf7\u5148\u4e0b\u67b6\u5546\u54c1\uff0c\u518d\u8fdb\u884c\u4fee\u6539");
        }
        if (tempProduct.getIsAudit().booleanValue()) {
            throw new CrmebException("\u5ba1\u6838\u4e2d\u7684\u5546\u54c1\u65e0\u6cd5\u4fee\u6539");
        }
        ProductCategory productCategory = (ProductCategory)this.productCategoryService.getById(productRequest.getCategoryId());
        if (ObjectUtil.isNull((Object)productCategory) || productCategory.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u5e73\u53f0\u5206\u7c7b\u4e0d\u5b58\u5728\u6216\u4ee5\u5220\u9664");
        }
        if (productCategory.getLevel() < 3) {
            throw new CrmebException("\u5fc5\u987b\u9009\u62e9\u5546\u54c1\u5e73\u53f0\u7b2c\u4e09\u7ea7\u5206\u7c7b");
        }
        Product product = new Product();
        BeanUtils.copyProperties((Object)productRequest, (Object)product);
        product.setAuditStatus(tempProduct.getAuditStatus());
        Merchant merchant = this.merchantService.getByIdException(tempProduct.getMerId());
        String cdnUrl = this.systemAttachmentService.getCdnUrl();
        product.setImage(this.systemAttachmentService.clearPrefix(product.getImage(), cdnUrl));
        product.setSliderImage(this.systemAttachmentService.clearPrefix(product.getSliderImage(), cdnUrl));
        List attrValueAddRequestList = productRequest.getAttrValue();
        ProductAttrValueAddRequest minAttrValue = attrValueAddRequestList.stream().min(Comparator.comparing(ProductAttrValueAddRequest::getPrice)).get();
        product.setPrice(minAttrValue.getPrice());
        product.setOtPrice(minAttrValue.getOtPrice());
        product.setCost(minAttrValue.getCost());
        product.setStock(Integer.valueOf(attrValueAddRequestList.stream().mapToInt(ProductAttrValueAddRequest::getStock).sum()));
        List addRequestList = productRequest.getAttr();
        ArrayList attrAddList = CollUtil.newArrayList((Object[])new ProductAttr[0]);
        ArrayList attrUpdateList = CollUtil.newArrayList((Object[])new ProductAttr[0]);
        addRequestList.forEach(e -> {
            ProductAttr attr = new ProductAttr();
            BeanUtils.copyProperties((Object)e, (Object)attr);
            if (ObjectUtil.isNull((Object)attr.getId())) {
                attr.setProductId(product.getId());
                attr.setType(ProductConstants.PRODUCT_TYPE_NORMAL);
                attrAddList.add(attr);
            } else {
                attr.setIsDel(Boolean.valueOf(false));
                attrUpdateList.add(attr);
            }
        });
        ArrayList attrValueAddList = CollUtil.newArrayList((Object[])new ProductAttrValue[0]);
        ArrayList attrValueUpdateList = CollUtil.newArrayList((Object[])new ProductAttrValue[0]);
        attrValueAddRequestList.forEach(e -> {
            ProductAttrValue attrValue = new ProductAttrValue();
            BeanUtils.copyProperties((Object)e, (Object)attrValue);
            attrValue.setSku(this.getSku(e.getAttrValue()));
            attrValue.setImage(this.systemAttachmentService.clearPrefix(e.getImage(), cdnUrl));
            attrValue.setVersion(Integer.valueOf(0));
            if (ObjectUtil.isNull((Object)attrValue.getId()) || attrValue.getId().equals(0)) {
                attrValue.setId(null);
                attrValue.setProductId(product.getId());
                attrValue.setQuota(Integer.valueOf(0));
                attrValue.setQuotaShow(Integer.valueOf(0));
                attrValue.setType(ProductConstants.PRODUCT_TYPE_NORMAL);
                attrValueAddList.add(attrValue);
            } else {
                attrValue.setProductId(product.getId());
                attrValue.setIsDel(Boolean.valueOf(false));
                attrValueUpdateList.add(attrValue);
            }
        });
        ArrayList descList = productRequest.getContents();
        if (CollUtil.isEmpty((Collection)descList)) {
            descList = new ArrayList();
        }
        List finalDescList = descList.stream().map(spd -> {
            ProductDescription productDescription = new ProductDescription();
            BeanUtils.copyProperties((Object)spd, (Object)productDescription);
            productDescription.setId(null);
            productDescription.setDescription(StrUtil.isNotBlank((CharSequence)spd.getDescription()) ? this.systemAttachmentService.clearPrefix(spd.getDescription(), cdnUrl) : "");
            productDescription.setType(ProductConstants.PRODUCT_TYPE_NORMAL);
            productDescription.setProductId(product.getId());
            return productDescription;
        }).collect(Collectors.toList());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            if (!merchant.getProductSwitch().booleanValue() && product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_EXEMPTION)) {
                product.setAuditStatus(ProductConstants.AUDIT_STATUS_EXEMPTION);
            } else {
                product.setAuditStatus(ProductConstants.AUDIT_STATUS_WAIT);
            }
            product.setIsAudit(Boolean.valueOf(false));
            this.dao.updateById(product);
            this.attrService.deleteByProductIdAndType(product.getId(), ProductConstants.PRODUCT_TYPE_NORMAL);
            this.productAttrValueService.deleteByProductIdAndType(product.getId(), ProductConstants.PRODUCT_TYPE_NORMAL);
            if (CollUtil.isNotEmpty((Collection)attrAddList)) {
                this.attrService.saveBatch(attrAddList);
            }
            if (CollUtil.isNotEmpty((Collection)attrUpdateList)) {
                this.attrService.saveOrUpdateBatch(attrUpdateList);
            }
            if (CollUtil.isNotEmpty((Collection)attrValueAddList)) {
                this.productAttrValueService.saveBatch(attrValueAddList);
            }
            if (CollUtil.isNotEmpty((Collection)attrValueUpdateList)) {
                this.productAttrValueService.saveOrUpdateBatch(attrValueUpdateList);
            }
            this.productDescriptionService.deleteByProductId(product.getId(), ProductConstants.PRODUCT_TYPE_NORMAL);
            this.productDescriptionService.saveBatch(finalDescList);
            if (CollUtil.isNotEmpty((Collection)productRequest.getCouponIds())) {
                this.productCouponService.deleteByProductId(product.getId());
                ArrayList<ProductCoupon> couponList = new ArrayList<ProductCoupon>();
                for (Integer couponId : productRequest.getCouponIds()) {
                    ProductCoupon spc = new ProductCoupon();
                    spc.setProductId(product.getId());
                    spc.setCouponId(couponId);
                    spc.setAddTime(CrmebDateUtil.getNowTime());
                    couponList.add(spc);
                }
                this.productCouponService.saveBatch(couponList);
            } else {
                this.productCouponService.deleteByProductId(product.getId());
            }
            return Boolean.TRUE;
        });
        return execute;
    }

    @Override
    public ProductInfoResponse getInfo(Integer id) {
        Product Product2 = (Product)this.dao.selectById(id);
        if (ObjectUtil.isNull((Object)Product2)) {
            throw new CrmebException("\u672a\u627e\u5230\u5bf9\u5e94\u5546\u54c1\u4fe1\u606f");
        }
        ProductInfoResponse ProductResponse = new ProductInfoResponse();
        BeanUtils.copyProperties((Object)Product2, (Object)ProductResponse);
        List<ProductAttr> attrList = this.attrService.getListByProductIdAndType(Product2.getId(), ProductConstants.PRODUCT_TYPE_NORMAL);
        ProductResponse.setAttr(attrList);
        List<ProductAttrValue> attrValueList = this.productAttrValueService.getListByProductIdAndType(Product2.getId(), ProductConstants.PRODUCT_TYPE_NORMAL);
        List valueResponseList = attrValueList.stream().map(e -> {
            AttrValueResponse valueResponse = new AttrValueResponse();
            BeanUtils.copyProperties((Object)e, (Object)valueResponse);
            return valueResponse;
        }).collect(Collectors.toList());
        ProductResponse.setAttrValue(valueResponseList);
        List<ProductDescription> descriptions = this.productDescriptionService.getPcProductDescriptionById(Product2.getId(), true);
        ProductResponse.setContents(descriptions);
        List<ProductCoupon> productCouponList = this.productCouponService.getListByProductId(Product2.getId());
        if (CollUtil.isNotEmpty(productCouponList)) {
            List<Integer> ids = productCouponList.stream().map(ProductCoupon::getCouponId).collect(Collectors.toList());
            SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
            if (systemAdmin.getMerId() > 0) {
                ProductResponse.setCouponIds(ids);
            } else {
                ProductResponse.setCouponList(this.couponService.findSimpleListByIdList(ids));
            }
        }
        return ProductResponse;
    }

    @Override
    public List<ProductTabsHeaderResponse> getTabsHeader() {
        ArrayList<ProductTabsHeaderResponse> headers = new ArrayList<ProductTabsHeaderResponse>();
        ProductTabsHeaderResponse header1 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(1));
        ProductTabsHeaderResponse header2 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(2));
        ProductTabsHeaderResponse header3 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(3));
        ProductTabsHeaderResponse header4 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(4));
        ProductTabsHeaderResponse header5 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(5));
        ProductTabsHeaderResponse header6 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(6));
        ProductTabsHeaderResponse header7 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(7));
        headers.add(header1);
        headers.add(header2);
        headers.add(header3);
        headers.add(header4);
        headers.add(header5);
        headers.add(header6);
        headers.add(header7);
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        for (ProductTabsHeaderResponse h : headers) {
            lqw.clear();
            lqw.select(new SFunction[]{Product::getId});
            lqw.eq(Product::getMerId, (Object)systemAdmin.getMerId());
            this.setAdminListWrapperByType((LambdaQueryWrapper<Product>)lqw, h.getType(), systemAdmin.getMerId());
            List products = this.dao.selectList((Wrapper)lqw);
            h.setCount(Integer.valueOf(products.size()));
        }
        return headers;
    }

    private void setAdminListWrapperByType(LambdaQueryWrapper<Product> lqw, Integer type, Integer merId) {
        switch (type) {
            case 1: {
                lqw.eq(Product::getIsShow, (Object)true);
                lqw.eq(Product::getIsRecycle, (Object)false);
                lqw.eq(Product::getIsDel, (Object)false);
                lqw.in(Product::getAuditStatus, new Object[]{ProductConstants.AUDIT_STATUS_SUCCESS, ProductConstants.AUDIT_STATUS_EXEMPTION});
                break;
            }
            case 2: {
                lqw.eq(Product::getIsShow, (Object)false);
                lqw.eq(Product::getIsRecycle, (Object)false);
                lqw.eq(Product::getIsDel, (Object)false);
                lqw.eq(Product::getIsAudit, (Object)false);
                lqw.in(Product::getAuditStatus, new Object[]{ProductConstants.AUDIT_STATUS_WAIT, ProductConstants.AUDIT_STATUS_EXEMPTION, ProductConstants.AUDIT_STATUS_SUCCESS});
                break;
            }
            case 3: {
                lqw.le(Product::getStock, (Object)0);
                lqw.eq(Product::getIsRecycle, (Object)false);
                lqw.eq(Product::getIsDel, (Object)false);
                lqw.in(Product::getAuditStatus, new Object[]{ProductConstants.AUDIT_STATUS_SUCCESS, ProductConstants.AUDIT_STATUS_EXEMPTION});
                break;
            }
            case 4: {
                MerchantInfo merchantInfo = this.merchantInfoService.getByMerId(merId);
                lqw.le(Product::getStock, (Object)(ObjectUtil.isNotNull((Object)merchantInfo) ? merchantInfo.getAlertStock() : 0));
                lqw.eq(Product::getIsRecycle, (Object)false);
                lqw.eq(Product::getIsDel, (Object)false);
                lqw.in(Product::getAuditStatus, new Object[]{ProductConstants.AUDIT_STATUS_SUCCESS, ProductConstants.AUDIT_STATUS_EXEMPTION});
                break;
            }
            case 5: {
                lqw.eq(Product::getIsRecycle, (Object)true);
                lqw.eq(Product::getIsDel, (Object)false);
                break;
            }
            case 6: {
                lqw.eq(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_WAIT);
                lqw.eq(Product::getIsAudit, (Object)true);
                lqw.eq(Product::getIsRecycle, (Object)false);
                lqw.eq(Product::getIsDel, (Object)false);
                break;
            }
            case 7: {
                lqw.eq(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_FAIL);
                lqw.eq(Product::getIsAudit, (Object)false);
                lqw.eq(Product::getIsRecycle, (Object)false);
                lqw.eq(Product::getIsDel, (Object)false);
                break;
            }
        }
    }

    @Override
    public ProductRequest importProductFromUrl(String url, int tag) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        Merchant merchant = this.merchantService.getByIdException(admin.getMerId());
        if (merchant.getCopyProductNum() <= 0) {
            throw new CrmebException("\u5546\u6237\u590d\u5236\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
        }
        ProductRequest productRequest = null;
        try {
            switch (tag) {
                case 1: {
                    productRequest = this.productUtils.getTaobaoProductInfo(url, tag);
                    break;
                }
                case 2: {
                    productRequest = this.productUtils.getJDProductInfo(url, tag);
                    break;
                }
                case 3: {
                    productRequest = this.productUtils.getSuningProductInfo(url, tag);
                    break;
                }
                case 4: {
                    productRequest = this.productUtils.getPddProductInfo(url, tag);
                    break;
                }
                case 5: {
                    productRequest = this.productUtils.getTmallProductInfo(url, tag);
                }
            }
        }
        catch (Exception e) {
            throw new CrmebException("\u786e\u8ba4URL\u548c\u5e73\u53f0\u662f\u5426\u6b63\u786e\uff0c\u4ee5\u53ca\u5e73\u53f0\u8d39\u7528\u662f\u5426\u8db3\u989d" + e.getMessage());
        }
        Boolean sub = this.merchantService.subCopyProductNum(merchant.getId());
        if (!sub.booleanValue()) {
            this.LOGGER.error("\u6263\u9664\u5546\u6237\u590d\u5236\u6761\u6570\u5f02\u5e38\uff1a\u5546\u6237ID = {}", (Object)merchant.getId());
        }
        return productRequest;
    }

    @Override
    public ProductResponseForCopyProduct importProductFrom99Api(String url, int tag) throws JSONException {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        Merchant merchant = this.merchantService.getByIdException(admin.getMerId());
        if (merchant.getCopyProductNum() <= 0) {
            throw new CrmebException("\u5546\u6237\u590d\u5236\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
        }
        ProductResponseForCopyProduct copyProduct = null;
        try {
            switch (tag) {
                case 1: {
                    copyProduct = this.productUtils.getTaobaoProductInfo99Api(url, tag);
                    break;
                }
                case 2: {
                    copyProduct = this.productUtils.getJDProductInfo99Api(url, tag);
                    break;
                }
                case 3: {
                    copyProduct = this.productUtils.getSuningProductInfo99Api(url, tag);
                    break;
                }
                case 4: {
                    copyProduct = this.productUtils.getPddProductInfo99Api(url, tag);
                    break;
                }
                case 5: {
                    copyProduct = this.productUtils.getTmallProductInfo99Api(url, tag);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CrmebException("\u786e\u8ba4URL\u548c\u5e73\u53f0\u662f\u5426\u6b63\u786e\uff0c\u4ee5\u53ca\u5e73\u53f0\u8d39\u7528\u662f\u5426\u8db3\u989d" + e.getMessage());
        }
        Boolean sub = this.merchantService.subCopyProductNum(merchant.getId());
        if (!sub.booleanValue()) {
            this.LOGGER.error("\u6263\u9664\u5546\u6237\u590d\u5236\u6761\u6570\u5f02\u5e38\uff1a\u5546\u6237ID = {}", (Object)merchant.getId());
        }
        return copyProduct;
    }

    @Override
    public Boolean deleteProduct(ProductDeleteRequest request) {
        Product product = (Product)this.getById(request.getId());
        if (ObjectUtil.isNull((Object)product)) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if ("recycle".equals(request.getType()) && product.getIsRecycle().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u5df2\u5b58\u5728\u56de\u6536\u7ad9");
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(Product::getId, (Object)product.getId());
        if ("delete".equals(request.getType())) {
            wrapper.set(Product::getIsDel, (Object)true);
        } else {
            wrapper.set(Product::getIsRecycle, (Object)true);
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.update((Wrapper)wrapper);
            if (request.getType().equals("recycle")) {
                this.cartService.productStatusNotEnable(request.getId());
            } else {
                this.cartService.productDelete(request.getId());
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean restoreProduct(Integer productId) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(Product::getId, (Object)productId);
        wrapper.set(Product::getIsRecycle, (Object)false);
        wrapper.set(Product::getIsShow, (Object)false);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean operationStock(Integer id, Integer num, String type) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (type.equals("quick")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock + {}", (Object[])new Object[]{num}));
        }
        if (type.equals("add")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock + {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = IF(sales<{}, 0, sales-{})", (Object[])new Object[]{num, num}));
        }
        if (type.equals("sub")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock - {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales + {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)" and (stock - {} >= 0)", (Object[])new Object[]{num}));
        }
        updateWrapper.eq((Object)"id", (Object)id);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u666e\u901a\u5546\u54c1\u5e93\u5b58\u5931\u8d25,\u5546\u54c1id = " + id);
        }
        return update;
    }

    @Override
    public Boolean offShelf(Integer id) {
        Product product = (Product)this.getById(id);
        if (ObjectUtil.isNull((Object)product)) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (!product.getIsShow().booleanValue()) {
            return true;
        }
        product.setIsShow(Boolean.valueOf(false));
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.dao.updateById(product);
            this.cartService.productStatusNotEnable(id);
            this.productRelationService.deleteByProId(product.getId());
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean putOnShelf(Integer id) {
        Product product = (Product)this.getById(id);
        if (ObjectUtil.isNull((Object)product)) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (product.getIsShow().booleanValue()) {
            return true;
        }
        if (product.getIsAudit().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u5ba1\u6838\u4e2d\u65e0\u6cd5\u4e0a\u67b6");
        }
        if (!product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_EXEMPTION) && !product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_SUCCESS)) {
            throw new CrmebException("\u5546\u54c1\u72b6\u6001\u5f02\u5e38\u65e0\u6cd5\u4e0a\u67b6");
        }
        LoginUserVo loginUserVo = SecurityUtil.getLoginUserVo();
        Merchant merchant = (Merchant)this.merchantService.getById(loginUserVo.getUser().getMerId());
        if (!merchant.getIsSwitch().booleanValue()) {
            throw new CrmebException("\u6253\u5f00\u5546\u6237\u5f00\u5173\u540e\u65b9\u80fd\u4e0a\u67b6\u5546\u54c1");
        }
        product.setIsShow(Boolean.valueOf(true));
        List<ProductAttrValue> skuList = this.productAttrValueService.getListByProductIdAndType(id, ProductConstants.PRODUCT_TYPE_NORMAL);
        List skuIdList = skuList.stream().map(ProductAttrValue::getId).collect(Collectors.toList());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.dao.updateById(product);
            if (CollUtil.isNotEmpty((Collection)skuIdList)) {
                this.cartService.productStatusNoEnable(skuIdList);
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public PageInfo<Product> getIndexProduct(String terminal, Integer cid, PageParamRequest pageParamRequest) {
        List<ProductCategory> categoryList;
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getMerId, Product::getImage, Product::getName, Product::getUnitName, Product::getPrice, Product::getOtPrice, Product::getSales, Product::getFicti, Product::getCategoryId, Product::getBrandId});
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        lqw.gt(Product::getStock, (Object)0);
        if (cid > 0) {
            categoryList = this.productCategoryService.getThirdCategoryByFirstId(cid, 0);
            if (CollUtil.isEmpty(categoryList)) {
                return new PageInfo();
            }
            List cidList = categoryList.stream().map(ProductCategory::getId).collect(Collectors.toList());
            lqw.in(Product::getCategoryId, cidList);
        }
        if (StrUtil.isNotBlank((CharSequence)terminal)) {
            if ("pc".equalsIgnoreCase(terminal)) {
                categoryList = this.productCategoryService.getPcThirdCategory();
                lqw.in(Product::getCategoryId, (Collection)categoryList.stream().map(ProductCategory::getId).collect(Collectors.toList()));
            } else if ("risk".equalsIgnoreCase(terminal)) {
                categoryList = this.productCategoryService.getRiskThirdCategory();
                lqw.in(Product::getCategoryId, (Collection)categoryList.stream().map(ProductCategory::getId).collect(Collectors.toList()));
            }
        }
        lqw.orderByDesc(Product::getRank);
        lqw.orderByDesc(Product::getId);
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List<Product> productList = this.dao.selectList((Wrapper)lqw);
        productList = this.activityStyleService.makeActivityBorderStyle(productList);
        return CommonPage.copyPageInfo((Page)page, productList);
    }

    private void getForSaleWhere(LambdaQueryWrapper<Product> lqw) {
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.eq(Product::getIsRecycle, (Object)false);
        lqw.eq(Product::getIsShow, (Object)true);
        lqw.in(Product::getAuditStatus, new Object[]{ProductConstants.AUDIT_STATUS_SUCCESS, ProductConstants.AUDIT_STATUS_EXEMPTION});
    }

    @Override
    public PageInfo<ProductFrontResponse> findH5List(ProductFrontSearchRequest request, PageParamRequest pageRequest) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ObjectUtil.isNotNull((Object)request.getCid()) && request.getCid().length() > 0) {
            map.put("categoryId", request.getCid());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeyword())) {
            String keyword = URLUtil.decode((String)request.getKeyword());
            map.put("keywords", keyword);
        }
        if (ObjectUtil.isNotNull((Object)request.getMaxPrice())) {
            map.put("maxPrice", request.getMaxPrice());
        }
        if (ObjectUtil.isNotNull((Object)request.getMinPrice())) {
            map.put("minPrice", request.getMinPrice());
        }
        if (ObjectUtil.isNotNull((Object)request.getBrandId()) && request.getBrandId().length() > 0) {
            map.put("brandId", request.getBrandId());
        }
        if (ObjectUtil.isNotNull((Object)request.getIsSelf())) {
            map.put("isSelf", request.getIsSelf() != false ? 1 : 0);
        }
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId().length() > 0) {
            map.put("merId", request.getMerId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getSalesOrder())) {
            if (request.getSalesOrder().equals("desc")) {
                map.put("lastStr", " order by (p.sales + p.ficti) desc, p.rank desc, p.sort desc, p.id desc");
            } else {
                map.put("lastStr", " order by (p.sales + p.ficti) asc, p.rank desc, p.sort desc, p.id desc");
            }
        } else if (StrUtil.isNotBlank((CharSequence)request.getPriceOrder())) {
            if (request.getPriceOrder().equals("desc")) {
                map.put("lastStr", " order by p.price desc, p.rank desc, p.sort desc, p.id desc");
            } else {
                map.put("lastStr", " order by p.price asc, p.rank desc, p.sort desc, p.id desc");
            }
        } else {
            map.put("lastStr", " order by p.rank desc, p.sort desc, p.id desc");
        }
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        List<ProductFrontResponse> responseList = this.dao.findH5List(map);
        if (CollUtil.isEmpty(responseList)) {
            return CommonPage.copyPageInfo((Page)page, responseList);
        }
        responseList.forEach(e -> {
            Integer sumCount = this.productReplyService.getCountByScore(e.getId(), "all");
            Integer goodCount = this.productReplyService.getCountByScore(e.getId(), "good");
            String replyChance = "0";
            if (sumCount > 0 && goodCount > 0) {
                replyChance = String.format("%.2f", goodCount.doubleValue() / sumCount.doubleValue());
            }
            e.setReplyNum(sumCount);
            e.setPositiveRatio(replyChance);
        });
        ArrayList<Product> products = new ArrayList<Product>();
        responseList.forEach(response -> {
            Product product = new Product();
            BeanUtils.copyProperties((Object)response, (Object)product);
            products.add(product);
        });
        List<Product> makeProductList = this.activityStyleService.makeActivityBorderStyle(products);
        makeProductList.forEach(p -> responseList.stream().map(resProduct -> {
            if (p.getId().equals(resProduct.getId())) {
                resProduct.setActivityStyle(p.getActivityStyle());
            }
            return resProduct;
        }).collect(Collectors.toList()));
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public Product getH5Detail(Integer id) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Product::getId, (Object)id);
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        Product product = (Product)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)product)) {
            throw new CrmebException(StrUtil.format((CharSequence)"\u6ca1\u6709\u627e\u5230ID\uff1a {} \u7684\u5546\u54c1", (Object[])new Object[]{id}));
        }
        List<ProductDescription> sd = this.productDescriptionService.getPcProductDescriptionById(product.getId(), true);
        if (ObjectUtil.isNotNull(sd)) {
            product.setContents(sd);
        }
        return product;
    }

    @Override
    public Product getCartByProId(Integer productId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getImage, Product::getName});
        lqw.eq(Product::getId, (Object)productId);
        return (Product)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Integer getNewProductByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId});
        lqw.eq(Product::getIsDel, (Object)0);
        lqw.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public List<Product> findAllProductByNotDelete() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getMerId});
        lqw.eq(Product::getIsDel, (Object)0);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<Product> likeProductName(String productName, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId});
        lqw.like(Product::getName, (Object)productName);
        lqw.eq(Product::getIsDel, (Object)0);
        if (!merId.equals(0)) {
            lqw.eq(Product::getMerId, (Object)merId);
        }
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Integer getOnSaleNum(Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (merId > 0) {
            lqw.eq(Product::getMerId, (Object)merId);
        }
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Boolean forcedRemovalAll(Integer merchantId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Product::getIsShow, (Object)false);
        wrapper.set(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_WAIT);
        wrapper.eq(Product::getMerId, (Object)merchantId);
        wrapper.eq(Product::getIsDel, (Object)false);
        wrapper.ne(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_FAIL);
        boolean update = this.update((Wrapper)wrapper);
        if (!update) {
            return update;
        }
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        query.select(new SFunction[]{Product::getId});
        query.eq(Product::getMerId, (Object)merchantId);
        query.eq(Product::getIsDel, (Object)false);
        List productList = this.dao.selectList((Wrapper)query);
        productList.forEach(product -> {
            this.cartService.productStatusNotEnable(product.getId());
            this.productRelationService.deleteByProId(product.getId());
        });
        return true;
    }

    @Override
    public PageInfo<PlatformProductListResponse> getPlatformPageList(ProductSearchRequest request, PageParamRequest pageParamRequest) {
        HashMap map = CollUtil.newHashMap();
        map.put("type", request.getType());
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            ProductCategory category = (ProductCategory)this.productCategoryService.getById(request.getCategoryId());
            if (category.getLevel().equals(3)) {
                map.put("categoryIds", request.getCategoryId());
            } else {
                List<ProductCategory> categoryList = this.productCategoryService.findAllChildListByPid(category.getId(), category.getLevel());
                List cateIdList = categoryList.stream().filter(e -> e.getLevel().equals(3)).map(e -> e.getId().toString()).collect(Collectors.toList());
                String categoryIds = String.join((CharSequence)",", cateIdList);
                map.put("categoryIds", categoryIds);
            }
        }
        if (ObjectUtil.isNotNull((Object)request.getMerId())) {
            map.put("merId", request.getMerId());
        }
        if (ObjectUtil.isNotNull((Object)request.getIsBrokerage())) {
            map.put("isBrokerage", request.getIsBrokerage());
        }
        if (ObjectUtil.isNotNull((Object)request.getMerchantType())) {
            map.put("merchantType", request.getMerchantType());
        }
        if (ObjectUtil.isNotNull((Object)request.getMerchantName())) {
            map.put("merchantName", request.getMerchantName());
        }
        if (ObjectUtil.isNotNull((Object)request.getIsSelf())) {
            map.put("self", request.getIsSelf());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            map.put("keywords", keywords);
        }
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List<PlatformProductListResponse> proList = this.dao.getPlatformPageList(map);
        return CommonPage.copyPageInfo((Page)page, proList);
    }

    @Override
    public List<PlatformProductListResponse> getPlatformListForIds(List<String> ids) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(Product::getIsDel, (Object)Boolean.FALSE);
        lambdaQueryWrapper.in(Product::getId, ids);
        List products = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        List<PlatformProductListResponse> platformProductListResponses = this.productListToPlatFromProductListResponse(products);
        return platformProductListResponses;
    }

    @Override
    public List<PlatformProductListResponse> getPlatformListForIdsByLimit(List<String> ids) {
        if (this.crmebConfig.getActivityStyleProductLimit() < ids.size()) {
            throw new CrmebException("\u6d3b\u52a8\u8fb9\u6846 \u6307\u5b9a\u5546\u54c1\u4e0a\u9650\uff1a" + this.crmebConfig.getActivityStyleProductLimit());
        }
        return this.getPlatformListForIds(ids);
    }

    @Override
    public Boolean audit(ProductAuditRequest request) {
        if (request.getAuditStatus().equals("fail") && StrUtil.isEmpty((CharSequence)request.getReason())) {
            throw new CrmebException("\u5ba1\u6838\u62d2\u7edd\u8bf7\u586b\u5199\u62d2\u7edd\u539f\u56e0");
        }
        Product product = this.getByIdException(request.getId());
        if (!product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT)) {
            throw new CrmebException("\u5546\u54c1\u5e76\u975e\u7b49\u5f85\u5ba1\u6838\u72b6\u6001");
        }
        if (!product.getIsAudit().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u672a\u8fdb\u5165\u5ba1\u6838\u6d41\u7a0b\u4e2d");
        }
        if (request.getAuditStatus().equals("fail")) {
            product.setAuditStatus(ProductConstants.AUDIT_STATUS_FAIL);
            product.setReason(request.getReason());
        } else {
            product.setAuditStatus(ProductConstants.AUDIT_STATUS_SUCCESS);
            Merchant merchant = this.merchantService.getByIdException(product.getMerId());
            if (!merchant.getProductSwitch().booleanValue()) {
                product.setAuditStatus(ProductConstants.AUDIT_STATUS_EXEMPTION);
            }
        }
        product.setIsAudit(Boolean.valueOf(false));
        product.setIsShow(Boolean.valueOf(false));
        return this.updateById(product);
    }

    @Override
    public Boolean forceDown(ProductForceDownRequest request) {
        String ids = request.getIds();
        List<Integer> idList = Stream.of(ids.split(",")).map(Integer::valueOf).collect(Collectors.toList());
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Product::getIsShow, (Object)false);
        wrapper.set(Product::getIsAudit, (Object)false);
        wrapper.set(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_WAIT);
        wrapper.in(Product::getId, idList);
        boolean update = this.update((Wrapper)wrapper);
        if (update) {
            idList.forEach(id -> {
                this.cartService.productStatusNotEnable((Integer)id);
                this.productRelationService.deleteByProId((Integer)id);
            });
        }
        return update;
    }

    @Override
    public Boolean isExistStoreCategory(Integer id) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId});
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.apply(" find_in_set({0}, cate_id)", new Object[]{id});
        lqw.last(" limit 1");
        Product Product2 = (Product)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)Product2);
    }

    @Override
    public Boolean addBrowse(Integer proId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.setSql("browse = browse + 1");
        wrapper.eq(Product::getId, (Object)proId);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<ProMerchantProductResponse> getRecommendedProductsByMerId(Integer merId, Integer num) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getMerId, Product::getImage, Product::getName, Product::getPrice, Product::getSales, Product::getFicti});
        lqw.eq(Product::getMerId, (Object)merId);
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        lqw.orderByDesc(Product::getSort);
        lqw.last("limit " + num);
        List productList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)productList)) {
            return CollUtil.newArrayList((Object[])new ProMerchantProductResponse[0]);
        }
        return productList.stream().map(product -> {
            ProMerchantProductResponse response = new ProMerchantProductResponse();
            BeanUtils.copyProperties((Object)product, (Object)response);
            return response;
        }).collect(Collectors.toList());
    }

    @Override
    public PageInfo<Product> findMerchantProH5List(MerchantProductSearchRequest request, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getName, Product::getImage, Product::getPrice, Product::getOtPrice, Product::getSales, Product::getFicti, Product::getUnitName, Product::getStock, Product::getMerId, Product::getCategoryId, Product::getBrandId});
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        lqw.eq(Product::getMerId, (Object)request.getMerId());
        if (StrUtil.isNotBlank((CharSequence)request.getKeyword())) {
            String keyword = URLUtil.decode((String)request.getKeyword());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(Product::getName, (Object)keyword)).or()).like(Product::getKeyword, (Object)keyword);
            });
        }
        if (ObjectUtil.isNotNull((Object)request.getCid()) && request.getCid() > 0) {
            lqw.apply(StrUtil.format((CharSequence)" find_in_set({}, cate_id)", (Object[])new Object[]{request.getCid()}), new Object[0]);
        }
        if (ObjectUtil.isNotNull((Object)request.getMaxPrice())) {
            lqw.le(Product::getPrice, (Object)request.getMaxPrice());
        }
        if (ObjectUtil.isNotNull((Object)request.getMinPrice())) {
            lqw.ge(Product::getPrice, (Object)request.getMinPrice());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getSalesOrder())) {
            if (request.getSalesOrder().equals("desc")) {
                lqw.last(" order by (sales + ficti) desc, sort desc, id desc");
            } else {
                lqw.last(" order by (sales + ficti) asc, sort desc, id desc");
            }
        } else {
            if (StrUtil.isNotBlank((CharSequence)request.getPriceOrder())) {
                if (request.getPriceOrder().equals("desc")) {
                    lqw.orderByDesc(Product::getPrice);
                } else {
                    lqw.orderByAsc(Product::getPrice);
                }
            }
            lqw.orderByDesc(Product::getSort);
            lqw.orderByDesc(Product::getId);
        }
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List productList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)productList);
    }

    @Override
    public Boolean isUseBrand(Integer brandId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId});
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.eq(Product::getBrandId, (Object)brandId);
        lqw.last("limit 1");
        Product Product2 = (Product)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)Product2);
    }

    @Override
    public Boolean isUsePlatformCategory(Integer categoryId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId});
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.eq(Product::getCategoryId, (Object)categoryId);
        lqw.last("limit 1");
        Product Product2 = (Product)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)Product2);
    }

    @Override
    public List<Product> findUseGuarantee(Integer gid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getMerId});
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.apply(" find_in_set({0}, guarantee_ids)", new Object[]{gid});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean isUseGuarantee(Integer gid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId});
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.apply(" find_in_set({0}, guarantee_ids)", new Object[]{gid});
        lqw.last("limit 1");
        Product Product2 = (Product)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)Product2);
    }

    @Override
    public Integer getAwaitAuditNum(Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_WAIT);
        lqw.eq(Product::getIsAudit, (Object)true);
        lqw.eq(Product::getIsRecycle, (Object)false);
        lqw.eq(Product::getIsDel, (Object)false);
        this.setAdminListWrapperByType((LambdaQueryWrapper<Product>)lqw, 6, merId);
        if (merId > 0) {
            lqw.eq(Product::getMerId, (Object)merId);
        }
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Boolean downByMerId(Integer merId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Product::getIsShow, (Object)false);
        wrapper.eq(Product::getMerId, (Object)merId);
        wrapper.eq(Product::getIsShow, (Object)true);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PageInfo<Product> getCouponProList(CouponProductSearchRequest request) {
        Coupon coupon;
        Integer userId = this.userService.getUserIdException();
        CouponUser couponUser = (CouponUser)this.couponUserService.getById(request.getUserCouponId());
        if (ObjectUtil.isNull((Object)couponUser) || !couponUser.getUid().equals(userId) || couponUser.getStatus() > CouponConstants.STORE_COUPON_USER_STATUS_USABLE) {
            throw new CrmebException("\u4f18\u60e0\u5238\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u672a\u4f7f\u7528\u72b6\u6001");
        }
        List pidList = null;
        if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT)) {
            List<CouponProduct> cpList = this.couponProductService.findByCid(couponUser.getCouponId());
            if (CollUtil.isEmpty(cpList)) {
                throw new CrmebException("\u4f18\u60e0\u5238\u5bf9\u5e94\u5546\u54c1\u4e0d\u5b58\u5728");
            }
            pidList = cpList.stream().map(CouponProduct::getPid).collect(Collectors.toList());
        }
        if (ObjectUtil.isNull((Object)(coupon = (Coupon)this.couponService.getById(couponUser.getCouponId())))) {
            throw new CrmebException("\u4f18\u60e0\u5238\u5b9e\u4f53\u4e0d\u5b58\u5728");
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getName, Product::getImage, Product::getPrice, Product::getOtPrice, Product::getSales, Product::getFicti, Product::getUnitName, Product::getStock, Product::getMerId});
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        if (StrUtil.isNotBlank((CharSequence)request.getKeyword())) {
            String decode = URLUtil.decode((String)request.getKeyword());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(Product::getName, (Object)decode)).or()).like(Product::getKeyword, (Object)decode);
            });
        }
        if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_MERCHANT)) {
            lqw.eq(Product::getMerId, (Object)couponUser.getMerId());
        }
        if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT) && CollUtil.isNotEmpty(pidList)) {
            lqw.in(Product::getId, pidList);
        }
        if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT_CATEGORY)) {
            ProductCategory productCategory = (ProductCategory)this.productCategoryService.getById(Integer.valueOf(coupon.getLinkedData()));
            ArrayList<Integer> pcIdList = new ArrayList<Integer>();
            if (productCategory.getLevel().equals(3)) {
                pcIdList.add(productCategory.getId());
            } else {
                List<Object> productCategoryList = new ArrayList();
                if (productCategory.getLevel().equals(2)) {
                    productCategoryList = this.productCategoryService.findAllChildListByPid(productCategory.getId(), productCategory.getLevel());
                }
                if (productCategory.getLevel().equals(1)) {
                    productCategoryList = this.productCategoryService.getThirdCategoryByFirstId(productCategory.getId(), 0);
                }
                List collect = productCategoryList.stream().map(ProductCategory::getId).collect(Collectors.toList());
                pcIdList.addAll(collect);
            }
            lqw.in(Product::getCategoryId, pcIdList);
        }
        if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_BRAND)) {
            lqw.eq(Product::getBrandId, (Object)Integer.valueOf(coupon.getLinkedData()));
        }
        if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_JOINT_MERCHANT)) {
            lqw.in(Product::getMerId, new Object[]{coupon.getLinkedData()});
        }
        lqw.orderByDesc(Product::getSort);
        lqw.orderByDesc(Product::getId);
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List productList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)productList);
    }

    @Override
    public List<ProductTabsHeaderResponse> getPlatformTabsHeader() {
        ArrayList<ProductTabsHeaderResponse> headers = new ArrayList<ProductTabsHeaderResponse>();
        ProductTabsHeaderResponse header1 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(1));
        ProductTabsHeaderResponse header2 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(2));
        ProductTabsHeaderResponse header6 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(6));
        ProductTabsHeaderResponse header7 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(7));
        headers.add(header1);
        headers.add(header2);
        headers.add(header6);
        headers.add(header7);
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        for (ProductTabsHeaderResponse h : headers) {
            lqw.clear();
            lqw.select(new SFunction[]{Product::getId});
            this.setAdminListWrapperByType((LambdaQueryWrapper<Product>)lqw, h.getType(), 0);
            List Products = this.dao.selectList((Wrapper)lqw);
            h.setCount(Integer.valueOf(Products.size()));
        }
        return headers;
    }

    @Override
    public Boolean platUpdate(ProductPlatUpdateRequest request) {
        Product product = this.getByIdException(request.getId());
        if (product.getFicti().equals(request.getFicti()) && product.getRank().equals(request.getRank())) {
            return Boolean.TRUE;
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Product::getFicti, (Object)request.getFicti());
        wrapper.set(Product::getRank, (Object)request.getRank());
        wrapper.eq(Product::getId, (Object)request.getId());
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean isUseShippingTemplateId(Integer templateId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Product::getTempId, (Object)templateId);
        lqw.eq(Product::getIsDel, (Object)false);
        return this.dao.selectCount((Wrapper)lqw) > 0;
    }

    @Override
    public Boolean submitAudit(Integer id) {
        Product product = this.getByIdException(id);
        if (product.getIsAudit().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u5df2\u7ecf\u5728\u5ba1\u6838\u4e2d");
        }
        if (!product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT)) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5728\u5f85\u63d0\u5ba1\u72b6\u6001");
        }
        if (product.getIsRecycle().booleanValue()) {
            throw new CrmebException("\u56de\u6536\u7ad9\u5546\u54c1\u65e0\u6cd5\u8fdb\u884c\u6b64\u7c7b\u64cd\u4f5c");
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Product::getIsAudit, (Object)true);
        wrapper.set(Product::getIsShow, (Object)false);
        wrapper.eq(Product::getId, (Object)id);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean quickAddStock(ProductAddStockRequest request) {
        Product product = this.getByIdException(request.getId());
        if (product.getIsAudit().booleanValue()) {
            throw new CrmebException("\u5ba1\u6838\u4e2d\u5546\u54c1\u65e0\u6cd5\u7f16\u8f91");
        }
        List valueStockList = request.getAttrValueList();
        List<Integer> attrIdList = valueStockList.stream().map(ProductAttrValueAddStockRequest::getId).distinct().collect(Collectors.toList());
        if (attrIdList.size() != valueStockList.size()) {
            throw new CrmebException("\u6709\u91cd\u590d\u7684\u5546\u54c1\u89c4\u683c\u5c5e\u6027ID");
        }
        List<ProductAttrValue> valueList = this.productAttrValueService.getByProductIdAndAttrIdList(request.getId(), attrIdList, ProductConstants.PRODUCT_TYPE_NORMAL);
        if (CollUtil.isEmpty(valueList) || valueList.size() != attrIdList.size()) {
            throw new CrmebException("\u5546\u54c1\u89c4\u683c\u5c5e\u6027ID\u6570\u7ec4\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5");
        }
        block0: for (ProductAttrValueAddStockRequest value : valueStockList) {
            for (ProductAttrValue attrValue : valueList) {
                if (!attrValue.getId().equals(value.getId())) continue;
                value.setVersion(attrValue.getVersion());
                continue block0;
            }
        }
        int totalStock = valueStockList.stream().mapToInt(ProductAttrValueAddStockRequest::getStock).sum();
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.operationStock(product.getId(), totalStock, "quick");
            valueStockList.forEach(valueStock -> this.productAttrValueService.operationStock(valueStock.getId(), valueStock.getStock(), "quick", ProductConstants.PRODUCT_TYPE_NORMAL, valueStock.getVersion()));
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean reviewFreeEdit(ProductReviewFreeEditRequest request) {
        Product product = this.getByIdException(request.getId());
        if (product.getIsShow().booleanValue()) {
            throw new CrmebException("\u4e0a\u67b6\u5546\u54c1\u65e0\u6cd5\u7f16\u8f91");
        }
        if (product.getIsAudit().booleanValue()) {
            throw new CrmebException("\u5ba1\u6838\u4e2d\u5546\u54c1\u65e0\u6cd5\u7f16\u8f91");
        }
        List attrValueRequestList = request.getAttrValue();
        List<ProductAttrValue> attrValueList = this.productAttrValueService.getListByProductIdAndType(product.getId(), ProductConstants.PRODUCT_TYPE_NORMAL);
        if (CollUtil.isEmpty(attrValueList) || attrValueList.size() != attrValueRequestList.size()) {
            throw new CrmebException("\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        attrValueList.forEach(attrValue -> {
            for (ProductAttrValueReviewFreeEditRequest attrValueRequest : attrValueRequestList) {
                if (!attrValueRequest.getId().equals(attrValue.getId())) continue;
                attrValue.setPrice(attrValueRequest.getPrice());
                attrValue.setStock(attrValueRequest.getStock());
                attrValue.setVersion(Integer.valueOf(0));
                break;
            }
        });
        ProductAttrValue minAttrValue = attrValueList.stream().min(Comparator.comparing(ProductAttrValue::getPrice)).get();
        Product tempProduct = new Product();
        tempProduct.setId(product.getId());
        tempProduct.setPrice(minAttrValue.getPrice());
        tempProduct.setStock(Integer.valueOf(attrValueList.stream().mapToInt(ProductAttrValue::getStock).sum()));
        if (!product.getCateId().equals(request.getCateId())) {
            tempProduct.setCateId(request.getCateId());
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean update = this.updateById(tempProduct);
            if (!update) {
                this.LOGGER.error("\u514d\u5ba1\u7f16\u8f91\u5546\u54c1\u5931\u8d25\uff0c\u5546\u54c1id = {}", (Object)tempProduct.getId());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            update = this.productAttrValueService.updateBatchById(attrValueList, 100);
            if (!update) {
                this.LOGGER.error("\u514d\u5ba1\u7f16\u8f91\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u5931\u8d25\uff0c\u5546\u54c1id = {}", (Object)tempProduct.getId());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public MyRecord copyConfig() {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        String copyType = this.systemConfigService.getValueByKey("system_product_copy_type");
        if (StrUtil.isBlank((CharSequence)copyType)) {
            throw new CrmebException("\u8bf7\u5148\u8fdb\u884c\u91c7\u96c6\u5546\u54c1\u914d\u7f6e");
        }
        int copyNum = 0;
        if (copyType.equals("1")) {
            if (admin.getMerId() > 0) {
                Merchant merchant = (Merchant)this.merchantService.getById(admin.getMerId());
                copyNum = merchant.getCopyProductNum();
            } else {
                OnePassUserInfoVo info = this.onePassService.info();
                copyNum = Optional.ofNullable(info.getCopy().getNum()).orElse(0);
            }
        }
        MyRecord record = new MyRecord();
        record.set("copyType", (Object)copyType);
        record.set("copyNum", (Object)copyNum);
        return record;
    }

    @Override
    public MyRecord copyProduct(String url) {
        SystemAdmin currentMerchantAdmin = SecurityUtil.getLoginUserVo().getUser();
        Merchant currentMerchant = this.merchantService.getByIdException(currentMerchantAdmin.getMerId());
        if (currentMerchant.getCopyProductNum() <= 0) {
            throw new CrmebException("\u5f53\u524d\u5546\u6237\u91c7\u96c6\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
        }
        JSONObject jsonObject = this.onePassService.copyGoods(url);
        ProductResponseForCopyProduct productResponseForCopyProduct = ProductUtils.onePassCopyTransition(jsonObject);
        MyRecord record = new MyRecord();
        return record.set("info", (Object)productResponseForCopyProduct);
    }

    @Override
    public Map<Integer, Product> getMapByIdList(List<Integer> proIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getName, Product::getPrice, Product::getImage, Product::getIsShow, Product::getIsDel, Product::getBizType});
        lqw.in(Product::getId, proIdList);
        List productList = this.dao.selectList((Wrapper)lqw);
        HashMap productMap = CollUtil.newHashMap();
        productList.forEach(e -> productMap.put(e.getId(), e));
        return productMap;
    }

    @Override
    public PageInfo<ProductActivityResponse> getActivitySearchPage(ProductActivitySearchRequest request, PageParamRequest pageRequest) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            map.put("name", URLUtil.decode((String)request.getName()));
        }
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            map.put("categoryId", request.getCategoryId());
        }
        if (ObjectUtil.isNotNull((Object)request.getIsShow())) {
            map.put("isShow", request.getIsShow() != false ? 1 : 0);
        }
        if (ObjectUtil.isNotNull((Object)request.getMerStars()) && request.getMerStars() > 0) {
            map.put("merStars", request.getMerStars());
        }
        if (admin.getMerId() > 0) {
            request.setMerIds(admin.getMerId().toString());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getMerIds())) {
            map.put("merIds", request.getMerIds());
        }
        if (ObjectUtil.isNotNull((Object)request.getBrandId())) {
            map.put("brandId", request.getBrandId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getSalesOrder())) {
            if (request.getSalesOrder().equals("desc")) {
                map.put("lastStr", " order by (p.sales + p.ficti) desc, p.rank desc, p.sort desc, p.id desc");
            } else {
                map.put("lastStr", " order by (p.sales + p.ficti) asc, p.rank desc, p.sort desc, p.id desc");
            }
        } else if (StrUtil.isNotBlank((CharSequence)request.getPriceOrder())) {
            if (request.getPriceOrder().equals("desc")) {
                map.put("lastStr", " order by p.price desc, p.rank desc, p.sort desc, p.id desc");
            } else {
                map.put("lastStr", " order by p.price asc, p.rank desc, p.sort desc, p.id desc");
            }
        } else {
            map.put("lastStr", " order by p.rank desc, p.sort desc, p.id desc");
        }
        List<ProductActivityResponse> responseList = this.dao.getActivitySearchPage(map);
        responseList.forEach(response -> {
            List<ProductAttrValue> attrValueList = this.productAttrValueService.getListByProductIdAndType(response.getId(), ProductConstants.PRODUCT_TYPE_NORMAL);
            response.setAttrValue(attrValueList);
        });
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public PageInfo<ProductActivityResponse> getActivitySearchPageByMerchant(ProductActivitySearchRequest request, PageParamRequest pageRequest) {
        if (ObjectUtil.isNull((Object)request.getActivityId())) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u79d2\u6740\u6d3b\u52a8");
        }
        SeckillActivity activity = (SeckillActivity)this.seckillActivityService.getById(request.getActivityId());
        if (ObjectUtil.isNull((Object)activity) || activity.getIsDel().booleanValue()) {
            throw new CrmebException("\u79d2\u6740\u6d3b\u52a8\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5");
        }
        if (activity.getStatus().equals(2)) {
            throw new CrmebException("\u79d2\u6740\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        Merchant merchant = this.merchantService.getByIdException(admin.getMerId());
        if (activity.getMerStars() > merchant.getStarLevel()) {
            throw new CrmebException("\u5546\u6237\u7b49\u7ea7\u4e0d\u8db3\u4ee5\u53c2\u52a0\u8be5\u6d3b\u52a8");
        }
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            map.put("name", URLUtil.decode((String)request.getName()));
        }
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            map.put("categoryId", request.getCategoryId());
        }
        if (ObjectUtil.isNotNull((Object)request.getCateId())) {
            map.put("cateId", request.getCateId());
        }
        if (ObjectUtil.isNotNull((Object)request.getIsShow())) {
            map.put("isShow", request.getIsShow() != false ? 1 : 0);
        }
        map.put("merId", admin.getMerId());
        if (!activity.getProCategory().equals("0")) {
            map.put("proCateIds", activity.getProCategory());
        }
        if (ObjectUtil.isNotNull((Object)request.getProductId())) {
            map.put("productId", request.getProductId());
        }
        List<ProductActivityResponse> responseList = this.dao.getActivitySearchPageByMerchant(map);
        responseList.forEach(response -> {
            List<ProductAttrValue> attrValueList = this.productAttrValueService.getListByProductIdAndType(response.getId(), ProductConstants.PRODUCT_TYPE_NORMAL);
            response.setAttrValue(attrValueList);
        });
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public Boolean seckillRollBack(Integer id, Integer num, Integer sales) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock + {}", (Object[])new Object[]{num}));
        updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales + {}", (Object[])new Object[]{sales}));
        updateWrapper.eq((Object)"id", (Object)id);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u79d2\u6740\u56de\u6eda\u5e93\u5b58\u8d25\uff0cId = " + id);
        }
        return update;
    }

    @Override
    public Boolean activityOperationStock(Integer id, Integer num, Integer sales, String type) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (type.equals("create")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock - {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)" and (stock - {} >= 0)", (Object[])new Object[]{num}));
        }
        if (type.equals("back")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock + {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales + {}", (Object[])new Object[]{sales}));
        }
        updateWrapper.eq((Object)"id", (Object)id);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u666e\u901a\u5546\u54c1\u5e93\u5b58\u5931\u8d25,\u5546\u54c1id = " + id);
        }
        return update;
    }

    private Product getByIdException(Integer id) {
        Product Product2 = (Product)this.getById(id);
        if (ObjectUtil.isNull((Object)Product2) || Product2.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        return Product2;
    }

    @Override
    public List<PlatformProductListResponse> productListToPlatFromProductListResponse(List<Product> productList) {
        ArrayList<PlatformProductListResponse> platformProductListResponses = new ArrayList<PlatformProductListResponse>();
        for (Product product : productList) {
            PlatformProductListResponse r = new PlatformProductListResponse();
            BeanUtils.copyProperties((Object)product, (Object)r);
            platformProductListResponses.add(r);
        }
        return platformProductListResponses;
    }

    @Override
    public List<SimpleProductVo> findCouponListLimit3(Integer couponCategory, List<Integer> pidList, String linkedData, List<Integer> pcIdList) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{Product::getId, Product::getName, Product::getImage, Product::getPrice, Product::getStock});
        switch (couponCategory) {
            case 2: {
                lqw.in(Product::getId, pidList);
                break;
            }
            case 4: {
                lqw.in(Product::getCategoryId, pcIdList);
                break;
            }
            case 5: {
                lqw.eq(Product::getBrandId, (Object)Integer.valueOf(linkedData));
                break;
            }
            case 6: {
                lqw.in(Product::getMerId, (Collection)CrmebUtil.stringToArray((String)linkedData));
            }
        }
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        lqw.orderByDesc((Object[])new SFunction[]{Product::getSort, Product::getId});
        lqw.last(" limit 3");
        List productList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)productList)) {
            return new ArrayList<SimpleProductVo>();
        }
        return productList.stream().map(e -> {
            SimpleProductVo vo = new SimpleProductVo();
            BeanUtils.copyProperties((Object)e, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
    }

    @Override
    public PageInfo<Product> findCouponProductList(Integer couponId, Integer couponCategory, String couponLinkedDate, SystemCouponProductSearchRequest pageParamRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        switch (couponCategory) {
            case 2: {
                List<CouponProduct> couponProductList = this.couponProductService.findByCid(couponId);
                List pidList = couponProductList.stream().map(CouponProduct::getPid).collect(Collectors.toList());
                lqw.in(Product::getId, pidList);
                break;
            }
            case 4: {
                ProductCategory productCategory = (ProductCategory)this.productCategoryService.getById(Integer.valueOf(couponLinkedDate));
                ArrayList<Integer> pcIdList = new ArrayList<Integer>();
                if (productCategory.getLevel().equals(3)) {
                    pcIdList.add(productCategory.getId());
                } else {
                    List<Object> productCategoryList = new ArrayList();
                    if (productCategory.getLevel().equals(2)) {
                        productCategoryList = this.productCategoryService.findAllChildListByPid(productCategory.getId(), productCategory.getLevel());
                    }
                    if (productCategory.getLevel().equals(1)) {
                        productCategoryList = this.productCategoryService.getThirdCategoryByFirstId(productCategory.getId(), 0);
                    }
                    List collect = productCategoryList.stream().map(ProductCategory::getId).collect(Collectors.toList());
                    pcIdList.addAll(collect);
                }
                lqw.in(Product::getCategoryId, pcIdList);
                break;
            }
            case 5: {
                lqw.eq(Product::getBrandId, (Object)Integer.valueOf(couponLinkedDate));
                break;
            }
            case 6: {
                lqw.in(Product::getMerId, (Collection)CrmebUtil.stringToArray((String)couponLinkedDate));
            }
        }
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        if (StrUtil.isNotBlank((CharSequence)pageParamRequest.getKeyword())) {
            String decode = URLUtil.decode((String)pageParamRequest.getKeyword());
            lqw.like(Product::getName, (Object)decode);
        }
        lqw.orderByDesc((Object[])new SFunction[]{Product::getSort, Product::getId});
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List productList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)productList);
    }

    @Override
    public List<Product> findByIds(List<Integer> proIdsList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(Product::getId, proIdsList);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<BcxProductInfoResponse> getPcIndexProduct(String userProductIds) {
        List<ProCategoryCacheVo> firstCategory = this.productCategoryService.getFrontFirstCategory("pc");
        if (CollUtil.isEmpty(firstCategory)) {
            this.log.error("\u7b2c\u4e00\u7ea7\u5206\u7c7b\u4e3a\u7a7a\uff0c\u8bf7\u6392\u67e5\u95ee\u9898\uff01");
            return new ArrayList<BcxProductInfoResponse>();
        }
        String thirdCategoryIds = firstCategory.stream().flatMap(first -> {
            this.log.debug("\u7b2c\u4e00\u7ea7\uff1a" + first.getName() + " \u5b50\u5206\u7c7b\u4e2a\u6570\uff1a" + first.getChildList().size());
            return first.getChildList().stream();
        }).flatMap(second -> {
            this.log.debug("\u7b2c\u4e8c\u7ea7\uff1a" + second.getName() + " \u5b50\u5206\u7c7b\u4e2a\u6570\uff1a" + second.getChildList().size());
            return second.getChildList().stream();
        }).map(t -> String.valueOf(t.getId())).collect(Collectors.joining(","));
        this.log.debug("\u9996\u9875\u4e09\u7ea7\u5206\u7c7bids\uff1a" + thirdCategoryIds);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cateIds", thirdCategoryIds);
        map.put("userProductIds", userProductIds);
        List<BcxProductInfoResponse> pcIndexList = this.dao.getPcProductList(map);
        this.log.debug("\u9996\u9875\u4e09\u7ea7\u5206\u7c7b\u5546\u54c1\u6570\u91cf\uff1a" + pcIndexList.size());
        return pcIndexList;
    }

    @Override
    public List<BcxProductInfoResponse> getPcProductByNameAndCategory(String userProductIds, String name, String firstCategory, String secondCategory, String thirdCategory) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userProductIds", userProductIds);
        map.put("name", name);
        map.put("firstCategory", firstCategory);
        map.put("secondCategory", secondCategory);
        map.put("thirdCategory", thirdCategory);
        return this.dao.getPcProductList(map);
    }

    @Override
    public BcxProductInfoResponse getPcProductDetail(String userProductIds, Integer productId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userProductIds", userProductIds);
        map.put("productId", productId);
        List<BcxProductInfoResponse> productList = this.dao.getPcProductList(map);
        if (CollUtil.isNotEmpty(productList)) {
            return productList.get(0);
        }
        return null;
    }

    @Override
    public List<BcxProductRiskResponse> getRiskProduct() {
        return this.dao.getRiskProduct();
    }

    @Override
    public List<Product> getProductByThirdCategoryId(Integer thirdCategoryId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Product::getCategoryId, (Object)thirdCategoryId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Integer getBrokerageTotal(Integer productId) {
        Product product = (Product)this.getById(productId);
        int brokerageTotal = 0;
        if (product.getIsBrokerage() == 1) {
            if (product.getIsSub().booleanValue()) {
                List<ProductAttrValue> skuList = this.productAttrValueService.getListByProductIdAndType(productId, 0);
                if (CollectionUtil.isNotEmpty(skuList)) {
                    brokerageTotal = skuList.get(0).getBrokerage() + skuList.get(0).getBrokerageTwo();
                }
            } else {
                brokerageTotal = Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_brokerage_first_ratio")) + Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_brokerage_second_ratio"));
            }
        }
        return brokerageTotal;
    }
}

