/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.model.product.ProductReply;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.ProductReplyCommentRequest;
import com.zbkj.common.request.ProductReplySearchRequest;
import com.zbkj.common.request.ProductReplyVirtualRequest;
import com.zbkj.common.response.ProductDetailReplyResponse;
import com.zbkj.common.response.ProductReplayCountResponse;
import com.zbkj.common.response.ProductReplyResponse;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.ProductReplyDao;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductReplyService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.UserService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductReplyServiceImpl
extends ServiceImpl<ProductReplyDao, ProductReply>
implements ProductReplyService {
    @Resource
    private ProductReplyDao dao;
    @Autowired
    private ProductService productService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private ProductAttrValueService attrValueService;
    @Autowired
    private UserService userService;

    @Override
    public PageInfo<ProductReplyResponse> getAdminPage(ProductReplySearchRequest request, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        Integer merId = 0;
        if (ObjectUtil.isNotNull((Object)request.getMerId())) {
            merId = request.getMerId();
        }
        if (!this.adminPageGetWhere((LambdaQueryWrapper<ProductReply>)lqw, request, merId).booleanValue()) {
            Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new ProductReplyResponse[0]));
        }
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List dataList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)dataList)) {
            return CommonPage.copyPageInfo((Page)page, new ArrayList());
        }
        List<Integer> uidList = dataList.stream().map(ProductReply::getUid).distinct().collect(Collectors.toList());
        Map<Object, Object> userMap = CollUtil.newHashMap();
        if (CollUtil.isNotEmpty(uidList)) {
            userMap = this.userService.getUidMapList(uidList);
        }
        ArrayList<ProductReplyResponse> dataResList = new ArrayList<ProductReplyResponse>();
        for (ProductReply productReply : dataList) {
            Merchant merchant;
            ProductReplyResponse productReplyResponse = new ProductReplyResponse();
            BeanUtils.copyProperties((Object)productReply, (Object)productReplyResponse);
            if (productReply.getOrderDetailId() > 0) {
                OrderDetail orderDetail = (OrderDetail)this.orderDetailService.getById(productReply.getOrderDetailId());
                productReplyResponse.setProductName(orderDetail.getProductName());
                productReplyResponse.setProductImage(orderDetail.getImage());
                merchant = (Merchant)this.merchantService.getById(orderDetail.getMerId());
                productReplyResponse.setMerName(merchant.getName());
            } else {
                Product product = (Product)this.productService.getById(productReply.getProductId());
                productReplyResponse.setProductName(product.getName());
                productReplyResponse.setProductImage(product.getImage());
                merchant = (Merchant)this.merchantService.getById(product.getMerId());
                productReplyResponse.setMerName(merchant.getName());
            }
            if (StrUtil.isNotBlank((CharSequence)productReply.getPics())) {
                productReplyResponse.setPics(CrmebUtil.stringToArrayStr((String)productReply.getPics()));
            }
            if (productReply.getUid() > 0) {
                productReplyResponse.setIsLogoff(((User)userMap.get(productReply.getUid())).getIsLogoff());
            }
            dataResList.add(productReplyResponse);
        }
        return CommonPage.copyPageInfo((Page)page, dataResList);
    }

    @Override
    public PageInfo<ProductReplyResponse> getMerchantAdminPage(ProductReplySearchRequest request, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        if (!this.adminPageGetWhere((LambdaQueryWrapper<ProductReply>)lqw, request, systemAdmin.getMerId()).booleanValue()) {
            Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new ProductReplyResponse[0]));
        }
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List dataList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)dataList)) {
            return CommonPage.copyPageInfo((Page)page, new ArrayList());
        }
        List<Integer> uidList = dataList.stream().map(ProductReply::getUid).distinct().collect(Collectors.toList());
        Map<Object, Object> userMap = CollUtil.newHashMap();
        if (CollUtil.isNotEmpty(uidList)) {
            userMap = this.userService.getUidMapList(uidList);
        }
        ArrayList<ProductReplyResponse> dataResList = new ArrayList<ProductReplyResponse>();
        for (ProductReply productReply : dataList) {
            ProductReplyResponse productReplyResponse = new ProductReplyResponse();
            BeanUtils.copyProperties((Object)productReply, (Object)productReplyResponse);
            if (productReply.getOrderDetailId() > 0) {
                OrderDetail orderDetail = (OrderDetail)this.orderDetailService.getById(productReply.getOrderDetailId());
                productReplyResponse.setProductName(orderDetail.getProductName());
                productReplyResponse.setProductImage(orderDetail.getImage());
            } else {
                Product product = (Product)this.productService.getById(productReply.getProductId());
                productReplyResponse.setProductName(product.getName());
                productReplyResponse.setProductImage(product.getImage());
            }
            if (StrUtil.isNotBlank((CharSequence)productReply.getPics())) {
                productReplyResponse.setPics(CrmebUtil.stringToArrayStr((String)productReply.getPics()));
            }
            if (productReply.getUid() > 0) {
                productReplyResponse.setIsLogoff(((User)userMap.get(productReply.getUid())).getIsLogoff());
            }
            dataResList.add(productReplyResponse);
        }
        return CommonPage.copyPageInfo((Page)page, dataResList);
    }

    @Override
    public Boolean virtualCreate(ProductReplyVirtualRequest request) {
        Product product = (Product)this.productService.getById(request.getProductId());
        if (ObjectUtil.isNull((Object)product) || product.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        ProductAttrValue attrValue = (ProductAttrValue)this.attrValueService.getById(request.getAttrValueId());
        if (ObjectUtil.isNull((Object)attrValue) || attrValue.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u503c\u4e0d\u5b58\u5728");
        }
        ProductReply productReply = new ProductReply();
        BeanUtils.copyProperties((Object)request, (Object)productReply);
        String cdnUrl = this.systemAttachmentService.getCdnUrl();
        productReply.setAvatar(this.systemAttachmentService.clearPrefix(request.getAvatar(), cdnUrl));
        if (CollUtil.isNotEmpty((Collection)request.getPics())) {
            List pics = request.getPics().stream().map(e -> this.systemAttachmentService.clearPrefix((String)e, cdnUrl)).collect(Collectors.toList());
            productReply.setPics(String.join((CharSequence)",", pics));
        }
        productReply.setUid(Integer.valueOf(0));
        productReply.setMerId(product.getMerId());
        productReply.setSku(attrValue.getSku());
        return this.save(productReply);
    }

    @Override
    public ProductReplayCountResponse getH5Count(Integer productId) {
        Integer sumCount = this.getCountByScore(productId, "all");
        Integer goodCount = this.getCountByScore(productId, "good");
        Integer mediumCount = this.getCountByScore(productId, "medium");
        Integer poorCount = this.getCountByScore(productId, "poor");
        String replyChance = "0";
        if (sumCount > 0 && goodCount > 0) {
            replyChance = String.format("%.2f", goodCount.doubleValue() / sumCount.doubleValue());
        }
        Integer replyStar = 0;
        if (sumCount > 0) {
            replyStar = this.getSumStar(productId);
            BigDecimal divide = new BigDecimal(replyStar).divide(new BigDecimal(sumCount.toString()), 0, 1);
            replyStar = divide.intValue();
        }
        return new ProductReplayCountResponse(sumCount, goodCount, mediumCount, poorCount, replyChance, replyStar);
    }

    @Override
    public ProductDetailReplyResponse getH5ProductReply(Integer proId) {
        String nickname;
        ProductDetailReplyResponse response = new ProductDetailReplyResponse();
        Integer sumCount = this.getCountByScore(proId, "all");
        if (sumCount.equals(0)) {
            response.setSumCount(Integer.valueOf(0));
            response.setReplyChance("0");
            return response;
        }
        Integer goodCount = this.getCountByScore(proId, "good");
        String replyChance = "0";
        if (sumCount > 0 && goodCount > 0) {
            replyChance = String.format("%.2f", goodCount.doubleValue() / sumCount.doubleValue());
        }
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(ProductReply::getProductId, (Object)proId);
        lqw.eq(ProductReply::getIsDel, (Object)false);
        lqw.orderByDesc(ProductReply::getId);
        lqw.last(" limit 1");
        ProductReply productReply = (ProductReply)this.dao.selectOne((Wrapper)lqw);
        ProductReplyResponse productReplyResponse = new ProductReplyResponse();
        BeanUtils.copyProperties((Object)productReply, (Object)productReplyResponse);
        if (StrUtil.isNotBlank((CharSequence)productReply.getPics())) {
            productReplyResponse.setPics(CrmebUtil.stringToArrayStr((String)productReply.getPics()));
        }
        if (StrUtil.isNotBlank((CharSequence)(nickname = productReply.getNickname()))) {
            nickname = nickname.length() == 1 ? nickname.concat("**") : (nickname.length() == 2 ? nickname.charAt(0) + "**" : nickname.charAt(0) + "**" + nickname.substring(nickname.length() - 1));
            productReplyResponse.setNickname(nickname);
        }
        if (productReply.getUid() > 0) {
            User user = (User)this.userService.getById(productReply.getUid());
            productReplyResponse.setIsLogoff(user.getIsLogoff());
        }
        response.setSumCount(sumCount);
        response.setReplyChance(replyChance);
        response.setProductReply(productReplyResponse);
        return response;
    }

    @Override
    public PageInfo<ProductReplyResponse> getH5List(Integer proId, Integer type, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(ProductReply::getIsDel, (Object)false);
        lqw.eq(ProductReply::getProductId, (Object)proId);
        switch (type) {
            case 1: {
                lqw.eq(ProductReply::getStar, (Object)5);
                break;
            }
            case 2: {
                lqw.apply(" star < 5 and star > 1", new Object[0]);
                break;
            }
            case 3: {
                lqw.eq(ProductReply::getStar, (Object)1);
                break;
            }
        }
        lqw.orderByDesc(ProductReply::getId);
        List replyList = this.dao.selectList((Wrapper)lqw);
        ArrayList<ProductReplyResponse> responseList = new ArrayList<ProductReplyResponse>();
        if (CollUtil.isEmpty((Collection)replyList)) {
            return CommonPage.copyPageInfo((Page)page, responseList);
        }
        List<Integer> uidList = replyList.stream().map(e -> e.getUid()).distinct().collect(Collectors.toList());
        Map<Integer, User> userMap = this.userService.getUidMapList(uidList);
        for (ProductReply productReply : replyList) {
            String nickname;
            ProductReplyResponse productReplyResponse = new ProductReplyResponse();
            BeanUtils.copyProperties((Object)productReply, (Object)productReplyResponse);
            if (StrUtil.isNotBlank((CharSequence)productReply.getPics())) {
                productReplyResponse.setPics(CrmebUtil.stringToArrayStr((String)productReply.getPics()));
            }
            if (StrUtil.isNotBlank((CharSequence)(nickname = productReply.getNickname()))) {
                nickname = nickname.length() == 1 ? nickname.concat("**") : (nickname.length() == 2 ? nickname.charAt(0) + "**" : nickname.charAt(0) + "**" + nickname.substring(nickname.length() - 1));
                productReplyResponse.setNickname(nickname);
            }
            if (productReply.getUid() > 0) {
                productReplyResponse.setIsLogoff(userMap.get(productReply.getUid()).getIsLogoff());
            }
            responseList.add(productReplyResponse);
        }
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public Boolean delete(Integer id) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(ProductReply::getIsDel, (Object)1);
        wrapper.eq(ProductReply::getId, (Object)id);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean comment(ProductReplyCommentRequest request) {
        ProductReply reply = (ProductReply)this.getById(request.getId());
        if (ObjectUtil.isNull((Object)reply) || reply.getIsDel().booleanValue()) {
            throw new CrmebException("\u8bc4\u8bba\u4e0d\u5b58\u5728");
        }
        if (reply.getIsReply().booleanValue()) {
            throw new CrmebException("\u5df2\u8bc4\u8bba");
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ProductReply::getId, (Object)request.getId());
        wrapper.set(ProductReply::getMerchantReplyContent, (Object)request.getMerchantReplyContent());
        wrapper.set(ProductReply::getMerchantReplyTime, (Object)DateUtil.date());
        wrapper.set(ProductReply::getIsReply, (Object)true);
        return this.update((Wrapper)wrapper);
    }

    private Boolean adminPageGetWhere(LambdaQueryWrapper<ProductReply> lqw, ProductReplySearchRequest request, Integer merId) {
        if (!merId.equals(0)) {
            lqw.eq(ProductReply::getMerId, (Object)merId);
        }
        if (ObjectUtil.isNotNull((Object)request.getStar())) {
            lqw.eq(ProductReply::getStar, (Object)request.getStar());
        }
        if (ObjectUtil.isNotNull((Object)request.getIsReply())) {
            lqw.eq(ProductReply::getIsReply, (Object)request.getIsReply());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getProductSearch())) {
            String search = URLUtil.decode((String)request.getProductSearch());
            List<Product> storeProducts = this.productService.likeProductName(search, merId);
            if (CollUtil.isNotEmpty(storeProducts)) {
                List productIds = storeProducts.stream().map(Product::getId).collect(Collectors.toList());
                lqw.in(ProductReply::getProductId, productIds);
            } else {
                return Boolean.FALSE;
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getNickname())) {
            String nickNameSearch = URLUtil.decode((String)request.getNickname());
            lqw.like(ProductReply::getNickname, (Object)nickNameSearch);
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            lqw.between(ProductReply::getCreateTime, (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        lqw.eq(ProductReply::getIsDel, (Object)false);
        lqw.orderByDesc(ProductReply::getId);
        return Boolean.TRUE;
    }

    private Integer getSumStar(Integer productId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"IFNULL(sum(star),0) as star"});
        queryWrapper.eq((Object)"is_del", (Object)0);
        queryWrapper.eq((Object)"product_id", (Object)productId);
        ProductReply productReply = (ProductReply)this.dao.selectOne((Wrapper)queryWrapper);
        if (ObjectUtil.isNull((Object)productReply)) {
            return 0;
        }
        if (productReply.getStar() == 0) {
            return 0;
        }
        return productReply.getStar();
    }

    @Override
    public Integer getCountByScore(Integer productId, String type) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(ProductReply::getProductId, (Object)productId);
        lqw.eq(ProductReply::getIsDel, (Object)false);
        switch (type) {
            case "all": {
                break;
            }
            case "good": {
                lqw.eq(ProductReply::getStar, (Object)5);
                break;
            }
            case "medium": {
                lqw.and(i -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.lt(ProductReply::getStar, (Object)5)).gt(ProductReply::getStar, (Object)1);
                });
                break;
            }
            case "poor": {
                lqw.eq(ProductReply::getStar, (Object)1);
            }
        }
        return this.dao.selectCount((Wrapper)lqw);
    }
}

