/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.product.ProductCategory;
import com.zbkj.common.request.ProductCategoryRequest;
import com.zbkj.common.response.FirstCategoryWithProductNumberResponse;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.vo.ProCategoryCacheTree;
import com.zbkj.common.vo.ProCategoryCacheVo;
import com.zbkj.service.dao.ProductCategoryDao;
import com.zbkj.service.service.CouponService;
import com.zbkj.service.service.ProductBrandCategoryService;
import com.zbkj.service.service.ProductCategoryService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.SystemAttachmentService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ProductCategoryServiceImpl
extends ServiceImpl<ProductCategoryDao, ProductCategory>
implements ProductCategoryService {
    @Resource
    private ProductCategoryDao dao;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ProductBrandCategoryService productBrandCategoryService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private CouponService couponService;

    @Override
    public List<ProductCategory> getAdminList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductCategory::getIsDel, (Object)false);
        lqw.orderByDesc(ProductCategory::getSort);
        lqw.orderByAsc(ProductCategory::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean add(ProductCategoryRequest request) {
        boolean save;
        if (this.checkName(request.getName(), request.getPid()).booleanValue()) {
            throw new CrmebException("\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        ProductCategory productCategory = new ProductCategory();
        BeanUtils.copyProperties((Object)request, (Object)productCategory);
        productCategory.setId(null);
        productCategory.setPid(Integer.valueOf(0));
        if (!request.getLevel().equals(1)) {
            if (request.getPid().equals(0)) {
                throw new CrmebException("\u5b50\u7ea7\u83dc\u5355\uff0c\u7236\u7ea7ID\u4e0d\u80fd\u4e3a0");
            }
            ProductCategory category = this.getByIdException(request.getPid());
            if (category.getLevel() >= request.getLevel()) {
                throw new CrmebException("\u65b0\u589e\u7684\u5546\u54c1\u5206\u7c7b\u5c42\u7ea7\u5f02\u5e38");
            }
            productCategory.setPid(request.getPid());
        }
        if (StrUtil.isNotBlank((CharSequence)productCategory.getIcon())) {
            productCategory.setIcon(this.systemAttachmentService.clearPrefix(productCategory.getIcon()));
        }
        if (save = this.save(productCategory)) {
            this.redisUtil.delete(new String[]{"productCategoryList"});
            this.redisUtil.delete(new String[]{"productCategoryMerchantList"});
        }
        return save;
    }

    @Override
    public Boolean delete(Integer id) {
        List<ProductCategory> categoryList;
        ProductCategory category = this.getByIdException(id);
        if (category.getLevel() < 3 && CollUtil.isNotEmpty(categoryList = this.findAllChildListByPid(category.getId(), category.getLevel()))) {
            throw new CrmebException("\u8bf7\u5148\u5220\u9664\u5b50\u7ea7\u5206\u7c7b");
        }
        if (this.productService.isUsePlatformCategory(category.getId()).booleanValue()) {
            throw new CrmebException("\u6709\u5546\u54c1\u4f7f\u7528\u8be5\u5206\u7c7b\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        if (this.productBrandCategoryService.isExistCategory(category.getId()).booleanValue()) {
            throw new CrmebException("\u6709\u54c1\u724c\u5173\u8054\u8be5\u5206\u7c7b\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        category.setIsDel(Boolean.valueOf(true));
        Boolean update = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(category);
            this.couponService.deleteByProCategoryId(category.getId());
            return Boolean.TRUE;
        });
        if (update.booleanValue()) {
            this.redisUtil.delete(new String[]{"productCategoryList"});
            this.redisUtil.delete(new String[]{"productCategoryMerchantList"});
        }
        return update;
    }

    @Override
    public Boolean edit(ProductCategoryRequest request) {
        boolean update;
        if (ObjectUtil.isNull((Object)request.getId()) || ObjectUtil.isNull((Object)request.getPid())) {
            throw new CrmebException("\u5546\u54c1\u5206\u7c7bID\u6216Pid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ProductCategory oldCategory = this.getByIdException(request.getId());
        if (!(oldCategory.getName().equals(request.getName()) && oldCategory.getPid().equals(request.getPid()) || !this.checkName(request.getName(), request.getPid()).booleanValue())) {
            throw new CrmebException("\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (oldCategory.getLevel().equals(3) && !request.getLevel().equals(3)) {
            if (this.productService.isUsePlatformCategory(oldCategory.getId()).booleanValue()) {
                throw new CrmebException("\u6709\u5546\u54c1\u4f7f\u7528\u8be5\u5206\u7c7b\uff0c\u65e0\u6cd5\u4fee\u6539");
            }
            if (this.productBrandCategoryService.isExistCategory(oldCategory.getId()).booleanValue()) {
                throw new CrmebException("\u6709\u54c1\u724c\u5173\u8054\u8be5\u5206\u7c7b\uff0c\u65e0\u6cd5\u4fee\u6539");
            }
        }
        ProductCategory category = new ProductCategory();
        BeanUtils.copyProperties((Object)request, (Object)category);
        category.setPid(oldCategory.getPid());
        if (StrUtil.isNotBlank((CharSequence)category.getIcon())) {
            category.setIcon(this.systemAttachmentService.clearPrefix(category.getIcon()));
        }
        if (update = this.updateById(category)) {
            this.redisUtil.delete(new String[]{"productCategoryList"});
            this.redisUtil.delete(new String[]{"productCategoryMerchantList"});
        }
        return update;
    }

    @Override
    public Boolean updateShowStatus(Integer id) {
        boolean showStatus;
        ProductCategory category = this.getByIdException(id);
        ArrayList<ProductCategory> categoryList = new ArrayList<ProductCategory>();
        boolean bl = showStatus = category.getIsShow() == false;
        if (!category.getLevel().equals(1) && showStatus) {
            ProductCategory firstCategory;
            ProductCategory parentCategory = this.getByIdException(category.getPid());
            if (parentCategory.getIsShow().equals(false)) {
                parentCategory.setIsShow(Boolean.valueOf(showStatus));
                categoryList.add(parentCategory);
            }
            if (parentCategory.getLevel().equals(2) && (firstCategory = this.getByIdException(parentCategory.getPid())).getIsShow().equals(false)) {
                firstCategory.setIsShow(Boolean.valueOf(showStatus));
                categoryList.add(firstCategory);
            }
        }
        category.setIsShow(Boolean.valueOf(showStatus));
        categoryList.add(category);
        Boolean update = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateBatchById(categoryList);
            if (category.getLevel().equals(2)) {
                this.updateChildShowStatus(category.getId(), showStatus);
            }
            if (category.getLevel().equals(1)) {
                List<ProductCategory> productCategoryList = this.findAllChildListByPid(category.getId(), category.getLevel());
                productCategoryList.forEach(c -> c.setIsShow(Boolean.valueOf(showStatus)));
                this.updateBatchById(productCategoryList, 100);
            }
            return Boolean.TRUE;
        });
        if (update.booleanValue()) {
            this.redisUtil.delete(new String[]{"productCategoryList"});
            this.redisUtil.delete(new String[]{"productCategoryMerchantList"});
        }
        return update;
    }

    private void updateChildShowStatus(Integer pid, Boolean showStatus) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(ProductCategory::getIsShow, (Object)showStatus);
        wrapper.eq(ProductCategory::getPid, (Object)pid);
        this.update((Wrapper)wrapper);
    }

    @Override
    public List<ProCategoryCacheVo> getCacheTree() {
        List categoryList = CollUtil.newArrayList((Object[])new ProductCategory[0]);
        if (this.redisUtil.exists("productCategoryList").booleanValue()) {
            categoryList = (List)this.redisUtil.get("productCategoryList");
        } else {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.eq(ProductCategory::getIsDel, (Object)false);
            categoryList = this.dao.selectList((Wrapper)lqw);
            if (CollUtil.isEmpty(categoryList)) {
                return CollUtil.newArrayList((Object[])new ProCategoryCacheVo[0]);
            }
            this.redisUtil.set("productCategoryList", categoryList);
        }
        List voList = categoryList.stream().map(e -> {
            ProCategoryCacheVo cacheVo = new ProCategoryCacheVo();
            BeanUtils.copyProperties((Object)e, (Object)cacheVo);
            return cacheVo;
        }).collect(Collectors.toList());
        ProCategoryCacheTree categoryTree = new ProCategoryCacheTree(voList);
        return categoryTree.buildTree();
    }

    @Override
    public List<ProductCategory> getCache() {
        List categoryList = CollUtil.newArrayList((Object[])new ProductCategory[0]);
        if (this.redisUtil.exists("productCategoryList").booleanValue()) {
            categoryList = (List)this.redisUtil.get("productCategoryList");
        } else {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.eq(ProductCategory::getIsDel, (Object)false);
            categoryList = this.dao.selectList((Wrapper)lqw);
            if (CollUtil.isEmpty((Collection)categoryList)) {
                return CollUtil.newArrayList((Object[])new ProductCategory[0]);
            }
            this.redisUtil.set("productCategoryList", (Object)categoryList);
        }
        return categoryList;
    }

    @Override
    public List<ProCategoryCacheVo> getMerchantCacheTree(String terminal) {
        List categoryList = CollUtil.newArrayList((Object[])new ProductCategory[0]);
        if (this.redisUtil.exists("productCategoryMerchantList").booleanValue()) {
            categoryList = (List)this.redisUtil.get("productCategoryMerchantList");
        } else {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.eq(ProductCategory::getIsShow, (Object)true);
            lqw.eq(ProductCategory::getIsDel, (Object)false);
            categoryList = this.dao.selectList((Wrapper)lqw);
            if (CollUtil.isEmpty(categoryList)) {
                return CollUtil.newArrayList((Object[])new ProCategoryCacheVo[0]);
            }
            this.redisUtil.set("productCategoryMerchantList", categoryList);
        }
        List voList = categoryList.stream().filter(c -> {
            if ("pc".equals(terminal)) {
                return c.getPcMall();
            }
            if ("risk".equals(terminal)) {
                return c.getWxMiniRisk();
            }
            return true;
        }).map(e -> {
            ProCategoryCacheVo cacheVo = new ProCategoryCacheVo();
            BeanUtils.copyProperties((Object)e, (Object)cacheVo);
            return cacheVo;
        }).collect(Collectors.toList());
        ProCategoryCacheTree categoryTree = new ProCategoryCacheTree(voList);
        return categoryTree.buildTree();
    }

    @Override
    public List<ProductCategory> findAllChildListByPid(Integer pid, Integer level) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductCategory::getPid, (Object)pid);
        lqw.eq(ProductCategory::getIsDel, (Object)false);
        if (level.equals(2)) {
            return this.dao.selectList((Wrapper)lqw);
        }
        List categoryList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)categoryList)) {
            return categoryList;
        }
        List pidList = categoryList.stream().map(ProductCategory::getId).collect(Collectors.toList());
        lqw.clear();
        lqw.in(ProductCategory::getPid, pidList);
        lqw.eq(ProductCategory::getIsDel, (Object)false);
        List childCategoryList = this.dao.selectList((Wrapper)lqw);
        categoryList.addAll(childCategoryList);
        return categoryList;
    }

    @Override
    public List<ProCategoryCacheVo> getFrontFirstCategory(String terminal) {
        List<ProCategoryCacheVo> cacheVoList = this.getMerchantCacheTree(terminal);
        return cacheVoList.stream().filter(e -> e.getLevel().equals(1)).collect(Collectors.toList());
    }

    @Override
    public List<ProductCategory> getHomeThirdCategory(Integer firstId) {
        return this.getThirdCategoryByFirstId(firstId, 9);
    }

    @Override
    public List<ProductCategory> getThirdCategoryByFirstId(Integer firstId, Integer limit) {
        return this.dao.getThirdCategoryByFirstId(firstId, limit);
    }

    @Override
    public Map<Integer, ProductCategory> getMapByIdList(List<Integer> cateIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{ProductCategory::getId, ProductCategory::getName});
        lqw.in(ProductCategory::getId, cateIdList);
        List categoryList = this.dao.selectList((Wrapper)lqw);
        HashMap categoryMap = CollUtil.newHashMap();
        categoryList.forEach(c -> categoryMap.put(c.getId(), c));
        return categoryMap;
    }

    @Override
    public String getNameStrByIds(String proCategoryIds) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{ProductCategory::getName});
        lqw.in(ProductCategory::getId, (Collection)CrmebUtil.stringToArray((String)proCategoryIds));
        List categoryList = this.dao.selectList((Wrapper)lqw);
        return categoryList.stream().map(ProductCategory::getName).collect(Collectors.joining(","));
    }

    @Override
    public List<Integer> findParentIdByChildIds(List<Integer> childIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(ProductCategory::getId, childIdList);
        List list = this.dao.selectList((Wrapper)lqw);
        return list.stream().map(ProductCategory::getPid).collect(Collectors.toList());
    }

    @Override
    public List<FirstCategoryWithProductNumberResponse> countProductByFirstCategory(String name) {
        return this.dao.countProductByFirstCategory(name);
    }

    private ProductCategory getByIdException(Integer id) {
        ProductCategory category = (ProductCategory)this.getById(id);
        if (ObjectUtil.isNull((Object)category) || category.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        return category;
    }

    private Boolean checkName(String name, Integer pid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{ProductCategory::getId});
        lqw.eq(ProductCategory::getName, (Object)name);
        lqw.eq(ProductCategory::getIsDel, (Object)false);
        lqw.eq(ProductCategory::getPid, (Object)pid);
        lqw.last(" limit 1");
        ProductCategory productCategory = (ProductCategory)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)productCategory) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public List<ProductCategory> getPcThirdCategory() {
        List<ProductCategory> cache = this.getCache();
        return cache.stream().filter(c -> ObjectUtil.isNotNull((Object)c) && ObjectUtil.equal((Object)c.getLevel(), (Object)3) && c.getPcMall() != false && c.getIsShow() != false).collect(Collectors.toList());
    }

    @Override
    public List<ProductCategory> getRiskThirdCategory() {
        List<ProductCategory> cache = this.getCache();
        List<ProductCategory> list = cache.stream().filter(c -> ObjectUtil.isNotNull((Object)c) && ObjectUtil.equal((Object)c.getLevel(), (Object)3) && c.getWxMiniRisk() != false && c.getIsShow() != false).collect(Collectors.toList());
        return list;
    }
}

