/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.product.ProductBrand;
import com.zbkj.common.model.product.ProductBrandCategory;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BrandCategorySearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.ProductBrandRequest;
import com.zbkj.common.response.ProductBrandListResponse;
import com.zbkj.common.response.ProductBrandResponse;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.service.dao.ProductBrandDao;
import com.zbkj.service.service.CouponService;
import com.zbkj.service.service.ProductBrandCategoryService;
import com.zbkj.service.service.ProductBrandService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.SystemAttachmentService;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ProductBrandServiceImpl
extends ServiceImpl<ProductBrandDao, ProductBrand>
implements ProductBrandService {
    @Resource
    private ProductBrandDao dao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private ProductBrandCategoryService brandCategoryService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ProductService productService;
    @Autowired
    private CouponService couponService;

    @Override
    public PageInfo<ProductBrandListResponse> getAdminPage(PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductBrand::getIsDel, (Object)false);
        lqw.orderByDesc(ProductBrand::getSort);
        List brandList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)brandList)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new ProductBrandListResponse[0]));
        }
        List responseList = brandList.stream().map(e -> {
            ProductBrandListResponse response = new ProductBrandListResponse();
            BeanUtils.copyProperties((Object)e, (Object)response);
            List<ProductBrandCategory> list = this.brandCategoryService.getListByBrandId(e.getId());
            if (CollUtil.isEmpty(list)) {
                response.setCategoryIds("");
            } else {
                List cidList = list.stream().map(bc -> bc.getCid().toString()).collect(Collectors.toList());
                response.setCategoryIds(String.join((CharSequence)",", cidList));
            }
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public Boolean add(ProductBrandRequest request) {
        Boolean execute;
        this.validateName(request.getName());
        ProductBrand brand = new ProductBrand();
        BeanUtils.copyProperties((Object)request, (Object)brand);
        brand.setId(null);
        if (StrUtil.isNotBlank((CharSequence)brand.getIcon())) {
            brand.setIcon(this.systemAttachmentService.clearPrefix(brand.getIcon()));
        }
        if ((execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.save(brand);
            if (StrUtil.isNotBlank((CharSequence)request.getCategoryIds())) {
                List<ProductBrandCategory> initList = this.brandCategoryInit(brand.getId(), request.getCategoryIds());
                this.brandCategoryService.saveBatch(initList, 100);
            }
            return Boolean.TRUE;
        })).booleanValue()) {
            this.redisUtil.delete(new String[]{"productBrandAllList"});
        }
        return execute;
    }

    @Override
    public Boolean delete(Integer id) {
        ProductBrand brand = this.getByIdException(id);
        if (this.productService.isUseBrand(brand.getId()).booleanValue()) {
            throw new CrmebException("\u6709\u5546\u54c1\u4f7f\u7528\u8be5\u54c1\u724c\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        brand.setIsDel(Boolean.valueOf(true));
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(brand);
            this.brandCategoryService.deleteByBid(brand.getId());
            this.couponService.deleteByBrandId(brand.getId());
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.redisUtil.delete(new String[]{"productBrandAllList"});
        }
        return execute;
    }

    @Override
    public Boolean edit(ProductBrandRequest request) {
        Boolean execute;
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ProductBrand oldBrand = this.getByIdException(request.getId());
        if (!oldBrand.getName().equals(request.getName())) {
            this.validateName(request.getName());
        }
        ProductBrand brand = new ProductBrand();
        BeanUtils.copyProperties((Object)request, (Object)brand);
        if (StrUtil.isNotBlank((CharSequence)brand.getIcon())) {
            brand.setIcon(this.systemAttachmentService.clearPrefix(brand.getIcon()));
        }
        if ((execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(brand);
            this.brandCategoryService.deleteByBid(brand.getId());
            if (StrUtil.isNotBlank((CharSequence)request.getCategoryIds())) {
                List<ProductBrandCategory> initList = this.brandCategoryInit(brand.getId(), request.getCategoryIds());
                this.brandCategoryService.saveBatch(initList, 100);
            }
            return Boolean.TRUE;
        })).booleanValue()) {
            this.redisUtil.delete(new String[]{"productBrandAllList"});
        }
        return execute;
    }

    @Override
    public Boolean updateShowStatus(Integer id) {
        ProductBrand brand;
        brand.setIsShow(Boolean.valueOf((brand = this.getByIdException(id)).getIsShow() == false));
        boolean update = this.updateById(brand);
        if (update) {
            this.redisUtil.delete(new String[]{"productBrandAllList"});
        }
        return update;
    }

    @Override
    public List<ProductBrandResponse> getCacheAllList() {
        if (this.redisUtil.exists("productBrandAllList").booleanValue()) {
            return (List)this.redisUtil.get("productBrandAllList");
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductBrand::getIsDel, (Object)false);
        lqw.orderByDesc(ProductBrand::getSort);
        List brandList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)brandList)) {
            return CollUtil.newArrayList((Object[])new ProductBrandResponse[0]);
        }
        List<ProductBrandResponse> responseList = brandList.stream().map(e -> {
            ProductBrandResponse brandResponse = new ProductBrandResponse();
            BeanUtils.copyProperties((Object)e, (Object)brandResponse);
            return brandResponse;
        }).collect(Collectors.toList());
        this.redisUtil.set("productBrandAllList", responseList);
        return responseList;
    }

    @Override
    public PageInfo<ProductBrandResponse> getPageListByCategory(BrandCategorySearchRequest request, PageParamRequest pageParamRequest) {
        List<ProductBrand> brandList;
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        HashMap map = CollUtil.newHashMap();
        map.put("cid", request.getCid());
        if (StrUtil.isNotBlank((CharSequence)request.getBrandName())) {
            map.put("brandName", request.getBrandName());
        }
        if (CollUtil.isEmpty(brandList = this.dao.getPageListByCategory(map))) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new ProductBrandResponse[0]));
        }
        List responseList = brandList.stream().map(e -> {
            ProductBrandResponse brandResponse = new ProductBrandResponse();
            BeanUtils.copyProperties((Object)e, (Object)brandResponse);
            return brandResponse;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    private ProductBrand getByIdException(Integer id) {
        ProductBrand brand = (ProductBrand)this.getById(id);
        if (ObjectUtil.isNull((Object)brand) || brand.getIsDel().booleanValue()) {
            throw new CrmebException("\u54c1\u724c\u4e0d\u5b58\u5728");
        }
        return brand;
    }

    private List<ProductBrandCategory> brandCategoryInit(Integer bid, String categoryIds) {
        String[] split = categoryIds.split(",");
        return Arrays.stream(split).map(e -> {
            ProductBrandCategory brandCategory = new ProductBrandCategory();
            brandCategory.setBid(bid);
            brandCategory.setCid(Integer.valueOf(e));
            return brandCategory;
        }).collect(Collectors.toList());
    }

    private void validateName(String name) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductBrand::getIsDel, (Object)false);
        lqw.eq(ProductBrand::getName, (Object)name);
        lqw.last(" limit 1");
        ProductBrand brand = (ProductBrand)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNotNull((Object)brand)) {
            throw new CrmebException("\u54c1\u724c\u5df2\u5b58\u5728");
        }
    }
}

