/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.constants.UserConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.bcx.BcxPayOffline;
import com.zbkj.common.model.bcx.BcxPlatformFee;
import com.zbkj.common.model.bcx.BcxPlatformFeeConfig;
import com.zbkj.common.model.express.Express;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.order.OrderInvoice;
import com.zbkj.common.model.order.OrderInvoiceDetail;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.system.SystemNotification;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserToken;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.OrderRemarkRequest;
import com.zbkj.common.request.OrderSearchRequest;
import com.zbkj.common.request.OrderSendRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SplitOrderSendDetailRequest;
import com.zbkj.common.request.bcx.OrderModifyPriceRequest;
import com.zbkj.common.response.MerchantOrderPageResponse;
import com.zbkj.common.response.OrderAdminDetailResponse;
import com.zbkj.common.response.OrderCountItemResponse;
import com.zbkj.common.response.OrderInfoFrontDataResponse;
import com.zbkj.common.response.OrderInvoiceResponse;
import com.zbkj.common.response.PlatformOrderAdminDetailResponse;
import com.zbkj.common.response.PlatformOrderPageResponse;
import com.zbkj.common.response.bcx.BcxOrderRelationResponse;
import com.zbkj.common.response.bcx.BcxOrderSummaryInfo;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.common.vo.LogisticsResultVo;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.service.dao.OrderDao;
import com.zbkj.service.service.ExpressService;
import com.zbkj.service.service.LogisticService;
import com.zbkj.service.service.MerchantOrderService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OnePassService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderInvoiceDetailService;
import com.zbkj.service.service.OrderInvoiceService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.OrderStatusService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.SystemAdminService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.TemplateMessageService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserTokenService;
import com.zbkj.service.service.bcx.BcxOrderRelationService;
import com.zbkj.service.service.bcx.BcxPayOfflineFileService;
import com.zbkj.service.service.bcx.BcxPayOfflineService;
import com.zbkj.service.service.bcx.BcxPlatformFeeService;
import com.zbkj.service.service.impl.SystemNotificationServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class OrderServiceImpl
extends ServiceImpl<OrderDao, Order>
implements OrderService {
    @Resource
    private OrderDao dao;
    @Autowired
    private MerchantOrderService merchantOrderService;
    @Autowired
    private UserService userService;
    @Autowired
    private ProductService productService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private SystemAdminService systemAdminService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private OrderStatusService orderStatusService;
    @Autowired
    private ExpressService expressService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private OnePassService onePassService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private LogisticService logisticService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private OrderInvoiceService orderInvoiceService;
    @Autowired
    private OrderInvoiceDetailService orderInvoiceDetailService;
    @Autowired
    private UserTokenService userTokenService;
    @Autowired
    private TemplateMessageService templateMessageService;
    @Autowired
    private SystemNotificationServiceImpl systemNotificationService;
    @Resource
    private BcxOrderRelationService bcxOrderRelationService;
    @Resource
    BcxPlatformFeeService bcxPlatformFeeService;
    @Resource
    private BcxPayOfflineService bcxPayOfflineService;
    @Resource
    private BcxPayOfflineFileService bcxPayOfflineFileService;

    @Override
    public Order getByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getOrderNo, (Object)orderNo);
        lqw.last(" limit 1");
        Order order = (Order)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff1a" + orderNo);
        }
        return order;
    }

    @Override
    public Order findByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getOrderNo, (Object)orderNo);
        lqw.last(" limit 1");
        return (Order)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean updatePaid(String orderNo) {
        LambdaUpdateWrapper lqw = new LambdaUpdateWrapper();
        lqw.set(Order::getPaid, (Object)true);
        lqw.set(Order::getPayTime, (Object)DateUtil.date());
        lqw.set(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
        lqw.eq(Order::getOrderNo, (Object)orderNo);
        lqw.eq(Order::getPaid, (Object)false);
        return this.update((Wrapper)lqw);
    }

    @Override
    public Order getByOutTradeNo(String outTradeNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getOutTradeNo, (Object)outTradeNo);
        lqw.last(" limit 1");
        Order order = (Order)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        return order;
    }

    @Override
    public PageInfo<Order> getUserOrderList(Integer userId, Integer status, Integer bizType, Integer categoryId, Integer fapiaoStatus, PageParamRequest pageRequest) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getUid, (Object)userId);
        if (status >= 0) {
            if (status == 1) {
                lqw.in(Order::getStatus, new Object[]{OrderConstants.ORDER_STATUS_WAIT_SHIPPING, OrderConstants.ORDER_STATUS_PART_SHIPPING});
            } else {
                lqw.eq(Order::getStatus, (Object)status);
            }
        }
        if (bizType != null) {
            lqw.eq(Order::getBizType, (Object)bizType);
        }
        if (fapiaoStatus != null) {
            lqw.eq(Order::getFapiaoStatus, (Object)fapiaoStatus);
        }
        if (categoryId != null) {
            List productIds = ((QueryChainWrapper)this.productService.query().select(new String[]{"id"}).eq((Object)"category_id", (Object)categoryId)).list().stream().map(Product::getId).collect(Collectors.toList());
            if (CollUtil.isEmpty(productIds)) {
                return new PageInfo();
            }
            List orderNos = ((QueryChainWrapper)((QueryChainWrapper)this.orderDetailService.query().select(new String[]{"order_no"}).in((Object)"product_id", productIds)).eq((Object)"uid", (Object)userId)).list().stream().map(OrderDetail::getOrderNo).collect(Collectors.toList());
            if (CollUtil.isEmpty(orderNos)) {
                return new PageInfo();
            }
            lqw.in(Order::getOrderNo, orderNos);
        }
        lqw.lt(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
        lqw.eq(Order::getIsUserDel, (Object)false);
        lqw.eq(Order::getIsMerchantDel, (Object)false);
        lqw.in(Order::getType, new Object[]{OrderConstants.ORDER_TYPE_NORMAL, OrderConstants.ORDER_TYPE_SECKILL, OrderConstants.ORDER_TYPE_RISK});
        lqw.eq(Order::getIsDel, (Object)false);
        lqw.orderByDesc(Order::getId);
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        List orderList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)orderList);
    }

    @Override
    public Boolean cancel(String orderNo, Boolean isUser) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Order::getCancelStatus, (Object)(isUser != false ? OrderConstants.ORDER_CANCEL_STATUS_USER : OrderConstants.ORDER_CANCEL_STATUS_SYSTEM));
        wrapper.set(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_CANCEL);
        wrapper.eq(Order::getOrderNo, (Object)orderNo);
        wrapper.eq(Order::getPaid, (Object)false);
        wrapper.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_PAY);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PageInfo<MerchantOrderPageResponse> getMerchantAdminPageSql(OrderSearchRequest request, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        Map<String, Object> queryParam = OrderServiceImpl.concatQueryParam(request);
        return CommonPage.copyPageInfo((Page)page, this.dao.queryMerchantOrderList(queryParam));
    }

    @Override
    @Deprecated
    public PageInfo<MerchantOrderPageResponse> getMerchantAdminPage(OrderSearchRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Page startPage = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Order::getOrderNo, Order::getUid, Order::getPayPrice, Order::getPayType, Order::getPaid, Order::getStatus, Order::getRefundStatus, Order::getIsUserDel, Order::getCancelStatus, Order::getType, Order::getCreateTime, Order::getLevel, Order::getBizType});
        lqw.eq(Order::getMerId, (Object)systemAdmin.getMerId());
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            if (!NumberUtil.isInteger((String)request.getOrderNo())) {
                lqw.like(Order::getOrderNo, (Object)URLUtil.decode((String)request.getOrderNo()));
            } else {
                lqw.eq(Order::getBizType, (Object)request.getOrderNo());
            }
        }
        if (ObjectUtil.isNotNull((Object)request.getType())) {
            lqw.eq(Order::getType, (Object)request.getType());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            this.getRequestTimeWhere((LambdaQueryWrapper<Order>)lqw, request.getDateLimit());
        }
        this.getMerchantStatusWhere((LambdaQueryWrapper<Order>)lqw, request.getStatus());
        lqw.eq(Order::getIsMerchantDel, (Object)false);
        if ("unPaid".equals(request.getStatus())) {
            lqw.eq(Order::getLevel, (Object)OrderConstants.ORDER_LEVEL_PLATFORM);
        } else {
            lqw.eq(Order::getLevel, (Object)OrderConstants.ORDER_LEVEL_MERCHANT);
        }
        lqw.orderByDesc(Order::getId);
        List orderList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)orderList)) {
            return CommonPage.copyPageInfo((Page)startPage, (List)CollUtil.newArrayList((Object[])new MerchantOrderPageResponse[0]));
        }
        List<Integer> uidList = orderList.stream().map(Order::getUid).distinct().collect(Collectors.toList());
        Map<Integer, User> userMap = this.userService.getUidMapList(uidList);
        List pageResponses = orderList.stream().map(e -> {
            MerchantOrderPageResponse pageResponse = new MerchantOrderPageResponse();
            BeanUtils.copyProperties((Object)e, (Object)pageResponse);
            MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(e.getOrderNo());
            pageResponse.setShippingType(merchantOrder.getShippingType());
            pageResponse.setUserRemark(merchantOrder.getUserRemark());
            pageResponse.setMerRemark(merchantOrder.getMerchantRemark());
            User u = (User)userMap.get(e.getUid());
            pageResponse.setNickName(u != null ? u.getNickname() : "");
            pageResponse.setIsLogoff(Boolean.valueOf(u != null ? u.getIsLogoff() : true));
            return pageResponse;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)startPage, pageResponses);
    }

    @Override
    public OrderCountItemResponse getMerchantOrderStatusNum(String dateLimit) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        OrderCountItemResponse response = new OrderCountItemResponse();
        response.setAll(this.getCount(dateLimit, "all", systemAdmin.getMerId()));
        response.setUnPaid(this.getCount(dateLimit, "unPaid", systemAdmin.getMerId()));
        response.setNotShipped(this.getCount(dateLimit, "notShipped", systemAdmin.getMerId()));
        response.setSpike(this.getCount(dateLimit, "spike", systemAdmin.getMerId()));
        response.setReceiving(this.getCount(dateLimit, "receiving", systemAdmin.getMerId()));
        response.setComplete(this.getCount(dateLimit, "complete", systemAdmin.getMerId()));
        response.setRefunded(this.getCount(dateLimit, "refunded", systemAdmin.getMerId()));
        response.setDeleted(this.getCount(dateLimit, "deleted", systemAdmin.getMerId()));
        response.setVerification(this.getCount(dateLimit, "awaitVerification", systemAdmin.getMerId()));
        response.setCanceled(this.getCount(dateLimit, "canceled", systemAdmin.getMerId()));
        return response;
    }

    @Override
    public OrderAdminDetailResponse adminDetail(String orderNo) {
        BcxPayOffline offline;
        User user;
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Order order = this.getByOrderNo(orderNo);
        if (order.getIsMerchantDel().booleanValue() || !order.getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException("\u672a\u627e\u5230\u5bf9\u5e94\u8ba2\u5355\u4fe1\u606f");
        }
        OrderAdminDetailResponse orderAdminDetailResponse = new OrderAdminDetailResponse();
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(orderNo);
        BeanUtils.copyProperties((Object)merchantOrder, (Object)orderAdminDetailResponse);
        BeanUtils.copyProperties((Object)order, (Object)orderAdminDetailResponse);
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(orderNo);
        List orderInfoList = orderDetailList.stream().map(e -> {
            OrderInfoFrontDataResponse dataResponse = new OrderInfoFrontDataResponse();
            BeanUtils.copyProperties((Object)e, (Object)dataResponse);
            return dataResponse;
        }).collect(Collectors.toList());
        orderAdminDetailResponse.setOrderDetailList(orderInfoList);
        if (order.getBizType().equals(ProductConstants.BIZ_TYPE_RISK)) {
            boolean isPlatOrderNo = StrUtil.isBlank((CharSequence)order.getPlatOrderNo());
            String relateOrderNo = isPlatOrderNo ? order.getOrderNo() : order.getPlatOrderNo();
            List<BcxOrderRelationResponse> relations = this.bcxOrderRelationService.queryByOrderNo(relateOrderNo, isPlatOrderNo);
            orderAdminDetailResponse.setRelations(relations);
        }
        orderAdminDetailResponse.setNikeName((user = (User)this.userService.getById(order.getUid())) != null ? user.getNickname() : "");
        orderAdminDetailResponse.setPhone(user != null ? user.getPhone() : "");
        orderAdminDetailResponse.setIsLogoff(Boolean.valueOf(user != null ? user.getIsLogoff() : true));
        if (merchantOrder.getClerkId() > 0) {
            SystemAdmin clerkAdmin = (SystemAdmin)this.systemAdminService.getById(merchantOrder.getClerkId());
            orderAdminDetailResponse.setClerkName(clerkAdmin.getRealName());
        }
        if ((offline = this.bcxPayOfflineService.queryByOrderNo(orderNo)) != null) {
            orderAdminDetailResponse.setUserMsg(offline.getUserMsg());
            orderAdminDetailResponse.setMerMsg(offline.getMerMsg());
            List fileList = ((QueryChainWrapper)this.bcxPayOfflineFileService.query().eq((Object)"order_no", (Object)orderNo)).list();
            if (CollUtil.isNotEmpty((Collection)fileList)) {
                orderAdminDetailResponse.setFileList(fileList);
            }
        }
        return orderAdminDetailResponse;
    }

    @Override
    public Boolean send(OrderSendRequest request) {
        Order order;
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        if (request.getDeliveryType().equals("express")) {
            if (ObjectUtil.isNull((Object)request.getExpressRecordType())) {
                throw new CrmebException("\u8bf7\u9009\u62e9\u53d1\u8d27\u8bb0\u5f55\u7c7b\u578b");
            }
            this.validateExpressSend(request);
        }
        if (!(order = this.getByOrderNo(request.getOrderNo())).getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (order.getIsUserDel().booleanValue() || order.getIsMerchantDel().booleanValue()) {
            throw new CrmebException("\u8ba2\u5355\u5df2\u5220\u9664");
        }
        if (!order.getLevel().equals(OrderConstants.ORDER_LEVEL_MERCHANT)) {
            throw new CrmebException("\u8ba2\u5355\u7b49\u7ea7\u5f02\u5e38\uff0c\u4e0d\u662f\u5546\u6237\u8ba2\u5355");
        }
        if (!order.getStatus().equals(OrderConstants.ORDER_STATUS_WAIT_SHIPPING) && !order.getStatus().equals(OrderConstants.ORDER_STATUS_PART_SHIPPING)) {
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5904\u4e8e\u5f85\u53d1\u8d27\u72b6\u6001");
        }
        if (order.getRefundStatus().equals(OrderConstants.ORDER_REFUND_STATUS_ALL)) {
            throw new CrmebException("\u8ba2\u5355\u5df2\u9000\u6b3e\u65e0\u6cd5\u53d1\u8d27");
        }
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(request.getOrderNo());
        if (!merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_EXPRESS)) {
            throw new CrmebException("\u8ba2\u5355\u975e\u53d1\u8d27\u7c7b\u578b\u8ba2\u5355");
        }
        if (!request.getIsSplit().booleanValue()) {
            if (request.getDeliveryType().equals("fictitious")) {
                return this.virtual(order.getOrderNo());
            }
            if (request.getDeliveryType().equals("express")) {
                return this.sendExpress(request, order, merchantOrder);
            }
        }
        if (CollUtil.isEmpty((Collection)request.getDetailList())) {
            throw new CrmebException("\u62c6\u5355\u53d1\u8d27\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List detailRequestList = request.getDetailList();
        List detailIdList = detailRequestList.stream().map(SplitOrderSendDetailRequest::getOrderDetailId).distinct().collect(Collectors.toList());
        if (detailRequestList.size() != detailIdList.size()) {
            throw new CrmebException("\u6709\u91cd\u590d\u7684\u53d1\u8d27\u5355\u8be6\u60c5");
        }
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(request.getOrderNo());
        detailRequestList.forEach(detailRequest -> {
            if (detailRequest.getNum() < 1) {
                throw new CrmebException("\u8ba2\u5355\u8be6\u60c5\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e1");
            }
            OrderDetail orderDetail = orderDetailList.stream().filter(e -> e.getId().equals(detailRequest.getOrderDetailId())).findAny().orElse(null);
            if (ObjectUtil.isNull((Object)orderDetail)) {
                throw new CrmebException("\u8ba2\u5355\u8be6\u60c5ID\u4e0d\u5bf9\u5e94");
            }
            if (orderDetail.getPayNum() - orderDetail.getDeliveryNum() - orderDetail.getRefundNum() - detailRequest.getNum() < 0) {
                throw new CrmebException("\u8d85\u51fa\u53ef\u53d1\u8d27\u6570\u91cf,\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u91cf");
            }
        });
        return this.splitSendExpress(request, order, merchantOrder, orderDetailList);
    }

    @Override
    public Boolean merchantDeleteByOrderNo(String orderNo) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Order order = this.getByOrderNoAndMerId(orderNo, systemAdmin.getMerId());
        if (!order.getIsUserDel().booleanValue()) {
            throw new CrmebException("\u7528\u6237\u672a\u5220\u9664\u8ba2\u5355\u65f6\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        order.setIsMerchantDel(Boolean.valueOf(true));
        return this.updateById(order);
    }

    @Override
    public Boolean merchantMark(OrderRemarkRequest request) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Order order = this.getByOrderNoAndMerId(request.getOrderNo(), systemAdmin.getMerId());
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(order.getOrderNo());
        merchantOrder.setMerchantRemark(request.getRemark());
        return this.merchantOrderService.updateById(merchantOrder);
    }

    @Override
    public Boolean takeDelivery(String orderNo) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_TAKE_DELIVERY);
        wrapper.set(Order::getReceivingTime, (Object)DateUtil.date());
        wrapper.eq(Order::getOrderNo, (Object)orderNo);
        wrapper.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public BcxOrderSummaryInfo getPlatformSummaryOrderInfo(OrderSearchRequest request) {
        Map<String, Object> queryParam = OrderServiceImpl.concatQueryParam(request);
        return this.dao.queryPlatformOrderSummary(queryParam);
    }

    @Override
    public BcxOrderSummaryInfo getMerchantSummaryOrderInfo(OrderSearchRequest request) {
        Map<String, Object> queryParam = OrderServiceImpl.concatQueryParam(request);
        return this.dao.queryMerchantOrderSummary(queryParam);
    }

    @Override
    public PageInfo<PlatformOrderPageResponse> getPlatformAdminPageSql(OrderSearchRequest request, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        Map<String, Object> queryParam = OrderServiceImpl.concatQueryParam(request);
        return CommonPage.copyPageInfo((Page)page, this.dao.queryPlatformOrderList(queryParam));
    }

    private static Map<String, Object> concatQueryParam(OrderSearchRequest request) {
        HashMap<String, Object> queryParam = new HashMap<String, Object>(12);
        if (StrUtil.isNotEmpty((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimitUtilVo = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            queryParam.put("startTime", dateLimitUtilVo.getStartTime());
            queryParam.put("endTime", dateLimitUtilVo.getEndTime());
        }
        queryParam.put("merId", request.getMerId());
        queryParam.put("orderNo", request.getOrderNo());
        queryParam.put("payType", request.getPayType());
        queryParam.put("type", request.getType());
        queryParam.put("status", request.getStatus());
        queryParam.put("productName", request.getProductName());
        queryParam.put("userName", request.getUserName());
        queryParam.put("memberName", request.getMemberName());
        queryParam.put("insuranceType", request.getInsuranceType());
        queryParam.put("categoryId", request.getCategoryId());
        return queryParam;
    }

    @Override
    @Deprecated
    public PageInfo<PlatformOrderPageResponse> getPlatformAdminPage(OrderSearchRequest request, PageParamRequest pageParamRequest) {
        Page startPage = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            lqw.eq(Order::getMerId, (Object)request.getMerId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            lqw.like(Order::getOrderNo, (Object)URLUtil.decode((String)request.getOrderNo()));
        }
        if (ObjectUtil.isNotNull((Object)request.getType())) {
            lqw.eq(Order::getType, (Object)request.getType());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getDateLimit())) {
            this.getRequestTimeWhere((LambdaQueryWrapper<Order>)lqw, request.getDateLimit());
        }
        this.getMerchantStatusWhere((LambdaQueryWrapper<Order>)lqw, request.getStatus());
        lqw.orderByDesc(Order::getId);
        List orderList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)orderList)) {
            return CommonPage.copyPageInfo((Page)startPage, (List)CollUtil.newArrayList((Object[])new PlatformOrderPageResponse[0]));
        }
        List<Integer> uidList = orderList.stream().map(Order::getUid).distinct().collect(Collectors.toList());
        Map<Integer, User> userMap = this.userService.getUidMapList(uidList);
        List<Integer> merIdList = orderList.stream().map(Order::getMerId).distinct().collect(Collectors.toList());
        Map<Integer, Merchant> merchantMap = this.merchantService.getMerIdMapByIdList(merIdList);
        List pageResponses = orderList.stream().map(e -> {
            PlatformOrderPageResponse pageResponse = new PlatformOrderPageResponse();
            BeanUtils.copyProperties((Object)e, (Object)pageResponse);
            MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(e.getOrderNo());
            pageResponse.setShippingType(merchantOrder.getShippingType());
            pageResponse.setUserRemark(merchantOrder.getUserRemark());
            pageResponse.setMerRemark(merchantOrder.getMerchantRemark());
            User u = (User)userMap.get(e.getUid());
            pageResponse.setNickName(u != null ? u.getNickname() : "");
            pageResponse.setIsLogoff(Boolean.valueOf(u != null ? u.getIsLogoff() : true));
            if (e.getMerId() > 0) {
                Merchant m = (Merchant)merchantMap.get(e.getMerId());
                pageResponse.setMerName(m != null ? m.getName() : "");
            }
            return pageResponse;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)startPage, pageResponses);
    }

    @Override
    public OrderCountItemResponse getPlatformOrderStatusNum(String dateLimit) {
        OrderCountItemResponse response = new OrderCountItemResponse();
        response.setAll(this.getCount(dateLimit, "all", 0));
        response.setUnPaid(this.getCount(dateLimit, "unPaid", 0));
        response.setNotShipped(this.getCount(dateLimit, "notShipped", 0));
        response.setSpike(this.getCount(dateLimit, "spike", 0));
        response.setReceiving(this.getCount(dateLimit, "receiving", 0));
        response.setComplete(this.getCount(dateLimit, "complete", 0));
        response.setRefunded(this.getCount(dateLimit, "refunded", 0));
        response.setDeleted(this.getCount(dateLimit, "deleted", 0));
        response.setVerification(this.getCount(dateLimit, "awaitVerification", 0));
        response.setCanceled(this.getCount(dateLimit, "canceled", 0));
        return response;
    }

    @Override
    public PlatformOrderAdminDetailResponse platformInfo(String orderNo) {
        User user;
        Order order = this.getByOrderNo(orderNo);
        PlatformOrderAdminDetailResponse response = new PlatformOrderAdminDetailResponse();
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(orderNo);
        BeanUtils.copyProperties((Object)merchantOrder, (Object)response);
        BeanUtils.copyProperties((Object)order, (Object)response);
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(orderNo);
        List orderInfoList = orderDetailList.stream().map(e -> {
            OrderInfoFrontDataResponse dataResponse = new OrderInfoFrontDataResponse();
            BeanUtils.copyProperties((Object)e, (Object)dataResponse);
            return dataResponse;
        }).collect(Collectors.toList());
        response.setOrderDetailList(orderInfoList);
        if (order.getBizType().equals(ProductConstants.BIZ_TYPE_RISK)) {
            boolean isPlatOrderNo = StrUtil.isBlank((CharSequence)order.getPlatOrderNo());
            String relateOrderNo = isPlatOrderNo ? order.getOrderNo() : order.getPlatOrderNo();
            List<BcxOrderRelationResponse> relations = this.bcxOrderRelationService.queryByOrderNo(relateOrderNo, isPlatOrderNo);
            response.setRelations(relations);
        }
        response.setNikeName((user = (User)this.userService.getById(order.getUid())) != null ? user.getNickname() : "");
        response.setPhone(user != null ? user.getPhone() : "");
        response.setIsLogoff(Boolean.valueOf(user != null ? user.getIsLogoff() : true));
        if (merchantOrder.getClerkId() > 0) {
            SystemAdmin clerkAdmin = (SystemAdmin)this.systemAdminService.getById(merchantOrder.getClerkId());
            response.setClerkName(clerkAdmin.getRealName());
        }
        if (order.getMerId() > 0) {
            Merchant merchant = (Merchant)this.merchantService.getById(order.getMerId());
            response.setMerName(merchant.getName());
            response.setMerIsSelf(merchant.getIsSelf());
        }
        return response;
    }

    @Override
    public LogisticsResultVo getLogisticsInfo(Integer invoiceId) {
        OrderInvoice orderInvoice = (OrderInvoice)this.orderInvoiceService.getById(invoiceId);
        if (ObjectUtil.isNull((Object)orderInvoice)) {
            throw new CrmebException("\u53d1\u8d27\u5355\u4e0d\u5b58\u5728");
        }
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(orderInvoice.getOrderNo());
        return this.logisticService.info(orderInvoice.getTrackingNumber(), null, Optional.ofNullable(orderInvoice.getExpressCode()).orElse(""), merchantOrder.getUserPhone());
    }

    @Override
    public Boolean verificationOrderByCode(String verifyCode) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByVerifyCode(verifyCode);
        if (ObjectUtil.isNull((Object)merchantOrder)) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6838\u9500\u7801");
        }
        Order order = this.getByOrderNo(merchantOrder.getOrderNo());
        if (!admin.getMerId().equals(order.getMerId())) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6838\u9500\u7801");
        }
        if (!order.getStatus().equals(OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION)) {
            throw new CrmebException("\u8ba2\u5355\u5df2\u6838\u9500");
        }
        order.setStatus(OrderConstants.ORDER_STATUS_TAKE_DELIVERY);
        order.setReceivingTime((Date)DateUtil.date());
        merchantOrder.setClerkId(admin.getId());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(order);
            this.orderDetailService.takeDelivery(order.getOrderNo());
            this.merchantOrderService.updateById(merchantOrder);
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.redisUtil.lPush("alterOrderTakeByUser", (Object)order.getOrderNo());
        }
        return execute;
    }

    @Override
    public Integer getOrderProductNumByDate(String date) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"IFNULL(sum(total_num), 0) as total_num"});
        wrapper.eq((Object)"is_del", (Object)0);
        wrapper.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        Order order = (Order)this.dao.selectOne((Wrapper)wrapper);
        return order.getTotalNum();
    }

    @Override
    public Integer getOrderSuccessProductNumByDate(String date) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"IFNULL(sum(total_num), 0) as total_num"});
        wrapper.eq((Object)"paid", (Object)1);
        wrapper.eq((Object)"is_del", (Object)0);
        wrapper.apply("date_format(pay_time, '%Y-%m-%d') = {0}", new Object[]{date});
        Order order = (Order)this.dao.selectOne((Wrapper)wrapper);
        return order.getTotalNum();
    }

    @Override
    public Integer getOrderNumByDate(Integer merId, String date) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"id"});
        if (merId > 0) {
            wrapper.eq((Object)"mer_id", (Object)merId);
        }
        wrapper.eq((Object)"is_del", (Object)0);
        wrapper.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectCount((Wrapper)wrapper);
    }

    @Override
    public BigDecimal getPayOrderAmountByDate(Integer merId, String date) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"pay_price"});
        wrapper.eq((Object)"paid", (Object)1);
        if (merId > 0) {
            wrapper.eq((Object)"mer_id", (Object)merId);
        }
        wrapper.eq((Object)"is_del", (Object)false);
        wrapper.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        List orderList = this.dao.selectList((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)orderList)) {
            return BigDecimal.ZERO;
        }
        return orderList.stream().map(Order::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public List<OrderDetail> getDetailList(String orderNo) {
        this.getByOrderNo(orderNo);
        return this.orderDetailService.getShipmentByOrderNo(orderNo);
    }

    @Override
    public List<OrderInvoiceResponse> getInvoiceList(String orderNo) {
        return this.orderInvoiceService.findByOrderNo(orderNo);
    }

    @Override
    public List<Order> findCanCompleteOrder(Integer autoCompleteDay) {
        DateTime autoCompleteDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)(-autoCompleteDay.intValue()));
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Order::getId, Order::getUid, Order::getOrderNo});
        lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_TAKE_DELIVERY);
        lqw.eq(Order::getLevel, (Object)OrderConstants.ORDER_LEVEL_MERCHANT);
        lqw.le(Order::getReceivingTime, (Object)autoCompleteDate);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean batchCompleteByOrderNo(List<String> orderNoList) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_COMPLETE);
        wrapper.in(Order::getOrderNo, orderNoList);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean completeByOrderNo(String orderNo) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_COMPLETE);
        wrapper.eq(Order::getOrderNo, (Object)orderNo);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Integer getCountByStatusAndUid(Integer status, Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getUid, (Object)userId);
        lqw.eq(Order::getIsDel, (Object)false);
        if (OrderConstants.ORDER_STATUS_WAIT_SHIPPING.equals(status)) {
            lqw.in(Order::getStatus, new Object[]{OrderConstants.ORDER_STATUS_WAIT_SHIPPING, OrderConstants.ORDER_STATUS_PART_SHIPPING});
        } else if (status >= 0) {
            lqw.eq(Order::getStatus, (Object)status);
        }
        lqw.eq(Order::getIsUserDel, (Object)false);
        lqw.eq(Order::getIsMerchantDel, (Object)false);
        lqw.ne(Order::getRefundStatus, (Object)OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Integer getPayOrderNumByDate(String date) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"id"});
        wrapper.eq((Object)"paid", (Object)1);
        wrapper.eq((Object)"is_del", (Object)0);
        wrapper.apply("date_format(pay_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectCount((Wrapper)wrapper);
    }

    @Override
    public BigDecimal getSpreadOrderTotalPriceByOrderList(List<String> orderNoList) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{Order::getPayPrice});
        lqw.in(Order::getOrderNo, orderNoList);
        List orderList = this.dao.selectList((Wrapper)lqw);
        return orderList.stream().map(Order::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public Boolean paySplitDelete(String orderNo) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Order::getIsDel, (Object)true);
        wrapper.eq(Order::getOrderNo, (Object)orderNo);
        wrapper.eq(Order::getIsDel, (Object)false);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<Order> getByPlatOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getPlatOrderNo, (Object)orderNo);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean isExistPendingOrderByUid(Integer uid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Order::getId});
        lqw.eq(Order::getUid, (Object)uid);
        lqw.eq(Order::getIsDel, (Object)0);
        lqw.in(Order::getStatus, new Object[]{OrderConstants.ORDER_STATUS_WAIT_SHIPPING, OrderConstants.ORDER_STATUS_PART_SHIPPING, OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION});
        lqw.ne(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
        lqw.last(" limit 1");
        Order order = (Order)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)order);
    }

    @Override
    public List<Order> findAwaitTakeDeliveryOrderList(String sendTime) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
        lqw.ne(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
        lqw.le(Order::getUpdateTime, (Object)sendTime);
        lqw.eq(Order::getIsDel, (Object)false);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Integer getNotShippingNum(Integer merId) {
        return this.getCount("", "notShipped", merId);
    }

    @Override
    public Integer getAwaitVerificationNum(Integer merId) {
        return this.getCount("", "awaitVerification", merId);
    }

    @Override
    public Integer getProductNumCount(Integer uid, Integer proId, Integer productType) {
        return this.dao.getProductNumCount(uid, proId, productType);
    }

    @Override
    public List<Order> findPayByDate(Integer merId, String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (merId > 0) {
            lqw.eq(Order::getMerId, (Object)merId);
        }
        lqw.eq(Order::getPaid, (Object)1);
        lqw.ne(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_PAY);
        lqw.eq(Order::getIsDel, (Object)0);
        lqw.apply("date_format(pay_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<Order> findExportList(OrderSearchRequest request) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            lqw.eq(Order::getMerId, (Object)request.getMerId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            lqw.like(Order::getOrderNo, (Object)URLUtil.decode((String)request.getOrderNo()));
        }
        if (ObjectUtil.isNotNull((Object)request.getType())) {
            lqw.eq(Order::getType, (Object)request.getType());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getDateLimit())) {
            this.getRequestTimeWhere((LambdaQueryWrapper<Order>)lqw, request.getDateLimit());
        }
        this.getMerchantStatusWhere((LambdaQueryWrapper<Order>)lqw, request.getStatus());
        lqw.orderByDesc(Order::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    private Order getByOrderNoAndMerId(String orderNo, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getOrderNo, (Object)orderNo);
        lqw.eq(Order::getMerId, (Object)merId);
        lqw.last(" limit 1");
        Order order = (Order)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        return order;
    }

    private Boolean splitSendExpress(OrderSendRequest request, Order order, MerchantOrder merchantOrder, List<OrderDetail> orderDetailList) {
        Express express = this.expressService.getByCode(request.getExpressCode());
        if (ObjectUtil.isNull((Object)express)) {
            throw new CrmebException("\u672a\u627e\u5230\u5feb\u9012\u516c\u53f8");
        }
        List detailRequestList = request.getDetailList();
        ArrayList orderInvoiceDetailList = new ArrayList();
        ArrayList orderDetailUpdateList = new ArrayList();
        detailRequestList.forEach(detail -> {
            OrderDetail orderDetail = orderDetailList.stream().filter(e -> e.getId().equals(detail.getOrderDetailId())).findAny().orElse(null);
            orderDetail.setDeliveryNum(Integer.valueOf(orderDetail.getDeliveryNum() + detail.getNum()));
            OrderInvoiceDetail invoiceDetail = new OrderInvoiceDetail();
            BeanUtils.copyProperties((Object)orderDetail, (Object)invoiceDetail);
            invoiceDetail.setNum(detail.getNum());
            invoiceDetail.setCreateTime((Date)DateUtil.date());
            invoiceDetail.setUpdateTime((Date)DateUtil.date());
            orderInvoiceDetailList.add(invoiceDetail);
            orderDetailUpdateList.add(orderDetail);
        });
        String trackingNumber = request.getExpressNumber();
        if (request.getExpressRecordType().equals(2)) {
            List productNameList = orderInvoiceDetailList.stream().map(OrderInvoiceDetail::getProductName).collect(Collectors.toList());
            String cargo = String.join((CharSequence)",", productNameList);
            trackingNumber = this.expressDump(request, merchantOrder, express, cargo);
        }
        OrderInvoice invoice = new OrderInvoice();
        invoice.setMerId(order.getMerId());
        invoice.setOrderNo(order.getOrderNo());
        invoice.setUid(order.getUid());
        invoice.setExpressCode(express.getCode());
        invoice.setExpressName(express.getName());
        invoice.setTrackingNumber(trackingNumber);
        invoice.setTotalNum(Integer.valueOf(orderInvoiceDetailList.stream().mapToInt(OrderInvoiceDetail::getNum).sum()));
        merchantOrder.setDeliveryType("express");
        merchantOrder.setLastDeliveryTime((Date)DateUtil.date());
        order.setStatus(OrderConstants.ORDER_STATUS_PART_SHIPPING);
        String message = "\u5df2\u53d1\u8d27 \u5feb\u9012\u516c\u53f8\uff1a{deliveryName}, \u5feb\u9012\u5355\u53f7\uff1a{deliveryCode}".replace("{deliveryName}", express.getName()).replace("{deliveryCode}", trackingNumber);
        Boolean execute = (Boolean)this.transactionTemplate.execute(i -> {
            this.updateById(order);
            this.merchantOrderService.updateById(merchantOrder);
            this.orderDetailService.updateBatchById(orderDetailUpdateList);
            this.orderInvoiceService.save(invoice);
            orderInvoiceDetailList.forEach(e -> e.setInvoiceId(invoice.getId()));
            this.orderInvoiceDetailService.saveBatch(orderInvoiceDetailList);
            this.orderStatusService.createLog(order.getOrderNo(), "express_split_old", message);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u5feb\u9012\u62c6\u5355\u53d1\u8d27\u5931\u8d25\uff01");
        }
        List<OrderDetail> detailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        long count = detailList.stream().filter(e -> e.getPayNum() - e.getDeliveryNum() > 0).count();
        if (count <= 0L) {
            order.setStatus(OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
            this.updateById(order);
        }
        SystemNotification payNotification = this.systemNotificationService.getByMark("deliverGoods");
        this.pushMessageOrder(order, payNotification, invoice);
        return execute;
    }

    private Boolean sendExpress(OrderSendRequest request, Order order, MerchantOrder merchantOrder) {
        Express express = this.expressService.getByCode(request.getExpressCode());
        if (ObjectUtil.isNull((Object)express)) {
            throw new CrmebException("\u672a\u627e\u5230\u5feb\u9012\u516c\u53f8");
        }
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        ArrayList orderInvoiceDetailList = new ArrayList();
        ArrayList orderDetailUpdateList = new ArrayList();
        orderDetailList.forEach(od -> {
            if (od.getPayNum() > od.getDeliveryNum()) {
                OrderInvoiceDetail invoiceDetail = new OrderInvoiceDetail();
                BeanUtils.copyProperties((Object)od, (Object)invoiceDetail);
                invoiceDetail.setNum(Integer.valueOf(od.getPayNum() - od.getDeliveryNum()));
                invoiceDetail.setCreateTime((Date)DateUtil.date());
                invoiceDetail.setUpdateTime((Date)DateUtil.date());
                orderInvoiceDetailList.add(invoiceDetail);
                od.setDeliveryNum(od.getPayNum());
                orderDetailUpdateList.add(od);
            }
        });
        if (CollUtil.isEmpty(orderInvoiceDetailList)) {
            throw new CrmebException("\u8ba2\u5355\u6ca1\u6709\u9700\u8981\u53d1\u8d27\u7684\u5546\u54c1");
        }
        String trackingNumber = request.getExpressNumber();
        if (request.getExpressRecordType().equals(2)) {
            List productNameList = orderInvoiceDetailList.stream().map(OrderInvoiceDetail::getProductName).collect(Collectors.toList());
            String cargo = String.join((CharSequence)",", productNameList);
            trackingNumber = this.expressDump(request, merchantOrder, express, cargo);
        }
        OrderInvoice invoice = new OrderInvoice();
        invoice.setMerId(order.getMerId());
        invoice.setOrderNo(order.getOrderNo());
        invoice.setUid(order.getUid());
        invoice.setExpressCode(express.getCode());
        invoice.setExpressName(express.getName());
        invoice.setTrackingNumber(trackingNumber);
        invoice.setTotalNum(Integer.valueOf(orderInvoiceDetailList.stream().mapToInt(OrderInvoiceDetail::getNum).sum()));
        merchantOrder.setDeliveryType("express");
        order.setStatus(OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
        String message = "\u5df2\u53d1\u8d27 \u5feb\u9012\u516c\u53f8\uff1a{deliveryName}, \u5feb\u9012\u5355\u53f7\uff1a{deliveryCode}".replace("{deliveryName}", express.getName()).replace("{deliveryCode}", trackingNumber);
        Boolean execute = (Boolean)this.transactionTemplate.execute(i -> {
            this.updateById(order);
            this.merchantOrderService.updateById(merchantOrder);
            this.orderDetailService.updateBatchById(orderDetailUpdateList);
            this.orderInvoiceService.save(invoice);
            orderInvoiceDetailList.forEach(e -> e.setInvoiceId(invoice.getId()));
            this.orderInvoiceDetailService.saveBatch(orderInvoiceDetailList);
            this.orderStatusService.createLog(request.getOrderNo(), "express", message);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u5feb\u9012\u53d1\u8d27\u5931\u8d25\uff01");
        }
        SystemNotification payNotification = this.systemNotificationService.getByMark("deliverGoods");
        this.pushMessageOrder(order, payNotification, invoice);
        return execute;
    }

    private String expressDump(OrderSendRequest request, MerchantOrder merchantOrder, Express express, String cargo) {
        String configExportOpen = this.systemConfigService.getValueByKeyException("config_export_open");
        if (!configExportOpen.equals("1")) {
            throw new CrmebException("\u8bf7\u5148\u5f00\u542f\u7535\u5b50\u9762\u5355");
        }
        MyRecord record = new MyRecord();
        record.set("com", (Object)express.getCode());
        record.set("to_name", (Object)merchantOrder.getRealName());
        record.set("to_tel", (Object)merchantOrder.getUserPhone());
        record.set("to_addr", (Object)merchantOrder.getUserAddress());
        record.set("from_name", (Object)request.getToName());
        record.set("from_tel", (Object)request.getToTel());
        record.set("from_addr", (Object)request.getToAddr());
        record.set("temp_id", (Object)request.getExpressTempId());
        String siid = this.systemConfigService.getValueByKeyException("config_export_siid");
        record.set("siid", (Object)siid);
        record.set("count", (Object)merchantOrder.getTotalNum());
        if (StrUtil.isBlank((CharSequence)cargo)) {
            List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(merchantOrder.getOrderNo());
            List productNameList = orderDetailList.stream().map(OrderDetail::getProductName).collect(Collectors.toList());
            record.set("cargo", (Object)String.join((CharSequence)",", productNameList));
        } else {
            record.set("cargo", (Object)cargo);
        }
        if (express.getPartnerId().booleanValue()) {
            record.set("partner_id", (Object)express.getAccount());
        }
        if (express.getPartnerKey().booleanValue()) {
            record.set("partner_key", (Object)express.getPassword());
        }
        if (express.getNet().booleanValue()) {
            record.set("net", (Object)express.getNetName());
        }
        MyRecord myRecord = this.onePassService.expressDump(record);
        return myRecord.getStr("kuaidinum");
    }

    private Boolean virtual(String orderNo) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
        wrapper.eq(Order::getOrderNo, (Object)orderNo);
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.update((Wrapper)wrapper);
            this.merchantOrderService.virtual(orderNo);
            this.orderStatusService.createLog(orderNo, "delivery_fictitious", "\u865a\u62df\u53d1\u8d27");
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u865a\u62df\u53d1\u8d27\u5931\u8d25");
        }
        return execute;
    }

    private void validateExpressSend(OrderSendRequest request) {
        if (request.getExpressRecordType().equals(1)) {
            if (StrUtil.isBlank((CharSequence)request.getExpressNumber())) {
                throw new CrmebException("\u8bf7\u586b\u5199\u5feb\u9012\u5355\u53f7");
            }
            return;
        }
        if (StrUtil.isBlank((CharSequence)request.getExpressCode())) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u5feb\u9012\u516c\u53f8");
        }
        if (StrUtil.isBlank((CharSequence)request.getExpressTempId())) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u7535\u5b50\u9762\u5355");
        }
        if (StrUtil.isBlank((CharSequence)request.getToName())) {
            throw new CrmebException("\u8bf7\u586b\u5199\u5bc4\u4ef6\u4eba\u59d3\u540d");
        }
        if (StrUtil.isBlank((CharSequence)request.getToTel())) {
            throw new CrmebException("\u8bf7\u586b\u5199\u5bc4\u4ef6\u4eba\u7535\u8bdd");
        }
        if (StrUtil.isBlank((CharSequence)request.getToAddr())) {
            throw new CrmebException("\u8bf7\u586b\u5199\u5bc4\u4ef6\u4eba\u5730\u5740");
        }
    }

    private Integer getCount(String dateLimit, String status, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (merId > 0) {
            lqw.eq(Order::getMerId, (Object)merId);
            lqw.eq(Order::getIsMerchantDel, (Object)false);
        }
        if (StrUtil.isNotBlank((CharSequence)dateLimit)) {
            this.getRequestTimeWhere((LambdaQueryWrapper<Order>)lqw, dateLimit);
        }
        this.getMerchantStatusWhere((LambdaQueryWrapper<Order>)lqw, status);
        return this.dao.selectCount((Wrapper)lqw);
    }

    private void getMerchantStatusWhere(LambdaQueryWrapper<Order> lqw, String status) {
        if (StrUtil.isBlank((CharSequence)status)) {
            return;
        }
        switch (status) {
            case "all": {
                break;
            }
            case "unPaid": {
                lqw.eq(Order::getPaid, (Object)false);
                lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_PAY);
                lqw.eq(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
                lqw.eq(Order::getIsUserDel, (Object)false);
                break;
            }
            case "notShipped": {
                lqw.in(Order::getStatus, new Object[]{OrderConstants.ORDER_STATUS_WAIT_SHIPPING, OrderConstants.ORDER_STATUS_PART_SHIPPING});
                lqw.eq(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
                lqw.ne(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
                lqw.eq(Order::getIsUserDel, (Object)false);
                break;
            }
            case "spike": {
                lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
                lqw.eq(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
                lqw.ne(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
                lqw.eq(Order::getIsUserDel, (Object)false);
                break;
            }
            case "receiving": {
                lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_TAKE_DELIVERY);
                lqw.eq(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
                lqw.ne(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
                lqw.eq(Order::getIsUserDel, (Object)false);
                break;
            }
            case "complete": {
                lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_COMPLETE);
                lqw.eq(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
                lqw.ne(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
                lqw.eq(Order::getIsUserDel, (Object)false);
                break;
            }
            case "awaitVerification": {
                lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION);
                lqw.eq(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
                lqw.ne(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
                lqw.eq(Order::getIsUserDel, (Object)false);
                break;
            }
            case "refunded": {
                lqw.eq(Order::getPaid, (Object)true);
                lqw.eq(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
                lqw.eq(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
                lqw.eq(Order::getIsUserDel, (Object)false);
                break;
            }
            case "deleted": {
                lqw.eq(Order::getIsUserDel, (Object)true);
                break;
            }
            case "canceled": {
                lqw.ne(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
            }
        }
        lqw.eq(Order::getIsDel, (Object)false);
    }

    private void getRequestTimeWhere(LambdaQueryWrapper<Order> lqw, String dateLimit) {
        DateLimitUtilVo dateLimitUtilVo = CrmebDateUtil.getDateLimit((String)dateLimit);
        lqw.between(Order::getCreateTime, (Object)dateLimitUtilVo.getStartTime(), (Object)dateLimitUtilVo.getEndTime());
    }

    private void pushMessageOrder(Order order, SystemNotification notification, OrderInvoice invoice) {
        if (!order.getPayType().equals("weixin")) {
            return;
        }
        if (order.getPayChannel().equals("h5")) {
            return;
        }
        HashMap<String, String> temMap = new HashMap<String, String>();
        if (order.getPayChannel().equals("public") && notification.getIsWechat().equals(1)) {
            UserToken userToken = this.userTokenService.getTokenByUserId(order.getUid(), UserConstants.USER_TOKEN_TYPE_WECHAT);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            temMap.put("first", "\u8ba2\u5355\u53d1\u8d27\u63d0\u9192");
            temMap.put("keyword1", order.getOrderNo());
            temMap.put("keyword2", invoice.getExpressName());
            temMap.put("keyword3", invoice.getExpressCode());
            temMap.put("remark", "\u6b22\u8fce\u518d\u6b21\u8d2d\u4e70\uff01");
            this.templateMessageService.pushTemplateMessage(notification.getWechatId(), temMap, userToken.getToken());
            return;
        }
        if (order.getPayChannel().equals("mini") && notification.getIsRoutine().equals(1)) {
            UserToken userToken = this.userTokenService.getTokenByUserId(order.getUid(), UserConstants.USER_TOKEN_TYPE_ROUTINE);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            temMap.put("character_string7", order.getOrderNo());
            temMap.put("thing1", invoice.getExpressName());
            temMap.put("character_string2", invoice.getExpressCode());
            temMap.put("thing11", "\u60a8\u7684\u8ba2\u5355\u5df2\u53d1\u8d27");
            this.templateMessageService.pushMiniTemplateMessage(notification.getRoutineId(), temMap, userToken.getToken());
        }
    }

    @Override
    public Integer getBizTypeByProductsType(List<Integer> productIds) {
        Map<Integer, Product> productMap = this.productService.getMapByIdList(productIds);
        List types = productMap.values().stream().map(p -> p.getBizType() != null ? p.getBizType() : 0).distinct().collect(Collectors.toList());
        if (types.size() > 1) {
            throw new CrmebException("\u4e00\u4e2a\u8ba2\u5355\u5185\u53ea\u80fd\u6709\u4e00\u79cd\u7c7b\u578b\u7684\u5546\u54c1(\u5b9e\u4f53/\u865a\u62df/\u7279\u6b8a/\u4fdd\u9669)");
        }
        List merIds = productMap.values().stream().map(Product::getMerId).distinct().collect(Collectors.toList());
        if (merIds.size() > 1) {
            throw new CrmebException("B2B\u4e00\u4e2a\u8ba2\u5355\u4e0d\u80fd\u5305\u542b\u591a\u5bb6\u5546\u6237\u7684\u5546\u54c1");
        }
        return (Integer)types.get(0);
    }

    @Override
    public boolean modifyPrice(OrderModifyPriceRequest request) {
        Order order = this.getByOrderNo(request.getOrderNo());
        if (!order.getBizType().equals(ProductConstants.BIZ_TYPE_RISK) && !order.getBizType().equals(ProductConstants.BIZ_TYPE_VIRTUAL)) {
            throw new CrmebException("\u6682\u53ea\u652f\u6301\u865a\u62df\u5546\u54c1\u8ba2\u5355/\u98ce\u8bc4\u8ba2\u5355\u6539\u4ef7");
        }
        if (order.getPaid().booleanValue()) {
            throw new CrmebException("\u5df2\u652f\u4ed8\u4e0d\u80fd\u6539\u4ef7");
        }
        List<OrderDetail> orderDetails = this.orderDetailService.getByOrderNo(request.getOrderNo());
        if (orderDetails.size() > 1) {
            throw new CrmebException("\u6682\u4e0d\u652f\u6301\u591a\u4e2a\u5546\u54c1\u660e\u7ec6\u7684\u8ba2\u5355\u6539\u4ef7");
        }
        @NotNull(message="\u4fee\u6539\u7684\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a") BigDecimal newPrice = request.getNewPrice();
        if (newPrice != null && newPrice.compareTo(BigDecimal.ZERO) > 0) {
            String feeChangeMsg;
            BigDecimal oldPrice = order.getPayPrice();
            BigDecimal ratio = newPrice.divide(oldPrice, 8, RoundingMode.CEILING);
            String priceChangeMsg = "\u5b9e\u9645\u652f\u4ed8\u4ef7\u683c\u4ece" + oldPrice + "\u4fee\u6539\u6210" + newPrice;
            order.setPayPrice(newPrice);
            String totalPriceChangeMsg = "\u603b\u4ef7\u683c\u4ece" + order.getTotalPrice() + "\u4fee\u6539\u6210" + newPrice;
            order.setTotalPrice(newPrice);
            OrderDetail orderDetail = orderDetails.get(0);
            orderDetail.setPayPrice(newPrice);
            BigDecimal newPlatFee = Optional.ofNullable(order.getPlatFee()).orElse(BigDecimal.ZERO).multiply(ratio).setScale(2, 2);
            BcxPlatformFee bcxPlatformFee = this.bcxPlatformFeeService.queryByOrderNo(order.getOrderNo(), 0);
            BcxPlatformFeeConfig feeConfig = (BcxPlatformFeeConfig)JSONObject.parseObject((String)bcxPlatformFee.getConfig(), BcxPlatformFeeConfig.class);
            if (feeConfig.getSellFeeType() == 0) {
                feeChangeMsg = "\u5e73\u53f0\u670d\u52a1\u8d39\u4ece" + order.getPlatFee() + "\u4fee\u6539\u6210" + newPlatFee;
                order.setPlatFee(newPlatFee);
                orderDetail.setPlatFee(newPlatFee);
                bcxPlatformFee.setPlatFee(newPlatFee);
            } else {
                feeChangeMsg = "\u5e73\u53f0\u670d\u52a1\u8d39\u662f\u56fa\u5b9a\u91d1\u989d" + order.getPlatFee() + "\uff0c\u6ca1\u6709\u8ddf\u968f\u6539\u4ef7\u53d8\u5316";
            }
            Boolean result = (Boolean)this.transactionTemplate.execute(e -> {
                this.updateById(order);
                this.orderDetailService.updateById(orderDetail);
                this.bcxPlatformFeeService.updateById(bcxPlatformFee);
                this.orderStatusService.createLog(order.getOrderNo(), "modify_price", priceChangeMsg);
                this.orderStatusService.createLog(order.getOrderNo(), "modify_price", totalPriceChangeMsg);
                this.orderStatusService.createLog(order.getOrderNo(), "modify_price", feeChangeMsg);
                return true;
            });
            return Boolean.TRUE.equals(result);
        }
        return false;
    }

    @Override
    public Map<String, Order> getMapByOrderNoList(List<String> orderNoList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(Order::getOrderNo, orderNoList);
        List orderList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)orderList)) {
            return null;
        }
        return orderList.stream().distinct().collect(Collectors.toMap(Order::getOrderNo, Function.identity(), (o, n) -> o));
    }

    @Override
    public void writeFapiaoSuccess(List<String> orderNoList) {
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.set(Order::getFapiaoStatus, (Object)1);
        luw.in(Order::getOrderNo, orderNoList);
        this.dao.update(null, (Wrapper)luw);
    }

    @Override
    public List<Order> testAllOrderNo() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getBizType, (Object)2);
        lqw.eq(Order::getStatus, (Object)4);
        lqw.eq(Order::getPaid, (Object)true);
        lqw.eq(Order::getIsDel, (Object)false);
        lqw.eq(Order::getLevel, (Object)1);
        DateTime dateTime = DateUtil.parseDateTime((String)"2023-11-15 00:00:00");
        lqw.gt(Order::getPayTime, (Object)dateTime.toString());
        return this.dao.selectList((Wrapper)lqw);
    }
}

