/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.ShippingTemplatesConstants;
import com.zbkj.common.enums.RoleEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.bcx.BcxPlatformFeeConfig;
import com.zbkj.common.model.bill.MerchantDailyStatement;
import com.zbkj.common.model.bill.MerchantMonthStatement;
import com.zbkj.common.model.express.ShippingTemplates;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.merchant.MerchantApply;
import com.zbkj.common.model.merchant.MerchantCategory;
import com.zbkj.common.model.merchant.MerchantInfo;
import com.zbkj.common.model.merchant.MerchantType;
import com.zbkj.common.model.system.SystemNotification;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.MerchantAddRequest;
import com.zbkj.common.request.MerchantMoveSearchRequest;
import com.zbkj.common.request.MerchantSearchRequest;
import com.zbkj.common.request.MerchantSettledApplyRequest;
import com.zbkj.common.request.MerchantUpdatePhoneRequest;
import com.zbkj.common.request.MerchantUpdateProductNumRequest;
import com.zbkj.common.request.MerchantUpdateRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxPlatformFeeConfigRequest;
import com.zbkj.common.response.CategoryMerchantResponse;
import com.zbkj.common.response.IndexMerchantResponse;
import com.zbkj.common.response.MerchantBaseInfoResponse;
import com.zbkj.common.response.MerchantDetailResponse;
import com.zbkj.common.response.MerchantHeaderNumResponse;
import com.zbkj.common.response.MerchantIndexInfoResponse;
import com.zbkj.common.response.MerchantPageResponse;
import com.zbkj.common.response.MerchantPlatformDetailResponse;
import com.zbkj.common.response.MerchantSearchResponse;
import com.zbkj.common.response.MerchantServiceInfoResponse;
import com.zbkj.common.response.MerchantSettledResponse;
import com.zbkj.common.response.MerchantTakeTheirResponse;
import com.zbkj.common.response.ProMerchantProductResponse;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.common.vo.LoginUserVo;
import com.zbkj.common.vo.MerchantConfigInfoVo;
import com.zbkj.common.vo.MerchantSettlementInfoVo;
import com.zbkj.service.dao.MerchantDao;
import com.zbkj.service.service.MerchantApplyService;
import com.zbkj.service.service.MerchantCategoryService;
import com.zbkj.service.service.MerchantDailyStatementService;
import com.zbkj.service.service.MerchantInfoService;
import com.zbkj.service.service.MerchantMonthStatementService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.MerchantTypeService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.ShippingTemplatesService;
import com.zbkj.service.service.SmsService;
import com.zbkj.service.service.SystemAdminService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemNotificationService;
import com.zbkj.service.service.UserMerchantCollectService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.bcx.BcxPlatformFeeConfigService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class MerchantServiceImpl
extends ServiceImpl<MerchantDao, Merchant>
implements MerchantService {
    @Resource
    private MerchantDao dao;
    private final Logger logger = LoggerFactory.getLogger(MerchantServiceImpl.class);
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private SystemAdminService adminService;
    @Autowired
    private ProductService productService;
    @Autowired
    private MerchantInfoService merchantInfoService;
    @Autowired
    private MerchantCategoryService merchantCategoryService;
    @Autowired
    private MerchantTypeService merchantTypeService;
    @Autowired
    private MerchantDailyStatementService merchantDailyStatementService;
    @Autowired
    private MerchantMonthStatementService merchantMonthStatementService;
    @Autowired
    private MerchantApplyService merchantApplyService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserMerchantCollectService userMerchantCollectService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private ShippingTemplatesService shippingTemplatesService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private SystemNotificationService systemNotificationService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private BcxPlatformFeeConfigService bcxPlatformFeeConfigService;

    @Override
    public PageInfo<MerchantPageResponse> getAdminPage(MerchantSearchRequest searchRequest, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper<Merchant> lqw = this.getAdminPageWrapperBySearch(searchRequest);
        lqw.orderByDesc(Merchant::getSort);
        List merchantList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)merchantList)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new MerchantPageResponse[0]));
        }
        List responseList = merchantList.stream().map(e -> {
            MerchantPageResponse response = new MerchantPageResponse();
            BeanUtils.copyProperties((Object)e, (Object)response);
            SystemAdmin systemAdmin = (SystemAdmin)this.adminService.getById(e.getCreateId());
            response.setCreateName(systemAdmin.getRealName());
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    private LambdaQueryWrapper<Merchant> getAdminPageWrapperBySearch(MerchantSearchRequest searchRequest) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotNull((Object)searchRequest.getCategoryId())) {
            lqw.eq(Merchant::getCategoryId, (Object)searchRequest.getCategoryId());
        }
        if (ObjectUtil.isNotNull((Object)searchRequest.getTypeId())) {
            lqw.eq(Merchant::getTypeId, (Object)searchRequest.getTypeId());
        }
        if (ObjectUtil.isNotNull((Object)searchRequest.getIsSelf())) {
            lqw.eq(Merchant::getIsSelf, (Object)searchRequest.getIsSelf());
        }
        if (ObjectUtil.isNotNull((Object)searchRequest.getIsSwitch())) {
            lqw.eq(Merchant::getIsSwitch, (Object)searchRequest.getIsSwitch());
        }
        if (StrUtil.isNotBlank((CharSequence)searchRequest.getKeywords())) {
            String keywords = URLUtil.decode((String)searchRequest.getKeywords());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(Merchant::getName, (Object)keywords)).or()).apply(StrUtil.format((CharSequence)" find_in_set('{}', keywords)", (Object[])new Object[]{keywords}), new Object[0]);
            });
        }
        if (StrUtil.isNotBlank((CharSequence)searchRequest.getDateLimit())) {
            DateLimitUtilVo dateLimitUtilVo = CrmebDateUtil.getDateLimit((String)searchRequest.getDateLimit());
            lqw.between(Merchant::getCreateTime, (Object)dateLimitUtilVo.getStartTime(), (Object)dateLimitUtilVo.getEndTime());
        }
        lqw.eq(Merchant::getIsDel, (Object)false);
        return lqw;
    }

    @Override
    public MerchantHeaderNumResponse getListHeaderNum(MerchantSearchRequest searchRequest) {
        Integer openNum = this.getOpenNum(searchRequest);
        Integer closeNum = this.getCloseNum(searchRequest);
        return new MerchantHeaderNumResponse(openNum, closeNum);
    }

    private Integer getOpenNum(MerchantSearchRequest searchRequest) {
        LambdaQueryWrapper<Merchant> lqw = this.getAdminPageWrapperBySearch(searchRequest);
        lqw.eq(Merchant::getIsSwitch, (Object)1);
        return this.dao.selectCount((Wrapper)lqw);
    }

    private Integer getCloseNum(MerchantSearchRequest searchRequest) {
        LambdaQueryWrapper<Merchant> lqw = this.getAdminPageWrapperBySearch(searchRequest);
        lqw.eq(Merchant::getIsSwitch, (Object)0);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Integer getAllCount() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Merchant::getIsDel, (Object)false);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public MerchantServiceInfoResponse getCustomerServiceInfo(Integer id) {
        this.getByIdException(id);
        MerchantInfo merchantInfo = this.merchantInfoService.getByMerId(id);
        MerchantServiceInfoResponse response = new MerchantServiceInfoResponse();
        BeanUtils.copyProperties((Object)merchantInfo, (Object)response);
        return response;
    }

    @Override
    public Boolean add(MerchantAddRequest request) {
        if (this.checkMerchantName(request.getName()).booleanValue() || this.merchantApplyService.checkMerchantName(request.getName()).booleanValue()) {
            throw new CrmebException("\u5546\u6237\u540d\u5df2\u5b58\u5728");
        }
        if (this.checkMerchantPhone(request.getPhone()).booleanValue() || this.merchantApplyService.checkMerchantPhone(request.getPhone()).booleanValue()) {
            throw new CrmebException("\u5546\u6237\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        if (this.adminService.checkAccount(request.getPhone()).booleanValue()) {
            throw new CrmebException("\u5546\u6237\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        LoginUserVo loginUserVo = SecurityUtil.getLoginUserVo();
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            Boolean aBoolean = this.commonAdd(request, "admin", loginUserVo.getUser().getId());
            if (!aBoolean.booleanValue()) {
                this.logger.error("\u540e\u53f0\u65b0\u589e\u5546\u6237\u4e8b\u52a1\u5931\u8d25\uff01\u51c6\u5907\u56de\u6eda");
                e.setRollbackOnly();
            }
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            SystemNotification payNotification = this.systemNotificationService.getByMark("auditSuccess");
            if (StrUtil.isNotBlank((CharSequence)request.getPhone()) && payNotification != null && payNotification.getIsSms() != null && payNotification.getIsSms().equals(1)) {
                String merSiteUrl = this.systemConfigService.getValueByKey("mer_site_url");
                if (StrUtil.isBlank((CharSequence)merSiteUrl)) {
                    merSiteUrl = "";
                }
                try {
                    this.smsService.sendMerchantAuditSuccessNotice(request.getPhone(), DateUtil.date().toString(), request.getName(), request.getPhone(), "000000", merSiteUrl);
                }
                catch (Exception e2) {
                    this.logger.error("\u5546\u6237\u521b\u5efa\u6210\u529f\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff0c{}", (Object)e2.getMessage());
                }
            }
        }
        return execute;
    }

    private Boolean commonAdd(MerchantAddRequest request, String createType, Integer createId) {
        Merchant merchant = new Merchant();
        BeanUtils.copyProperties((Object)request, (Object)merchant);
        if (StrUtil.isNotBlank((CharSequence)merchant.getQualificationPicture())) {
            merchant.setQualificationPicture(this.systemAttachmentService.clearPrefix(merchant.getQualificationPicture()));
        }
        merchant.setCreateType(createType);
        merchant.setCreateId(createId);
        MerchantInfo merchantInfo = new MerchantInfo();
        MerchantDailyStatement dailyStatement = new MerchantDailyStatement();
        MerchantMonthStatement monthStatement = new MerchantMonthStatement();
        ShippingTemplates shippingTemplates = new ShippingTemplates();
        shippingTemplates.setName("\u5168\u56fd\u5305\u90ae");
        shippingTemplates.setType(Integer.valueOf(0));
        shippingTemplates.setAppoint(ShippingTemplatesConstants.APPOINT_TYPE_ALL);
        shippingTemplates.setSort(Integer.valueOf(999));
        boolean save = this.save(merchant);
        if (!save) {
            return Boolean.FALSE;
        }
        this.savePlatformFeeConfig(request, merchant);
        SystemAdmin merchantAdmin = this.initMerchantAdmin(request.getPhone(), request.getName());
        merchantAdmin.setMerId(merchant.getId());
        merchantAdmin.setOrgAccount(merchant.getOrgAccount());
        merchantAdmin.setOrgName(merchant.getOrgName());
        save = this.adminService.save(merchantAdmin);
        if (!save) {
            return Boolean.FALSE;
        }
        merchant.setAdminId(merchantAdmin.getId());
        this.dao.updateById(merchant);
        merchantInfo.setMerId(merchant.getId());
        save = this.merchantInfoService.save(merchantInfo);
        if (!save) {
            return Boolean.FALSE;
        }
        dailyStatement.setMerId(merchant.getId()).setDataDate(DateUtil.date().toDateStr());
        monthStatement.setMerId(merchant.getId()).setDataDate(DateUtil.date().toString("yyyy-MM"));
        save = this.merchantDailyStatementService.save(dailyStatement);
        if (!save) {
            return Boolean.FALSE;
        }
        save = this.merchantMonthStatementService.save(monthStatement);
        if (!save) {
            return Boolean.FALSE;
        }
        shippingTemplates.setMerId(merchant.getId());
        save = this.shippingTemplatesService.save(shippingTemplates);
        return save;
    }

    private void savePlatformFeeConfig(MerchantAddRequest request, Merchant merchant) {
        BcxPlatformFeeConfigRequest feeConfig = request.getFeeConfig();
        BcxPlatformFeeConfig exist = this.bcxPlatformFeeConfigService.queryByMerId(merchant.getId());
        BcxPlatformFeeConfig config = new BcxPlatformFeeConfig();
        BeanUtils.copyProperties((Object)feeConfig, (Object)config);
        config.setId(exist != null ? exist.getId() : null);
        config.setLevel(Integer.valueOf(1));
        config.setMerId(merchant.getId());
        this.bcxPlatformFeeConfigService.saveOrUpdate(config);
    }

    private SystemAdmin initMerchantAdmin(String account, String name) {
        SystemAdmin systemAdmin = new SystemAdmin();
        systemAdmin.setAccount(account);
        systemAdmin.setPwd(CrmebUtil.merchantInitPassword((String)account));
        systemAdmin.setRealName(name);
        systemAdmin.setStatus(Boolean.valueOf(true));
        systemAdmin.setRoles(RoleEnum.SUPER_MERCHANT.getValue().toString());
        systemAdmin.setType(RoleEnum.SUPER_MERCHANT.getValue());
        return systemAdmin;
    }

    @Override
    public Boolean edit(MerchantUpdateRequest request) {
        Merchant merchant = this.getByIdException(request.getId());
        if (!request.getName().equals(merchant.getName()) && this.checkMerchantName(request.getName(), request.getId()).booleanValue()) {
            throw new CrmebException("\u5546\u6237\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Merchant tempMerchant = new Merchant();
        BeanUtils.copyProperties((Object)request, (Object)tempMerchant);
        if (StrUtil.isNotBlank((CharSequence)tempMerchant.getQualificationPicture())) {
            tempMerchant.setQualificationPicture(this.systemAttachmentService.clearPrefix(tempMerchant.getQualificationPicture()));
        }
        this.savePlatformFeeConfig(request, merchant);
        SystemAdmin admin = (SystemAdmin)this.adminService.getById(merchant.getAdminId());
        admin.setOrgName(request.getOrgName());
        admin.setOrgAccount(request.getOrgAccount());
        this.adminService.updateById(admin);
        return this.dao.updateById(tempMerchant) > 0;
    }

    private void savePlatformFeeConfig(MerchantUpdateRequest request, Merchant merchant) {
        BcxPlatformFeeConfigRequest feeConfig = request.getFeeConfig();
        BcxPlatformFeeConfig exist = this.bcxPlatformFeeConfigService.queryById(feeConfig.getId());
        BcxPlatformFeeConfig config = Optional.ofNullable(exist).orElseGet(BcxPlatformFeeConfig::new);
        BeanUtils.copyProperties((Object)feeConfig, (Object)config);
        config.setLevel(Integer.valueOf(1));
        config.setMerId(merchant.getId());
        this.bcxPlatformFeeConfigService.saveOrUpdate(config);
    }

    @Override
    public Boolean resetPassword(Integer id) {
        Merchant merchant = this.getByIdException(id);
        SystemAdmin systemAdmin = this.adminService.getDetail(merchant.getAdminId());
        systemAdmin.setPwd(CrmebUtil.merchantInitPassword((String)systemAdmin.getAccount()));
        return this.adminService.updateById(systemAdmin);
    }

    @Override
    public Boolean updateCopyProductNum(MerchantUpdateProductNumRequest request) {
        Merchant merchant = this.getByIdException(request.getId());
        if (request.getType().equals("sub") && merchant.getCopyProductNum() - request.getNum() < 0) {
            throw new CrmebException("\u6263\u51cf\u540e\u7684\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (request.getType().equals("add")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"copy_product_num = copy_product_num + {}", (Object[])new Object[]{request.getNum()}));
        }
        if (request.getType().equals("sub")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"copy_product_num = copy_product_num - {}", (Object[])new Object[]{request.getNum()}));
            updateWrapper.last(StrUtil.format((CharSequence)"and (copy_product_num - {} >= 0)", (Object[])new Object[]{request.getNum()}));
        }
        updateWrapper.eq((Object)"id", (Object)request.getId());
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public MerchantPlatformDetailResponse getPlatformDetail(Integer id) {
        Merchant merchant = this.getByIdException(id);
        MerchantPlatformDetailResponse response = new MerchantPlatformDetailResponse();
        BeanUtils.copyProperties((Object)merchant, (Object)response);
        BcxPlatformFeeConfig config = this.bcxPlatformFeeConfigService.queryByMerId(merchant.getId());
        response.setFeeConfig(config);
        response.setAccount(merchant.getPhone());
        return response;
    }

    @Override
    public Boolean recommendSwitch(Integer id) {
        Merchant merchant;
        merchant.setIsRecommend(Boolean.valueOf((merchant = this.getByIdException(id)).getIsRecommend() == false));
        return this.dao.updateById(merchant) > 0;
    }

    @Override
    public Boolean close(Integer id) {
        Merchant merchant = this.getByIdException(id);
        if (!merchant.getIsSwitch().booleanValue()) {
            throw new CrmebException("\u5546\u6237\u5df2\u662f\u5173\u95ed\u72b6\u6001");
        }
        merchant.setIsSwitch(Boolean.valueOf(false));
        merchant.setProductSwitch(Boolean.valueOf(true));
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.dao.updateById(merchant);
            this.productService.forcedRemovalAll(merchant.getId());
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean open(Integer id) {
        Merchant merchant = this.getByIdException(id);
        if (merchant.getIsSwitch().booleanValue()) {
            throw new CrmebException("\u5546\u6237\u5df2\u7ecf\u662f\u5f00\u542f\u72b6\u6001");
        }
        this.openMerchantValidator(merchant);
        merchant.setIsSwitch(Boolean.valueOf(true));
        return this.dao.updateById(merchant) > 0;
    }

    @Override
    public Boolean auditSuccess(MerchantAddRequest request, Integer auditorId) {
        if (this.checkMerchantName(request.getName()).booleanValue()) {
            throw new CrmebException("\u5546\u6237\u540d\u5df2\u5b58\u5728");
        }
        if (this.checkMerchantPhone(request.getPhone()).booleanValue()) {
            throw new CrmebException("\u5546\u6237\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        if (this.adminService.checkAccount(request.getPhone()).booleanValue()) {
            throw new CrmebException("\u5546\u6237\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        return this.commonAdd(request, "apply", auditorId);
    }

    @Override
    public Merchant getByIdException(Integer id) {
        Merchant merchant = (Merchant)this.getById(id);
        if (ObjectUtil.isNull((Object)merchant) || merchant.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u6237\u4e0d\u5b58\u5728");
        }
        return merchant;
    }

    @Override
    public Boolean subCopyProductNum(Integer id) {
        UpdateWrapper wrapper = Wrappers.update();
        wrapper.setSql(" copy_product_num = copy_product_num -1 ");
        wrapper.eq((Object)"id", (Object)id);
        wrapper.ge((Object)"copy_product_num", (Object)1);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean operationBalance(Integer merId, BigDecimal price, String type) {
        UpdateWrapper wrapper = Wrappers.update();
        if (type.equals("add")) {
            wrapper.setSql(" balance = balance + " + price);
        } else {
            wrapper.setSql(" balance = balance - " + price);
        }
        wrapper.eq((Object)"id", (Object)merId);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<Merchant> getListByIdList(List<Integer> merIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(Merchant::getId, merIdList);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Map<Integer, Merchant> getMerIdMapByIdList(List<Integer> merIdList) {
        List<Merchant> merchantList = this.getListByIdList(merIdList);
        HashMap<Integer, Merchant> merchantMap = new HashMap<Integer, Merchant>();
        merchantList.forEach(merchant -> merchantMap.put(merchant.getId(), (Merchant)merchant));
        return merchantMap;
    }

    @Override
    public MerchantBaseInfoResponse getBaseInfo() {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Merchant merchant = this.getByIdException(systemAdmin.getMerId());
        MerchantBaseInfoResponse baseInfo = new MerchantBaseInfoResponse();
        MerchantCategory merchantCategory = (MerchantCategory)this.merchantCategoryService.getById(merchant.getCategoryId());
        MerchantType merchantType = (MerchantType)this.merchantTypeService.getById(merchant.getTypeId());
        BeanUtils.copyProperties((Object)merchant, (Object)baseInfo);
        baseInfo.setMerCategory(merchantCategory.getName());
        baseInfo.setMerType(merchantType.getName());
        return baseInfo;
    }

    @Override
    public MerchantConfigInfoVo getConfigInfo() {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Merchant merchant = this.getByIdException(systemAdmin.getMerId());
        MerchantInfo merchantInfo = this.merchantInfoService.getByMerId(merchant.getId());
        MerchantConfigInfoVo infoResponse = new MerchantConfigInfoVo();
        BeanUtils.copyProperties((Object)merchant, (Object)infoResponse);
        BeanUtils.copyProperties((Object)merchantInfo, (Object)infoResponse);
        return infoResponse;
    }

    @Override
    public MerchantSettlementInfoVo getSettlementInfo() {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        MerchantInfo merchantInfo = this.merchantInfoService.getByMerId(systemAdmin.getMerId());
        if (ObjectUtil.isNull((Object)merchantInfo)) {
            throw new CrmebException("\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        MerchantSettlementInfoVo response = new MerchantSettlementInfoVo();
        BeanUtils.copyProperties((Object)merchantInfo, (Object)response);
        return response;
    }

    @Override
    public Boolean configInfoEdit(MerchantConfigInfoVo request) {
        this.serviceTypeCheck(request);
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Merchant tempMerchant = this.getByIdException(systemAdmin.getMerId());
        MerchantInfo tempMerchantInfo = this.merchantInfoService.getByMerId(tempMerchant.getId());
        Merchant merchant = new Merchant();
        MerchantInfo merchantInfo = new MerchantInfo();
        BeanUtils.copyProperties((Object)request, (Object)merchant);
        BeanUtils.copyProperties((Object)request, (Object)merchantInfo);
        String cdnUrl = this.systemAttachmentService.getCdnUrl();
        merchant.setBackImage(this.systemAttachmentService.clearPrefix(request.getBackImage(), cdnUrl));
        merchant.setAvatar(this.systemAttachmentService.clearPrefix(request.getAvatar(), cdnUrl));
        merchant.setRectangleLogo(this.systemAttachmentService.clearPrefix(request.getRectangleLogo(), cdnUrl));
        merchant.setCoverImage(this.systemAttachmentService.clearPrefix(request.getCoverImage(), cdnUrl));
        merchant.setStreetBackImage(this.systemAttachmentService.clearPrefix(request.getStreetBackImage(), cdnUrl));
        merchant.setId(tempMerchant.getId());
        if (StrUtil.isNotBlank((CharSequence)merchant.getPcBanner())) {
            merchant.setPcBanner(this.systemAttachmentService.clearPrefix(merchant.getPcBanner(), cdnUrl));
        }
        if (StrUtil.isNotBlank((CharSequence)merchant.getPcBackImage())) {
            merchant.setPcBackImage(this.systemAttachmentService.clearPrefix(merchant.getPcBackImage(), cdnUrl));
        }
        merchantInfo.setId(tempMerchantInfo.getId());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(merchant);
            this.merchantInfoService.updateById(merchantInfo);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean settlementInfoEdit(MerchantSettlementInfoVo request) {
        this.settlementInfoCheck(request);
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        MerchantInfo tempMerchantInfo = this.merchantInfoService.getByMerId(systemAdmin.getMerId());
        if (ObjectUtil.isNull((Object)tempMerchantInfo)) {
            throw new CrmebException("\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        MerchantInfo merchantInfo = new MerchantInfo();
        BeanUtils.copyProperties((Object)request, (Object)merchantInfo);
        merchantInfo.setId(tempMerchantInfo.getId());
        if (!request.getSettlementType().equals("bank")) {
            String cdnUrl = this.systemAttachmentService.getCdnUrl();
            if (StrUtil.isNotBlank((CharSequence)request.getWechatQrcodeUrl())) {
                merchantInfo.setWechatQrcodeUrl(this.systemAttachmentService.clearPrefix(request.getWechatQrcodeUrl(), cdnUrl));
            }
            if (StrUtil.isNotBlank((CharSequence)request.getAlipayQrcodeUrl())) {
                merchantInfo.setAlipayQrcodeUrl(this.systemAttachmentService.clearPrefix(request.getAlipayQrcodeUrl(), cdnUrl));
            }
        }
        return this.merchantInfoService.updateById(merchantInfo);
    }

    private void settlementInfoCheck(MerchantSettlementInfoVo request) {
        if (request.getSettlementType().equals("bank")) {
            if (StrUtil.isBlank((CharSequence)request.getBankUserName())) {
                throw new CrmebException("\u6301\u5361\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)request.getBankName())) {
                throw new CrmebException("\u94f6\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)request.getBankCard())) {
                throw new CrmebException("\u94f6\u884c\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)request.getBankAddress())) {
                // empty if block
            }
        }
        if (request.getSettlementType().equals("wechat")) {
            if (StrUtil.isBlank((CharSequence)request.getWechatCode())) {
                throw new CrmebException("\u5fae\u4fe1\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)request.getWechatQrcodeUrl())) {
                throw new CrmebException("\u5fae\u4fe1\u6536\u6b3e\u4e8c\u7ef4\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)request.getRealName())) {
                throw new CrmebException("\u771f\u5b9e\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (request.getSettlementType().equals("alipay")) {
            if (StrUtil.isBlank((CharSequence)request.getAlipayCode())) {
                throw new CrmebException("\u652f\u4ed8\u5b9d\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)request.getAlipayQrcodeUrl())) {
                throw new CrmebException("\u652f\u4ed8\u5b9d\u6536\u6b3e\u4e8c\u7ef4\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    @Override
    public Boolean updateSwitch() {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Merchant merchant = this.getByIdException(systemAdmin.getMerId());
        if (merchant.getIsSwitch().booleanValue()) {
            merchant.setIsSwitch(Boolean.valueOf(false));
            this.productService.downByMerId(merchant.getId());
            return this.updateById(merchant);
        }
        this.openMerchantValidator(merchant);
        merchant.setIsSwitch(Boolean.valueOf(true));
        return this.updateById(merchant);
    }

    private void openMerchantValidator(Merchant merchant) {
        if (StrUtil.isBlank((CharSequence)merchant.getAvatar()) || StrUtil.isBlank((CharSequence)merchant.getBackImage()) || StrUtil.isBlank((CharSequence)merchant.getStreetBackImage())) {
            throw new CrmebException("\u8bf7\u5148\u8fdb\u884c\u5546\u6237\u5934\u50cf\u3001\u80cc\u666f\u56fe\u914d\u7f6e");
        }
        MerchantInfo merchantInfo = this.merchantInfoService.getByMerId(merchant.getId());
        if (StrUtil.isBlank((CharSequence)merchantInfo.getServiceLink()) && StrUtil.isBlank((CharSequence)merchantInfo.getServicePhone())) {
            throw new CrmebException("\u8bf7\u5148\u8fdb\u884c\u5ba2\u670d\u4fe1\u606f\u914d\u7f6e");
        }
    }

    @Override
    public List<Integer> getAllId() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Merchant::getId});
        lqw.eq(Merchant::getIsDel, (Object)false);
        List merchantList = this.dao.selectList((Wrapper)lqw);
        return merchantList.stream().map(Merchant::getId).collect(Collectors.toList());
    }

    @Override
    public Boolean settledApply(MerchantSettledApplyRequest request) {
        if (this.checkMerchantName(request.getName()).booleanValue()) {
            throw new CrmebException("\u5546\u6237\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (this.checkMerchantPhone(request.getPhone()).booleanValue()) {
            throw new CrmebException("\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        this.checkValidateCode(request.getPhone(), request.getCaptcha());
        return this.merchantApplyService.settledApply(request);
    }

    private void checkValidateCode(String phone, String code) {
        Object validateCode = this.redisUtil.get("sms:validate:code:" + phone);
        if (ObjectUtil.isNull((Object)validateCode)) {
            throw new CrmebException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        if (!validateCode.toString().equals(code)) {
            throw new CrmebException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.redisUtil.delete(new String[]{"sms:validate:code:" + phone});
    }

    @Override
    public PageInfo<MerchantSettledResponse> findSettledRecord(PageParamRequest pageParamRequest) {
        Integer uid = this.userService.getUserIdException();
        PageInfo<MerchantApply> pageInfo = this.merchantApplyService.findSettledRecord(uid, pageParamRequest);
        List merchantApplyList = pageInfo.getList();
        if (CollUtil.isEmpty((Collection)merchantApplyList)) {
            return CommonPage.copyPageInfo(pageInfo, (List)CollUtil.newArrayList((Object[])new MerchantSettledResponse[0]));
        }
        List responseList = merchantApplyList.stream().map(apply -> {
            MerchantSettledResponse response = new MerchantSettledResponse();
            BeanUtils.copyProperties((Object)apply, (Object)response);
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo(pageInfo, responseList);
    }

    @Override
    public PageInfo<MerchantSearchResponse> findSearchList(MerchantMoveSearchRequest request, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            lqw.eq(Merchant::getCategoryId, (Object)request.getCategoryId());
        }
        if (ObjectUtil.isNotNull((Object)request.getTypeId())) {
            lqw.eq(Merchant::getTypeId, (Object)request.getTypeId());
        }
        if (ObjectUtil.isNotNull((Object)request.getIsSelf())) {
            lqw.eq(Merchant::getIsSelf, (Object)request.getIsSelf());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(Merchant::getName, (Object)keywords)).or()).apply(StrUtil.format((CharSequence)" find_in_set('{}', keywords)", (Object[])new Object[]{keywords}), new Object[0]);
            });
        }
        lqw.eq(Merchant::getIsSwitch, (Object)true);
        lqw.eq(Merchant::getIsDel, (Object)false);
        lqw.orderByDesc((Object[])new SFunction[]{Merchant::getStarLevel, Merchant::getIsRecommend, Merchant::getSort, Merchant::getId});
        List merchantList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)merchantList)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new MerchantSearchResponse[0]));
        }
        List responseList = merchantList.stream().map(merchant -> {
            MerchantSearchResponse response = new MerchantSearchResponse();
            BeanUtils.copyProperties((Object)merchant, (Object)response);
            List<ProMerchantProductResponse> merchantProductResponseList = this.productService.getRecommendedProductsByMerId(merchant.getId(), 3);
            response.setProList(merchantProductResponseList);
            Integer followerNum = this.userMerchantCollectService.getCountByMerId(merchant.getId());
            response.setFollowerNum(followerNum);
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public PageInfo<MerchantSearchResponse> getStreet(String terminal, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Merchant::getIsSwitch, (Object)true);
        lqw.eq(Merchant::getIsDel, (Object)false);
        if (StrUtil.isNotBlank((CharSequence)terminal)) {
            if ("pc".equalsIgnoreCase(terminal)) {
                lqw.eq(Merchant::getPcMall, (Object)true);
            } else if ("risk".equalsIgnoreCase(terminal)) {
                lqw.eq(Merchant::getWxMiniRisk, (Object)true);
            }
        }
        lqw.orderByDesc((Object[])new SFunction[]{Merchant::getIsRecommend, Merchant::getSort, Merchant::getId});
        List merchantList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)merchantList)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new MerchantSearchResponse[0]));
        }
        List responseList = merchantList.stream().map(merchant -> {
            MerchantSearchResponse response = new MerchantSearchResponse();
            BeanUtils.copyProperties((Object)merchant, (Object)response);
            List<ProMerchantProductResponse> merchantProductResponseList = this.productService.getRecommendedProductsByMerId(merchant.getId(), 3);
            response.setProList(merchantProductResponseList);
            Integer followerNum = this.userMerchantCollectService.getCountByMerId(merchant.getId());
            response.setFollowerNum(followerNum);
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public MerchantIndexInfoResponse getIndexInfo(Integer id) {
        Integer userId = this.userService.getUserId();
        Merchant merchant = this.getByIdException(id);
        if (!merchant.getIsSwitch().booleanValue()) {
            throw new CrmebException("\u5546\u6237\u672a\u8425\u4e1a");
        }
        MerchantIndexInfoResponse response = new MerchantIndexInfoResponse();
        BeanUtils.copyProperties((Object)merchant, (Object)response);
        MerchantInfo merchantInfo = this.merchantInfoService.getByMerId(merchant.getId());
        BeanUtils.copyProperties((Object)merchantInfo, (Object)response);
        response.setIsCollect(Boolean.valueOf(false));
        if (userId > 0) {
            response.setIsCollect(this.userMerchantCollectService.isCollect(userId, merchant.getId()));
            String dateStr = DateUtil.date().toString("yyyy-MM-dd");
            this.redisUtil.incrAndCreate(StrUtil.format((CharSequence)"statistics:merchant:visitors:{}:{}", (Object[])new Object[]{dateStr, merchant.getId()}));
        }
        return response;
    }

    @Override
    public MerchantDetailResponse getDetail(Integer id) {
        Merchant merchant = this.getByIdException(id);
        if (!merchant.getIsSwitch().booleanValue()) {
            throw new CrmebException("The store is not open");
        }
        MerchantInfo merchantInfo = this.merchantInfoService.getByMerId(merchant.getId());
        MerchantDetailResponse response = new MerchantDetailResponse();
        BeanUtils.copyProperties((Object)merchant, (Object)response);
        BeanUtils.copyProperties((Object)merchantInfo, (Object)response);
        response.setFollowerNum(this.userMerchantCollectService.getCountByMerId(merchant.getId()));
        Integer userId = this.userService.getUserId();
        if (userId > 0) {
            response.setIsCollect(this.userMerchantCollectService.isCollect(userId, merchant.getId()));
        } else {
            response.setIsCollect(Boolean.valueOf(false));
        }
        return response;
    }

    @Override
    public Boolean isExistCategory(Integer cid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Merchant::getId});
        lqw.eq(Merchant::getIsDel, (Object)false);
        lqw.eq(Merchant::getCategoryId, (Object)cid);
        lqw.last(" limit 1");
        Merchant merchant = (Merchant)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)merchant);
    }

    @Override
    public Boolean isExistType(Integer tid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Merchant::getId});
        lqw.eq(Merchant::getIsDel, (Object)false);
        lqw.eq(Merchant::getTypeId, (Object)tid);
        lqw.last(" limit 1");
        Merchant merchant = (Merchant)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)merchant);
    }

    private void serviceTypeCheck(MerchantConfigInfoVo request) {
        if (request.getServiceType().equals("H5")) {
            if (StrUtil.isBlank((CharSequence)request.getServiceLink())) {
                throw new CrmebException("\u5ba2\u670dH5\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ReUtil.isMatch((String)"[a-zA-z]+://[^\\s]*", (CharSequence)request.getServiceLink())) {
                throw new CrmebException("\u5ba2\u670dH5\u94fe\u63a5\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        if (request.getServiceType().equals("phone") && StrUtil.isBlank((CharSequence)request.getServicePhone())) {
            throw new CrmebException("\u5ba2\u670d\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Boolean checkMerchantPhone(String phone) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Merchant::getId});
        lqw.eq(Merchant::getPhone, (Object)phone);
        lqw.eq(Merchant::getIsDel, (Object)false);
        lqw.last(" limit 1");
        Merchant merchant = (Merchant)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)merchant);
    }

    @Override
    public Boolean updatePhone(MerchantUpdatePhoneRequest request) {
        Merchant merchant = this.getByIdException(request.getId());
        if (request.getPhone().equals(merchant.getPhone())) {
            return Boolean.TRUE;
        }
        if (this.checkMerchantPhone(request.getPhone(), request.getId()).booleanValue() || this.merchantApplyService.checkMerchantPhone(request.getPhone()).booleanValue()) {
            throw new CrmebException("\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        if (this.adminService.checkAccount(request.getPhone()).booleanValue()) {
            throw new CrmebException("\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        merchant.setPhone(request.getPhone());
        SystemAdmin systemAdmin = this.adminService.getDetail(merchant.getAdminId());
        String pwd = "";
        try {
            pwd = CrmebUtil.decryptPassowrd((String)systemAdmin.getPwd(), (String)systemAdmin.getAccount());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        systemAdmin.setAccount(request.getPhone());
        systemAdmin.setPwd(CrmebUtil.encryptPassword((String)pwd, (String)request.getPhone()));
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(merchant);
            this.adminService.updateById(systemAdmin);
            return Boolean.TRUE;
        });
    }

    @Override
    public List<IndexMerchantResponse> findIndexList(String terminal, Integer recomdProdsNum) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Merchant::getIsSwitch, (Object)true);
        lqw.eq(Merchant::getIsDel, (Object)false);
        if (StrUtil.isNotBlank((CharSequence)terminal)) {
            if ("pc".equalsIgnoreCase(terminal)) {
                lqw.eq(Merchant::getPcMall, (Object)true);
            } else if ("risk".equalsIgnoreCase(terminal)) {
                lqw.eq(Merchant::getWxMiniRisk, (Object)true);
            }
        }
        lqw.orderByDesc((Object[])new SFunction[]{Merchant::getIsRecommend, Merchant::getSort, Merchant::getId});
        lqw.last(" limit " + recomdProdsNum);
        List merchantList = this.dao.selectList((Wrapper)lqw);
        return merchantList.stream().map(mer -> {
            IndexMerchantResponse response = new IndexMerchantResponse();
            BeanUtils.copyProperties((Object)mer, (Object)response);
            response.setProList(this.productService.getRecommendedProductsByMerId(mer.getId(), 3));
            response.setFollowerNum(this.userMerchantCollectService.getCountByMerId(mer.getId()));
            return response;
        }).collect(Collectors.toList());
    }

    @Override
    public Map<Integer, Merchant> getMapByIdList(List<Integer> merIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Merchant::getId, Merchant::getName, Merchant::getIsSelf, Merchant::getTypeId, Merchant::getCategoryId, Merchant::getAvatar});
        lqw.in(Merchant::getId, merIdList);
        List merchantList = this.dao.selectList((Wrapper)lqw);
        HashMap merchantMap = CollUtil.newHashMap();
        merchantList.forEach(merchant -> merchantMap.put(merchant.getId(), merchant));
        return merchantMap;
    }

    @Override
    public MerchantTakeTheirResponse getTakeTheir(Integer id) {
        Merchant merchant = this.getByIdException(id);
        if (!merchant.getIsSwitch().booleanValue()) {
            throw new CrmebException("\u5546\u6237\u672a\u8425\u4e1a");
        }
        if (!merchant.getIsTakeTheir().booleanValue()) {
            throw new CrmebException("\u5546\u6237\u672a\u5f00\u542f\u81ea\u63d0");
        }
        MerchantTakeTheirResponse response = new MerchantTakeTheirResponse();
        BeanUtils.copyProperties((Object)merchant, (Object)response);
        return response;
    }

    @Override
    public Boolean sendSettledCode(String phone) {
        return this.smsService.sendCommonCode(phone);
    }

    @Override
    public Integer getNewNumByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public List<Merchant> all() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Merchant::getId, Merchant::getName});
        lqw.eq(Merchant::getIsDel, (Object)0);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<CategoryMerchantResponse> getUseCategoryList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Merchant::getId, Merchant::getName, Merchant::getCategoryId});
        lqw.eq(Merchant::getIsSwitch, (Object)1);
        lqw.eq(Merchant::getIsDel, (Object)0);
        List merchantList = this.dao.selectList((Wrapper)lqw);
        ArrayList responseList = CollUtil.newArrayList((Object[])new CategoryMerchantResponse[0]);
        if (CollUtil.isEmpty((Collection)merchantList)) {
            return responseList;
        }
        Map<Integer, MerchantCategory> categoryMap = this.merchantCategoryService.allMap();
        merchantList.forEach(m -> {
            if (responseList.stream().anyMatch(e -> e.getId().equals(m.getCategoryId()))) {
                responseList.forEach(response -> {
                    if (response.getId().equals(m.getCategoryId())) {
                        response.getMerchantList().add(m);
                    }
                });
            } else {
                CategoryMerchantResponse response2 = new CategoryMerchantResponse();
                MerchantCategory merchantCategory = (MerchantCategory)categoryMap.get(m.getCategoryId());
                response2.setId(merchantCategory.getId());
                response2.setName(merchantCategory.getName());
                response2.getMerchantList().add(m);
                responseList.add(response2);
            }
        });
        return responseList;
    }

    private Boolean checkMerchantPhone(String phone, Integer id) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Merchant::getId});
        lqw.eq(Merchant::getPhone, (Object)phone);
        lqw.ne(Merchant::getId, (Object)id);
        lqw.eq(Merchant::getIsDel, (Object)false);
        lqw.last(" limit 1");
        Merchant merchant = (Merchant)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)merchant);
    }

    private Boolean checkMerchantName(String name) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Merchant::getId});
        lqw.eq(Merchant::getName, (Object)name);
        lqw.eq(Merchant::getIsDel, (Object)false);
        lqw.last(" limit 1");
        Merchant merchant = (Merchant)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)merchant);
    }

    private Boolean checkMerchantName(String name, Integer id) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Merchant::getId});
        lqw.eq(Merchant::getName, (Object)name);
        lqw.ne(Merchant::getId, (Object)id);
        lqw.eq(Merchant::getIsDel, (Object)false);
        lqw.last(" limit 1");
        Merchant merchant = (Merchant)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)merchant);
    }
}

