/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.bill.MerchantDailyStatement;
import com.zbkj.common.model.order.OrderProfitSharing;
import com.zbkj.common.model.order.RefundOrder;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.MerchantDailyStatementDao;
import com.zbkj.service.service.MerchantDailyStatementService;
import com.zbkj.service.service.OrderProfitSharingService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.RefundOrderService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantDailyStatementServiceImpl
extends ServiceImpl<MerchantDailyStatementDao, MerchantDailyStatement>
implements MerchantDailyStatementService {
    @Resource
    private MerchantDailyStatementDao dao;
    @Autowired
    private OrderProfitSharingService orderProfitSharingService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private RefundOrderService refundOrderService;

    @Override
    public List<MerchantDailyStatement> findByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantDailyStatement::getDataDate, (Object)date);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<MerchantDailyStatement> findByMonth(String month) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.apply("date_format(data_date, '%Y-%m') = {0}", new Object[]{month});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageInfo<MerchantDailyStatement> getPageList(String dateLimit, PageParamRequest pageParamRequest) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantDailyStatement::getMerId, (Object)systemAdmin.getMerId());
        if (StrUtil.isNotBlank((CharSequence)dateLimit)) {
            DateLimitUtilVo dateLimitVo = CrmebDateUtil.getDateLimit((String)dateLimit);
            String startDate = DateUtil.parse((String)dateLimitVo.getStartTime()).toDateStr();
            String endDate = DateUtil.parse((String)dateLimitVo.getEndTime()).toDateStr();
            lqw.between(MerchantDailyStatement::getDataDate, (Object)startDate, (Object)endDate);
        }
        lqw.orderByDesc(MerchantDailyStatement::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)list)) {
            return CommonPage.copyPageInfo((Page)page, (List)list);
        }
        String today = DateUtil.date().toDateStr();
        for (MerchantDailyStatement dailyStatement : list) {
            if (!dailyStatement.getDataDate().equals(today)) continue;
            this.writeDailyStatement(dailyStatement);
        }
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    private void writeDailyStatement(MerchantDailyStatement statement) {
        List<OrderProfitSharing> sharingList = this.orderProfitSharingService.findByDate(statement.getMerId(), statement.getDataDate());
        List<RefundOrder> refundOrderList = this.refundOrderService.findByDate(statement.getMerId(), statement.getDataDate());
        BigDecimal orderPayAmount = new BigDecimal("0.00");
        int orderNum = 0;
        BigDecimal orderIncomeAmount = new BigDecimal("0.00");
        BigDecimal handlingFee = new BigDecimal("0.00");
        BigDecimal firstBrokerage = new BigDecimal("0.00");
        BigDecimal secondBrokerage = new BigDecimal("0.00");
        BigDecimal refundAmount = new BigDecimal("0.00");
        int refundNum = 0;
        BigDecimal platCouponPrice = new BigDecimal("0.00");
        BigDecimal integralPrice = new BigDecimal("0.00");
        BigDecimal brokeragePrice = new BigDecimal("0.00");
        BigDecimal orderRefundPrice = new BigDecimal("0.00");
        BigDecimal refundPlatCouponPrice = new BigDecimal("0.00");
        BigDecimal refundIntegralPrice = new BigDecimal("0.00");
        BigDecimal refundHandlingFee = new BigDecimal("0.00");
        BigDecimal refundBrokeragePrice = new BigDecimal("0.00");
        BigDecimal refundMerchantTransferAmount = new BigDecimal("0.00");
        BigDecimal freightFee = new BigDecimal("0.00");
        BigDecimal refundFreightFee = new BigDecimal("0.00");
        if (CollUtil.isNotEmpty(sharingList)) {
            orderPayAmount = sharingList.stream().map(OrderProfitSharing::getOrderPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderNum = sharingList.size();
            orderIncomeAmount = sharingList.stream().map(OrderProfitSharing::getProfitSharingMerPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            handlingFee = sharingList.stream().map(OrderProfitSharing::getProfitSharingPlatPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            firstBrokerage = sharingList.stream().map(OrderProfitSharing::getFirstBrokerageFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            secondBrokerage = sharingList.stream().map(OrderProfitSharing::getSecondBrokerageFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            platCouponPrice = sharingList.stream().map(OrderProfitSharing::getPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            integralPrice = sharingList.stream().map(OrderProfitSharing::getIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            brokeragePrice = firstBrokerage.add(secondBrokerage);
            freightFee = sharingList.stream().map(OrderProfitSharing::getFreightFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (CollUtil.isNotEmpty(refundOrderList)) {
            refundAmount = refundOrderList.stream().map(RefundOrder::getRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundNum = refundOrderList.size();
            refundMerchantTransferAmount = refundOrderList.stream().map(RefundOrder::getMerchantRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundHandlingFee = refundOrderList.stream().map(RefundOrder::getPlatformRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundPlatCouponPrice = refundOrderList.stream().map(RefundOrder::getRefundPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundBrokeragePrice = refundOrderList.stream().map(e -> e.getRefundFirstBrokerageFee().add(e.getRefundSecondBrokerageFee())).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundIntegralPrice = refundOrderList.stream().map(RefundOrder::getRefundIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderRefundPrice = refundOrderList.stream().map(RefundOrder::getRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundFreightFee = refundOrderList.stream().map(RefundOrder::getRefundFreightFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal orderReceivable = orderPayAmount.add(platCouponPrice).add(integralPrice);
        BigDecimal orderRefundable = BigDecimal.ZERO.subtract(refundMerchantTransferAmount).subtract(refundHandlingFee).subtract(refundBrokeragePrice);
        BigDecimal orderRefund = orderRefundable.subtract(refundPlatCouponPrice).subtract(refundIntegralPrice);
        BigDecimal platformHandling = handlingFee.subtract(refundHandlingFee);
        BigDecimal brokerage = brokeragePrice.subtract(refundBrokeragePrice);
        BigDecimal income = orderReceivable.add(orderRefundable);
        BigDecimal payout = platformHandling.add(brokerage);
        BigDecimal incomeExpenditure = income.subtract(payout);
        statement.setOrderPayAmount(orderPayAmount);
        statement.setOrderNum(Integer.valueOf(orderNum));
        statement.setOrderIncomeAmount(orderIncomeAmount);
        statement.setHandlingFee(handlingFee);
        statement.setFirstBrokerage(firstBrokerage);
        statement.setSecondBrokerage(secondBrokerage);
        statement.setRefundAmount(refundAmount);
        statement.setRefundNum(Integer.valueOf(refundNum));
        statement.setIncomeExpenditure(incomeExpenditure.abs());
        statement.setPlatCouponPrice(platCouponPrice);
        statement.setIntegralPrice(integralPrice);
        statement.setBrokeragePrice(brokeragePrice);
        statement.setOrderRefundPrice(orderRefundPrice);
        statement.setRefundPlatCouponPrice(refundPlatCouponPrice);
        statement.setRefundIntegralPrice(refundIntegralPrice);
        statement.setRefundHandlingFee(refundHandlingFee);
        statement.setRefundBrokeragePrice(refundBrokeragePrice);
        statement.setRefundMerchantTransferAmount(refundMerchantTransferAmount);
        statement.setFreightFee(freightFee);
        statement.setRefundFreightFee(refundFreightFee);
    }
}

