/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.bcx.BcxSettle;
import com.zbkj.common.model.bcx.BcxSettleAttachments;
import com.zbkj.common.request.BcxSettleAttachmentsRequest;
import com.zbkj.common.request.BcxSettleUploadAttachmentsRequest;
import com.zbkj.common.utils.IdGeneratorSnowflake;
import com.zbkj.service.dao.BcxSettleAttachmentsDao;
import com.zbkj.service.service.BcxSettleAttachmentsService;
import com.zbkj.service.service.BcxSettleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BcxSettleAttachmentsServiceImpl
extends ServiceImpl<BcxSettleAttachmentsDao, BcxSettleAttachments>
implements BcxSettleAttachmentsService {
    private static final Logger log = LoggerFactory.getLogger(BcxSettleAttachmentsServiceImpl.class);
    @Resource
    private BcxSettleAttachmentsDao dao;
    @Autowired
    private BcxSettleService bcxSettleService;
    @Autowired
    private IdGeneratorSnowflake snowflake;

    @Override
    @Transactional
    public Boolean uploadAttachments(BcxSettleUploadAttachmentsRequest request) {
        List<BcxSettleAttachments> attachments;
        log.info("==================\u4e0a\u4f20\u9644\u4ef6==================");
        ArrayList<BcxSettleAttachments> attachmentsList = new ArrayList<BcxSettleAttachments>();
        Date now = new Date();
        if (CollectionUtil.isNotEmpty((Collection)request.getSettleInvoiceList())) {
            for (BcxSettleAttachmentsRequest attachmentsRequest : request.getSettleInvoiceList()) {
                attachmentsList.add(this.createBcxSettleAttachments(request.getSettleId(), 1, attachmentsRequest, now));
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)request.getSettleProofList())) {
            for (BcxSettleAttachmentsRequest attachmentsRequest : request.getSettleProofList()) {
                attachmentsList.add(this.createBcxSettleAttachments(request.getSettleId(), 2, attachmentsRequest, now));
            }
        }
        if (CollectionUtil.isNotEmpty(attachmentsList)) {
            this.saveBatch(attachmentsList);
        }
        if (CollectionUtil.isNotEmpty(attachments = this.findBySettleId(request.getSettleId())) && attachments.stream().anyMatch(attachment -> attachment.getType() == 1) && attachments.stream().anyMatch(attachment -> attachment.getType() == 2)) {
            BcxSettle bcxSettle = (BcxSettle)this.bcxSettleService.getById(request.getSettleId());
            bcxSettle.setUploadAttachments(Integer.valueOf(2));
            this.bcxSettleService.updateById(bcxSettle);
        }
        log.info("==================\u4e0a\u4f20\u9644\u4ef6\u5b8c\u6210==================");
        return true;
    }

    @Override
    public List<BcxSettleAttachments> findBySettleId(Long settleId) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.eq((Object)"settle_id", (Object)settleId);
        return this.list((Wrapper)queryWrapper);
    }

    private BcxSettleAttachments createBcxSettleAttachments(Long settleId, Integer type, BcxSettleAttachmentsRequest attachmentsRequest, Date now) {
        BcxSettleAttachments attachments = new BcxSettleAttachments();
        attachments.setId(Long.valueOf(this.snowflake.snowflakeId()));
        attachments.setSettleId(settleId);
        attachments.setType(type);
        attachments.setFileName(attachmentsRequest.getFileName());
        attachments.setExtName(attachmentsRequest.getExtName());
        attachments.setUrl(attachmentsRequest.getUrl());
        attachments.setCreateTime(now);
        attachments.setUpdateTime(now);
        return attachments;
    }
}

