/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxDepartmentMember;
import com.zbkj.common.model.bcx.BcxDepartmentMemberServe;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxDepartmentMemberSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxDepartmentMemberResponse;
import com.zbkj.common.response.BcxDepartmentResponse;
import com.zbkj.service.dao.BcxDepartmentMemberDao;
import com.zbkj.service.service.BcxDepartmentMemberServeService;
import com.zbkj.service.service.BcxDepartmentMemberService;
import com.zbkj.service.service.BcxDepartmentService;
import com.zbkj.service.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BcxDepartmentMemberServiceImpl
extends ServiceImpl<BcxDepartmentMemberDao, BcxDepartmentMember>
implements BcxDepartmentMemberService {
    @Resource
    private BcxDepartmentMemberDao dao;
    @Autowired
    private BcxDepartmentService bcxDepartmentService;
    @Resource
    private BcxDepartmentMemberServeService bcxDepartmentMemberServeService;
    @Resource
    private UserService userService;

    @Override
    public List<BcxDepartmentResponse> findAllTree() {
        List allList = this.list();
        if (CollectionUtil.isEmpty((Collection)allList)) {
            return new ArrayList<BcxDepartmentResponse>();
        }
        List<BcxDepartmentMemberResponse> memberList = allList.stream().map(this::getBcxDepartmentMemberResponse).collect(Collectors.toList());
        List<BcxDepartmentResponse> responseList = this.bcxDepartmentService.findAllTreeWithMember(memberList);
        return responseList;
    }

    private BcxDepartmentMemberResponse getBcxDepartmentMemberResponse(BcxDepartmentMember member) {
        BcxDepartmentMemberResponse response = new BcxDepartmentMemberResponse();
        response.setId(member.getId());
        response.setDeptId(member.getDepartmentId());
        response.setName(member.getName());
        return response;
    }

    @Override
    public BcxDepartmentMember findByBcxId(String bcxId) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.eq((Object)"bcx_id", (Object)bcxId);
        return (BcxDepartmentMember)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public PageInfo<BcxDepartmentMemberResponse> getPage(BcxDepartmentMemberSearchRequest request, PageParamRequest pageParamRequest) {
        HashMap map = CollUtil.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            map.put("name", request.getName());
        }
        if (ObjectUtil.isNotNull((Object)request.getDepartmentName())) {
            map.put("departmentName", request.getDepartmentName());
        }
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List<BcxDepartmentMemberResponse> list = this.dao.selectListByParam(map);
        return CommonPage.copyPageInfo((Page)page, list);
    }

    @Override
    public String getMemerNamesByUid(Integer uid) {
        User user = (User)this.userService.getById(uid);
        if (ObjectUtil.isNull((Object)user)) {
            return "";
        }
        LambdaQueryWrapper qw = Wrappers.lambdaQuery();
        qw.eq(BcxDepartmentMemberServe::getOrgId, (Object)user.getAccount());
        List list = this.bcxDepartmentMemberServeService.list((Wrapper)qw);
        if (list.isEmpty()) {
            return "";
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(BcxDepartmentMember::getBcxId, (Collection)list.stream().map(BcxDepartmentMemberServe::getBcxId).collect(Collectors.toList()));
        List members = this.dao.selectList((Wrapper)lqw);
        if (members.isEmpty()) {
            return "";
        }
        return members.stream().map(BcxDepartmentMember::getName).collect(Collectors.joining(","));
    }
}

