/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.article.Article;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.ArticleRequest;
import com.zbkj.common.request.ArticleSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.ArticleInfoResponse;
import com.zbkj.common.response.ArticleResponse;
import com.zbkj.service.dao.ArticleDao;
import com.zbkj.service.service.ArticleService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArticleServiceImpl
extends ServiceImpl<ArticleDao, Article>
implements ArticleService {
    private final Logger logger = LoggerFactory.getLogger(ArticleServiceImpl.class);
    @Resource
    private ArticleDao dao;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;

    @Override
    public PageInfo<ArticleResponse> getList(String cid, PageParamRequest pageParamRequest) {
        Page articlePage = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Article::getCid, (Object)cid);
        lqw.eq(Article::getStatus, (Object)true);
        lqw.eq(Article::getIsDel, (Object)false);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lqw.orderByDesc((Object[])new SFunction[]{Article::getSort, Article::getId})).orderByDesc(Article::getVisit)).orderByDesc(Article::getCreateTime);
        List articleList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)articleList)) {
            return CommonPage.copyPageInfo((Page)articlePage, (List)CollUtil.newArrayList((Object[])new ArticleResponse[0]));
        }
        List responseList = articleList.stream().map(e -> {
            ArticleResponse articleResponse = new ArticleResponse();
            BeanUtils.copyProperties((Object)e, (Object)articleResponse);
            return articleResponse;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)articlePage, responseList);
    }

    @Override
    public PageInfo<ArticleResponse> getAdminList(ArticleSearchRequest request, PageParamRequest pageParamRequest) {
        Page articlePage = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotNull((Object)request.getCid())) {
            lqw.eq(Article::getCid, (Object)request.getCid());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getTitle())) {
            String title = URLUtil.decode((String)request.getTitle());
            lqw.like(Article::getTitle, (Object)title);
        }
        if (StrUtil.isNotBlank((CharSequence)request.getAuthor())) {
            lqw.eq(Article::getAuthor, (Object)URLUtil.decode((String)request.getAuthor()));
        }
        lqw.eq(Article::getIsDel, (Object)false);
        ((LambdaQueryWrapper)lqw.orderByDesc(Article::getSort)).orderByDesc(Article::getId);
        List articleList = this.dao.selectList((Wrapper)lqw);
        ArrayList<ArticleResponse> responseList = new ArrayList<ArticleResponse>();
        if (CollUtil.isEmpty((Collection)articleList)) {
            return CommonPage.copyPageInfo((Page)articlePage, responseList);
        }
        for (Article article : articleList) {
            ArticleResponse response = new ArticleResponse();
            BeanUtils.copyProperties((Object)article, (Object)response);
            responseList.add(response);
        }
        return CommonPage.copyPageInfo((Page)articlePage, responseList);
    }

    @Override
    public ArticleInfoResponse getVoByFront(Integer id) {
        Article article = (Article)this.getById(id);
        if (ObjectUtil.isNull((Object)article) || article.getIsDel().booleanValue()) {
            throw new CrmebException("\u6587\u7ae0\u4e0d\u5b58\u5728");
        }
        if (!article.getStatus().booleanValue()) {
            throw new CrmebException("\u6587\u7ae0\u4e0d\u5b58\u5728");
        }
        ArticleInfoResponse articleResponse = new ArticleInfoResponse();
        BeanUtils.copyProperties((Object)article, (Object)articleResponse);
        if (this.addArticleVisit(id).booleanValue()) {
            this.logger.error("\u589e\u52a0\u6587\u7ae0\u9605\u8bfb\u6b21\u6570\u5931\u8d25\uff0c\u6587\u7ae0id = {}", (Object)id);
        }
        return articleResponse;
    }

    private Boolean addArticleVisit(Integer id) {
        UpdateWrapper wrapper = Wrappers.update();
        wrapper.setSql("visit = visit + 1");
        wrapper.eq((Object)"id", (Object)id);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<Article> getBannerList() {
        int articleBannerLimit = 5;
        String articleBannerLimitString = this.systemConfigService.getValueByKey("news_slides_limit");
        if (StrUtil.isNotBlank((CharSequence)articleBannerLimitString)) {
            articleBannerLimit = Integer.parseInt(articleBannerLimitString);
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Article::getId, Article::getCover, Article::getTitle});
        lqw.eq(Article::getIsBanner, (Object)true);
        lqw.eq(Article::getStatus, (Object)true);
        lqw.eq(Article::getIsDel, (Object)false);
        lqw.orderByDesc((Object[])new SFunction[]{Article::getSort, Article::getId});
        lqw.last(" limit " + articleBannerLimit);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<ArticleResponse> getHotList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Article::getId, Article::getCover, Article::getTitle, Article::getCreateTime});
        lqw.eq(Article::getIsHot, (Object)true);
        lqw.eq(Article::getStatus, (Object)true);
        lqw.eq(Article::getIsDel, (Object)false);
        lqw.orderByDesc((Object[])new SFunction[]{Article::getSort, Article::getId});
        lqw.last(" limit 20");
        List articleList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)articleList)) {
            return CollUtil.newArrayList((Object[])new ArticleResponse[0]);
        }
        return articleList.stream().map(e -> {
            ArticleResponse articleResponse = new ArticleResponse();
            BeanUtils.copyProperties((Object)e, (Object)articleResponse);
            return articleResponse;
        }).collect(Collectors.toList());
    }

    @Override
    public Boolean create(ArticleRequest articleRequest) {
        Article article = new Article();
        BeanUtils.copyProperties((Object)articleRequest, (Object)article);
        article.setId(null);
        String cdnUrl = this.systemAttachmentService.getCdnUrl();
        article.setCover(this.systemAttachmentService.clearPrefix(article.getCover(), cdnUrl));
        article.setContent(this.systemAttachmentService.clearPrefix(article.getContent(), cdnUrl));
        article.setVisit(Long.valueOf(0L));
        return this.save(article);
    }

    @Override
    public Boolean deleteById(Integer id) {
        Article article = this.getByIdException(id);
        article.setIsDel(Boolean.valueOf(true));
        return this.updateById(article);
    }

    private Article getByIdException(Integer id) {
        Article article = (Article)this.getById(id);
        if (ObjectUtil.isNull((Object)article) || article.getIsDel().booleanValue()) {
            throw new CrmebException("\u6587\u7ae0\u4e0d\u5b58\u5728");
        }
        return article;
    }

    @Override
    public Boolean updateArticle(ArticleRequest articleRequest) {
        if (ObjectUtil.isNull((Object)articleRequest.getId())) {
            throw new CrmebException("\u6587\u7ae0ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.getByIdException(articleRequest.getId());
        Article article = new Article();
        BeanUtils.copyProperties((Object)articleRequest, (Object)article);
        String cdnUrl = this.systemAttachmentService.getCdnUrl();
        article.setCover(this.systemAttachmentService.clearPrefix(article.getCover(), cdnUrl));
        article.setContent(this.systemAttachmentService.clearPrefix(article.getContent(), cdnUrl));
        return this.updateById(article);
    }

    @Override
    public ArticleInfoResponse getDetail(Integer id) {
        Article article = this.getByIdException(id);
        ArticleInfoResponse response = new ArticleInfoResponse();
        BeanUtils.copyProperties((Object)article, (Object)response);
        return response;
    }

    @Override
    public Boolean isUseCategory(Integer categoryId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Article::getCid, (Object)categoryId);
        lqw.eq(Article::getIsDel, (Object)false);
        lqw.eq(Article::getIsDel, (Object)false);
        lqw.last(" limit 1");
        Article article = (Article)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)article);
    }

    @Override
    public List<Article> getIndexHeadline() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Article::getId, Article::getTitle});
        lqw.eq(Article::getIsHot, (Object)true);
        lqw.eq(Article::getStatus, (Object)true);
        lqw.eq(Article::getIsDel, (Object)false);
        lqw.orderByDesc(Article::getSort);
        lqw.last(" limit 10");
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean articleSwitch(Integer id) {
        Article article;
        article.setStatus(Boolean.valueOf((article = this.getByIdException(id)).getStatus() == false));
        return this.updateById(article);
    }
}

