/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.article.ArticleCategory;
import com.zbkj.common.request.ArticleCategoryRequest;
import com.zbkj.common.response.ArticleCategoryResponse;
import com.zbkj.service.dao.ArticleCategoryDao;
import com.zbkj.service.service.ArticleCategoryService;
import com.zbkj.service.service.ArticleService;
import com.zbkj.service.service.SystemAttachmentService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArticleCategoryServiceImpl
extends ServiceImpl<ArticleCategoryDao, ArticleCategory>
implements ArticleCategoryService {
    @Resource
    private ArticleCategoryDao dao;
    @Autowired
    private ArticleService articleService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;

    @Override
    public List<ArticleCategoryResponse> getAdminList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ArticleCategory::getIsDel, (Object)false);
        lqw.orderByDesc((Object[])new SFunction[]{ArticleCategory::getSort, ArticleCategory::getId});
        List categoryList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)categoryList)) {
            return CollUtil.newArrayList((Object[])new ArticleCategoryResponse[0]);
        }
        ArrayList responseList = CollUtil.newArrayList((Object[])new ArticleCategoryResponse[0]);
        for (ArticleCategory category : categoryList) {
            ArticleCategoryResponse response = new ArticleCategoryResponse();
            BeanUtils.copyProperties((Object)category, (Object)response);
            responseList.add(response);
        }
        return responseList;
    }

    @Override
    public Boolean create(ArticleCategoryRequest request) {
        ArticleCategory articleCategory = new ArticleCategory();
        BeanUtils.copyProperties((Object)request, (Object)articleCategory);
        articleCategory.setId(null);
        if (StrUtil.isNotBlank((CharSequence)request.getIcon())) {
            articleCategory.setIcon(this.systemAttachmentService.clearPrefix(articleCategory.getIcon()));
        }
        articleCategory.setStatus(Boolean.valueOf(true));
        return this.save(articleCategory);
    }

    @Override
    public Boolean deleteById(Integer id) {
        ArticleCategory articleCategory = this.getByIdException(id);
        if (this.articleService.isUseCategory(id).booleanValue()) {
            throw new CrmebException("\u6709\u6587\u7ae0\u4f7f\u7528\u6b64\u5206\u7c7b\uff0c\u8bf7\u5148\u4fee\u6539\u5bf9\u5e94\u6587\u7ae0\u5206\u7c7b");
        }
        articleCategory.setIsDel(Boolean.valueOf(true));
        return this.dao.updateById(articleCategory) > 0;
    }

    private ArticleCategory getByIdException(Integer id) {
        ArticleCategory articleCategory = (ArticleCategory)this.getById(id);
        if (ObjectUtil.isNull((Object)articleCategory)) {
            throw new CrmebException("\u6587\u7ae0\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        if (articleCategory.getIsDel().booleanValue()) {
            throw new CrmebException("\u6587\u7ae0\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        return articleCategory;
    }

    @Override
    public Boolean edit(ArticleCategoryRequest request) {
        if (ObjectUtil.isNull((Object)request.getId()) || request.getId() < 1) {
            throw new CrmebException("\u8bf7\u4f20\u5165\u5206\u7c7bID");
        }
        this.getByIdException(request.getId());
        ArticleCategory articleCategory = new ArticleCategory();
        BeanUtils.copyProperties((Object)request, (Object)articleCategory);
        if (StrUtil.isNotBlank((CharSequence)request.getIcon())) {
            articleCategory.setIcon(this.systemAttachmentService.clearPrefix(articleCategory.getIcon()));
        }
        return this.updateById(articleCategory);
    }

    @Override
    public Boolean categorySwitch(Integer id) {
        ArticleCategory articleCategory = this.getByIdException(id);
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(ArticleCategory::getStatus, (Object)(articleCategory.getStatus() == false ? 1 : 0));
        wrapper.eq(ArticleCategory::getId, (Object)id);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<ArticleCategoryResponse> getFrontList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ArticleCategory::getIsDel, (Object)false);
        lqw.eq(ArticleCategory::getStatus, (Object)true);
        lqw.orderByDesc((Object[])new SFunction[]{ArticleCategory::getSort, ArticleCategory::getId});
        List categoryList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)categoryList)) {
            return CollUtil.newArrayList((Object[])new ArticleCategoryResponse[0]);
        }
        ArrayList responseList = CollUtil.newArrayList((Object[])new ArticleCategoryResponse[0]);
        for (ArticleCategory category : categoryList) {
            ArticleCategoryResponse response = new ArticleCategoryResponse();
            BeanUtils.copyProperties((Object)category, (Object)response);
            responseList.add(response);
        }
        return responseList;
    }
}

