/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.zbkj.common.constants.AlipayConfig;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.alipay.AliPayInfo;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.service.service.AliPayInfoService;
import com.zbkj.service.service.AliPayService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserService;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class AliPayServiceImpl
implements AliPayService {
    private static final Logger logger = LoggerFactory.getLogger(AliPayServiceImpl.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private AliPayInfoService aliPayInfoService;

    @Override
    public void refund(String outTradeNo, String refundOrderNo, String refundReasonWapExplain, BigDecimal refundPrice) {
        String out_trade_no = outTradeNo;
        String refund_amount = refundPrice.toString();
        String refund_reason = refundReasonWapExplain;
        String out_request_no = refundOrderNo;
        String aliPayAppid = this.systemConfigService.getValueByKey(AlipayConfig.APPID);
        String aliPayPrivateKey = this.systemConfigService.getValueByKey(AlipayConfig.RSA_PRIVATE_KEY);
        String aliPayPublicKey = this.systemConfigService.getValueByKey(AlipayConfig.ALIPAY_PUBLIC_KEY);
        DefaultAlipayClient client = new DefaultAlipayClient(AlipayConfig.URL, aliPayAppid, aliPayPrivateKey, AlipayConfig.FORMAT, AlipayConfig.CHARSET, aliPayPublicKey, AlipayConfig.SIGNTYPE);
        AlipayTradeRefundRequest alipay_request = new AlipayTradeRefundRequest();
        AlipayTradeRefundModel model = new AlipayTradeRefundModel();
        model.setOutTradeNo(out_trade_no);
        model.setRefundAmount(refund_amount);
        model.setRefundReason(refund_reason);
        model.setOutRequestNo(out_request_no);
        alipay_request.setBizModel((AlipayObject)model);
        logger.info("alipay_request = " + alipay_request);
        AlipayTradeRefundResponse alipay_response = null;
        try {
            alipay_response = (AlipayTradeRefundResponse)client.execute((AlipayRequest)alipay_request);
        }
        catch (AlipayApiException e) {
            logger.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u7533\u8bf7\u5f02\u5e38\uff0calipay_response = " + alipay_response);
            logger.error(e.getMessage());
            throw new CrmebException("\u652f\u4ed8\u5b9d\u652f\u4ed8\u7ed3\u679c\u5f02\u5e38");
        }
        logger.info("alipay_response = " + alipay_response.getBody());
    }

    @Override
    public String pay(String orderNo, BigDecimal price, String orderType, String payChannel) {
        String result;
        AlipayTradeWapPayResponse response;
        if (payChannel.equals("alipayApp")) {
            return this.appPay(orderNo, price, orderType);
        }
        String out_trade_no = orderNo;
        String total_amount = price.toString();
        String subject = this.systemConfigService.getValueByKeyException("site_name");
        String timeout_express = "30m";
        String aliPayAppid = this.systemConfigService.getValueByKey(AlipayConfig.APPID);
        String aliPayPrivateKey = this.systemConfigService.getValueByKey(AlipayConfig.RSA_PRIVATE_KEY);
        String aliPayPublicKey = this.systemConfigService.getValueByKey(AlipayConfig.ALIPAY_PUBLIC_KEY);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(AlipayConfig.URL, aliPayAppid, aliPayPrivateKey, AlipayConfig.FORMAT, AlipayConfig.CHARSET, aliPayPublicKey, AlipayConfig.SIGNTYPE);
        AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
        alipayRequest.setReturnUrl(this.systemConfigService.getValueByKey(orderType.equals("order") ? AlipayConfig.return_url : AlipayConfig.recharge_return_url));
        String apiDomain = this.systemConfigService.getValueByKeyException("api_url");
        alipayRequest.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/alipay");
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(out_trade_no);
        model.setSubject(subject);
        model.setTotalAmount(total_amount);
        model.setTimeoutExpress(timeout_express);
        model.setProductCode("QUICK_WAP_PAY");
        model.setQuitUrl(this.systemConfigService.getValueByKey(orderType.equals("order") ? AlipayConfig.quit_url : AlipayConfig.recharge_quit_url));
        String encode = "type=" + (orderType.equals("order") ? "order" : "recharge");
        try {
            encode = URLEncoder.encode(encode, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new CrmebException("\u652f\u4ed8\u5b9d\u53c2\u6570UrlEncode\u5f02\u5e38");
        }
        model.setPassbackParams(encode);
        alipayRequest.setBizModel((AlipayObject)model);
        logger.info("alipayRequest = " + alipayRequest);
        try {
            response = (AlipayTradeWapPayResponse)alipayClient.pageExecute((AlipayRequest)alipayRequest);
            result = response.getBody();
        }
        catch (AlipayApiException e) {
            logger.error("\u652f\u4ed8\u5b9d\u8ba2\u5355\u751f\u6210\u5931\u8d25," + e.getErrMsg());
            throw new CrmebException(e.getErrMsg());
        }
        logger.info("result = " + result);
        AliPayInfo aliPayInfo = new AliPayInfo();
        aliPayInfo.setAppId(aliPayAppid);
        aliPayInfo.setTimestamp(DateUtil.now());
        aliPayInfo.setBody("");
        aliPayInfo.setSubject(subject);
        aliPayInfo.setOutTradeNo(out_trade_no);
        aliPayInfo.setTimeoutExpress(timeout_express);
        aliPayInfo.setTotalAmount(total_amount);
        aliPayInfo.setPassbackParams(model.getPassbackParams());
        aliPayInfo.setNotifyUrl(alipayRequest.getNotifyUrl());
        aliPayInfo.setCode(Optional.ofNullable(response.getCode()).orElse(""));
        aliPayInfo.setMsg(Optional.ofNullable(response.getMsg()).orElse(""));
        aliPayInfo.setSubCode(Optional.ofNullable(response.getSubCode()).orElse(""));
        aliPayInfo.setSubMsg(Optional.ofNullable(response.getSubMsg()).orElse(""));
        aliPayInfo.setTradeNo(Optional.ofNullable(response.getTradeNo()).orElse(""));
        aliPayInfo.setSellerId(Optional.ofNullable(response.getSellerId()).orElse(""));
        this.aliPayInfoService.save(aliPayInfo);
        return result;
    }

    private String appPay(String orderNo, BigDecimal price, String orderType) {
        String result;
        AlipayTradeAppPayResponse response;
        String out_trade_no = orderNo;
        String total_amount = price.toString();
        String subject = this.systemConfigService.getValueByKeyException("site_name");
        String timeout_express = "30m";
        String aliPayAppid = this.systemConfigService.getValueByKey(AlipayConfig.APPID);
        String aliPayPrivateKey = this.systemConfigService.getValueByKey(AlipayConfig.RSA_PRIVATE_KEY);
        String aliPayPublicKey = this.systemConfigService.getValueByKey(AlipayConfig.ALIPAY_PUBLIC_KEY);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(AlipayConfig.URL, aliPayAppid, aliPayPrivateKey, AlipayConfig.FORMAT, AlipayConfig.CHARSET, aliPayPublicKey, AlipayConfig.SIGNTYPE);
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        model.setSubject(subject);
        model.setOutTradeNo(out_trade_no);
        model.setTimeoutExpress(timeout_express);
        model.setTotalAmount(total_amount);
        model.setProductCode("QUICK_MSECURITY_PAY");
        String encode = "type=" + (orderType.equals("order") ? "order" : "recharge");
        try {
            encode = URLEncoder.encode(encode, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new CrmebException("\u652f\u4ed8\u5b9d\u53c2\u6570UrlEncode\u5f02\u5e38");
        }
        model.setPassbackParams(encode);
        request.setBizModel((AlipayObject)model);
        String apiDomain = this.systemConfigService.getValueByKeyException("api_url");
        request.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/alipay");
        try {
            response = (AlipayTradeAppPayResponse)alipayClient.sdkExecute((AlipayRequest)request);
            result = response.getBody();
        }
        catch (AlipayApiException e) {
            logger.error("\u751f\u6210\u652f\u4ed8\u5b9dapp\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38," + e.getErrMsg());
            throw new CrmebException(e.getErrMsg());
        }
        logger.info("\u652f\u4ed8\u5b9dapp result = " + result);
        AliPayInfo aliPayInfo = new AliPayInfo();
        aliPayInfo.setAppId(aliPayAppid);
        aliPayInfo.setTimestamp(DateUtil.now());
        aliPayInfo.setBody("");
        aliPayInfo.setSubject(subject);
        aliPayInfo.setOutTradeNo(out_trade_no);
        aliPayInfo.setTimeoutExpress(timeout_express);
        aliPayInfo.setTotalAmount(total_amount);
        aliPayInfo.setPassbackParams(model.getPassbackParams());
        aliPayInfo.setNotifyUrl(request.getNotifyUrl());
        aliPayInfo.setCode(Optional.ofNullable(response.getCode()).orElse(""));
        aliPayInfo.setMsg(Optional.ofNullable(response.getMsg()).orElse(""));
        aliPayInfo.setSubCode(Optional.ofNullable(response.getSubCode()).orElse(""));
        aliPayInfo.setSubMsg(Optional.ofNullable(response.getSubMsg()).orElse(""));
        aliPayInfo.setTradeNo(Optional.ofNullable(response.getTradeNo()).orElse(""));
        aliPayInfo.setSellerId(Optional.ofNullable(response.getSellerId()).orElse(""));
        this.aliPayInfoService.save(aliPayInfo);
        return result;
    }
}

