package com.bcxin.obpm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.common.utils.HttpClientUtil;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.service.StampService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zjh
 * @date 2019年1月7日 16:12:00
 */
@Service
public class StampServiceImpl implements StampService {

    private Logger logger = LoggerFactory.getLogger(StampServiceImpl.class);
    @Autowired
    private ConfigUtil configUtils;

    @Override
    public String addStamp(String fileUrl, String type) throws Exception {
        Map<String, Object> parm = new HashMap<String, Object>();
        String top = "";
        String left = "";

        String pfxPath = "D:\\stamp.pfx";
        String xmlPath = "D:\\stamp.xml";
        logger.error("签章开始：文件地址" + fileUrl);
        String pfxPathValue = configUtils.getValueByKey(Constants.STAMP_KEY_URL);
        if (pfxPathValue != null && pfxPathValue != null) {
            pfxPath = pfxPathValue;
        } else {
            throw new Exception("没有配置签章pfx地址");
        }
        String xmlPathValue = configUtils.getValueByKey(Constants.STAMP_XML_URL);
        if (xmlPathValue != null && xmlPathValue != null) {
            xmlPath = xmlPathValue;
        } else {
            throw new Exception("没有配置签章xml地址");
        }

        String pdfPath = fileUrl;
        if ("1".equals(type)) {
            left = "700";
            top = "420";//420
        } else if ("2".equals(type)) {
            left = "160";
            top = "235";
        }
        String xml = Constants.STAMP_XML.replace("{pfxPath}", pfxPath)
                .replace("{xmlPath}", xmlPath)
                .replace("{pdfPath}", pdfPath)
                .replace("{left}", left)
                .replace("{top}", top);

        // 获取签章地址stampURL
        String url;

        String value = configUtils.getValueByKey(Constants.STAMP_URL);
        if (value != null && value != null) {
            url = value;
        } else {
            throw new Exception("没有配置签章地址");
        }
        logger.error("签章内容：" + xml);
        logger.error("签章地址：" + url);
        JSONObject returnMessage = HttpClientUtil.post(url, xml);
        logger.error("签章访问结束，返回数据：" + returnMessage);
        if (returnMessage.get("signResult") != null) {
            if ("1".equals(returnMessage.get("signResult").toString())) {
                return "签章成功";
            } else {
                return "签章失败";
            }
        }else {
            return "返回失败";
        }


    }

}
