package com.bcxin.obpm.ministerial;


import com.bcxin.obpm.annotation.MinisterialAttr;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/**
 * 国籍转换
 * @author linqinglin
 * @date 2021/03/06 0006 13:20
 */
@Component
public class NationalMinDataFormatStrategy implements MinDataFormatStrategy {
    @Override
    public String format(Field columnField, Object data) {

        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }

        Map<String,String> nationalMap = new HashMap<>();
        nationalMap.put("阿鲁巴","ABW");
        nationalMap.put("阿富汗","AFG");
        nationalMap.put("安哥拉","AGO");
        nationalMap.put("安圭拉","AIA");
        nationalMap.put("阿尔巴尼亚","ALB");
        nationalMap.put("安道尔","AND");
        nationalMap.put("荷属安的列斯","ANT");
        nationalMap.put("阿联酋","ARE");
        nationalMap.put("阿根廷","ARG");
        nationalMap.put("亚美尼亚","ARM");
        nationalMap.put("美属萨摩亚","ASM");
        nationalMap.put("南极洲","ATA");
        nationalMap.put("法属南部领土","ATF");
        nationalMap.put("安提瓜和巴布达","ATG");
        nationalMap.put("澳大利亚","AUS");
        nationalMap.put("奥地利","AUT");
        nationalMap.put("阿塞拜疆","AZE");
        nationalMap.put("布隆迪","BDI");
        nationalMap.put("比利时","BEL");
        nationalMap.put("贝宁","BEN");
        nationalMap.put("布基纳法索","BFA");
        nationalMap.put("孟加拉国","BGD");
        nationalMap.put("保加利亚","BGR");
        nationalMap.put("巴林","BHR");
        nationalMap.put("巴哈马","BHS");
        nationalMap.put("波斯尼亚和黑塞哥维那","BIH");
        nationalMap.put("白俄罗斯","BLR");
        nationalMap.put("伯利兹","BLZ");
        nationalMap.put("百幕大","BMU");
        nationalMap.put("玻利维亚","BOL");
        nationalMap.put("巴西","BRA");
        nationalMap.put("巴巴多斯","BRB");
        nationalMap.put("文莱","BRN");
        nationalMap.put("不丹","BTN");
        nationalMap.put("布维岛","BVT");
        nationalMap.put("博茨瓦纳","BWA");
        nationalMap.put("中非","CAF");
        nationalMap.put("加拿大","CAN");
        nationalMap.put("科科斯群岛","CCK");
        nationalMap.put("瑞士","CHE");
        nationalMap.put("智利","CHL");
        nationalMap.put("中国","CHN");
        nationalMap.put("科特迪瓦","CIV");
        nationalMap.put("喀麦隆","CMR");
        nationalMap.put("刚果民主共和国","COD");
        nationalMap.put("刚果","COG");
        nationalMap.put("库克群岛","COK");
        nationalMap.put("哥伦比亚","COL");
        nationalMap.put("科摩罗","COM");
        nationalMap.put("佛得角","CPV");
        nationalMap.put("哥斯达黎加","CRI");
        nationalMap.put("古巴","CUB");
        nationalMap.put("圣诞岛","CXR");
        nationalMap.put("开曼群岛","CYM");
        nationalMap.put("塞浦路斯","CYP");
        nationalMap.put("捷克","CZE");
        nationalMap.put("德国","DEU");
        nationalMap.put("吉布提","DJI");
        nationalMap.put("多米尼加","DMA");
        nationalMap.put("丹麦","DNK");
        nationalMap.put("多米尼家共和国","DOM");
        nationalMap.put("阿尔及利亚","DZA");
        nationalMap.put("厄瓜多尔","ECU");
        nationalMap.put("埃及","EGY");
        nationalMap.put("厄立特里亚","ERI");
        nationalMap.put("西撒哈拉","ESH");
        nationalMap.put("西班牙","ESP");
        nationalMap.put("爱沙尼亚","EST");
        nationalMap.put("埃塞俄比亚","ETH");
        nationalMap.put("芬兰","FIN");
        nationalMap.put("斐济","FJI");
        nationalMap.put("马尔维纳斯群岛","FLK");
        nationalMap.put("法国","FRA");
        nationalMap.put("法罗群岛","FRO");
        nationalMap.put("密克罗尼西亚","FSM");
        nationalMap.put("加蓬","GAB");
        nationalMap.put("英国（独立领土公民、出国不用）","GBD");
        nationalMap.put("英国（海外国民，出国不用）","GBN");
        nationalMap.put("英国（海外公民，出国不用）","GBO");
        nationalMap.put("英国（保护公民，出国不用）","GBP");
        nationalMap.put("英国","GBR");
        nationalMap.put("英国（隶属，出国不用）","GBS");
        nationalMap.put("格鲁吉亚","GEO");
        nationalMap.put("加纳","GHA");
        nationalMap.put("直布罗陀","GIB");
        nationalMap.put("几内亚","GIN");
        nationalMap.put("瓜德罗普","GLP");
        nationalMap.put("冈比亚","GMB");
        nationalMap.put("几内亚比绍","GNB");
        nationalMap.put("赤道几内亚","GNQ");
        nationalMap.put("希腊","GRC");
        nationalMap.put("格林纳达","GRD");
        nationalMap.put("格陵兰","GRL");
        nationalMap.put("危地马拉","GTM");
        nationalMap.put("法属圭亚那","GUF");
        nationalMap.put("关岛","GUM");
        nationalMap.put("圭亚那","GUY");
        nationalMap.put("香港","HKG");
        nationalMap.put("赫德岛和麦克唐纳岛","HMD");
        nationalMap.put("洪都拉斯","HND");
        nationalMap.put("克罗地亚","HRV");
        nationalMap.put("海地","HTI");
        nationalMap.put("匈牙利","HUN");
        nationalMap.put("印度尼西亚","IDN");
        nationalMap.put("印度","IND");
        nationalMap.put("英属印度洋领土","IOT");
        nationalMap.put("爱尔兰","IRL");
        nationalMap.put("伊朗","IRN");
        nationalMap.put("伊拉克","IRQ");
        nationalMap.put("冰岛","ISL");
        nationalMap.put("以色列","ISR");
        nationalMap.put("意大利","ITA");
        nationalMap.put("牙买加","JAM");
        nationalMap.put("约旦","JOR");
        nationalMap.put("日本","JPN");
        nationalMap.put("约翰斯顿岛","JTN");
        nationalMap.put("哈萨克斯坦","KAZ");
        nationalMap.put("肯尼亚","KEN");
        nationalMap.put("吉尔吉斯斯坦","KGZ");
        nationalMap.put("柬埔寨","KHM");
        nationalMap.put("基里巴斯","KIR");
        nationalMap.put("圣基茨和尼维斯","KNA");
        nationalMap.put("韩国（南朝鲜）","KOR");
        nationalMap.put("科威特","KWT");
        nationalMap.put("老挝","LAO");
        nationalMap.put("黎巴嫩","LBN");
        nationalMap.put("利比里亚","LBR");
        nationalMap.put("利比亚","LBY");
        nationalMap.put("圣卢西亚","LCA");
        nationalMap.put("列支敦土登","LIE");
        nationalMap.put("斯里兰卡","LKA");
        nationalMap.put("莱索托","LSO");
        nationalMap.put("立陶宛","LTU");
        nationalMap.put("卢森堡","LUX");
        nationalMap.put("拉脱维亚","LVA");
        nationalMap.put("澳门","MAC");
        nationalMap.put("摩洛哥","MAR");
        nationalMap.put("摩纳哥","MCO");
        nationalMap.put("摩尔多瓦","MDA");
        nationalMap.put("马达加斯加","MDG");
        nationalMap.put("马尔代夫","MDV");
        nationalMap.put("墨西哥","MEX");
        nationalMap.put("马绍尔群岛","MHL");
        nationalMap.put("中途岛","MID");
        nationalMap.put("马其顿","MKD");
        nationalMap.put("马里","MLI");
        nationalMap.put("马耳他","MLT");
        nationalMap.put("缅甸","MMR");
        nationalMap.put("蒙古","MNG");
        nationalMap.put("北马里亚纳","MNP");
        nationalMap.put("莫桑比克","MOZ");
        nationalMap.put("毛里塔尼亚","MRT");
        nationalMap.put("蒙特塞拉特","MSR");
        nationalMap.put("马提尼克","MTQ");
        nationalMap.put("毛里求斯","MUS");
        nationalMap.put("马拉维","MWI");
        nationalMap.put("马来西亚","MYS");
        nationalMap.put("马约特","MYT");
        nationalMap.put("纳米比亚","NAM");
        nationalMap.put("新喀里多尼亚","NCL");
        nationalMap.put("尼日尔","NER");
        nationalMap.put("诺福克岛","NFK");
        nationalMap.put("尼日利亚","NGA");
        nationalMap.put("尼加拉瓜","NIC");
        nationalMap.put("纽埃","NIU");
        nationalMap.put("荷兰","NLD");
        nationalMap.put("挪威","NOR");
        nationalMap.put("尼波尔","NPL");
        nationalMap.put("瑙鲁","NRU");
        nationalMap.put("中间地带","NTZ");
        nationalMap.put("新西兰","NZL");
        nationalMap.put("阿曼","OMN");
        nationalMap.put("巴基斯坦","PAK");
        nationalMap.put("巴拿马","PAN");
        nationalMap.put("皮特凯恩群岛","PCN");
        nationalMap.put("秘鲁","PER");
        nationalMap.put("菲律宾","PHL");
        nationalMap.put("贝劳","PLW");
        nationalMap.put("巴布亚新几内亚","PNG");
        nationalMap.put("波兰","POL");
        nationalMap.put("波多黎各","PRI");
        nationalMap.put("朝鲜","PRK");
        nationalMap.put("葡萄牙","PRT");
        nationalMap.put("巴拉圭","PRY");
        nationalMap.put("巴勒斯坦","PST");
        nationalMap.put("法属菠利尼西亚","PYF");
        nationalMap.put("卡塔尔","QAT");
        nationalMap.put("留尼汪","REU");
        nationalMap.put("罗马尼亚","ROM");
        nationalMap.put("俄罗斯","RUS");
        nationalMap.put("卢旺达","RWA");
        nationalMap.put("沙特阿拉伯","SAU");
        nationalMap.put("苏丹","SDN");
        nationalMap.put("塞内加尔","SEN");
        nationalMap.put("塞尔维亚","SF");
        nationalMap.put("新加坡","SGP");
        nationalMap.put("南乔治亚岛和南桑德韦奇岛","SGS");
        nationalMap.put("圣赫勒拿","SHN");
        nationalMap.put("斯瓦尔巴群岛","SJM");
        nationalMap.put("所罗门群岛","SLB");
        nationalMap.put("塞拉利昂","SLE");
        nationalMap.put("萨尔瓦多","SLV");
        nationalMap.put("圣马力诺","SMR");
        nationalMap.put("索马里","SOM");
        nationalMap.put("圣皮埃尔和密克隆","SPM");
        nationalMap.put("塞班","SS");
        nationalMap.put("圣多美和普林西比","STP");
        nationalMap.put("苏里南","SUR");
        nationalMap.put("斯洛伐克","SVK");
        nationalMap.put("斯洛文尼亚","SVN");
        nationalMap.put("瑞典","SWE");
        nationalMap.put("斯威士兰","SWZ");
        nationalMap.put("锡金","SX");
        nationalMap.put("塞舌尔","SYC");
        nationalMap.put("叙利亚","SYR");
        nationalMap.put("特克斯和凯科斯群岛","TCA");
        nationalMap.put("乍得","TCD");
        nationalMap.put("多哥","TGO");
        nationalMap.put("泰国","THA");
        nationalMap.put("塔吉克斯坦","TJK");
        nationalMap.put("托克劳","TKL");
        nationalMap.put("土库曼斯坦","TKM");
        nationalMap.put("东帝汶","TMP");
        nationalMap.put("汤加","TON");
        nationalMap.put("特立尼达和多巴哥","TTO");
        nationalMap.put("突尼斯","TUN");
        nationalMap.put("土耳其","TUR");
        nationalMap.put("图瓦卢","TUV");
        nationalMap.put("台湾","TWN");
        nationalMap.put("坦桑尼亚","TZA");
        nationalMap.put("乌干达","UGA");
        nationalMap.put("乌克兰","UKR");
        nationalMap.put("美属太平洋各群岛","UMI");
        nationalMap.put("联合国","UN");
        nationalMap.put("联合国","UNA");
        nationalMap.put("联合国","UNO");
        nationalMap.put("乌拉圭","URY");
        nationalMap.put("美国","USA");
        nationalMap.put("乌兹别克斯坦","UZB");
        nationalMap.put("梵蒂冈","VAT");
        nationalMap.put("圣文森特和格林纳丁斯","VCT");
        nationalMap.put("委内瑞拉","VEN");
        nationalMap.put("英属维尔京群岛","VGB");
        nationalMap.put("美属维尔京群岛","VIR");
        nationalMap.put("越南","VNM");
        nationalMap.put("瓦努阿图","VUT");
        nationalMap.put("威克岛","WAK");
        nationalMap.put("瓦利斯和富图纳群岛","WLF");
        nationalMap.put("西萨摩亚","WSM");
        nationalMap.put("无国籍（无国籍人）","XXA");
        nationalMap.put("无国籍（难民）","XXB");
        nationalMap.put("无国籍（未声明国籍）","XXX");
        nationalMap.put("也门","YEM");
        nationalMap.put("南斯拉夫","YUG");
        nationalMap.put("南非","ZAF");
        nationalMap.put("扎伊尔","ZAR");
        nationalMap.put("赞比亚","ZMB");
        nationalMap.put("津巴布韦","ZWE");
        nationalMap.put("国籍不详","ZZZ");


        return nationalMap.get(data);
    }



}
