package com.bcxin.obpm.dto.Ministerial;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 搜索类基类
 * @author Ethan
 */
@Data
public class SearchDto<T> {

    protected String keyword;
    protected List<T> data = new ArrayList<T>();
    //分页参数开始
    protected boolean paging = true;//是否分页,默认分页
    protected Integer pageNum;//页数
    protected Integer numPerPage;//每页显示几条
    protected Long totalCount;

    private Long userid;

    private  String path;

    /***
     * 当前分页数
     */
    private Integer page;

    /***
     * 一页显示几条数据
     */
    private Integer rows;

    /**
     * 所在地县（区）代码
     **/
    private String district;

    private String sort;//排序字段

    private String order;//排序 asc 顺序 or 倒序desc

    /***
     * 数据权限机构区域编码列表
     */
    //private List<Police> areasList;

    /**
     * 所属区域
     */
    private String areaCode;

    /**
     * 机构
     */
    private Long orgId;

    /**
     * 是否公安相关业务 公安人员 机构 角色 等业务
     */
    private boolean policeBusiness = true;

    /**
     * 职级权限 0职级查询 1全部开放
     */
    private String rankAuth="0";

    public Integer getStart() {
        return (this.pageNum == null ? 0:this.pageNum) * (this.numPerPage == null ? 0:this.numPerPage);
    }

}
