package com.bcxin.obpm.dto.Ministerial;

import com.bcxin.auth.common.utils.IocContainer;
import com.bcxin.obpm.ministerial.*;

/**
 * @author linqinglin
 * @date 2021/03/06 0006 10:05
 */
public enum MinisterialDataFormat{


    /**
     * 默认
     */
    DEFAULT{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(DefaultMinDataFormatStrategy.class) ;
        }
    },
    /**
     * 是否有保安员证
     */
    HAVE_ZGCER{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(HaveCerMinDataFormatStrategy.class) ;
        }
    },

    /**
     * 性别
     */
    GENDER{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(GenderMinDataFormatStrategy.class) ;
        }
    },
    /**
     * 照片名
     */
    PHOTONAME{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(PhotoNameMinDataFormatStrategy.class) ;
        }
    },
    /**
     * 0,1 转2 ，1
     */
    BOOLEAN_CHANGE{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(BooleanMinDataFormatStrategy.class) ;
        }
    },
    /**
     * 参军情况
     */
    ENROLLED{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(EnrolledMinDataFormatStrategy.class) ;
        }
    },
    /**
     * 文化程度
     */
    EDU{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(EduMinDataFormatStrategy.class) ;
        }
    },
    /**
     * 民族
     */
    NATION{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(NationMinDataFormatStrategy.class) ;
        }
    },
    /**
     * 国籍
     */
    NATIONAL{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(NationalMinDataFormatStrategy.class) ;
        }
    },
    /**
     * 出生日期
     */
    BIRTH{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(BirthMinDataFormatStrategy.class) ;
        }
    },

    /***
     * 证件类型
     */
    CARD_TYPE {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(CardTypeMinDataFormatStrategy.class) ;
        }
    },

    /***
     * 管理层证件类型
     */
    MANAGER_CARD_TYPE {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(ManagerMinDataFormatStrategy.class) ;
        }
    },

    /***
     * 股东证件类型
     */
    INVESTOR_CARD_TYPE {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(InvestorCardTypeMinDataFormatStrategy.class) ;
        }
    },
    /***
     * 职务
     */
    JOB_type{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(JobTypeMinDataFormatStrategy.class) ;
        }
    },

    /***
     * 职业技能等级
     */
    JOB_LEVEL {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(JobLevelMinDataFormatStrategy.class) ;
        }
    },

    /***
     * 万元金额转元
     */
    AMOUNT{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(AmountFormatStrategy.class) ;
        }
    },
    /***
     * 服务范围
     */
    SECURITYSCOPETYPE{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(SecurityScopeTypeFormatStrategy.class) ;
        }
    },
    /***
     * 公司类型
     */
    COMPANYTYPE{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(CompanyTypeFormatStrategy.class) ;
        }
    },

    /**
     * 机构类型
     */
    INSTITUTION_TYPE {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
           return IocContainer.getObject(InstitutionTypeMinDataFormatStrategy.class) ;
        }
    },

    /**
     * 机构类型转类型编码
     */
    INSTITUTION_TYPE_TO_CODE {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(InstitutionTypeCodeMinDataFormatStrategy.class) ;
        }
    },

    /**
     * 公安机构代码
     */
    POLICE_ORG_CODE {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(PoliceOrgCodeMinDataFormatStrategy.class) ;
        }
    },

    /**
     * 照片转base64
     */
    PHOTO_TO_BASE64 {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(PhotoMinDataFormatStrategy.class) ;
        }
    },

    /**
     * 出资金额比例小数占比转百分比
     */
    CONVERSION_TO_PERCENT {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(StockDataFormatStrategy.class) ;
        }
    },

    /**
     * 出资金额改元
     */
    CONVERSION_TO_YUAN {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(YuanDataFormatStrategy.class) ;
        }
    },

    /**
     * 去掉京公保服/号
     */
    REMOVE_CHINESE {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(RemoveDataFormatStrategy.class) ;
        }
    },
    ECONOMIC_TYPE{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return IocContainer.getObject(RemoveDataFormatStrategy.class) ;
        }
    }
    ;


    public abstract MinDataFormatStrategy getMinDataFormatStrategy();


}