package com.bcxin.obpm.domain;

import com.bcxin.auth.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * v5保安员对象 tlk_securityman
 * 
 * @author lin
 * @date 2021-06-06
 */
@Data
public class ObpmSecurityMan extends BaseEntity {

    private static final long serialVersionUID = 1L;


    /**
     * 身份证号
     * ITEM_documentID
     */
    private String idnum;

    /**
     * 姓名
     * ITEM_securityName
     */
    private String name;

    /**
     * 头像
     * ITEM_headPhoto
     */
    private String imgPath;

    /**
     * 认证结果
     * ITEM_shiming
     */
    private String authStatus;

    /**
     * 认证结果描述
     * ITEM_beizhu
     */
    private String authResult;

    /**
     * 认证时间
     * ITEM_LastAuthTime
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date authDate;

}
