package com.bcxin.auth.system.util;

import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.common.utils.spring.SpringUtils;
import com.bcxin.auth.system.domain.SysConfig;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.obpm.service.BackgroundService;
import com.bcxin.zw.service.ZWService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2021/04/29 0029 17:33
 */
@Service
public class ConfigUtil {

    @Value("${file.mode.host}")
    private String host;

    @Value("${file.mode.userName}")
    private String userName;

    @Value("${file.mode.password}")
    private String password;

    @Value("${file.mode.port}")
    private Integer port;

    @Value("${file.mode.useFtp}")
    private boolean useFtp;

    public Boolean getUseFtp() {
        return useFtp;
    }

    public String getHost() {
        return host;
    }

    public String getUserName() {
        return userName;
    }

    public String getPassword() {
        return password;
    }

    public Integer getPort() {
        return port;
    }

    public String getFilePath() {
        return filePath;
    }

    @Value("${file.mode.filePath}")
    private String filePath;


    /***
     * 认证地址
     */
    @Value("${obpm.datasource.drive-class-name}")
    private String dbType;

    @Autowired
    private ISysConfigService configService;
    /**
     * 判断当前是否内网
     * @return
     */
    public boolean isIntranet(){
        String intranet = configService.selectConfigByKey(Constants.INTRANET);
        if(Constants.Y.equals(intranet)){
            return true;
        }
        return false;
    }
    /**
     * 判断当前是否公安网
     * @return
     */
    public boolean isPolice(){
        String police = configService.selectConfigByKey(Constants.POLICE);
        if(Constants.Y.equals(police)){
            return true;
        }
        return false;
    }

    /**
     * 湖南实人认证
     * 判断当前是否为湖南政务网
     * @return
     */

    public boolean isHNAuth(){
        String hnAuth = configService.selectConfigByKey(Constants.HN_AUTH);
        if(Constants.Y.equals(hnAuth)){
            return true;
        }
        return false;
    }

    public String getValueByKey(String key){
        String value = configService.selectConfigByKey(key);
        return value;
    }
    /**
     * 判断当前是否测试
     * @return
     */
    public boolean isTest(){
        String test = configService.selectConfigByKey(Constants.TEST);
        if(Constants.Y.equals(test)){
            return true;
        }
        return false;
    }
    /**
     * 判断当前是否测试保存
     * @return
     */
    public boolean isTestSave(){
        String test = configService.selectConfigByKey(Constants.TESTSAVE);
        if(Constants.N.equals(test)){
            return false;
        }
        return true;
    }

    /**
     * 是否华为高斯数据库
     * @return
     */
    public boolean isGSDB(){
        if(dbType.equals("org.postgresql.Driver")){
            return true;
        }
        return false;
    }


    public boolean toFtp(){
        String toftp = configService.selectConfigByKey(Constants.TOFTP);
        if(Constants.Y.equals(toftp)){
            return true;
        }
        return false;
    }

    public String getDemoPath() {
        return configService.selectConfigByKey(Constants.DEMO_PATH);
    }

    public String getV5URL() {
        return configService.selectConfigByKey(Constants.V5URL);
    }

    public String getV5IPURL() {
        return configService.selectConfigByKey(Constants.V5IPURL);
    }

    public String getLocalHostURL() {
        return configService.selectConfigByKey(Constants.LOCAL_HOST_URL);
    }


    public String getCurrentProvince() {
        return configService.selectConfigByKey(Constants.CURRENT_PROVINCE);
    }

    public String getCurrentNativeShort() {
        return configService.selectConfigByKey(Constants.CURRENT_Native_SHORT);
    }

    public String getCurrentNative() {
        return configService.selectConfigByKey(Constants.CURRENT_NATIVE);
    }

    public String getCurrentNativeName() {
        return configService.selectConfigByKey(Constants.CURRENT_NATIVE_NAME);
    }

    public BackgroundService getBackGroupService() {
        return SpringUtils.getBean("backgroundService_"+getCurrentProvince());
    }

    public ZWService getZWService() {
        return SpringUtils.getBean("zwService_"+getCurrentProvince());
    }

    public String getTimeUrl() {
        return configService.selectConfigByKey(Constants.SRC_HOST);
    }

    public String getTargetTimeUrl() {
        return configService.selectConfigByKey(Constants.TARGET_HOST);
    }

    public String getDataSyncFtpUrl() {
        return configService.selectConfigByKey(Constants.FTP_HOST);
    }

    public String getCreated() {
        return configService.selectConfigByKey(Constants.CREATED);
    }

    public List<String> getUnRemindList() {
        return  configService.selectConfigByKeyList(Constants.BEIJING_BG);
    }
}
