package com.bcxin.auth.schedule;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.system.domain.PerCerDto;
import com.bcxin.auth.system.service.PerCerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Auther panxianwei
 * @date 2022/1/20 9:28
 */
@Component("uploadPrintRecordTask")
public class UploadPrintRecordTask {
    private static Logger logger = LoggerFactory.getLogger(DataSyncFileTask.class);


    @Autowired
    private PerCerService perCerService;

    private boolean lock = false;

    public void run() {
        if (lock) {
            return;
        }
        lock = true;

        try {
            System.out.println("打印定时器启动");
            //查询已打印未生成打印记录的数据
            List<PerCerDto> perCerDtos =perCerService.findUnUploadRecord();
            for (PerCerDto perCerDto:perCerDtos
                 ) {
                String body=perCerService.generatePrintRecord(perCerDto);
                JSONObject object = JSONObject.parseObject(body);
                //string
                String s = object.getString("msg");
                if (s.equals("success")){
                    perCerDto.setCallBackResult(body);
                    perCerDto.setCallBackState(true);
                    perCerService.update(perCerDto);
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        } finally {
            System.out.println("打印定时器关闭");
            lock = false;
        }
    }

}
