package com.bcxin.platform.framework.config.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import javax.sql.DataSource;

/**
 * Mybatis支持*匹配扫描包
 * 
 * @author task
 */
@Configuration
@MapperScan(basePackages = "com.bcxin.oaflow.mapper", sqlSessionFactoryRef = "oaflowSqlSessionFactory")
public class OaFlowDSConfig
{
    private final String mapperLocation = "classpath:mapper/oaflow/*.xml";


    @Bean(name = "oaflowDataSource")
    @ConfigurationProperties(prefix = "oaflow.datasource")
    public DataSource oaflowDataSource() {
        return new DruidDataSource();
    }

    /**
     * 事务 只查询则不需要
     * @param obpmDataSource
     * @return
     * @throws Exception
     */
    //@Bean(name = "oaflowTransactionManager")
    //@ConditionalOnBean(name = "oaflowDataSource")
    //public DataSourceTransactionManager oaflowTransactionManager(@Qualifier("oaflowDataSource") DataSource oaflowDataSource) {
    //    return new DataSourceTransactionManager(oaflowDataSource);
    //}

    @Bean(name = "oaflowSqlSessionFactory")
    @ConditionalOnBean(name = "oaflowDataSource")
    public SqlSessionFactory oaflowSqlSessionFactory(@Qualifier("oaflowDataSource") DataSource oaflowDataSource)
            throws Exception {
        final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(oaflowDataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver()
                .getResources(mapperLocation));
        return sessionFactory.getObject();
    }
}