/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.util.file;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.RandomUtil;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.util.file.BcxinStringUtils;
import com.bcxin.platform.util.file.obs.OBSUtil;
import com.bcxin.platform.util.file.oss.OSSServiceExecutor;
import com.bcxin.platform.util.file.oss.OSSServiceInternetExecutor;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class BcxinFileUtils {
    private static final Logger log = LoggerFactory.getLogger(BcxinFileUtils.class);
    private static final String DEFAULT_UPLOAD_DIR = "upload";
    private static final String DEFAULT_UPLOAD_LINUX = "/data/upload/saas/";
    private static final String DEFAULT_TEMP_DIR = "temp";
    private static final String QRCODE_DIR = "qrcode";

    public static Map<String, String> saveFile(String uploadPath, MultipartFile multipartFile) {
        if (multipartFile != null) {
            try {
                Date now = new Date();
                String materialFileName = now.getTime() + BcxinStringUtils.random(5) + ".";
                String fileType = Files.getFileExtension((String)multipartFile.getOriginalFilename());
                materialFileName = materialFileName + fileType;
                String dirDate = DateUtil.today();
                File dir = new File(uploadPath + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String url = "public/common/file/get-resource?path=" + dirDate + "/" + materialFileName;
                String targetPath = uploadPath + dirDate + "/" + materialFileName;
                File targetFile = new File(targetPath);
                log.info("\u6267\u884c\u672c\u5730\u6587\u4ef6\u4e0a\u4f20..." + targetFile);
                multipartFile.transferTo(targetFile);
                HashMap map = Maps.newHashMap();
                map.put("url", url);
                map.put("key", "local_" + now.getTime());
                if (map == null || map.size() < 2) {
                    log.info("\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
                } else {
                    log.info("\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u6210\u529f!");
                }
                return map;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static String aliOSSFileUpload(MultipartFile xFile, String envi) {
        String fileType = Files.getFileExtension((String)xFile.getOriginalFilename());
        String randomNumber = DateUtil.current((boolean)false) + RandomUtil.randomNumbers((int)6);
        String fileName = randomNumber + "." + fileType;
        String directoryName = DateUtil.today();
        String ossKey = "upload/" + DateUtil.today() + "/" + fileName;
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor(envi);
        if (!ossExecutor.isExitsDirectory(directoryName)) {
            ossExecutor.createDirectory(directoryName);
        }
        try (InputStream inputStream = xFile.getInputStream();){
            ossExecutor.put(ossKey, inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
        }
        return ossExecutor.getServer() + ossKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String huaweiOBSFileUpload(MultipartFile xFile, String envi) {
        String fileType = Files.getFileExtension((String)xFile.getOriginalFilename());
        String randomNumber = DateUtil.current((boolean)false) + RandomUtil.randomNumbers((int)6);
        String fileName = randomNumber + "." + fileType;
        String directoryName = "upload/" + DateUtil.today() + "/";
        String ossKey = "upload/" + DateUtil.today() + "/" + fileName;
        OBSUtil obsUtil = new OBSUtil(envi);
        try (InputStream inputStream = xFile.getInputStream();){
            String string = obsUtil.put(directoryName, ossKey, inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String thumb_huaweiOBSFileUpload(MultipartFile xFile, String readPath, String envi) {
        readPath = readPath.replace("%2F", "/");
        String floot = readPath.split("upload/")[1];
        String fileType = Files.getFileExtension((String)floot);
        String directoryName = "upload/" + floot.split("/")[0] + "/";
        String ossKey = "upload/" + floot.replace("." + fileType, "_THUMB." + fileType);
        OBSUtil obsUtil = new OBSUtil(envi);
        try (InputStream inputStream = xFile.getInputStream();){
            String thumb = DEFAULT_UPLOAD_LINUX + UUID.randomUUID().toString() + "." + fileType;
            BcxinFileUtils.imageOp(inputStream, thumb, 100, 100);
            String string = obsUtil.put(directoryName, ossKey, new FileInputStream(new File(thumb)));
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void imageOp(InputStream inputStream, String outPath, int width, int height) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(inputStream);
        }
        catch (IOException e) {
            System.out.println("file path error...");
        }
        int originalImageWidth = ((Image)image).getWidth(null);
        int originalImageHeight = ((Image)image).getHeight(null);
        BufferedImage originalImage = new BufferedImage(originalImageWidth, originalImageHeight, 5);
        Graphics2D g2d = originalImage.createGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        BufferedImage changedImage = new BufferedImage(width, height, 5);
        double widthBo = (double)width / (double)originalImageWidth;
        double heightBo = (double)width / (double)originalImageHeight;
        AffineTransform transform = new AffineTransform();
        transform.setToScale(widthBo, heightBo);
        AffineTransformOp ato = new AffineTransformOp(transform, null);
        ato.filter(originalImage, changedImage);
        FileOutputStream smallImage = null;
        try {
            smallImage = new FileOutputStream(outPath);
            ImageIO.write((RenderedImage)changedImage, "jpeg", smallImage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (smallImage != null) {
                try {
                    smallImage.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String huaweiOBSFileUploadForBlob(MultipartFile xFile, String envi) {
        String fileType = Files.getFileExtension((String)xFile.getOriginalFilename());
        if (StringUtils.isEmpty((String)fileType)) {
            fileType = xFile.getOriginalFilename();
        }
        if ("blob".equals(fileType)) {
            fileType = "mp3";
        }
        String randomNumber = DateUtil.current((boolean)false) + RandomUtil.randomNumbers((int)6);
        String fileName = randomNumber + "." + fileType;
        String directoryName = "upload/" + DateUtil.today() + "/blob/";
        String ossKey = directoryName + fileName;
        OBSUtil obsUtil = new OBSUtil(envi);
        try (InputStream inputStream = xFile.getInputStream();){
            String string = obsUtil.put(directoryName, ossKey, inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String huaweiOBSFileUpload(File file, String envi, String fileType) {
        String randomNumber = DateUtil.current((boolean)false) + RandomUtil.randomNumbers((int)6);
        String fileName = randomNumber + "." + fileType;
        String directoryName = "upload/" + DateUtil.today() + "/";
        String ossKey = "upload/" + DateUtil.today() + "/" + fileName;
        OBSUtil obsUtil = new OBSUtil(envi);
        try (BufferedInputStream inputStream = FileUtil.getInputStream((File)file);){
            String string = obsUtil.put(directoryName, ossKey, inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String huaweiLocalFileUpload(File file, String date, String envi) {
        String directoryName = "upload/" + date + "/";
        String ossKey = "upload/" + date + "/" + file.getName();
        OBSUtil obsUtil = new OBSUtil(envi);
        try (BufferedInputStream inputStream = FileUtil.getInputStream((File)file);){
            String string = obsUtil.put(directoryName, ossKey, inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String huaweiBase64Upload(String base64File, String fileName, String date, String envi) {
        byte[] bytes;
        String directoryName = "upload/" + date + "/";
        String ossKey = "upload/" + date + "/" + fileName;
        OBSUtil obsUtil = new OBSUtil(envi);
        try {
            bytes = new BASE64Decoder().decodeBuffer(base64File);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            String string = obsUtil.put(directoryName, ossKey, inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String aliOSSFileTempUpload(File xFile, String envi) {
        String fileType = Files.getFileExtension((String)xFile.getName());
        String randomNumber = DateUtil.current((boolean)false) + RandomUtil.randomNumbers((int)6);
        String fileName = randomNumber + "." + fileType;
        String directoryName = DateUtil.today();
        String ossKey = "temp/" + DateUtil.today() + "/" + fileName;
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor(envi);
        if (!ossExecutor.isExitsDirectory(directoryName)) {
            ossExecutor.createDirectory(directoryName);
        }
        try (FileInputStream inputStream = new FileInputStream(xFile);){
            ossExecutor.put(ossKey, inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
        }
        return ossExecutor.getServer() + ossKey;
    }

    public static String aliOSSFixFileTempUpload(File xFile, String envi) {
        String fileName = xFile.getName();
        String directoryName = DateUtil.today();
        String ossKey = "temp/" + DateUtil.today() + "/" + fileName;
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor(envi);
        if (!ossExecutor.isExitsDirectory(directoryName)) {
            ossExecutor.createDirectory(directoryName);
        }
        try (FileInputStream inputStream = new FileInputStream(xFile);){
            ossExecutor.put(ossKey, inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
        }
        return ossExecutor.getServer() + ossKey;
    }

    public static String aliOSSFileQrCodeUpload(File xFile, String envi) {
        String fileType = Files.getFileExtension((String)xFile.getName());
        String randomNumber = DateUtil.current((boolean)false) + RandomUtil.randomNumbers((int)6);
        String fileName = randomNumber + "." + fileType;
        String directoryName = DateUtil.today();
        String ossKey = "qrcode/" + DateUtil.today() + "/" + fileName;
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor(envi);
        if (!ossExecutor.isExitsDirectory(directoryName)) {
            ossExecutor.createDirectory(directoryName);
        }
        try (FileInputStream inputStream = new FileInputStream(xFile);){
            ossExecutor.put(ossKey, inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
        }
        return ossExecutor.getServer() + ossKey;
    }

    public static String aliOSSFileUploadAsync(MultipartFile xFile, String envi) {
        String fileType = Files.getFileExtension((String)xFile.getOriginalFilename());
        String randomNumber = DateUtil.current((boolean)false) + RandomUtil.randomNumbers((int)6);
        String fileName = randomNumber + "." + fileType;
        String directoryName = DateUtil.today();
        String ossKey = "upload/" + DateUtil.today() + "/" + fileName;
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor(envi);
        if (!ossExecutor.isExitsDirectory(directoryName)) {
            ossExecutor.createDirectory(directoryName);
        }
        new Thread(() -> {
            try (InputStream inputStream = xFile.getInputStream();){
                ossExecutor.put(ossKey, inputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
            }
        }).start();
        return ossExecutor.getServer() + ossKey;
    }

    public static String aliOSSFileUploadInternet(MultipartFile xFile, String envi) {
        String fileType = Files.getFileExtension((String)xFile.getOriginalFilename());
        String randomNumber = DateUtil.current((boolean)false) + RandomUtil.randomNumbers((int)6);
        String fileName = randomNumber + "." + fileType;
        String directoryName = DateUtil.today();
        String ossKey = "upload/" + DateUtil.today() + "/" + fileName;
        OSSServiceInternetExecutor ossExecutor = new OSSServiceInternetExecutor(envi);
        if (!ossExecutor.isExitsDirectory(directoryName)) {
            ossExecutor.createDirectory(directoryName);
        }
        try (InputStream inputStream = xFile.getInputStream();){
            ossExecutor.put(ossKey, inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
        return ossExecutor.getServer() + ossKey;
    }

    public static String getInputStreamByUrl(String imgURL) {
        ByteArrayOutputStream outPut = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            URL url = new URL(imgURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            if (conn.getResponseCode() != 200) {
                return "fail";
            }
            try (InputStream inStream = conn.getInputStream();){
                int len = -1;
                while ((len = inStream.read(data)) != -1) {
                    outPut.write(data, 0, len);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(outPut.toByteArray());
    }

    public static void downloadBase64(HttpServletResponse response, String base64Code) throws IOException {
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + DateUtil.current((boolean)true) + ".pdf");
            byte[] bytes = new BASE64Decoder().decodeBuffer(base64Code);
            try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                byte[] buffer = new byte[1024];
                int byteRead = 0;
                while ((byteRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, byteRead);
                }
                out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File multipartFileToFile(MultipartFile file) throws Exception {
        File toFile = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            if (file.equals("") || file.getSize() <= 0L) {
                File file2 = null;
                return file2;
            }
            is = file.getInputStream();
            toFile = new File(file.getOriginalFilename());
            os = new FileOutputStream(toFile);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return toFile;
    }

    public static void deleteFolder(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    BcxinFileUtils.deleteFolder(f);
                }
                file.delete();
            } else {
                file.delete();
            }
        }
    }
}

