/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.oauth;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.obpm.domain.ObpmUser;
import com.bcxin.obpm.mapper.ObpmDepartmentMapper;
import com.bcxin.obpm.mapper.ObpmUserMapper;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.dto.oauth.AccessToken;
import com.bcxin.platform.dto.oauth.OAuthTokenxRequest;
import com.bcxin.platform.mapper.company.ComDepartMapper;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.service.oauth.OAuthService;
import com.bcxin.platform.service.oauth.RedisUtil;
import com.bcxin.platform.service.system.ISysConfigService;
import com.bcxin.platform.util.AESUtil;
import com.github.pagehelper.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Hex;
import org.apache.oltu.oauth2.as.issuer.MD5Generator;
import org.apache.oltu.oauth2.as.issuer.OAuthIssuerImpl;
import org.apache.oltu.oauth2.as.issuer.ValueGenerator;
import org.apache.oltu.oauth2.as.response.OAuthASResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.OAuthResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class OAuthServiceImpl
implements OAuthService {
    private static Logger logger = LoggerFactory.getLogger(OAuthServiceImpl.class);
    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;
    @Resource
    private RedisUtil redisUtil;
    @Autowired
    private ISysConfigService sysConfigService;
    @Resource
    private ObpmUserMapper obpmUserMapper;
    @Resource
    private ObpmDepartmentMapper obpmDepartmentMapper;
    @Resource
    private ComDepartMapper comDepartMapper;

    @Override
    public Result saveDispatch(HttpServletRequest request, HttpServletResponse response, String clientType) throws Exception {
        OAuthTokenxRequest oauthRequest = new OAuthTokenxRequest(request);
        Map<Boolean, OAuthResponse> handleResult = this.handle(oauthRequest, clientType);
        if (handleResult.containsKey(true)) {
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", handleResult.get(true) == null ? null : JSON.parse((String)handleResult.get(true).getBody()));
        }
        return Result.fail((String)(handleResult.get(false) == null ? "\u53c2\u6570\u9519\u8bef\uff01" : JSON.parseObject((String)handleResult.get(false).getBody()).getString("error_description")));
    }

    private Map<Boolean, OAuthResponse> handle(OAuthTokenxRequest oauthRequest, String clientType) throws OAuthProblemException, OAuthSystemException {
        HashMap<Boolean, OAuthResponse> result = new HashMap<Boolean, OAuthResponse>();
        OAuthResponse validateResponse = null;
        String userName = oauthRequest.getUsername();
        String passWord = oauthRequest.getPassword();
        String publicKey = oauthRequest.getPublicKey();
        if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)passWord) || StringUtils.isEmpty((String)publicKey)) {
            validateResponse = OAuthResponse.errorResponse((int)400).setError("invalid_grant").setErrorDescription("\u53c2\u6570\u9519\u8bef").buildJSONMessage();
            result.put(false, validateResponse);
            return result;
        }
        try {
            byte[] bytes = publicKey.getBytes();
            byte[] data = Hex.decodeHex((char[])passWord.toCharArray());
            byte[] s = new byte[]{};
            s = AESUtil.AES_CBC_Decrypt(data, bytes, bytes);
            passWord = new String(s);
            if (!userName.equals(passWord)) {
                validateResponse = OAuthResponse.errorResponse((int)400).setError("invalid_grant").setErrorDescription("\u7528\u6237\u6216\u8005\u5bc6\u7801\u9519\u8bef").buildJSONMessage();
                result.put(false, validateResponse);
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PerBaseInfo perBaseInfo = this.perBaseInfoMapper.selectPerBaseInfoByTlkId(userName);
        if (perBaseInfo == null) {
            validateResponse = OAuthResponse.errorResponse((int)400).setError("invalid_grant").setErrorDescription("\u7528\u6237\u4e0d\u5b58\u5728").buildJSONMessage();
            result.put(false, validateResponse);
            return result;
        }
        OAuthResponse oAuthResponse = this.handleAfterValidation(oauthRequest.getRedirectURI(), clientType, perBaseInfo);
        result.put(true, oAuthResponse);
        return result;
    }

    private OAuthResponse handleAfterValidation(String redirectURI, String clientType, PerBaseInfo perBaseInfo) throws OAuthProblemException, OAuthSystemException {
        AccessToken accessToken = this.retrieveAccessToken(clientType, perBaseInfo);
        OAuthResponse tokenResponse = this.createTokenResponse(redirectURI, accessToken);
        return tokenResponse;
    }

    private OAuthResponse createTokenResponse(String redirectURI, AccessToken accessToken) throws OAuthSystemException {
        OAuthASResponse.OAuthTokenResponseBuilder builder = OAuthASResponse.tokenResponse((int)200).location(redirectURI).setAccessToken(accessToken.getTokenId()).setExpiresIn(String.valueOf(accessToken.currentTokenExpiredSeconds())).setTokenType(accessToken.getTokenType());
        String refreshToken = accessToken.getRefreshToken();
        if (StringUtils.isNotEmpty((String)refreshToken)) {
            builder.setRefreshToken(refreshToken);
        }
        if (StringUtils.isNotEmpty((String)redirectURI)) {
            builder.setParam("redirect_uri", redirectURI);
        }
        return builder.buildJSONMessage();
    }

    @Override
    public AccessToken getAccessToken(String clientType, PerBaseInfo perBaseInfo) throws OAuthSystemException {
        String loginId = perBaseInfo.getPerId() + "";
        AccessToken accessToken = null;
        String value = this.redisUtil.getStringCache(loginId);
        if (StringUtils.isNotEmpty((String)value) && (accessToken = (AccessToken)this.redisUtil.getCache(value)) != null) {
            return accessToken;
        }
        accessToken = this.createAccessToken(perBaseInfo, clientType);
        return accessToken;
    }

    private AccessToken retrieveAccessToken(String clientType, PerBaseInfo perBaseInfo) throws OAuthSystemException {
        String loginId = perBaseInfo.getPerId() + "";
        AccessToken accessToken = null;
        String value = this.redisUtil.getStringCache(loginId);
        if (StringUtils.isNotEmpty((String)value) && (accessToken = (AccessToken)this.redisUtil.getCache(value)) != null) {
            this.redisUtil.delete(loginId);
            this.redisUtil.delete(accessToken.getTokenId());
        }
        accessToken = this.createAccessToken(perBaseInfo, clientType);
        return accessToken;
    }

    private AccessToken createAccessToken(PerBaseInfo perBaseInfo, String clientType) throws OAuthSystemException {
        OAuthIssuerImpl oauthIssuer = new OAuthIssuerImpl((ValueGenerator)new MD5Generator());
        String accessTokenString = oauthIssuer.accessToken();
        AccessToken accessToken = null;
        int seconds = 0;
        if (clientType.equals("1")) {
            seconds = 86400;
        } else if (clientType.equals("2")) {
            seconds = 2592000;
        }
        accessToken = new AccessToken();
        accessToken.setComId(perBaseInfo.getComId().toString());
        accessToken.setPerId(perBaseInfo.getPerId().toString());
        ObpmUser obpmUser = this.obpmUserMapper.selectObpmUserById(perBaseInfo.getTlkPerId());
        if (obpmUser != null) {
            if ("true".equals(obpmUser.getISDOMAINUSER())) {
                accessToken.setDomainAdmin(true);
            } else {
                List<String> tlkDepartIds = this.obpmDepartmentMapper.getAdminDepartIds(perBaseInfo.getTlkPerId());
                if (tlkDepartIds.size() > 0) {
                    List<String> departIds = this.comDepartMapper.findByTlkIds(tlkDepartIds);
                    accessToken.setAdminOrgIds(JSON.toJSONString(departIds));
                }
            }
        }
        accessToken.setName(perBaseInfo.getName());
        accessToken.setTokenId(accessTokenString);
        accessToken.setTokenExpiredSeconds(seconds);
        accessToken.setRefreshToken(oauthIssuer.refreshToken());
        this.redisUtil.putStringCache(perBaseInfo.getPerId() + "", accessTokenString, seconds);
        this.redisUtil.putCache(accessTokenString, accessToken, seconds);
        return accessToken;
    }

    @Override
    public AccessToken getAccessToken(String access_token) {
        AccessToken accessToken = (AccessToken)this.redisUtil.getCache(access_token);
        if (accessToken != null && accessToken.tokenExpired()) {
            accessToken = null;
        }
        return accessToken;
    }

    @Override
    public AccessToken getAccessToken(String access_token, boolean userV5Token) {
        AccessToken accessToken = this.getAccessToken(access_token);
        if (accessToken == null && userV5Token) {
            try {
                String v5Url = this.sysConfigService.selectConfigByKey("TLK_URL");
                if (StringUtil.isEmpty((String)v5Url)) {
                    return null;
                }
                v5Url = v5Url + "?accessToken=" + access_token;
                System.err.println("====>getAccessToken.v5Url:" + v5Url);
                String result = HttpUtil.get((String)v5Url);
                System.err.println("====>getAccessToken.result:" + result);
                Result tlkResult = (Result)JSON.parseObject((String)result, Result.class);
                Map resultMap = (Map)JSON.parseObject((String)tlkResult.getData().toString(), Map.class);
                String tlkUserId = !ObjectUtil.isNull(resultMap.get("id")) ? resultMap.get("id").toString() : "";
                PerBaseInfo perBaseInfo = this.perBaseInfoMapper.selectPerBaseInfoByTlkId(tlkUserId);
                if (perBaseInfo == null) {
                    throw new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728\uff1a" + tlkUserId);
                }
                accessToken = new AccessToken();
                accessToken.setComId(perBaseInfo.getComId().toString());
                accessToken.setPerId(perBaseInfo.getPerId().toString());
                ObpmUser obpmUser = this.obpmUserMapper.selectObpmUserById(perBaseInfo.getTlkPerId());
                if (obpmUser != null) {
                    if ("true".equals(obpmUser.getISDOMAINUSER()) || "1".equals(obpmUser.getISDOMAINUSER())) {
                        accessToken.setDomainAdmin(true);
                    } else {
                        List<String> tlkDepartIds = this.obpmDepartmentMapper.getAdminDepartIds(perBaseInfo.getTlkPerId());
                        if (tlkDepartIds.size() > 0) {
                            List<String> departIds = this.comDepartMapper.findByTlkIds(tlkDepartIds);
                            accessToken.setAdminOrgIds(JSON.toJSONString(departIds));
                        }
                    }
                }
                accessToken.setName(perBaseInfo.getName());
                accessToken.setTokenExpiredSeconds(86400);
                accessToken.setTokenId(access_token);
                this.redisUtil.putStringCache(perBaseInfo.getPerId() + "", access_token, accessToken.getTokenExpiredSeconds());
                this.redisUtil.putCache(access_token, accessToken, accessToken.getTokenExpiredSeconds());
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("v5_access_token\u9519\u8bef\uff01");
                return null;
            }
        }
        return accessToken;
    }

    public static void main(String[] args) throws Exception {
        String userName = "15601000000";
        String passWord = "86b955d41be7a1ce4b8db67da688103e";
        String publicKey = "wdMFAbNpSmRJEmOl";
        if (StringUtils.isNotEmpty((String)publicKey)) {
            byte[] bytes = publicKey.getBytes();
            byte[] data = Hex.decodeHex((char[])passWord.toCharArray());
            byte[] s = AESUtil.AES_CBC_Decrypt(data, bytes, bytes);
            passWord = new String(s);
            System.out.println(passWord);
        }
    }
}

