package com.bcxin.platform.service.meeting;

import com.bcxin.platform.common.exception.PlatFormBusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.meeting.ComHuaweiMeetMatch;
import com.bcxin.platform.domain.meeting.PerHuaweiMeetMatch;
import com.bcxin.platform.dto.meeting.ComHuaweiMeetMatchDto;
import com.bcxin.platform.dto.meeting.ModVmrDto;
import com.bcxin.platform.dto.meeting.PerHuaweiMeetMatchDto;
import com.bcxin.platform.dto.meeting.RestScheduleConfDTO;

import java.util.List;

/**
 * 企业华为云会议映射
 *
 * @author llc
 * @date 2019-12-03
 */
public interface ComHuaweiMeetMatchService {


    /**
     * 获取企业华为云会议映射
     *
     * @param comHuaweiMeetMatch
     * @return
     * @auth llc
     * @date 2019-12-24
     */
    Result getComHuaweiMeet(ComHuaweiMeetMatch comHuaweiMeetMatch) throws PlatFormBusinessException;


    /**
     * 获取企业华为云会议管理资源
     *
     * @param perHuaweiMeetMatch
     * @return
     * @auth llc
     * @date 2019-12-11
     */
    Result getHuaweiManageResource(PerHuaweiMeetMatch perHuaweiMeetMatch) throws PlatFormBusinessException;


    /**
     * <b> 预约会议 </b>
     *
     * @author ZXF
     * @create 2020/01/13 0013 17:18
     * @version
     * @注意事项 </b>
     */
    Result buildHuaweiMeet(RestScheduleConfDTO restScheduleConfDTO) throws PlatFormBusinessException;

    /**
     * <b> 用户查询自己的信息 </b>
     *
     * @author ZXF
     * @create 2020/01/13 0013 17:18
     * @version
     * @注意事项 </b>
     */
    Result getHuaweiUserDetail(PerHuaweiMeetMatch perHuaweiMeetMatch) throws PlatFormBusinessException;


    /**
     * 获取企业华为专用云会议室
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-02-17
     */
    Result getHuaweiCloudMeetRoomList(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException;

    /**
     * <b> 修改用户云会议室 </b>
     *
     * @author ZXF
     * @create 2020/02/19 0019 10:55
     * @version
     * @注意事项 </b>
     */
    Result updateHuaweiCloudMemberVmr(ModVmrDto dto) throws PlatFormBusinessException;

    /**
     * <b> 回收专用云会议室 </b>
     *
     * @author ZXF
     * @create 2020/02/19 0019 10:55
     * @version
     * @注意事项 </b>
     */
    Result recycleFromMember(ModVmrDto dto) throws PlatFormBusinessException;

    /**
     * <b> 分配专用云会议室 </b>
     *
     * @author ZXF
     * @create 2020/02/19 0019 10:55
     * @version
     * @注意事项 </b>
     */
    Result assignToMember(ModVmrDto dto) throws PlatFormBusinessException;

    /**
     * <b> 删除专用云会议室 </b>
     *
     * @author ZXF
     * @create 2020/02/19 0019 10:55
     * @version
     * @注意事项 </b>
     */
    Result deleteMemberVmr(ModVmrDto dto) throws PlatFormBusinessException;

    /**
     * <b> 分页查询用户云会议室 </b>
     *
     * @author ZXF
     * @create 2020/02/20 0020 10:43
     * @version
     * @注意事项 </b>
     */
    Result getHuaweiCloudMemberVmrList(ModVmrDto dto) throws PlatFormBusinessException;

    /**
     * 查询企业华为云会议映射
     *
     * @param comId 企业华为云会议映射ID
     * @return 企业华为云会议映射
     */
    ComHuaweiMeetMatch selectComHuaweiMeetMatchById(Long comId);

    /**
     * 查询企业华为云会议映射列表
     *
     * @param comHuaweiMeetMatch 企业华为云会议映射
     * @return 企业华为云会议映射集合
     */
    List<ComHuaweiMeetMatchDto> selectComHuaweiMeetMatchList(ComHuaweiMeetMatchDto comHuaweiMeetMatch);


    int saveComHuaweiMeetMatch(ComHuaweiMeetMatch comHuaweiMeetMatch) throws Exception;

    /**
     * 编辑企业华为云会议映射
     *
     * @param comHuaweiMeetMatch 企业华为云会议映射
     * @return 结果
     */
    int updateComHuaweiMeetMatch(ComHuaweiMeetMatch comHuaweiMeetMatch);

    /**
     * 批量删除企业华为云会议映射
     *
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteComHuaweiMeetMatchByIds(String ids);

    /**
     * 删除企业华为云会议映射信息
     *
     * @param comId 企业华为云会议映射ID
     * @return 结果
     */
    int deleteComHuaweiMeetMatchById(Long comId);

    int refreshComHuaweiMeet(Long comId);
}
