package com.bcxin.platform.mapper.wallet.manage;


import com.bcxin.platform.domain.wallet.ComWalletAccount;
import com.bcxin.platform.domain.wallet.ComWalletChangeEvent;
import com.bcxin.platform.dto.SearchParamDTO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.UpdateProvider;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
public interface ComWalletManageMapper {

    /**
     * <b> 查询是否设置新的商户侧ID有的拿新的，没有就返回comId </b>
     * @author ZXF
     * @create 2022/03/22 0022 16:36
     * @version
     * @注意事项 </b>
     */
    String getMerchantNoByComId(@Param("comId") Long comId);

    /**
     * <b> 企业钱包列表的分页查询 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:34
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> pageComWalletList(SearchParamDTO dto);

    /**
     * <b> 对账数据分页查询 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:34
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> pageComWalletReconciliationList(SearchParamDTO dto);

    /**
     * <b> 企业钱包账户-收支明细分页查询 </b>
     * @author ZXF
     * @create 2020/11/11 0011 14:07
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> pageComWalletAccountDetailList(SearchParamDTO dto);

    /**
     * 获取企业钱包账户对账统计数据
     * @author llc
     * @date 2019-09-19
     */
    Map<String,Object> getWalletReconciliationSum(SearchParamDTO dto);


    /**
     * <b> 查询企业钱包账户 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:33
     * @version
     * @注意事项 </b>
     */
    Map<String,Object> getComWalletAccountByComId(@Param("comId") Long comId);

    List<Map<String,Object>> findComWalletAccountByAllComId();

    int saveOrUpdateDualAccount(@Param("comId") Long comId
            ,@Param("comName") String comName
            ,@Param("walletAccountNo") String walletAccountNo
            ,@Param("totalAmount") String totalAmount
            ,@Param("availableAmount") String availableAmount
            ,@Param("frozenAmount") String frozenAmount);

    /**
     * <b> 更新企业钱包账户 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:36
     * @version
     * @注意事项 </b>
     */
    int updateComWalletAccount(ComWalletAccount comWalletAccount);

    /**
     * <b> 更新企业钱包账户通过执行拼接好的sql语句 </b>
     * @author ZXF
     * @create 2019/09/12 0012 17:35
     * @version
     * @注意事项 </b>
     */
    int updateComWalletAccountBySql(@Param("sqlStr") String sqlStr);

    /**
     * <b> 获取所有银行编码下拉数据 </b>
     * @author ZXF
     * @create 2019/09/02 0002 17:07
     * @version
     * @注意事项 </b>
     */
    List<Map> getAllBankCodeData();

    /**
     * <b> 根据企业钱包账户号查询企业名称 </b>
     * @author ZXF
     * @create 2019/09/03 0003 14:06
     * @version
     * @注意事项 </b>
     */
    String getComNameByWalletNo(@Param("walletNo") String walletNo);

    /**
     * <b> 获得钱包信息修改审批列表 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:34
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> pageComWalletApproveList(SearchParamDTO dto);


    /**
     * <b> 根据id获取钱包信息修改审批信息 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:33
     * @version
     * @注意事项 </b>
     */
    Map<String,Object> getComWalletApproveById(@Param("comWalletChangeEventId") Long comWalletChangeEventId);

    /**
     * <b> 根据id获取钱包信息修改的字段信息列表 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:33
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> getComWalletChangeDetailById(@Param("comWalletChangeEventId") Long comWalletChangeEventId);

    /**
     * <b> 修改钱包信息修改审批状态 </b>
     * @author ZXF
     * @create 2019/09/11 0002 14:36
     * @version
     * @注意事项 </b>
     */
    int updateComWalletApproveStatus(ComWalletChangeEvent comWalletChangeEvent);

    /**
     * <b> 叠加修改的新信息和旧信息 </b>
     * @author ZXF
     * @create 2019/09/16 0016 9:59
     * @version
     * @注意事项 </b>
     */
    Map<String,Object> getComWalletChangeFieldsById(@Param("comWalletChangeEventId") Long comWalletChangeEventId);

    /**
     * <b> 根据id和字段查询新变更的值 </b>
     * @author ZXF
     * @create 2019/09/17 0017 10:31
     * @version
     * @注意事项 </b>
     */
    String getInfoByFieldAndId(@Param("field") String field, @Param("comWalletChangeEventId") Long comWalletChangeEventId);

    /**
     * <b> 新增批量托底户明细 </b>
     * @author ZXF
     * @create 2019/10/12 0012 11:09
     * @version
     * @注意事项 </b>
     */
    Integer batchInsertAccountBaseRecord(List<Map<String, Object>> list);

    /**
     * <b> 托底户明细列表 </b>
     * @author ZXF
     * @create 2019/10/12 0012 11:23
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> pageAccountBaseRecordList(SearchParamDTO dto);


    @UpdateProvider(type = ChangeProvider.class, method = "changeAccountBySql")
    int changeAccountBySql(String sql);

    class ChangeProvider {
        public String changeAccountBySql(String sql) {
            return sql;
        }
    }
}