package com.bcxin.platform.mapper.system;

import com.bcxin.platform.domain.system.SysRegion;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 地区Mapper接口
 * 
 * @author task
 * @date 2021-01-22
 */
public interface SysRegionMapper
{
    /**
     * 查询地区
     * 
     * @param regionId 地区ID
     * @return 地区
     */
    SysRegion selectSysRegionById(Long regionId);

    /**
     * 查询地区列表
     * 
     * @param sysRegion 地区
     * @return 地区集合
     */
    List<SysRegion> selectSysRegionList(SysRegion sysRegion);

    List<SysRegion> selectByParentId(@Param("parentRegionId") Long parentRegionId);

    List<SysRegion> selectByLevel(@Param("regionLevel") Integer regionLevel);

    List<SysRegion> selectAll();

    SysRegion selectByName(@Param("regionName") String regionName);

}
