package com.bcxin.platform.mapper.attend;

import java.util.List;

import com.bcxin.platform.domain.attend.Attend;
import org.apache.ibatis.annotations.Param;
import com.bcxin.platform.domain.attend.AttendAddress;

/**
 * 考勤地点定位Mapper接口
 * 
 * @author lin
 * @date 2022-04-09
 */
public interface AttendAddressMapper{

    /**
     * 查询考勤地点定位
     * 
     * @param id 考勤地点定位ID
     * @return 考勤地点定位
     */
    AttendAddress findById(Long id);

    /**
     * 查询考勤地点定位列表
     * 
     * @param attendAddress 考勤地点定位
     * @return 考勤地点定位集合
     */
    List<AttendAddress> selectList(AttendAddress attendAddress);

    /**
     * 删除考勤地点定位
     * 
     * @param id 考勤地点定位ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤地点定位
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendAddress
     * @return
     */
    int save(AttendAddress attendAddress);

    /****
     * 选择修改
     * @param attendAddress
     * @return
     */
    int updateSelective(AttendAddress attendAddress);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendAddress> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendAddress> findByBatchId(@Param("list") List<AttendAddress> list);

    List<AttendAddress> findByAttendId(Long attendId);

    int deleteByAttendId(Attend attend);
}
